module ms.
export msort(bf).

/*  This program sorts a list using the merge sort algorithm.  Given a
non-trivial list to be sorted, it is first split into two lists of
approximately equal length.  (The two lists differ in length by at
most one.)  The two lists are then recursively sorted using merge 
sort, and the two sorted lists are then merged into a single sorted list.

Pipelining is the appropriate strategy here.  */


@pipelining.
@index_deltas-.

msort([],[]).
msort([X],[X]).
msort([H1|[H2|T]],Y) :- split([H1|[H2|T]],X1,X2), msort(X1,Y1), msort(X2,Y2), 
			merge(Y1,Y2,Y).

split([],[],[]).
split([H|T],[H|X1],X2) :- split(T, X2, X1).

merge([],X,X).
merge(X,[],X).
merge([H1|T],[H2|X1],[H1|X2]) :- H1 < H2, merge(T,[H2|X1],X2).
merge([H1|T],[H2|X1],[H2|X2]) :- H1 >= H2, merge([H1|T],X1,X2).

end_module.


/*  The above program can be called with the following sample queries:


?msort([1,2,3,4,5,6,7,8,9,10],X).
?msort([15,14,13,12,11,10,9,8,7,6,5,4,3,2,1],X).
?msort([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15],X).
?msort([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20],X).
?msort([20,19,18,17,16,15,14,13,12,11,10,9,8,7,6,5,4,3,2,1],X).

End of sample queries.   */
