module make_sequence.
export sequence(bbf,bff,fff), sequence_length(bf), print_seq(b).

/* This module provides utilities for converting a sequence that
is input as a list to a sequence in relational representation.

 To input a relation named (say) a, with facts 
	a(1,x1).
	a(2,x1).
	...
	a(n,xn).
   type in a single fact
	input_seq(a,[x0,x1,x2,...,xn]).

   The routines here then define a predicate called sequence s.t.:
	sequence(a,1,x1).
	sequence(a,2,x1).
	...
	sequence(a,n,xn).
   There is also a predicate that defines sequence_length(a,n).

*/

@index_deltas-.
@allowed_adornments sequence[bbf]. 
@allowed_adornments sequence[bff]. 
@allowed_adornments seqlist[ffff].
@allowed_adornments seqlist[bfff].
@allowed_adornments s_len[bf].

sequence(A,N,X) :- seqlist(A,N,X,L).
sequence_length(A,N) :- input_seq(A,L), s_len(L,N).

seqlist(A,1,X,L) :- input_seq(A,[X|L]).
seqlist(A,N1,X,L) :- seqlist(A,N,Y,Z), Z=[X|L], N1=N+1.

s_len([],0).
s_len([H|T],N) :- s_len(T,N1), N=N1+1.

print_the_seq(X) :- sequence(X,Y,Z), printf("sequence(%,%,%).",X,Y,Z).
print_the_length(X) :- sequence_length(X,Y), printf("sequence_length(%,%).",X,Y).
print_seq(X) :- print_the_seq(X), print_the_length(X).

end_module.



/*  Here is a sample inputs:

First type in:

input_seq(e,[c,a,c,b,c,b,a,b,c,c]).
input_seq(f,[d,d,a,d,b,b,d,a,b,d]).

at the CORAL prompt.

Then (after consulting make_seq.P), type

?sequence(e,I,C).
?sequence(f,I,C).

to see the relational representation.  If you
type in the rules:

   	seq(a,P,X) :- sequence(a,P,X).
	seq_len(a,N) :- sequence_length(a,N).

base relations seq and seq_len with the appropriate
facts will be created.

This is useful to create datasets for lcs.P.
See the file runlcs for an example of the above usage.  */

