
module knap.

export cost(bbff). 

% cost(J,I,C,X):  C is the optimal value of a knapsack 
% of size I packed using only items of types 1 through J;
% X is the last item packed.  (This field allows us to 
% recover the contents of the knapsack, if desired.)

cost(1,0,0,0).	

% considering more types of items to pack can't reduce 
% optimal knapsack value.

cost(J,I,C,X) :- J1=J-1, J1>0, cost(J1,I,C,X).

cost(J,I,C,J) :- size(J,S), I1=I-S, I1>=0,
	cost(J, I1, C2,_), 	% knapsack value for size I1
	value(J,V), C = C2+V.	% add item of type J to
				% knapsack of size I1 

% We only care about the optimal value for a given J and I

@aggregate_selection cost(J,I,C,X) (J,I) max(C).

end_module.

/*  Sample data */

% 5 types of items; see Sedgewick's ``Algorithms'' text 
% for a discussion.  The size s and value v of an item of 
% type i is given by size(i,s) and value(i,v).
% Try ?cost(5,17,C,X).

size(1,3).
size(2,4).
size(3,7).
size(4,8).
size(5,9).

value(1,4).
value(2,5).
value(3,10).
value(4,11).
value(5,13).

