
%  A program for the Towers of Hanoi problem.  
%  Also illustrates a mixture of pipelining and materialization.

module hanoi.
export solve(b).

solve(N):- hanoi(N,a,b,c,R).

end_module.


module app.
export nappend(bbf).
@pipelining.

nappend([],L,L).
nappend([H|L],L1,[H|R]) :-
	nappend(L,L1,R).

end_module.



module hanoi.
export hanoi(bbbbf).
@index_deltas-.
@multiset.

hanoi(1,A,B,C,[mv(A,C)]).
hanoi(N,A,B,C,M) :-
	N > 1,
	N1 = N - 1,
	hanoi(N1,A,C,B,M1),
	hanoi(N1,B,A,C,M2),
	nappend(M1,[mv(A,C)],T),
	nappend(T,M2,M).

end_module.

