module fibon.
export fib(bf).
@sup_magic +.	% The default; does not have to be specified.

/*  This is the famous fibonacci program.  While the program will work
fine with no annotations at all, the annotations below improve
performance a little.  Since the program is functional, few tuples
are produced in each iteration, and so indexing the "deltas" (sets
of new tuples) is an unjustified overhead.  Also, if we eliminate
duplicate goals, no other duplicates will be generated, and so other
predicates can be treated as multisets, i.e. without duplicate checks. 

tak.P and ackermann.P are other programs that are optimized similarly.  */

@check_subsumption +.
@index_deltas -.
@multiset +.

fib(0, 1).
fib(1, 1).
fib(N, X1+X2) :- N > 1, fib(N - 1, X1), fib(N - 2, X2).
		
end_module.
