

module declse_eg7a.
export bom(bf,ff).

% (This program is discussed in the introduction document.)

/* This program computes the total cost of a composite part by summing
the total costs of its subparts.  This is often called the bill-of-materials
problem. Note that the program is not stratified.  It will work correctly as
long as the assembly relation is acyclic (i.e. the part-subpart relationship,
closed transitively, is acyclic).  There are input data sets in bom1.F, bom2.F
and bomtree.F.  */


bom(Part,sum(<C>)) :- subpart_cost(Part,SubPart,C).

subpart_cost(Part,Part,Cost) :- basic_part(Part,Cost).
subpart_cost(Part,Subpart,Cost) :- assembly(Part,Subpart,Quantity), 
	bom(Subpart, TotalSubcost),
	Cost = Quantity * TotalSubcost.

end_module.



module declse_eg7b.
export bomb(bf,ff).

/*  The following program is equivalent to the previous one.
However, it relies upon the inter-module calling mechanism rather
than Ordered Search to ensure that all subpart costs are determined
before the bom rule is applied.  Thus, some operational reasoning
is required to understand why this works as expected.  

It is faster than the previous program on some data sets, for
example the one in bom1.F, and slower on others, for
example the one in bom2.F. */

bomb(Part,sum(<C>)) :- subpart_cost(Part,SubPart,C).

end_module.

module subpart.
%export subpart_cost(bff,fff).
export subpart_cost(fff).
@pipelining.

% The following annotation (commented out) should NOT be used!  This module
% is involved in a cycle of inter-module calls.
% @save_module.

subpart_cost(Part,Part,Cost) :- basic_part(Part,Cost).
subpart_cost(Part,Subpart,Cost) :- assembly(Part,Subpart,Quantity), 
	bomb(Subpart, TotalSubcost),
	Cost = Quantity * TotalSubcost.

end_module.


module declse_eg7c.
export bomc(ff).

/*  The following program is equivalent to the previous ones.
However, it relies upon the fact that the graph is acyclic to use
pipelined evaluation, and takes advantage of the fact that each path
is traversed just once.  It is similar to bomb in terms of when 
it is better than bom; it is faster than bomb.  */


bomc(Part,sum(<C>)) :- bomtmp(Part,SubPart,C).

end_module.

module bomtmp.
export bomtmp(bff).
@pipelining.	

bomtmp(Part,Part,Cost) :- basic_part(Part,Cost).
bomtmp(Part,Subsubpart,Cost) :- assembly(Part,Subpart,Quantity), 
	bomtmp(Subpart, Subsubpart, Subsubcost),
	Cost = Quantity * Subsubcost.

end_module.
