module algebra.
export g(f).

/*  This program refines the solution in algebra1.P.  The main 
change is that the definition of mt is moved to a different module,
and is evaluated using pipelining.  This program illustrates a
mixture of different evaluation strategies in different modules.  

This program is refined further by the program in algebra.opt.P.  */


g(X) :- g1(X).
g(X) :- g2(X).
%g(X) :- g3(X).			% commented out for a quick response ...
g(X) :- g(Y), g(Z), mt(Y,Z,X). 

end_module.

module mt.
export mt(bbf).
@pipelining.		% Overrides the default.

mt([],[],[]).
mt([X|Xt], [Y|Yt], [Z|Zt]) :- m(X,Y,Z), mt(Xt,Yt,Zt).

end_module.

% Data set; note that by placing these facts outside the module,
% they are treated as tuples in a base relation rather than as rules.
% This allows efficient indexing etc.

g1([0,0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,1,2,2,2,2,2,2,2,2,2]).
g2([0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2,0,0,0,1,1,1,2,2,2]).
g3([0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2]).

m(0,0,0).
m(0,1,0).
m(0,2,0).
m(1,0,0).
m(1,1,0).
m(1,2,1).
m(2,0,0).
m(2,1,2).
m(2,2,2).

