/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	user-builtin2.C
	Contains some code for builtin relations, and some useful
	functions that are used by many builtin relations
 ***********************************************************************/

#include <math.h>
#include <stdio.h>
#include <string.h>
#include "builtin-rel.h"
#include "gennum.h"
#include "unify.h"
#include "globals.h"
#include "parser.h"
#include "interface.h"
#include "generic-index.h"
#include <limits.h>


extern int C_linenum;
extern int scanner_at_eof;
extern int command_count;
extern int is_history_command;

#undef FAIL_RETURN
#define FAIL_RETURN  {iterator.set_no_match(); 		\
		if (tmp_file) fclose(tmp_file); 	\
		if (tmp_file_name) unlink(tmp_file_name); \
		return NULL;}

extern Symbol * PipeOutSymbol;
extern Symbol * PipeInSymbol;
extern Symbol * WriteTableSymbol;
extern Symbol * MakeIndexSymbol;
extern Symbol * IndexDeltaSymbol;
extern DatabaseStruct BuiltinDB ;
extern Arg    * create_nested_multiset();

extern int macro_pipe[2];

#ifdef UNIX_HP
#undef PIPE_MAX
#define PIPE_MAX 5000
#endif

/*
extern "C" {
      int pipe(int*);
      int write(int, const void*, int);
      int close(int);
      int unlink(char *);
}
*/

BindEnv* readTable(const char* infile,TupleIterator& iterator); // prototype

/*------------------------------------------------------------------
 Function Behaviour :: Strips a string of surrounding quotes.
    This function is used by many builtin-relations

 Oddities/Quirks :: Always creates a new string, even if the
   input string is not quoted. For such cases, the input is just
   copied onto the new string.

 -------------------------------------------------------------------*/
char *strip_quotes(char *str)
{
  char *temp_str = NULL;
  if (!str) 
	return temp_str;

  int str_len = strlen(str);
  temp_str = new char [str_len+1];

  if  (*str == '\"') {

      strcpy(temp_str,str+1) ;
      if  (str[str_len-1] == '\"')
          temp_str[str_len -2] = '\0' ;
  }
  else strcpy(temp_str, str) ;

  return temp_str;
}

char *mk_tmp_file_name(char *name)
{
    static filecount = 0;
    sprintf(name, "/tmp/__coral_file_%d", filecount++);
    return (name);
}

FILE *open_file(char *name)
{
    FILE *tmp_file;
    if (name)
        tmp_file = fopen(name, "w");
    if (!tmp_file) 
	fprintf(exEnv.error_file, "CORAL: unable to open file %s\n", name);
    return tmp_file;
}

BindEnv *pipeOutSolver(BuiltinRelation& , TupleIterator& iterator)
{
  /* Arglist should have two args.  The first a command to which the output is
  given, the second argument a relation name. */
  FILE *tmp_file = NULL;
  char *tmp_file_name = NULL;

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file, "Entering %s\n", PipeOutSymbol->string());
    }
#endif

  if (iterator.arg_list.arity() != 2) {
	fprintf(exEnv.error_file, "%s: Number of arguments must be 2.\n",
			PipeOutSymbol->string());
	FAIL_RETURN;
  }
	
  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM(term1);
  if ( term1.expr->kindof() != COR_SYMBOL_CONST) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad first argument to %s =",
			PipeOutSymbol->string() );
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
  }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM(term2);
  if ( term2.expr->kindof() != COR_FUNCTOR) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad second argument to %s =",
			PipeOutSymbol->string() );
        term2.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
  }
  FuncArg * fa = (FuncArg *)term2.expr;


    char name[100];
    tmp_file_name = mk_tmp_file_name(name);
    tmp_file = open_file(tmp_file_name);
    if (!tmp_file)
	FAIL_RETURN;


    Relation *printrel = find_relation(fa->functor(), fa->arity());
    if (!printrel) {
	fprintf(exEnv.error_file, 
		"CORAL :: Error - %s: relation %s(arity = %d) not found\n", 
		 	PipeOutSymbol->string(),
			fa->functor()->string(), fa->arity());
	FAIL_RETURN;
    }

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,
		"%s - printing facts..\n", PipeOutSymbol->string());
    }
#endif

    printrel->print_facts(tmp_file);
    fclose(tmp_file);
    tmp_file = NULL ;

    char *command = strip_quotes( ((Name)term1.expr)->string() );
    char *term_str = new char [strlen(command)+100];
    sprintf(term_str, "%s < %s", command, tmp_file_name);

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file, "%s - going to execute command: %s \n", 
			PipeOutSymbol->string(), term_str);
    }
#endif

    if (system(term_str)) {
	fprintf(exEnv.error_file, "CORAL :: Error -- Command \"%s\" failed !!\n",
		term_str) ;
	delete [] command ; delete [] term_str ;
	FAIL_RETURN;
    }

    delete [] command;

    delete [] term_str ;

    unlink(tmp_file_name);
    iterator.reset_no_match();

    return iterator.bindenv ;
}


/*----------------------------------------------------------------- */
BindEnv *writeTableSolver(BuiltinRelation&, TupleIterator& iterator)
{
  /*	Arglist can have one or two args. The first is the relation name,
	and the second is the output file. If the second argument is not
	provided, the output is sent to stdout  */

  FILE *tmp_file = NULL;
  char *tmp_file_name = NULL;
  int sort=0;			// do I sort the output?

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,"Entering %s\n", WriteTableSymbol->string());
    }
#endif

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM(term1);
  if ( term1.expr->kindof() != COR_FUNCTOR) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad first argument to %s =",
			WriteTableSymbol->string() );
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
  }
  FuncArg * fa = (FuncArg *)term1.expr;

  char *outfile = NULL;
  if (iterator.arg_list.arity() > 1) {
	Term term2 (iterator.arg_list[1], iterator.bindenv);
	FULL_DEREFERENCE_TERM(term2);
        outfile = strip_quotes( ((Name)term2.expr)->string() );
  }

  char* sortstring = NULL;	// to hold args passed in from command-line.

  if (iterator.arg_list.arity() > 2) { // now get the sort string. Should be
				       // arg 3.
    Term term3 (iterator.arg_list[2], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term3);
    sortstring = strip_quotes( ((Name)term3.expr)->string() );
    sort=1;
  }


    char name[100];
    tmp_file_name = mk_tmp_file_name(name);
    tmp_file = open_file(tmp_file_name);
    if (!tmp_file) {
	delete [] outfile ;
	FAIL_RETURN;
    }

    Relation *printrel = find_relation(fa->functor(), fa->arity());
    if (!printrel) {
	fprintf(exEnv.error_file, 
		"CORAL :: Error - %s: relation %s(arity = %d) not found\n", 
		 	WriteTableSymbol->string(),
			fa->functor()->string(), fa->arity());
	delete [] outfile ;
	FAIL_RETURN;
    }

    fprintf(tmp_file, "## %s %d %s\n", fa->functor()->string(), fa->arity(),
			outfile);
    printrel->print_facts(tmp_file);
    fclose(tmp_file);
    tmp_file = NULL ;

    delete [] outfile ;

// Now that the facts are in the temporary file, call the awk script
// on it, to write out the facts to outfile in a tabular form.

    char *term_str = new char [strlen(tmp_file_name)+ 256];
    char *sortoptions = new char[256]; // alloc space for sort options
    strcpy(sortoptions,"");	     // init it.

  if(sort || sortstring != NULL)
    sprintf(sortoptions,"sortoptions=%s",(sortstring == NULL ? "\"\"" :
					  sortstring)); 

  sprintf(term_str, "writetable.CORAL %s %s < %s", 
	  (sort ? "sort=1" : ""),
	  sortoptions,
	  tmp_file_name);	// set up the command to run the writetable routine.


    if (system(term_str)) {
	fprintf(exEnv.error_file, "CORAL :: Error -- Command \"%s\" failed !!\n",
		term_str) ;
	delete [] term_str ;
	FAIL_RETURN;
    }

    delete [] term_str ;

    unlink(tmp_file_name);
    iterator.reset_no_match();

    return iterator.bindenv ;
}

// this routine takes the name of the file in, processes it
// This has the components of the previous functon readTableSolver.
//
BindEnv* readTable(const char* infile,TupleIterator& iterator)
{
    char name[100];
    FILE *tmp_file = NULL;
    char *tmp_file_name = NULL;

    tmp_file_name = mk_tmp_file_name(name); // create a temp filename
    char *term_str = new char [strlen(tmp_file_name)+ 50];

    sprintf(term_str, "readtable.CORAL < %s > %s", infile, tmp_file_name);

    if (system(term_str)) {
	fprintf(exEnv.error_file, "CORAL :: Error -- Command \"%s\" failed !!\n",
		term_str) ; 

	delete [] term_str ;
	FAIL_RETURN;
    }


    
    if (!consultFile(tmp_file_name, tmp_file_name)) {
      CORAL_error(COR_FILE_NOT_FOUND, tmp_file_name, "readTable");
      iterator.set_no_match();
      unlink(tmp_file_name);
      delete [] term_str;
      return iterator.bindenv;
    }

    delete [] term_str ;
    unlink(tmp_file_name);
    return iterator.bindenv;

}
/*----------------------------------------------------------------- */

BindEnv *pipeInSolver(BuiltinRelation&, TupleIterator& iterator)
{


  /* Arglist should have one arg, which is  a command to be run and its
	output used as input to the system */
    FILE *tmp_file = NULL;
    char *tmp_file_name = NULL;

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,"Entering %s\n", PipeInSymbol->string());
    }
#endif

    if (iterator.arg_list.arity() != 1) {
	fprintf(exEnv.error_file, "%s: Number of arguments must be 1.\n", 
			PipeInSymbol->string());
	FAIL_RETURN;
    }
	
    Term term1 (iterator.arg_list[0], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term1);
    if ( term1.expr->kindof() != COR_SYMBOL_CONST) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad first argument to %s =",
		PipeInSymbol->string());
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
  }
    char *command = strip_quotes( ((Name)term1.expr)->string() );

    char *term_str = new char [strlen(command)+100];

    char name[100];
    tmp_file_name = mk_tmp_file_name(name);

    sprintf(term_str, "%s > %s", command, tmp_file_name);
    delete [] command;

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,
		"%s: Executing command %s\n", PipeInSymbol->string(),
			term_str);
    }
#endif

    if (system(term_str)) {
	fprintf(exEnv.error_file, "CORAL :: Error -- Command \"%s\" failed !!\n",
		term_str) ;
	delete [] term_str ;
	unlink(tmp_file_name);
	FAIL_RETURN;
    }

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,
		"%s - redirecting input.\n", PipeInSymbol->string());
    }
#endif

    
    if (!consultFile(tmp_file_name, tmp_file_name)) {
      CORAL_error(COR_FILE_NOT_FOUND, tmp_file_name, "pipeInSolver");
      iterator.set_no_match();
      unlink(tmp_file_name);
      delete [] term_str;
      return iterator.bindenv;
    }

    delete [] term_str ;
    unlink(tmp_file_name);
    return iterator.bindenv;

}

/***********************************************************************/

#undef FAIL_RETURN
#define FAIL_RETURN {iterator.set_no_match(); return iterator.bindenv;}

BindEnv *addIndexSolver1(BuiltinRelation&, TupleIterator& iterator)
{
  /* Arglist should have one arg - a funcarg with relation name, and 
	single arg with the binding pattern. */

#ifdef DO_TRACE
    if (exEnv.dbg_indexing) {
	fprintf(exEnv.trace_file, "Entering %s\n", MakeIndexSymbol->string());
    }
#endif

    if (iterator.arg_list.arity() != 1) {
	fprintf(exEnv.error_file, "%s: Number of arguments must be 1.\n",
			MakeIndexSymbol->string());
	FAIL_RETURN;
    }
	
    Term term1 (iterator.arg_list[0], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term1);
    if ( term1.expr->kindof() != COR_FUNCTOR) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad argument to %s =",
			MakeIndexSymbol->string() );
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
    }

    FuncArg * fa = (FuncArg *)term1.expr;
    if (fa->arity() != 1 || fa->args[0]->kindof() != COR_SYMBOL_CONST) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad argument to %s =",
			MakeIndexSymbol->string() );
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
    }
    char *adorn =  ((Name)fa->args[0])->string() ;

    Relation *indrel = find_relation(fa->functor(), strlen(adorn));
    if (!indrel) {
	fprintf(exEnv.error_file, 
		"CORAL :: Error - %s: relation %s(arity %d) not found\n", 
		 	MakeIndexSymbol->string(),
			fa->functor()->string(), strlen(adorn));
	FAIL_RETURN;
    }

    if (indrel->add_index(adorn) == COR_I_SUCCESS)
        iterator.reset_no_match();
    else iterator.set_no_match();

    return iterator.bindenv ;
}

BindEnv *addIndexSolver2(BuiltinRelation&, TupleIterator& iterator)
{
  /* Arglist should have two args - a funcarg with relation name (with a 
	single arg with the binding pattern) and a list of bound vars. */

#ifdef DO_TRACE
    if (exEnv.dbg_indexing) {
	fprintf(exEnv.trace_file,
		"Entering %s\n", MakeIndexSymbol->string());
    }
#endif

    if (iterator.arg_list.arity() != 2) {
	fprintf(exEnv.error_file, "%s: Number of arguments must be 1 or 2.\n",
			MakeIndexSymbol->string());
	FAIL_RETURN;
    }
	
    Term term1 (iterator.arg_list[0], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term1);
    if ( term1.expr->kindof() != COR_FUNCTOR) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad argument to %s =",
			MakeIndexSymbol->string() );
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
    }
    FuncArg * fa = (FuncArg *)term1.expr;

    Term term2 (iterator.arg_list[1], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term2);
  
    Relation *indrel = find_relation(fa->functor(), fa->arity() );
    if (!indrel) {
	fprintf(exEnv.error_file, 
		"CORAL :: Error - %s: relation %s(arity %d) not found\n", 
		 	MakeIndexSymbol->string(),
			fa->functor()->string(), fa->arity());
	FAIL_RETURN;
    }

    fprintf(exEnv.error_file, 
     "CORAL:: add_index - pattern form index addition not fully supported yet\n"
      );

    /**********
    if (indrel->add_index(term1.expr->argsterm2.expr) == COR_I_SUCCESS)
        iterator.reset_no_match();
    else iterator.set_no_match();
    **********/

    return iterator.bindenv ;
}

/*********************************/

BindEnv *deltaIndexSolver(BuiltinRelation&, TupleIterator& iterator)
{
  /* Arglist should have one arg - a funcarg with relation name, and 
	a dummy argument list to specify arity. */

#ifdef DO_TRACE
    if (exEnv.dbg_indexing) {
	fprintf(exEnv.trace_file,"Entering %s\n", IndexDeltaSymbol->string());
    }
#endif

    if (iterator.arg_list.arity() == 0) {
       exEnv.C_index_deltas_default = 1;
       iterator.reset_no_match();
       return iterator.bindenv ;
    }

    if (iterator.arg_list.arity() != 1) {
	fprintf(exEnv.error_file, "%s: Number of arguments must be 0 or 1.\n",
			IndexDeltaSymbol->string());
	FAIL_RETURN;
    }
	
    Term term1 (iterator.arg_list[0], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term1);
    if ( term1.expr->kindof() != COR_FUNCTOR) {
	fprintf(exEnv.error_file,"CORAL :: Error -- bad argument to %s =",
			IndexDeltaSymbol->string() );
        term1.printon(exEnv.error_file);
	fprintf(exEnv.error_file,"\n");
	FAIL_RETURN;
    }
    FuncArg * fa = (FuncArg *)term1.expr;

    Relation *indrel = find_relation(fa->functor(), fa->arity());
    if (!indrel) {
	fprintf(exEnv.error_file, 
		"CORAL :: Error - %s: relation %s(arity %d) not found\n", 
		 	IndexDeltaSymbol->string(),
			fa->functor()->string(), fa->arity());
	FAIL_RETURN;
    }

    if (indrel->set_delta_indexing(1) == COR_I_SUCCESS)
        iterator.reset_no_match();
    else iterator.set_no_match();

    return iterator.bindenv ;
}

BindEnv *AliasSolver(BuiltinRelation&, TupleIterator& iterator)
{

    if (iterator.arg_list.count() != 2) {
      CORAL_error(COR_BAD_ARITY, "2 arguments to alias needed", NULL);
      FAIL_RETURN;
    }

    Term term1 (iterator.arg_list[0], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term1);
    if ( term1.expr->kindof() != COR_SYMBOL_CONST) {
      fprintf(exEnv.error_file,"CORAL :: Error -- bad first argument to %s =",
	      AliasSymbol->string() );
      term1.printon(exEnv.error_file);
      fprintf(exEnv.error_file,"\n");
      FAIL_RETURN;
    }

    Term term2 (iterator.arg_list[1], iterator.bindenv);
    FULL_DEREFERENCE_TERM(term2);
    if ( term2.expr->kindof() != COR_SYMBOL_CONST) {
      fprintf(exEnv.error_file,"CORAL :: Error -- bad second argument to %s =",
	      AliasSymbol->string() );
      term2.printon(exEnv.error_file);
      fprintf(exEnv.error_file,"\n");
      FAIL_RETURN;
    }

    Association *ptr = SymbolLookup(BuiltinDB.RelationTable, 
				    (Name)(term2.expr)) ;
    if (HashNone(ptr->arg)) {
      fprintf(exEnv.error_file, "Specified builtin relation %s does not exist !\n",
	      SymbolString(term2.expr)) ;
      FAIL_RETURN ;
    }

    BuiltinRelation *tmp = (BuiltinRelation *)(ptr->val);
    BuiltinRelation *dummy = new BuiltinRelation(tmp->arity(),
						 (Name)(term1.expr),
						 tmp->solver);
    
    return iterator.bindenv ;	  
}


/*****************************************************************/


BindEnv *ArgTypeSolver(BuiltinRelation& rel, TupleIterator& iterator)
{
  if (iterator.arg_list.count() != 1) {
    CORAL_error(COR_BAD_ARITY, "1 argument needed", NULL);
    iterator.set_no_match();
    return iterator.bindenv;
  }
  
  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);

  int (*type_function)(Arg *);
  
  if (rel.name == IsConstantSymbol)
    type_function = is_constant;
  else if (rel.name == IsVarSymbol)
    type_function = is_var ;
  else if (rel.name == IsListSymbol)
    type_function = is_list ;
  else if (rel.name == IsFunctorSymbol)
    type_function = is_functor ;
  else if (rel.name == IsStringSymbol)
    type_function = is_string ;
  else if (rel.name == IsNumSymbol)
    type_function = is_num ;
  else if (rel.name == IsIntSymbol)
    type_function = is_int ;
  else if (rel.name == IsLongSymbol)
    type_function = is_long ;
  else if (rel.name == IsShortSymbol)
    type_function = is_short ;
  else if (rel.name == IsFloatSymbol)
    type_function = is_float ;
  else if (rel.name == IsDoubleSymbol)
    type_function = is_double ;
  else {
    iterator.set_no_match();
    return iterator.bindenv;
  }

  /** actually, here a simplify() should be called ***/
/*
  if ( term1.expr->kindof() == COR_VARIABLE )
    term1 = iterator.bindenv->lookup(((VarArg *)term1.expr)->var);
*/
  
  TermLink *rv = NULL;
  if ((*type_function)(term1.expr->simplify(iterator.bindenv, rv,
					    iterator.bindenv, NULL))) 
    iterator.reset_no_match();
  else
    iterator.set_no_match();

  return iterator.bindenv;

}

/*****************************************************************/

BindEnv *HistorySolver(BuiltinRelation&, TupleIterator& iterator)
{
  if (iterator.arg_list.count() == 0) {
    (exEnv.history)->display(exEnv.error_file);
    return iterator.bindenv;
  }

  if (iterator.arg_list.count() != 1) {
    CORAL_error(COR_BAD_ARITY, "1 argument to history needed", NULL);
    iterator.set_no_match();
    return iterator.bindenv;
  }
  
  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_NUM_CONST ) {
    CORAL_error(COR_BAD_ARG_TYPE, NULL, "HistorySolver");
    term1.printon(exEnv.error_file);
    fprintf(exEnv.error_file,"\n");
    iterator.set_no_match();
    return iterator.bindenv;
  }


#ifdef PIPE_MAX
  char buf[PIPE_MAX];
#else
  char buf[_POSIX_PIPE_BUF] ;
#endif


  char *tmp = (exEnv.history)->getCommand(make_int(term1.expr));

  if (!tmp) {
    fprintf(exEnv.error_file, "CORAL::Error: out of history range !\n");
    iterator.set_no_match();
    return iterator.bindenv;
  }

  pipe(macro_pipe);
  sprintf(buf, "%s\n", tmp);  
#ifdef PIPE_MAX
  ASSERT(strlen(buf) < PIPE_MAX) ;
#else
  ASSERT(strlen(buf) < _POSIX_PIPE_BUF) ;
#endif
  write(macro_pipe[1], buf, strlen(buf) );
  close(macro_pipe[1]);

  FILE *tmp_fd = fdopen(macro_pipe[0], "r");
  show_prompt = 0 ;
  fileStack.set_top_file_line(C_linenum);
  fileStack.push(tmp_fd,0) ;
  C_linenum = 0;
  yyin = tmp_fd ;
  scanner_at_eof = 0;

  // Now modify the history stack
  (exEnv.history)->addCommand(tmp, command_count++);
  is_history_command = 1;

  return iterator.bindenv ;
}

BindEnv *DisplayDefaultsSolver(BuiltinRelation&, TupleIterator& iterator)
{
    if (iterator.arg_list.count() != 0)
      CORAL_error(COR_BAD_ARITY, "no arguments to display_defaults needed",
		  NULL);


    char name[100];
    char *tmp_file_name = mk_tmp_file_name(name);
    FILE *tmp_file = open_file(tmp_file_name);
    if (!tmp_file) {
      iterator.set_no_match();
      return iterator.bindenv;
    }
    
    exEnv.display(tmp_file);
    fclose(tmp_file);
    DisplayFile(tmp_file_name);

    unlink(tmp_file_name);
    return iterator.bindenv ;	  
}

BindEnv *ResetDefaultsSolver(BuiltinRelation&, TupleIterator& iterator)
{
    if (iterator.arg_list.count() != 0)
      CORAL_error(COR_BAD_ARITY, "no arguments to reset_defaults needed",NULL);

    exEnv.init() ;
    return iterator.bindenv ;	  
}

Relation *find_local_or_external_relation(Name name, int arity) 
{
  Relation *rel;
  rel = find_local_relation(name, arity);
  if (!rel) rel = make_relation(name, arity);
  return rel;
}

BindEnv *InsertFactSolver(BuiltinRelation&,TupleIterator& iterator)
{

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,"Entering %s\n", "insert");
    }
#endif

    if (iterator.arg_list.count() > 0)
      {
	FOR_EACH_ARG(arg, iterator.arg_list) {

	  Term term1 (arg, iterator.bindenv);
	  FULL_DEREFERENCE_TERM(term1);
	  if ( term1.expr->kindof() != COR_FUNCTOR) {
	    CORAL_error(COR_BAD_ARGLIST, "Arguments must be functors",
			"InsertFactSolver");
	    term1.printon(exEnv.error_file);
	    fprintf(exEnv.error_file,"\n");
	    FAIL_RETURN;
	  }
	  Relation *rel = find_local_or_external_relation(
				 ((FuncArg *)(term1.expr))->functor(),
				 ((FuncArg *)(term1.expr))->arity());
	  rel->insert_new(((FuncArg *)(term1.expr))->args, iterator.bindenv);
	} END_EACH_ARG

      }
    return iterator.bindenv;
}

BindEnv *DeleteFactSolver(BuiltinRelation&,TupleIterator& iterator)
{

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,"Entering %s\n", "delete");
    }
#endif

    if (iterator.arg_list.count() > 0)
      {
	FOR_EACH_ARG(arg, iterator.arg_list) {

	  Term term1 (arg, iterator.bindenv);
	  FULL_DEREFERENCE_TERM(term1);
	  if ( term1.expr->kindof() != COR_FUNCTOR) {
	    CORAL_error(COR_BAD_ARGLIST, "Arguments must be functors",
			"DeleteFactSolver");
	    term1.printon(exEnv.error_file);
	    fprintf(exEnv.error_file,"\n");
	    FAIL_RETURN;
	  }

	  Relation *rel = find_local_or_external_relation(
				 ((FuncArg *)(term1.expr))->functor(),
				 ((FuncArg *)(term1.expr))->arity());

	  Tuple *tuple1 = new Tuple(((FuncArg *)(term1.expr))->args);
	  tuple1->env_size = parserStruct.rule_var_names.length;
	  tuple1->bindenv = iterator.bindenv;
	  rel->tuple_delete(tuple1);

	} END_EACH_ARG

      }
    return iterator.bindenv;
}


/*******************************************************************/
// This function takes in 3 arg. 1st is base, 2nd is exp, 3rd is answer to the
// query. 

Tuple * PowSolver(Tuple* in)
{
  ArgList* alist = ArgList::New(3);
  Arg * args[3];
  double nums[3],base,exp,ans;
  Double *Ans;			// place for result.
  char type=0;
  int numargs=0;
  int numvars=0;

#define ROOT 0
#define LOG 1
#define POW 2

  if(in->arity() != 3) {
    CORAL_error(COR_BAD_ARITY,"Format of pow is: pow(Base,Exponent,Answer)","PowSolver");
    return NULL;
  }

  for(int i=0;i<3;i++){
    args[i] = (in->args())[i];	// get the args
    if(is_num(args[i])) {	// if its a number
      numargs++;
      if(is_int(args[i])) {
	if(i == ROOT) 
	  base = make_int(args[i]);
	else if(i == LOG) 
	  exp = make_int(args[i]);
	else if(i == POW) 
	  ans = make_int(args[i]);
      }				// if int
      else if(is_double(args[i])) {
	if(i == ROOT) 
	  base = make_double(args[i]);
	else if(i == LOG) 
	  exp = make_double(args[i]);
	else if(i == POW) 
	  ans = make_double(args[i]);
      }			// if double
      else { /* syntax error */
	CORAL_error(COR_BAD_ARG_TYPE,"Arg must be of type DOUBLE or INT","PowSolver");
	return NULL;
      }
			       
    } else if(is_var(args[i])) { // is variable
      numvars++;
      type=i;
    } else {			// if not var or num
      	CORAL_error(COR_BAD_ARG_TYPE,"Arg must be a Variable or a Number","PowSolver");
	return NULL;
      }
  }				// for

  if(numargs == 2 && numvars == 1) { // fine
    switch(type) {
    case POW:
      Ans = new Double(pow(base,exp)); // call the function.
      (*alist)[0] = args[0];
      (*alist)[1] = args[1];
      (*alist)[2] = Ans;
      break;
    case LOG:
      Ans = new Double((log(ans)/log(base)));
      (*alist)[0] = args[0];
      (*alist)[1] = Ans;
      (*alist)[2] = args[2];
      break;
    case ROOT:
      Ans = new Double(pow(ans,1/exp)); // call the function.
      (*alist)[0] = Ans;
      (*alist)[1] = args[1];
      (*alist)[2] = args[2];
      break;
    default:
      break;
      /* error */
    }
  } 
  else if (numargs == 3 && numvars == 0) { // still fine
    if (ans == pow(base,exp)) {
      (*alist)[0] = args[0];
      (*alist)[1] = args[1];
      (*alist)[2] = args[2];
    }
  }
  else {
    CORAL_error(COR_BAD_ARG_TYPE,"Format of pow is: pow(Base,Exponent,Answer)",
		"PowSolver");
    return NULL;
  }
  Tuple* Result = new Tuple(alist); // create the tuple.
  
  return Result;

}

/*******************************************************************/
Tuple *CreateSetSolver(Tuple *query)
{
  if (query == NULL) {
    fprintf(exEnv.error_file,"Null argument passed to %s \n",
	    SymbolString(CreateSetSymbol)); 
    return NULL; 
  }

  int arity;
  if ((arity = query->arity()) != 1) {
    CORAL_error(COR_BAD_ARITY, "1 argument to create_set needed", NULL);
    return NULL;
  }

  if (((query->args())[0])->kindof() != COR_VARIABLE) {
    fprintf(exEnv.error_file,"CORAL :: Error -- first argument to %s should be free",
	    SymbolString(CreateSetSymbol));
    (query->args())[0]->printon(exEnv.error_file);
    fprintf(exEnv.error_file,"\n");
    return NULL;
  }
  ArgList *alist = ArgList::New(arity);
  (*alist)[0] = create_nested_multiset();

  Tuple *return_tuple = new Tuple(alist);
  return return_tuple;
}

/*******************************************************************/
Tuple *AddElemSolver(Tuple *query)
{
  if (query == NULL) {
    fprintf(exEnv.error_file,"Null argument passed to %s \n",
	    SymbolString(AddElemSymbol)); 
    return NULL; 
  }

  int arity;
  if ((arity = query->arity()) != 3) {
    CORAL_error(COR_BAD_ARITY, "3 arguments to add_elem needed", NULL);
    return NULL;
  }

  if (!((query->args())[0])->isConstant()) {
    fprintf(exEnv.error_file,"CORAL :: Error -- first argument to %s is free",
	    SymbolString(AddElemSymbol));
    (query->args())[0]->printon(exEnv.error_file);
    fprintf(exEnv.error_file,"\n");
    return NULL;
  }

  if (((query->args())[1])->kindof() != COR_RELATION) {
    fprintf(exEnv.error_file,"CORAL :: Error -- second argument to %s is not a set",
	    SymbolString(AddElemSymbol));
    (query->args())[1]->printon(exEnv.error_file);
    fprintf(exEnv.error_file,"\n");
    return NULL;
  }

  ArgList *alist = ArgList::New(arity);
  (*alist)[0] = (query->args())[0] ;
  (*alist)[1] = (query->args())[1] ;

  ((*alist)[2]) = create_nested_multiset();
  ((Relation *)((*alist)[1]))->add_all_tuples((Relation *)(((*alist)[2])));
  ((Relation *)(((*alist)[2])))->
    insert_tuple(make_tuple(make_arglist1((*alist)[0])));

  if (((query->args())[2])->isConstant()) {
    if (((query->args())[2])->kindof() != COR_RELATION) {
      fprintf(exEnv.error_file,"CORAL :: Error -- third argument to %s is not a set",
	      SymbolString(AddElemSymbol));
      (query->args())[2]->printon(exEnv.error_file);
      fprintf(exEnv.error_file,"\n");
      return NULL;
    }
    else if (!((query->args())[2])->equals(((*alist)[2])))
      return NULL;
  }

  Tuple *return_tuple = new Tuple(alist);
  return return_tuple;  
}

/*******************************************************************/
Tuple *AbsSolver(Tuple *query)
{
  if (query == NULL) {
    fprintf(exEnv.error_file,"Null argument passed to %s \n",
	    SymbolString(AbsOpSymbol)); 
    return NULL; 
  }

  int arity;
  if ((arity = query->arity()) != 2) {
    CORAL_error(COR_BAD_ARITY, "2 arguments to abs needed", NULL);
    return NULL;
  }

  if (((query->args())[0])->kindof() != COR_NUM_CONST) {
    fprintf(exEnv.error_file,
	    "CORAL :: Error -- first argument to %s is not a number",
	    SymbolString(AbsOpSymbol));
    (query->args())[0]->printon(exEnv.error_file);
    fprintf(exEnv.error_file,"\n");
    return NULL;
  }

  if ((((query->args())[1])->kindof() != COR_NUM_CONST) && 
      (((query->args())[1])->kindof() != COR_VARIABLE)) {
    fprintf(exEnv.error_file,
	    "CORAL :: Error -- second argument to %s is neither free nor \
                    a number", SymbolString(AbsOpSymbol));	    
    (query->args())[1]->printon(exEnv.error_file);
    fprintf(exEnv.error_file,"\n");
    return NULL;
  }

  ArgList *alist = ArgList::New(arity);

  double arg0, arg1;
  int arg1_is_var = 0;

  (*alist)[0] = (query->args())[0] ;
  if (is_double((*alist)[0])) arg0 = make_double((*alist)[0]);
  else if (is_int((*alist)[0])) arg0 = make_int((*alist)[0]);
  else return NULL;

  if (is_double((query->args())[1])) arg1 = make_double((query->args())[1]);
  else if (is_int((query->args())[1])) arg1 = make_int((query->args())[1]);
  else arg1_is_var = 1;

  if (arg1_is_var) {
      (*alist)[1] = make_arg(fabs(arg0));    
  }
  else {
    if (fabs(arg0) == arg1) 
      (*alist)[1] = (query->args())[1] ;
    else
      return NULL;
  }

  Tuple *return_tuple = new Tuple(alist);
  return return_tuple;
}
