/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "arg.h"
#include "rules.h"
#include "collection.h"
#include "externs.h"
#include "annotations.h"
#include "globals.h"
#include <stdlib.h>
#include <string.h>

extern void sprint_adornment(char *buf, BitVector *adorn);

extern void sprint_magic_name(char *buf, char *name, BitVector *adorn);
extern void sprint_magic_name(char *buf, char *name, char *adorn);
extern void fprint_magic_name(FILE *out, char *name, BitVector *adorn);
extern void fprint_magic_name(FILE *out, char *name, char *adorn);

extern void sprint_pred_name(char *buf, char *name, BitVector *adorn);
extern void sprint_pred_name(char *buf, char *name, char *adorn);
extern void fprint_pred_name(FILE *out, char *name, BitVector *adorn);
extern void fprint_pred_name(FILE *out, char *name, char *adorn);

static void print_unique_prednames(Clause *r, FILE *out);
void print_sips(Clause *r, struct sips *s, FILE *out);
// void print_pred(Literal *p, FILE *out, int head);
static void sprint_adornment(BitVector& adorn, char *str, int *pos) ;

int print_new_line_after_rule=1;

// ************
// print_adorn_for_pred is cleared when rules need to be displayed for tracing.
// At this stage, the predicate names already have the adornment.
// When the magic program calls the routine, the predicate names do not have 
// their adornments yet, and so the adornment needs to be printed out. 
//  The magic program uses the default setting of print_adorn_for_pred = 1.
// ************

int print_adorn_for_pred=1;
int C_suppress_all_free=0;

// ---------------------------------------------------------------

void print_rule(Clause *rule, FILE *out)
{
    int j;
    for (ClauseName *cname = rule->clause_names; cname; cname = cname->next) {
	fprintf(out, "%s", SymbolString(cname->name));
	if (cname->negated) fprintf(out, "-");
	fprintf(out, ": ");
    }
    print_pred(rule->head, out);
    for(int i=0; i < rule->head_deletes_count; i++) {
	fprintf(out, ", ");
	print_pred(rule->head_deletes[i], out, /* head */ 1);
    }
    if (rule->num_preds > 0 || rule->sips != NULL) {
	fprintf(out, " :- \n\t\t");
	for (j = 0; j < rule->num_preds; ++j) {
	    print_pred(rule->preds[j], out);
	    if (j < rule->num_preds - 1)
		fprintf(out, ", \n\t\t"); // print a pred on a line.
	}
	if (j==0)
	    fprintf(out, "true");	/* print "true" if no rhs preds */
	if (rule->sips) {
	    fprintf(out, " \n \t \t alias ");
	    print_sips(rule, rule->sips, out);
	}
    }
    fprintf(out, ".");

// Default is to print the new line. This is used by the magic program.
// While dumping trace code, we dont want new lines printed. So then
// the variable is cleared.
    if (print_new_line_after_rule)
     	fprintf(out, "\n");
}

static void sprint_pred( Literal *p, char *str, int *pos, int head=0)
{
    switch (p->kind) {
    case COR_REGULAR:
	if ( p->negated ) { 
	    if (head) 
		sprintf(str +*pos," del ") ;
	    else 
		sprintf(str +*pos," not ") ;
	    *pos += 5 ;
	}
	break;
    default :
	ASSERT((! p->negated )) ;
	break;
    }

    sprintf(str+(*pos), "%s", SymbolString(p->pred)) ;
    *pos += SymbolLength(p->pred) ;

    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    sprint_adornment(p->adorn, str, pos);
    C_suppress_all_free = temp;
    sprintf(str + *pos, "(");
    (*pos)++ ;
    p->args.sprint(str, pos);
    sprintf(str + *pos, ")");
    (*pos)++ ;
}

void sprint_rule(Clause *rule, char *str)
{
    int j; int str_pos = 0 ;
    for (ClauseName *cname = rule->clause_names; cname; cname = cname->next){
	sprintf(str+str_pos, "%s", SymbolString(cname->name));
	str_pos += SymbolLength(cname->name) ;
	if (cname->negated) {
	    sprintf(str+str_pos, "-");
	    str_pos++;
	}
	sprintf(str+str_pos, ": ") ;
	str_pos += 2 ;
    }

    sprint_pred(rule->head, str, &str_pos) ;
    for(j=0; j < rule->head_deletes_count; j++) {
	sprintf(str+str_pos, ", ");
	str_pos += 2;
	sprint_pred(rule->head_deletes[j], str, &str_pos, /* head */ 1);
    }
    if (rule->num_preds > 0 || rule->sips != NULL) {
	sprintf(str+str_pos, " :- ") ;
	str_pos += 4 ;
	for (j = 0; j < rule->num_preds; ++j) {
	    sprint_pred(rule->preds[j], str, &str_pos);
	    if (j < rule->num_preds - 1) {
		sprintf(str+str_pos, ", \n\t\t");
		str_pos += 5;
	    }
	}
	if (j==0){
	    sprintf(str+str_pos, "true") ;
	    str_pos += 4 ;
	}

// NOTE : Left out sips information
    }
    sprintf(str+str_pos, ".");
}

/*
void unparse(ParserStruct& parserStruct)
{

    if (parserStruct.CurModule.name)
	fprintf(stdout, "module %s.\n", SymbolString(parserStruct.CurModule.name));

    FOR_EACH_RULE(rule, parserStruct.rules) {
        print_rule(rule, stdout);
    } END_EACH_RULE
}
*/

/*
 * Print a unique (within 'rule') name for the index'th predicate of 'rule',
 * where index==0 means the head, and 1 is the first RHS predicate.
 */

static void print_unique_predname(Clause *rule, int index, FILE *out)
{
    Literal *pred = index ? rule->preds[index-1] : rule->head;
#ifdef SHORT_SIP_PREDNAMES
    fprintf(out, "%c%d", SymbolString(pred->pred)[0], index);
#else /* !SHORT_SIP_PREDNAMES */
    char num_preds[12];
    sprintf(num_preds, "%d", rule->num_preds);
    fprintf(out, "%s", SymbolString(pred->pred));
    /* Letting the format depend on num_preds guarantees that the
     * same number of digits is used for all the preds. */
    fprintf(out, "%0*d", strlen(num_preds), index);
#endif /* !SHORT_SIP_PREDNAMES */
}

static void print_unique_prednames(Clause *r, FILE *out)
{
    int i;

    fprintf(out, "[");
    print_unique_predname(r, 0, out);
    for (i = 1; i <= r->num_preds; i++) {
	fprintf(out, ", ");
	print_unique_predname(r, i, out);
    }
    fprintf(out, "]");
}

void print_pred( Literal *p, FILE *out, int head)
{
    switch (p->kind) {
    case COR_REGULAR:
      if ( p->negated ) {
	if (head) 
	    fprintf(out, " del ") ;
	else 
	    fprintf(out, " not ") ;
      }
      PrintSymbol(p->pred, out);
      break;
    case COR_MAGIC:
      /* CHANGE */
      ASSERT((! p->negated )) ;
      fprintf(out, "m_%s", SymbolString(p->pred));
      break;
    case COR_SUPMAGIC:
      /* CHANGE */
      ASSERT((! p->negated )) ;
      fprintf(out, "%s", SymbolString(p->pred)) ;
      break;
    case COR_FACTORMAGIC:
      ASSERT((! p->negated )) ;
      fprintf(out, "mf_%s", SymbolString(p->pred));
      break ;
    case COR_DONE_MAGIC:
      ASSERT((! p->negated )) ;
      fprintf(out, "done_m_%s", SymbolString(p->pred));
      break ;
    }


    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    print_adornment(p->adorn, out);
    C_suppress_all_free = temp;
    fprintf(out, "(");
    p->args.printon(out);
    fprintf(out, ")");
}

void print_adornment_brack(BitVector& a, FILE *file)
{
    int i;

    for (i = 0; i < a.len(); ++i) {
	fprintf(file, a.test(i) ? "b" : "f");
	}
}

void print_sip(Clause *r, struct sip *s, FILE *out)
{
    int b;

    for (; s; s = s->next) {
	fprintf(out, "\n\t\t\t\t[");
	for (b = s->tail.next(-1); b >= 0; b = s->tail.next(b)) {
	    print_unique_predname(r, b, out);
	    if (s->tail.next(b) >= 0 ) 
		fprintf(out, ", ");
	    }
	fprintf(out, "] ==> ");
	print_unique_predname(r, s->head, out);
	fprintf(out, "(");
	for(int c= s->bound_vars.next(-1),i=0; c>=0; 
				c=s->bound_vars.next(c), i++) {
	    fprintf(out, "%s", SymbolString(r->var_names[c]));
	    if ( i ) fprintf(out,",");
	}
	fprintf(out, ")");
	if(s->next)
	    fprintf(out, ",\n");
	else fprintf(out, "\n");
    }
}

void print_sips(Clause *r, struct sips *s, FILE *out)
{
    int sip_printed = 0;
    print_unique_prednames(r, out);
    fprintf(out, "\n") ;
    if ( s ) fprintf(out, "\t\t sips [\n ") ;

    for (; s; s = s->next) {
	if( 1 /*s->sip_list*/ ) {
	    if (sip_printed) fprintf(out, ",\n");
	    sip_printed = 1 ;
	    fprintf(out, "\t\t\t[ ");
	    print_adornment_brack(s->adorn, out);
	    fprintf(out, ": ");
	    print_sip(r, s->sip_list, out);
	    fprintf(out, "\t\t\t]") ;
	    }
    }
    if ( !sip_printed )
	fprintf(out, "\t[ ]") ;
    else fprintf(out, "\t\t ]\n");
}

/*****************************************************************/

static int all_args_free(BitVector *a)
{
	return(allargsfree(a));
}

static int all_args_free(char *a)
{
    for (int i=0; i < strlen(a); i++)
	if (a[i] == 'b')
	    return 0;
    return 1;
}

static int suppress_printing(BitVector *a)
{
    if (! print_adorn_for_pred)
       return 1;
    if (a->len() == 0)
       return 1;
    if (C_suppress_all_free && all_args_free(a))
       return 1;
    return 0;
}

static int suppress_printing(char *a)
{
    if (! print_adorn_for_pred)
       return 1;
    if (strlen(a) == 0)
       return 1;
    if (C_suppress_all_free && all_args_free(a))
       return 1;
    return 0;
}

void sprint_adornment(char *buf, BitVector* a)
{
    if(!a) return;
    if (! suppress_printing(a)) {
	*buf++ = '_';
        for (int i = 0; i < a->len(); i++)
	    buf[i] = a->test(i) ? 'b' : 'f';
        buf[a->len()] = '\0';
    }
}

void sprint_adornment(char *buf, char *a)
{
    if(!a) return;
    if ( ! suppress_printing(a)) {
	*buf++ = '_';
	sprintf(buf, "%s", a);
    }
}


static void sprint_adornment(BitVector& a, char *str, int *pos)
{
    if ( ! suppress_printing(&a)) {
	sprintf(str + *pos, "_"); (*pos)++ ;
        for (int i = 0; i < a.len(); ++i) {
	    sprintf(str + *pos, a.test(i) ? "b" : "f");
	    (*pos)++ ;
	}
    }
}

void print_adornment(BitVector& a, FILE *file)
{
    if ( !suppress_printing(&a)) {
	fprintf(file, "_");
        for (int i = 0; i < a.len(); ++i)
	    fprintf(file, a.test(i) ? "b" : "f");
    }
}

void print_adornment(BitVector *a, FILE *file)
{
    if (!a) return;
    print_adornment(*a, file);
}

void print_adornment(char *a, FILE *file)
{
    if(!a) return;
    if ( !suppress_printing(a)) {
	fprintf(file, "_");
	fprintf(file, "%s", a);
    }
}

void sprint_magic_name(char *buf, char *name, BitVector *adorn)
{
    sprintf(buf, "m_%s", name);
    char *p = buf + strlen(buf);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    sprint_adornment(p,adorn);
    C_suppress_all_free = temp;
}

void sprint_magic_name(char *buf, char *name, char *adorn)
{
    sprintf(buf, "m_%s", name);
    char *p = buf + strlen(buf);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    sprint_adornment(p,adorn);
    C_suppress_all_free = temp;
}

void fprint_magic_name(FILE *out, char *name, BitVector *adorn)
{
    fprintf(out, "m_%s", name);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    print_adornment(adorn, out);
    C_suppress_all_free = temp;
}

void fprint_magic_name(FILE *out, char *name, char *adorn)
{
    fprintf(out, "m_%s", name);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    print_adornment(adorn, out);
    C_suppress_all_free = temp;
}

void sprint_pred_name(char *buf, char *name, BitVector *adorn)
{
    sprintf(buf, "%s", name);
    char *p = buf + strlen(buf);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    sprint_adornment(p,adorn);
    C_suppress_all_free = temp;
}

void sprint_pred_name(char *buf, char *name, char *adorn)
{
    sprintf(buf, "%s", name);
    char *p = buf + strlen(buf);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    sprint_adornment(p,adorn);
    C_suppress_all_free = temp;
}

void fprint_pred_name(FILE *out, char *name, BitVector *adorn)
{
    fprintf(out, "%s", name);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    print_adornment(adorn, out);
    C_suppress_all_free = temp;
}

void fprint_pred_name(FILE *out, char *name, char *adorn)
{
    fprintf(out, "%s", name);
    int temp = C_suppress_all_free;
    C_suppress_all_free = 1;
    print_adornment(adorn, out);
    C_suppress_all_free = temp;
}

/*****************************************************************/

void print_allowed_adornment_annotations(PredAnnotations *anno,FILE *file)
{
    PredAnnotations *cur;

    for(cur = anno; cur; cur=cur->next()){
	fprintf(file,"%s%s  ", "@",SymbolString(AllowedAdornSymbol));
	cur->print(file, 0); // adornment printing wrt non-adorned predicates
	fprintf(file, ".\n");
    }
}

void print_make_index_annotations(PredAnnotations *anno, FILE *file)
{

    PredAnnotations *cur;

    for(cur = anno; cur; cur=cur->next()){
	fprintf(file,"%s%s  ", "@",SymbolString(MakeIndexSymbol));
	cur->print(file);
	fprintf(file, ".\n");
    }
}

void print_agg_sel_annotations(PredAnnotations *anno, FILE *file)
{
    PredAnnotations *cur;

    for(cur = anno; cur; cur=cur->next()){
	fprintf(file,"%s%s  ", "@",SymbolString(AggSelectionSymbol));
	cur->print(file);
	fprintf(file, ".\n");
    }
}

void print_prioritize_annotations(PredAnnotations *anno, FILE *file)
{
    PredAnnotations *cur;

    for(cur = anno; cur; cur=cur->next()){
      fprintf(file,"%s%s  ", "@",SymbolString(PrioritizeSymbol));
      cur->print(file);
      fprintf(file, ".\n");
    }
}


void print_MultisetAnnotations(PredAnnotations *anno, FILE *file)
{
  
  PredAnnotations *cur;
  
  for(cur = anno; cur; cur=cur->next()){
    if (cur->check_subsum == 0) 
      fprintf(file,"%s%s  ", "@",SymbolString(MultisetSymbol));
    else fprintf(file,"%s%s  ", "@",SymbolString(CheckSubsumSymbol));
    
    cur->print(file, 0);
    fprintf(file, ".\n");
  }

}

void print_Annotations(ModuleInfo& module_info,
		       FILE *file,
		       PredAnnotations *index,
		       PredAnnotations *agg_sel,
		       PredAnnotations *allowed_adorn,
		       PredAnnotations *multiset,
	               PredAnnotations *prioritize_annotations)
{
  fprintf(file, "@%s %c.\n", SymbolString(NoPreProcessingSymbol),
	  (module_info.PreProcessing ? '-' : '+'));
  fprintf(file, "@%s %c.\n", SymbolString(SupMagicIndexingSymbol),
	  (module_info.SupMagicIndexing ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(SupplementaryMagicSymbol),
	  (module_info.UseSupplementaryMagic ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(ExistOptSymbol),
	  (module_info.UseExistOpt ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(UseFactoringSymbol),
	  (module_info.UseFactoring ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(OrdinaryMagicSymbol),
	  (module_info.UseMagic ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(NoRewritingSymbol),
	  (module_info.Rewriting ? '-' : '+'));
  fprintf(file, "@%s %c.\n", SymbolString(UseOrdSearchSymbol),
	  (module_info.UseOrdSearch ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(SaveModuleSymbol),
	  (module_info.SaveModule ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(UsePipeliningSymbol),
	  (module_info.UsePipelining ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(SingleSccSymbol),
	  (module_info.SingleScc ? '+' : '-'));

  print_make_index_annotations(index, file);
  print_agg_sel_annotations(agg_sel, file);
  print_prioritize_annotations(prioritize_annotations, file);
  print_allowed_adornment_annotations(allowed_adorn, file);

  fprintf(file, "@%s %c.\n", SymbolString(CheckSubsumSymbol),
	  (module_info.CheckSubsum ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(MultisetSymbol),
	  (module_info.MultiSet ? '+' : '-'));
  print_MultisetAnnotations(multiset, file);


  fprintf(file, "@%s %c.\n", SymbolString(IndexDeltaSymbol),
	  (module_info.IndexDeltas ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(ReturnUnifySymbol),
	  (module_info.UseReturnUnify ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(ConvertFunctionsSymbol),
	  (module_info.ConvertFunctions ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(NonGroundFactsSymbol),
	  (module_info.NonGroundFacts ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(EagerEvalSymbol),
	  (module_info.EagerEval ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(MonotonicSymbol),
	  (module_info.Monotonic ? '+' : '-'));
  fprintf(file, "@%s %c.\n", SymbolString(PredicateSNSymbol),
	  (module_info.UsePredicateSN ? '+' : '-'));

}


void PredAnnotations::print(FILE *file, int adorned /* =1 */)
{

    if (adorned) {
        fprint_pred_name(file, SymbolString(pred), adorn);
    }
    else {
	fprint_pred_name(file, SymbolString(pred), (BitVector *) NULL);
	if (adorn) {
	  fprintf(file, "[");
	  for (int i = 0; i < adorn->len(); ++i)
	    fprintf(file, adorn->test(i) ? "b" : "f");
	  fprintf(file, "]");
	}
    }

    if (arglist1) {
	fprintf(file,"(");
	arglist1->print(NULL,file);
	fprintf(file,")");
    }

    if (arglist2) {
      fprintf(file,"(");
      arglist2->print(NULL,file);
      fprintf(file,")");
    }

    if (op_arg) {
	op_arg->print(NULL,file);
    }

}
