/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifdef __GNUG__
#ifdef USEGNUGPRAGMAS
#pragma implementation
#endif
#endif

#include "term.h"
#include "globals.h"
#include <string.h>
#include <malloc.h>

extern int C_ConstructEnvCount;
extern int C_ConstructEnvSize;
extern int C_DestructEnvCount;
extern int C_DestructEnvSize;


/****************************************************************************/
// TrieNode methods.
// -----------------

TrieNode * TrieNode::copy() 
{
    TrieNode *newnode = new TrieNode;
    *newnode = *this;
    return newnode;
}

TrieNode *make_trie(int height) 
{	
    TrieNode *node = new TrieNode();
    node->height = height;
    if (height > 1) {
        for (int i=0; i < 2; i++)
	    node->pointers[i] = make_trie(height-1);
    }
    else {
	node->binding.bindenv = NULL;
	node->binding.expr = NULL;
    }
    return node;
}


/****************************************************************************/
//
// BindEnvs:
//
//---------------------------------------------------------------------------
/****************************************************************************/
//
// ArrayBindEnvs:
//
//---------------------------------------------------------------------------


ArrayBindEnv::ArrayBindEnv(int size, int )
{
    _limit = size;
    bindarray = new Term [size];
    //bzero(bindarray, size * sizeof(Term));
    memset(bindarray, 0, size * sizeof(Term));
    _is_versioned = 0;
#ifdef DEBUG
    C_ConstructEnvCount++;
    C_ConstructEnvSize += _limit;
#endif
}

ArrayBindEnv::ArrayBindEnv()
{
    _limit = 0;
    bindarray = NULL;
    _is_versioned = 0;
#ifdef DEBUG
    C_ConstructEnvCount++;
#endif
}

ArrayBindEnv::~ArrayBindEnv()
{
    delete [] bindarray;
#ifdef DEBUG
    C_DestructEnvCount++;
    C_DestructEnvSize += _limit;
#endif
}

int ArrayBindEnv::all_free()
{
   for(register int i=0; i < _limit; i++)
       if (bindarray[i].expr != NULL)
	    return 0;
   return 1;
}

BindEnv * ArrayBindEnv::make_version()
{
    // WARNING - got to change this once versioned bindenvs are implemented
    //   	properly.

    VersionedBindEnv *newenv = new VersionedBindEnv(_limit);
    for (register int i=0; i< _limit; i++)
#ifdef USE_TRIES
	newenv->forcebind(i, bindarray[i]);
#else
	newenv->bind(i, bindarray[i]);
#endif
    return ((BindEnv*) newenv);
}

void ArrayBindEnv::resize(int newsize)
{
    Term *newbindarray = new Term [newsize];
    for(int i=0; i < _limit; i++)
       newbindarray[i] = bindarray[i];
    //bzero(&(newbindarray[_limit]), (newsize-_limit) * sizeof(Term));
    memset(&(newbindarray[_limit]), 0, (newsize-_limit) * sizeof(Term));
    Term *oldbindarray = bindarray;
    bindarray = newbindarray;
    _limit = newsize;
    delete oldbindarray;
}

BindEnv * ArrayBindEnv::make_version_and_swap()
{
    // This is a hack --- see note on versioning-hack for more information
    ArrayBindEnv *newenv = new ArrayBindEnv(_limit);
    for (register int i=0; i< _limit; i++)
	newenv->bindarray[i] = bindarray[i];

    // Swap bindarrays, so that backpatching trashes the new version.
    //  the old version is still available for reuse.

    Term *temparray = bindarray;
    bindarray = newenv->bindarray;
    newenv->bindarray = temparray;
    return ((BindEnv*) newenv);
}

void ArrayBindEnv::restore(BindEnv *env)
{
    // This is a hack --- see note on versioning-hack for more information
	// env has to be an array bindenv
    ArrayBindEnv *newenv = (ArrayBindEnv *)env;
    bindarray = newenv->bindarray;
    _limit = newenv->_limit;
}

BindEnv* ArrayBindEnv::copy_shell() {
    // This is a hack -- see note on versioning-hack for more information
	// Copy out the structure, but not the contents
	// Use this very carefully --- deleting bindenvs will delete the
	// bindarray too, so better use ::delete on the original bindenv
	//	rather than delete.
    ArrayBindEnv *newenv = new ArrayBindEnv ();
    newenv->_limit = _limit;
    newenv->bindarray = bindarray;
    return newenv;
}


/****************************************************************************/
//
// VersionedBindEnvs:
//
//     		Make sure VersionedBindEnv and ArrayBindEnv are used in
//		appropriate places.  It's dangerous to use versioned bindenvs
//		in place of arraybindenvs, and inefficient to do the reverse.
/***************
   NOTE:

   Versioned bindenvs should drop the bindenv name for all local bindings.
   Otherwise there will be problems with versioning.
   Suppose we had a bindenv a, with binding (t,a) for variable X.
   If we create a version a' of a, it should have the binding 
   (t,a') for X, and not (t,a).  Changing the names of the bindenv 
   for all bindings can be very expensive.  Hence we use NULL to refer to
   local bindings, internally.  We fool the external world by adding/deleting
   the bindenv when bindings are lookedup/created.

   Non-local bindings are created during rule application, but are 
   undone later on.  For such bindings we store the bindenv name and 
   do not change it on access.

****************/
//---------------------------------------------------------------------------

#ifdef USE_TRIES

VersionedBindEnv::VersionedBindEnv(int size, int )
{
    _limit = size;
    unsigned int hpower = 1;
    int height=1;	// height == 1 ==> leaf node
    while(hpower < size) {
       // hpower <<= 1;
       hpower *= 2;
       height++;
    }
    trie = make_trie(height);
    _is_versioned = 1;
#ifdef DEBUG
    C_ConstructEnvCount++;
    C_ConstructEnvSize += size;
#endif
}

VersionedBindEnv::VersionedBindEnv()
{
    _limit = 0;
    trie = NULL;
    _is_versioned = 1;
#ifdef DEBUG
    C_ConstructEnvCount++;
#endif
}

VersionedBindEnv::~VersionedBindEnv() {
#ifdef DEBUG
    C_DestructEnvCount++;
#endif
}

#ifdef NOBINDENVHACK
Term VersionedBindEnv::lookup(Variable var) const
#else
Term VersionedBindEnv::lookupV(Variable var) const
#endif
{    
    TrieNode *node = trie;
    ASSERT(((var < _limit) && (trie != NULL)));
    int varbackup = var;

    for(; node->height > 1; var=varbackup) {
        node = node->pointers[ (var >> (node->height-2)) & 1 ];
    }
    var=varbackup;
    Term term = node->binding;

    if (term.bindenv==NULL)
	term.bindenv = (BindEnv *)this;
    return term;
}

#ifdef NOBINDENVHACK
int VersionedBindEnv::bind(Variable var, Term term)
#else
int VersionedBindEnv::bindV(Variable var, Term term)
#endif
{
    TrieNode** nodep = &trie;
    ASSERT(((var < _limit) && trie != NULL));
    int varbackup = var; // To cover for bug in CFront.

    TrieNode *newnode;
    while( (*nodep)->height > 1) {
	newnode = (*nodep)->copy();
	(*nodep) = newnode;
	nodep = &(newnode->pointers[ (var >> (newnode->height-2)) & 1 ]);
	var = varbackup;
    }
    (*nodep) = (*nodep)->copy();
    (*nodep)->binding = term;  
    if ( (*nodep)->binding.bindenv == this)
	(*nodep)->binding.bindenv = NULL;
    return 1;
}

int VersionedBindEnv::forcebind(Variable var, Term term)
{
    /* Directly bind variable without making a copy of the path.
    *	 Useful for initialization of bindenvs
    */
    TrieNode *node = trie;
    int varbackup = var; // To cover for bug in CFront.

    ASSERT((var < _limit));
    for(; node->height > 1;var=varbackup) {
        node = node->pointers[ (var >> (node->height-2)) & 1 ];
    }
    node->binding = term;
    if (node->binding.bindenv == this)
	node->binding.bindenv = NULL;
    return 1;
}


BindEnv * VersionedBindEnv::make_version() {
    VersionedBindEnv *newenv = new VersionedBindEnv();
    (*newenv) = (*this);
    return ((BindEnv*) newenv);
}

void VersionedBindEnv::resize(int newsize) {

    if (newsize <= _limit)
	return;
#ifdef DEBUG
    C_ConstructEnvSize += newsize - _limit;
#endif

    int tmp = 1; // To avoid possible CFront bug, I'm using tmp instead of 1

    if ( newsize <= (tmp << (trie->height-1) )) {
	_limit = newsize;
	return;
    }

    TrieNode *right, *parent;
    tmp = 1;
    for (; newsize > (tmp << (trie->height-1)) ; tmp = 1) {
 	right = make_trie(trie->height);
	parent = new TrieNode();
	parent->pointers[0] = trie;
	parent->pointers[1] = right;
	parent->height = trie->height + 1;
	trie = parent;
    } 
    _limit = newsize;
}

int VersionedBindEnv::all_free() {
   for(register int i=0; i < _limit; i++)
       if (lookup(i).expr != NULL)
	    return 0;
   return 1;
}


BindEnv * VersionedBindEnv::make_version_and_swap()
{
    VersionedBindEnv *newenv = new VersionedBindEnv();
    (*newenv) = (*this);
    //  No need to swap tries, since trie updates are non-destructive

    return ((BindEnv*) newenv);
}

void VersionedBindEnv::restore(BindEnv *env)
{
    VersionedBindEnv *newenv = (VersionedBindEnv *)env;
    trie = newenv->trie;
    _limit = newenv->_limit;
}

BindEnv* VersionedBindEnv::copy_shell() {
    // This is a hack -- see note on versioning-hack for more information
	// Copy out the structure, but not the contents
	// Use this very carefully --- deleting bindenvs will delete the
	// bindarray too, so better use ::delete on the original bindenv
	//	rather than delete.
    VersionedBindEnv *newenv = new VersionedBindEnv ();
    (*newenv) = (*this);
    return newenv;
}

/*-------------------------------------------------------------------*/
#else 	/* Don't USE_TRIES */
/*-------------------------------------------------------------------*/

VersionedBindEnv::VersionedBindEnv(int size, int incr)
{
    _limit = size;
    bindarray = new Term [size];
    _is_versioned = 1;
#ifdef DEBUG
    C_ConstructEnvCount++;
    C_ConstructEnvSize += _limit;
#endif
}

VersionedBindEnv::VersionedBindEnv()
{
    _limit = 0;
    bindarray = NULL;
    _is_versioned = 1;
#ifdef DEBUG
    C_ConstructEnvCount++;
#endif
}

VersionedBindEnv::~VersionedBindEnv() {
    delete [] bindarray;
#ifdef DEBUG
    C_DestructEnvCount++;
    C_DestructEnvSize += _limit;
#endif
}


#ifdef NOBINDENVHACK
Term VersionedBindEnv::lookup(Variable var) const
#else
Term VersionedBindEnv::lookupV(Variable var) const
#endif
{    
    Term term = bindarray[var];
    if (term.bindenv==NULL)
	term.bindenv = this;
    return term;
}

#ifdef NOBINDENVHACK
int VersionedBindEnv::bind(Variable var, Term term)
#else
int VersionedBindEnv::bindV(Variable var, Term term)
#endif
{
    bindarray[var]=binding;  
    if (bindarray[var].bindenv == this)
	bindarray[var].bindenv = NULL;
    return 1;
}

int VersionedBindEnv::forcebind(Variable var, Term binding)
{
    bindarray[var]=binding;  
    if (bindarray[var].bindenv == this)
	bindarray[var].bindenv = NULL;
    return 1;
}

BindEnv * VersionedBindEnv::make_version() {
    VersionedBindEnv *newenv = new VersionedBindEnv(_limit);
    for (register int i=0; i< _limit; i++)
	newenv->bindarray[i] = bindarray[i];
    return ((BindEnv*) newenv);
}

void VersionedBindEnv::resize(int newsize) {
    Term *newbindarray = new Term [newsize];
    for(int i=0; i < _limit; i++)
       newbindarray[i] = bindarray[i];
    //bzero(&(newbindarray[_limit]), (newsize-_limit) * sizeof(Term));
    memset(&(newbindarray[_limit]), 0, (newsize-_limit) * sizeof(Term));
    Term *oldbindarray = bindarray;
    bindarray = newbindarray;
    _limit = newsize;
    delete oldbindarray;
}

int VersionedBindEnv::all_free() {
   for(register int i=0; i < _limit; i++)
       if (bindarray[i].expr != NULL)
	    return 0;
   return 1;
}


BindEnv * VersionedBindEnv::make_version_and_swap()
{
    // This is a hack --- see note on versioning-hack for more information
    VersionedBindEnv *newenv = new VersionedBindEnv(_limit);
    for (register int i=0; i< _limit; i++)
	newenv->bindarray[i] = bindarray[i];

    // Swap bindarrays, so that backpatching trashes the new version.
    //  the old version is still available for reuse.

    Term *temparray = bindarray;
    bindarray = newenv->bindarray;
    newenv->bindarray = temparray;
    return ((BindEnv*) newenv);
}

void VersionedBindEnv::restore(BindEnv *env)
{
    // This is a hack --- see note on versioning-hack for more information
	// env has to be an VersionedBindEnv
    VersionedBindEnv *newenv = (VersionedBindEnv *)env;
    bindarray = newenv->bindarray;
    _limit = newenv->_limit;
}

BindEnv* VersionedBindEnv::copy_shell() {
    // This is a hack -- see note on versioning-hack for more information
	// Copy out the structure, but not the contents
	// Use this very carefully --- deleting bindenvs will delete the
	// bindarray too, so better use ::delete on the original bindenv
	//	rather than delete.
    VersionedBindEnv *newenv = new VersionedBindEnv ();
    newenv->_limit = _limit;
    newenv->bindarray = bindarray;
    return newenv;
}

#endif	/* else case of USE_TRIES */


/****************************************************************************/
//
// GArrayBindEnvs: This should use C++ templates !!! - PRAVEEN
//
//---------------------------------------------------------------------------

//GArrayImplement(Term);
Term_garray::Term_garray(int tsize, int inc, int tlimit)  
{					
  size = tsize;			
  if (tlimit < 0) _limit = size;	
  else _limit = tlimit;	
  incr = inc;	
	if (size<incr) incr = size;
	if (tsize <= 0) tarray = NULL; 	      
	else  tarray = new Term *[ceil_div(tsize,inc)];
	C_NewGArraySize += ceil_div(tsize,inc)*sizeof(Term *);
	for(int i=0;i<ceil_div(tsize,inc);i++) tarray[i]=NULL;  
    }								
								
int Term_garray::resize(int newsize) 			
{								
  int i;							
  if(newsize <= size) { size = newsize; return 0;}	
  if (_limit < newsize) _limit = newsize;			
  Term **newarray = new Term *[ceil_div(newsize,incr)];
  for(i=0;i<ceil_div(size,incr);i++) 		
    newarray[i]=tarray[i];		
  for(i=ceil_div(size,incr);i<ceil_div(newsize,incr);i++)
    newarray[i]=NULL;			       
  C_NewGArraySize += (newsize - size)*sizeof(Term *);
  size = newsize;		
  delete tarray;		
  tarray = newarray;	
  return 0;		
}				

Term_garray * Term_garray::make_copy()		
{							
  int i,j;					
  Term_garray *copy = new Term_garray;		
  
  copy->size = size;				
  copy->_limit = _limit;				
  copy->incr = incr;				
  if(size<=0)	copy->tarray = NULL;		
  else copy->tarray = new Term *[ceil_div(size,incr)];	
  C_NewGArraySize += size * sizeof(Term *);
  for(i=0;i<ceil_div(size,incr);i++){
    if(tarray[i]) {			
      copy->tarray[i] = new Term[incr];	
      for (j=0;j<incr;j++)			
	copy->tarray[i][j] = tarray[i][j];	
      C_NewGArraySize += incr*sizeof(Term);
    }					
    else copy->tarray[i] = NULL;			
  }						
  return (copy) ;					
}							

int Term_garray::get_next(int i)			
{							
  if ( !tarray ) return(-1);			
  for(i++;i<size;){				
    if (! tarray[i/incr])				
      i = ((i/incr)+1)*incr;			
    else break;					
  }						
  return(i);					
}							

Term_garray::~Term_garray()			
{							
  if (!tarray) return;				
  for(int i=0; i< ceil_div(size,incr);i++) {	
    if(tarray[i]) {				
      delete [incr] tarray[i];			
      C_DeleteGArraySize += incr*sizeof(Term);
    }						
  }						
  delete [ceil_div(size,incr)] tarray ;		
  C_DeleteGArraySize += ceil_div(size,incr)*sizeof(Term *);
}

// END Implementation
GArrayBindEnv::GArrayBindEnv(int size, int incr /* = 128 */)
{
    _limit = size;
    ASSERT((size >=0))
    bindarray = new Term_garray(size,incr); 
    _is_versioned = 0;
#ifdef DEBUG
    C_ConstructEnvCount++;
    C_ConstructEnvSize += size;
#endif
}

GArrayBindEnv::GArrayBindEnv()
{
    _limit = 0;
    bindarray = NULL;
    _is_versioned = 0;
#ifdef DEBUG
    C_ConstructEnvCount++;
#endif
}

GArrayBindEnv::~GArrayBindEnv(){
#ifdef DEBUG
    C_DestructEnvCount++;
    C_DestructEnvSize += max_var_number();
#endif
    delete bindarray;   	// This delete can cause problems if
				// bindarrays are shared across bindenvs.
}

int GArrayBindEnv::all_free()
{ int i;
    // This function is quite efficient if the array has not been accessed
    // at all.  Otherwise it may take as much time as the size of the bindenv.
    // bindarray->get_next(i) scan fast through the array, when primed with 
    // i=-1.  It skips large empty regions of the array very fast.
    //
    for(i=bindarray->get_next(-1); i < max_var_number() && i >= 0;
		                           i=bindarray->get_next(i)){
	if((*bindarray)[i].expr != NULL)
		return(0);
	}
     return(1);
}

BindEnv * GArrayBindEnv::make_version()
{
    GArrayBindEnv* copy = new GArrayBindEnv();
    copy->_limit = _limit;
    copy->bindarray =  bindarray->make_copy();
#ifdef DEBUG
   C_ConstructEnvSize += _limit;
#endif
    return(copy);
}


BindEnv * GArrayBindEnv::make_version_and_swap()
{
    // This is a hack --- see note on versioning-hack for more information
    fprintf(stderr,
	"System Error: GArrayBindEnv:make_version_and_swap - not yet implemented\n");
    return NULL;
}

void GArrayBindEnv::restore(BindEnv *)
{
    // This is a hack --- see note on versioning-hack for more information
	// env has to be an VersionedBindEnv
    fprintf(stderr,
	"System Error: GArrayBindEnv:restore - not yet implemented\n");
}

BindEnv* GArrayBindEnv::copy_shell() {
    // This is a hack -- see note on versioning-hack for more information
    fprintf(stderr,
	"System Error: GArrayBindEnv:copy_shell - not yet implemented\n");
    return NULL;
}

/****************************************************************************/
/*******************
* BindEnv * OffsetBindEnv::make_version() {
*     fprintf(stderr,
* 	"System Error: OffsetBindEnv:make_version() - not yet implemented\n");
*     return NULL;
* }
* 
* BindEnv * OffsetBindEnv::make_offset_version(int offset){
*     fprintf(stderr,
*      "System Error: OffsetBindEnv:make_offset_version() - not yet implemented\n"
*      );
*     return NULL;
* }
* 
* void OffsetBindEnv::resize(int newsize) {
*     fprintf(stderr,
* 	"System Error: OffsetBindEnv:resize - not yet implemented\n");
* }
* 
* int OffsetBindEnv::all_free() {
*     // WARNING - this may be too conservative, and may cause problems.
*     return offsetbindenv->all_free();
* }
*******************/



/****************************************************************************/
//
// Trail:
//
// The Trail is a stack of TrailElements, which are (bindenv,variable) pairs.
// It is used to remember information that can be undone by PopTrail.
// If a TrailElement.var is non-negative, it marks a binding that as
// been pushed so that PopTrail can undo it.
// If the index is negative, the entire bindenv is to be deleted by PopTrail
//---------------------------------------------------------------------------

Trail trail(3000) ;

Trail::Trail(int size)
{
    Limit = size;
    Stack = (TrailElement *) malloc(Limit*sizeof(TrailElement)) ;
    TrailSize = 0;
}

// Pop the Tail until it has size 'new_size',
// undoing PushTrails as indicated.

/********   moved as inline to term.h
void Trail::PopTrail(int new_size)
{
    while (TrailSize > new_size) {
	TrailSize--;
	if (Stack[TrailSize].var >= 0) {
//	if ((Stack[TrailSize].var >= 0) && (Stack[TrailSize].bindenv)) {
	  ((Stack[TrailSize]).bindenv)->bind(Stack[TrailSize].var, NullTerm);
	    // if ( ! Stack[TrailSize].bindenv->is_versioned)
	    // (*(Stack[TrailSize].bindenv))[Stack[TrailSize].var] = NullTerm;
	    // Don't undo bindings for persistent versioned bindenvs! ?????
	}
	else{
	    delete Stack[TrailSize].bindenv ;
	}

    }
}
******/

/****************************************************************************/
//
// Term:
//
//---------------------------------------------------------------------------

Term NullTerm (NULL,NULL);

Term Term::dereference() {
    Term t = *this;
    while (t.expr && t.expr->kindof() == COR_VARIABLE && t.bindenv != NULL &&
			t.dereference_var().expr != NULL)
 	t = (t.dereference_var());
     return t;
}
/******************************/



/****************************************************************************/
//
// Tuple:
//
//---------------------------------------------------------------------------

/*

Term *Tuple::term(int i)
{
    Term term;
    term.expr = (*_args)[i];
    term.bindenv = bindenv;
    return (term);
}
*/

ArgPtr& Tuple::operator [](int i) const
{
    Term *term1 = term(i);
    
    FULL_DEREFERENCE_TERM(*term1);
    return term1->expr;
}

int Tuple::isConstant()
{
    int i;
    for(i=0;i < arity();i++)
	if (! arg(i)->isConstant()) return (0); 
    return (1) ;
}

BindEnv * Tuple::make_bindenv_version()
{
    if (default_bindenv()) {
	BindEnv *newenv;
	if (env_size == 0) return NULL;
        else if (isConstant()) return NULL;
	/* else */
	newenv =  new VersionedBindEnv(env_size);
	return newenv;
    }
    else {
	if (isConstant()) return NULL;
	return bindenv->make_version();
    }

}

extern ArrayBindEnv NullEnv;

void Tuple::printon(FILE *file) const
{
    if(default_bindenv())
	(*_args).print(NULL, file);
    else (*_args).print(bindenv, file);
}

Tuple * Tuple::rename(BindEnv *env)
{  // rename tuple with variables starting from after the maximum variable in
   // env.
   // CopyArgs resizes env to handle the extra variables.

   if (env_size == 0)
       return this;
   ArgList *copy_args = ArgList::New(arity());
   int env_size = CopyArgs(copy_args->first(), args().first(),
		bindenv, arity(), env);
   Tuple *newtuple = new Tuple(copy_args, env);
   newtuple->env_size = env_size;
   return newtuple;
}

