/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "arg.h"
#include "hash.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <malloc.h>

extern void SymbolTabInit();


//This redefines the definition of DCL_KEYWORD2(x,s) macro which is first 
//defined in builtin-syms.h.


#undef DCL_KEYWORD2(x,s)
#undef BUILTIN_SYMS
#define DCL_KEYWORD2(x,s)  Symbol* x = InsertSymbol(s,-1);
#include "builtin-syms.h"

#undef DCL_KEYWORD2(x,s)
#define DCL_KEYWORD2(x,s) extern Symbol * x;


int SymbolTabInitDone = 0;

Name AllocSymbol(register const char *s, register length)
    /* s - input string */
    /* length - length in bytes - if <0, strlen is used */
    
  { 
    register char *t; register n;
    if (length < 0) length = strlen(s);

    Symbol dummy(StrHash(s,length), length);
    struct dummy_class {
	char c[sizeof(Symbol)];
    };
    int size = sizeof(Symbol) + (length+1) * sizeof(char);
#ifdef DO_GC
    if (Symbol::__GCPointers == 0)
	Symbol::__GCPointers =
	    gcregistercallback((GCCALLBACKPROC)&Symbol::GCPointers,
			       "Symbol");
    Symbol *sym = (Symbol*)
	gcalloc(GCBYTEStoWORDS(size), Symbol::__GCPointers);
#else
    Symbol *sym = (Symbol*)new char[size];
#endif
    *(dummy_class*)sym = *(dummy_class*)&dummy;

    t = ((char *)sym)+sizeof(Symbol);
    for (n=length; n > 0 ; n--) *t++ = *s++;
    *t = 0;
    return sym;
  }

#define EQwith(el) (SymbolHash(el)==hash && SymbolLength(el) == len \
  && memcmp(SymbolString(el), s, len) == 0)

HashTable SymbolTab[1] =
  {{ 4, 2, 8 /* half log of initial size*/, 0, &StdHashFuncs, 0, 0 }};

Name *
FindSymbol(const char *s, int len, unsigned short hash) /* patterned after SymbolLookup */
{
#define tab SymbolTab
#define HASH_ELEMENT_TYPE Name
#define HASH_LENGTH_LOG tab->tab_len_log
#define HASH_ELEMENT_LOG tab->element_len_log
#define HASH_TO_INDEX(hash) (hash >> (HASH_WORD_LEN - tab->tab_len_log)) << tab->element_len_log
#define HASH_EQUAL(element,arg) EQwith(*element)
#define HASH_NULL(element) (*element==(Name)HashNull)
#define HASH_DATA tab->data
#define HASH_TO_STEP(hash) (((hash<<1)+1) & ((1<<tab->tab_len_log)-1)) << tab->element_len_log

#include "hashfunc.h"
#undef tab
}

Name InsertSymbol(const char *str, int len)
{
    if (!SymbolTabInitDone)
	SymbolTabInit();

    unsigned short h; register Name *p, s;
    if (len < 0) len = strlen(str);
	h = StrHash(str, len);
    p = (Name*)FindSymbol(str, len, h);
    if (*p != NULL) {
	return *p;
    }
    s = AllocSymbol(str, len);
/*    _SetRefCount(s, RefsInfinity); */
    /* Changed a line here - SS */
    *p = s;
    TabInserted(SymbolTab, (Association*)s);
    return s;
}

void PrintSymbol(Name sym, FILE *ff)
{
    fputs(sym->string(), ff);
}

#ifdef LINK_FOR_SYMBOLS
void EnterSymbolRange(Name sym_0, Name sym_n)
{
    register Name *p, cur_sym = sym_0;
    while ((char*)cur_sym < (char*)sym_n) {
	int align = sizeof(int);
	int len = SymbolLength(cur_sym);
	p = FindSymbol(SymbolString(cur_sym), len, SymbolHash(cur_sym));
	if (p == NULL || *p != NULL)
	    fprintf(stderr, "EnterSymbolRange failed for %s\n",
		SymbolString(cur_sym));
	else
	    *p = cur_sym;
	*(void**)cur_sym = __SymVT__;
	TabInserted(SymbolTab, (Association*)cur_sym);
	len += align - len % align;
	cur_sym = (Name)((char*)(cur_sym + 1) + len);
    }
    if ((char*)cur_sym != (char*)sym_n) abort();
}
#endif

void SymbolTabInit()
{
    if (SymbolTabInitDone) return;
    SymbolTabInitDone = 1;
    // InitSymVT(); // old code
    RehashBigger(SymbolTab);
#ifdef LINK_FOR_SYMBOLS
    extern Symbol __START_SYM[1];
    extern Symbol __END_SYM[1];
    EnterSymbolRange(__START_SYM, __END_SYM);
#endif
}

Name EnterSymbol(const char *s)
{
    return InsertSymbol(s, -1);
}

struct SymbolPackage {
   SymbolPackage() { SymbolTabInit(); }
};

SymbolPackage KeywordPackage();

