/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/*
 * Hashing for nested sets
 *
 * We use two fields for comparing sets:
 * HashVal Relation::_hash, and 
 * HashVal Relation::_eq_id
 *
 * (1) _hash is computed using HashVal Relation::hash(BindEnv *)
 *     which computes a hash value for a relation based on the tuples
 *     in the relation.  It uses a commutative, associative hashing
 *     function (multiplication), as a result of which the hash value
 *     of a relation does not depend on the order in which tuples are 
 *     accessed for computing the hash value.
 *     This is used as a sufficient condition for INEQUALITY, i.e.,
 *     if two hash values are distinct, so are the relations.
 *     However, as with all hash values, two relations could be distinct
 *     and have the same hash value.
 *
 * (2) _eq_id is an "id" field which is used as a sufficient
 *     condition for equality, i.e. if two _eq_id fields are the
 *     same, the relations are the same. However, it may be the case that
 *     _eq_id of one relation is different from the _eq_id field of
 *     another relation, while the two relations are indeed equal.
 *     In which case, we physically compare the two relations, and
 *     if equal, set the _eq_id field of each to the lower of the two.
 */

#include "set-hash-cons.h"
#include "hash-rel.h" 
#include "generic-rel.h"
#include "interface.h"
#include "cor_error.h"
#include "globals.h"

/********************************
*     #define  init_table_size   (int)(257)
*
*     static int equal_relation_args(void *a, void*b)
*     {
* 
*      *
*      * This is the equality function for nested Relations.
*      * this will be passed into the hashing code as an argument
*      * to the CoreHashTable constructor when creating the hash
*      * table for HashConsing nested Relations.
*      *
*      * Inputs: pointers to 2 nested relations to be tested for equality
*      *         if the 2 void* arguments are something other than
*      *         Relation*, the system will crash.
*      *         perhaps we should put a field with a special pattern in
*      *         class relation to be checked after coercion to trap
*      *         such errors?
*      *
*      * Output: 0 if the 2 Relations are not equal, a non-zero value
*      *         if they are equal.
*      *
* 
*         Relation *RelA = (Relation *)a;
*         Relation *RelB = (Relation *)b;
* 
*         return( RelA->raw_equals(RelB) );
* 
*      }
* 
*     // allocate a hash cons table for nested relations:
* 
*     CoreHashTable rel_hashcons_table(equal_relation_args, init_table_size);
* 
************************************/

HashVal Relation::hash(BindEnv * /* env is ignored */) {

/*
 * compute the hash value of a relation argument. 
 *
 */

 HashVal h_accum = 1;
 HashVal h_temp;
 Tuple *T;

    if (_hash != UnknownHashValue)   // then set has been hashed, so
        return (_hash);

    FOR_EACH_TUPLE(T, this) {

        h_temp = T->hash(); 	//  hash the element T

        if (h_temp == VarHashValue) {h_accum = VarHashValue; break;}
        else h_accum = h_accum * h_temp;	

    } END_EACH_TUPLE(T)

    _hash = h_accum;
    return(_hash);

/***********************
*   if ( _hash != VarHashValue ) {
* 
* #ifdef DO_TRACE
*     if (exEnv.dbg_sets) {
*        fprintf(exEnv.trace_file,
*                "Computed raw hash value of %u being inserted for set ",
*                        h_accum);
*        ((Arg*)(this))->printon(exEnv.trace_file);
*        fprintf(exEnv.trace_file,"\n");
*     }
* #endif
* 
*     _hash = (HashVal) rel_hashcons_table.insert(this, IntToHash(h_accum));
* 
* #ifdef DO_TRACE
*     if (exEnv.dbg_sets) {
*        fprintf(exEnv.trace_file,"Computed hash value of %X being inserted for set ",
*                        _hash);
*        ((Arg*)(this))->printon(exEnv.trace_file);
*        fprintf(exEnv.trace_file,"\n");
*     }
* #endif
* 
*   };
***********************/

};  // END Relation::hash

extern int equal_tuples(Tuple *tuple1, Tuple *tuple2, int display);
	// this is defined in join.C

unsigned int Relation::cardinality(Tuple *T) {

 /*
  * cardinality of a tuple in a relation
  *
  * INPUT: a pointer to a tuple, T
  *
  * OUTPUT: the number of occurrences of (*T) in (*this)
  *
  * NOTE: we assume that T is ground, and all tuples of *this are ground.
  *
  * NOTE: this could be made more efficient, by iterating only through the
  *       hash bucket for T, instead of all of the rel, should large sets
  *       be commonly used and too slow.  
  *
  */

#ifdef DO_TRACE
    if (exEnv.dbg_sets) {
	fprintf(exEnv.trace_file,
		"Relation::cardinality ----- cardinality of:  ");
	T->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, "\n");
    }
#endif

    HashVal h_T = T->hash();
    ASSERT((isGroundHashValue(h_T)));

    Tuple *tuple;
    HashVal h_tuple;
    unsigned int count = 0;
  
    FOR_EACH_TUPLE(tuple, this) {

    	h_tuple = tuple->hash();
    	ASSERT((isGroundHashValue(h_tuple)));

    	if (equal_tuples(tuple, T, /*display=*/ 0))   
	    count++;

    } END_EACH_TUPLE(tuple)

#ifdef DO_TRACE
    if (exEnv.dbg_sets) {
	fprintf(exEnv.trace_file, "            cardinality is: %d.\n", count);
    }
#endif

    return(count);

};  // END Relation::cardinality


int Relation::contained_in(Relation *rel) {

/*
 *   return true iff (*this) is a subset of rel
 *
 */


#ifdef DO_TRACE
    if (exEnv.dbg_sets)
	fprintf(exEnv.trace_file,
		"Relation::contained_in ----- check set containment.\n");
#endif

    Tuple *tuple;
    int contain = 1;

    FOR_EACH_TUPLE(tuple,this) {

        if (this->cardinality(tuple) > rel->cardinality(tuple)) {
	    contain = 0;
	    break;
        }

    } END_EACH_TUPLE(tuple)
  
#ifdef DO_TRACE
    if (exEnv.dbg_sets) {
	if (contain) 
	    fprintf(exEnv.trace_file,
		    "       ----- Relation::contained_in SUCCEEDED.\n");
	else 
	    fprintf(exEnv.trace_file, 
		    "       ----- Relation::contained_in FAILED.\n");
    }
#endif

    return(contain);


};  // END Relation::contained_in


int Relation::raw_equals(Relation *rel) {

/*
 *   return true iff *rel = *this
 *
 *   inputs can be assumed to be ground, since this is only called 
 *   with nested relations for which this condition is satisfied.
 *
 */

#ifdef DO_TRACE
    if (exEnv.dbg_sets)
	fprintf(exEnv.trace_file,
		"Relation::raw_equals ----- executing set equality.\n");
#endif

    Tuple *tuple = NULL;
    int equals = 1;

    FOR_EACH_TUPLE(tuple,this) {

        if (this->cardinality(tuple) != rel->cardinality(tuple)) {
	    equals = 0;
	    break;
        }

    } END_EACH_TUPLE(tuple)

#ifdef DO_TRACE
    if (exEnv.dbg_sets) {
	if (equals) 
	    fprintf(exEnv.trace_file, 
		    "        ----- Relation::raw_equals SUCCEEDED.\n");
	else 
	    fprintf(exEnv.trace_file, 
		    "        ----- Relation::raw_equals FAILED.\n");
    }
#endif

    return equals;

};  // END Relation::raw_equals


static int C_eq_id_count = 1; /* Make sure this is not equal to 
				UnknownHashValue and VarHashValue */

int Relation::equals(Arg *arg2) {

#ifdef DO_TRACE
    if (exEnv.dbg_sets)
	fprintf(exEnv.trace_file,
		"Relation::equals ------ executing set equality.\n");
#endif

    if (arg2->kindof() != COR_RELATION) return (0);

    Relation *that = (Relation*) arg2;

    HashVal h1 = this->hash();
    HashVal h2 = that->hash();

#ifdef DO_TRACE
        if (exEnv.dbg_sets) {
          fprintf(exEnv.trace_file,"Set-1 = ");
          ((Arg *)this)->printon(exEnv.trace_file);
          fprintf(exEnv.trace_file,". Hash = %X.\n",h1);
          fprintf(exEnv.trace_file,"Set-2 = ");
          arg2->printon(exEnv.trace_file);
          fprintf(exEnv.trace_file,". Hash = %X.\n\n",h2);
        }
#endif

    if ( !isGroundHashValue(h1) || !isGroundHashValue(h2) ) {
        CORAL_error(COR_NESTED_SET_NOT_GROUND, NULL,
                   "Relation::equals");
        return(-1);
    }

    if ( h1 != h2 ) {
#ifdef DO_TRACE
    	if (exEnv.dbg_sets)
	    fprintf(exEnv.trace_file,
		    "          ------- set equality FAILED.\n");
#endif
	return 0;
    }

    if ( isGroundHashValue(_eq_id) && (_eq_id == that->_eq_id) ) {
#ifdef DO_TRACE
	if (exEnv.dbg_sets) {
	    fprintf(exEnv.trace_file, "          ground id values exist.\n");
	    fprintf(exEnv.trace_file, 
		    "          ------- set equality SUCCEEDED.\n");
	}
#endif
	return 1;
    }

    int rel_equals = /*this->*/ raw_equals(that); 
    
    if ( !rel_equals) {
#ifdef DO_TRACE
	if (exEnv.dbg_sets) 
	    fprintf(exEnv.trace_file, 
		    "          ------- set equality FAILED.\n");
#endif
	return 0;
    }

    /* The sets are equal, so assign them the same id */

    if ( isGroundHashValue(_eq_id) && isGroundHashValue(that->_eq_id) ) {
        HashVal min_val = (that->_eq_id < _eq_id)? that->_eq_id : _eq_id;
        _eq_id = that->_eq_id = min_val;
    }
    else if ( ( ! isGroundHashValue(_eq_id)) 
	   && ( ! isGroundHashValue(that->_eq_id) ) ) {
        _eq_id = that->_eq_id = C_eq_id_count++;
    }
    else { // exactly one of them has been previously assigned 
	int id_val = isGroundHashValue(_eq_id) ? _eq_id : that->_eq_id;
	_eq_id = that->_eq_id = id_val;
    }

#ifdef DO_TRACE
    if (exEnv.dbg_sets) {
	fprintf(exEnv.trace_file, 
		"           assigning equal id values: %d.\n", _eq_id);
	fprintf(exEnv.trace_file, 
		"           ------- set equality SUCCEEDED.\n");
    }
#endif

    return 1;
	
}; // END Relation::equals
