

%{
/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
<INITIAL>[a-z_][#A-Za-z0-9_]* |
<INITIAL>[a-z_][#A-Za-z0-9_.]*[#A-Za-z0-9_]+ {

*************************************************************************/

# include	"scanner.h"
# include	"y.tab.h"

#ifdef FLEX_SCANNER
#undef yywrap

#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
    if (fast_consult) {\
      if ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
        YY_FATAL_ERROR( "read() in flex scanner failed" ); \
    } \
    else { \
     input_char = getc(yyin); \
     if ((input_char == EOF) || (input_char == 0)) \
       { scanner_at_eof =1; result = YY_NULL; } \
     else { buf[0] = input_char; result  = 1; } \
    }

#else

#undef input
#undef unput

#define input() \
     ((((input_char=getc(yyin))==EOF) || (input_char == 0)) ? (!(scanner_at_eof=1)) : input_char)

#define unput(c) { ungetc(c, yyin); }

#endif


extern char linebuf[];
extern int line_offset;

extern char commandbuf[];
extern int command_offset;

extern int C_linenum;
extern int command_count;

int input_char ;

extern YYSTYPE yylval;
extern char *prompt ;
extern int show_prompt ;

int in_comment = 0;
int scanner_at_eof = 0;
static int tmp;
int fast_consult = 0;

struct Integer;
struct Double;

EXTERN struct Double *NewDouble ARGS((double d));
EXTERN struct Integer *StrToInt ARGS((char *, int, int));


#undef YYLMAX
#define YYLMAX 2048


#define C_STRCAT(A,B)  if (command_count > 0) { \
                         if ((tmp = command_offset + yyleng) < MAX_RULE_LENGTH) { \
                           strncat(A+command_offset,B,yyleng); \
                           command_offset = tmp ; \
                         }\
                         else {\
                          command_count = -1;\
                          }\
			 }

%}
%Start C_COMMENT
%a 9000
%o 9000
%%
<INITIAL>\"[a-z_][#A-Za-z0-9_]*\" |
<INITIAL>\"[a-z_][#A-Za-z0-9_.]*[#A-Za-z0-9_]+\"  {
                        yytext[yyleng-1] = '\0';
			yylval.name = EnterSymbol(yytext + 1);
			C_STRCAT(commandbuf,yytext+1);
                        command_offset -= 2;
                        return SYMBOL;
			}

<INITIAL>\"[^\"]*\"     {
			yylval.name = EnterSymbol(yytext);
			C_STRCAT(commandbuf,yytext);
                        return SYMBOL;
			}

<INITIAL>"sips"		{ C_STRCAT(commandbuf,yytext); return SIPS; }
<INITIAL>"alias"	{ C_STRCAT(commandbuf,yytext); return ALIAS; }
<INITIAL>"true"		{ C_STRCAT(commandbuf,yytext); return TRUE; }
<INITIAL>"not"		{ C_STRCAT(commandbuf,yytext); return NOT; }
<INITIAL>"del"		{ C_STRCAT(commandbuf,yytext); return DEL; }

<INITIAL>"c_module"	{ C_STRCAT(commandbuf,yytext); return START_C_MODULE; }
<INITIAL>"end_c_module" { C_STRCAT(commandbuf,yytext); return END_C_MODULE; }
<INITIAL>"module"	{ C_STRCAT(commandbuf,yytext); return MODULE; }
<INITIAL>"export"	{ C_STRCAT(commandbuf,yytext); return EXPORT; }
<INITIAL>"sum"          { C_STRCAT(commandbuf,yytext); return SUM; }
<INITIAL>"prod"         { C_STRCAT(commandbuf,yytext); return PROD; }
<INITIAL>"count"	{ C_STRCAT(commandbuf,yytext); return COUNT; }
<INITIAL>"min"  	{ C_STRCAT(commandbuf,yytext); return MIN; }
<INITIAL>"max"  	{ C_STRCAT(commandbuf,yytext); return MAX; }
<INITIAL>"mod"          { C_STRCAT(commandbuf,yytext); return MOD; }
<INITIAL>"makeset"  	{ C_STRCAT(commandbuf,yytext); return MAKESET; }
<INITIAL>"avg"  	{ C_STRCAT(commandbuf,yytext); return AVG; }
<INITIAL>"end_module"   { C_STRCAT(commandbuf,yytext); return END_MODULE;}

<INITIAL>"<<"           {  C_STRCAT(commandbuf,yytext); return LSHIFT; }
<INITIAL>">>"           {  C_STRCAT(commandbuf,yytext); return RSHIFT; }
<INITIAL>"bitxor"       {  C_STRCAT(commandbuf,yytext); return BITXOR; }
<INITIAL>"bitand"       {  C_STRCAT(commandbuf,yytext); return BITAND; }
<INITIAL>"bitor"        {  C_STRCAT(commandbuf,yytext); return BITOR; }
<INITIAL>"bitnot"       {  C_STRCAT(commandbuf,yytext); return BITNOT; }  
<INITIAL>"is"		{ C_STRCAT(commandbuf,yytext); return EQUAL; }

<INITIAL>[A-Z_][A-Za-z0-9_]*  |
<INITIAL>[A-Z_][A-Za-z0-9_.]*[A-Za-z0-9_]+	{
			    yylval.name = EnterSymbol(yytext);
                            C_STRCAT(commandbuf,yytext);
			    return VAR;
                        }

<INITIAL>[0-9]+         {
			yylval.arg = (struct Arg*)StrToInt(yytext, 10, -1);
			C_STRCAT(commandbuf,yytext); return NUM;
                        }
<INITIAL>[0-9]+"."?[0-9]*[eE][+-]?[0-9]+? |
<INITIAL>[0-9]+"."[0-9]+([eE][+-]?[0-9]+)? {
			extern double atof();
			yylval.arg = (struct Arg*)NewDouble(atof(yytext));
			C_STRCAT(commandbuf,yytext); return NUM;
		        }


<INITIAL>[a-z_]([#A-Za-z0-9_.]*[#A-Za-z0-9_])? {
			yylval.name = EnterSymbol(yytext);
			C_STRCAT(commandbuf,yytext);
                        return SYMBOL;
			}


<INITIAL>"," 		{ C_STRCAT(commandbuf,yytext); return COMMA; } 
<INITIAL>":"		{ C_STRCAT(commandbuf,yytext); return COLON; }
<INITIAL>"." 		{ C_STRCAT(commandbuf,yytext); return PERIOD;}
<INITIAL>":-" 		{ C_STRCAT(commandbuf,yytext); return MARK; }
<INITIAL>"<-" 		{ C_STRCAT(commandbuf,yytext); return MARK; }
<INITIAL>"+="		{ C_STRCAT(commandbuf,yytext); return APPEND;}
<INITIAL>"-="		{ C_STRCAT(commandbuf,yytext); return DELETE;}
<INITIAL>"*="		{ C_STRCAT(commandbuf,yytext); return UPDATE;}
<INITIAL>":="		{ C_STRCAT(commandbuf,yytext); return ASSIGN;}
<INITIAL>"==>"		{ C_STRCAT(commandbuf,yytext); return ARROW; }
<INITIAL>"//"		{ C_STRCAT(commandbuf,yytext); return SLASHSLASH; }
<INITIAL>"("		{ C_STRCAT(commandbuf,yytext); return LPAREN; }
<INITIAL>")"		{ C_STRCAT(commandbuf,yytext); return RPAREN; }
<INITIAL>"{"		{ C_STRCAT(commandbuf,yytext); return LBRACE; }
<INITIAL>"}"		{ C_STRCAT(commandbuf,yytext); return RBRACE; }
<INITIAL>"["		{ C_STRCAT(commandbuf,yytext); return LBRACKET; }
<INITIAL>"]"		{ C_STRCAT(commandbuf,yytext); return RBRACKET; }
<INITIAL>"_"		{ C_STRCAT(commandbuf,yytext); return UNDERSCORE; }
<INITIAL>"$"            { C_STRCAT(commandbuf,yytext); return DOLLAR; }
<INITIAL>"|"		{ C_STRCAT(commandbuf,yytext); return VBAR; }
<INITIAL>"@"		{ C_STRCAT(commandbuf,yytext); return AT; }
<INITIAL>"+"		{ C_STRCAT(commandbuf,yytext); return PLUS; }
<INITIAL>"-"		{ C_STRCAT(commandbuf,yytext); return MINUS; }
<INITIAL>"*"		{ C_STRCAT(commandbuf,yytext); return STAR; }
<INITIAL>"/"		{ C_STRCAT(commandbuf,yytext); return SLASH; }
<INITIAL>"?"		{ C_STRCAT(commandbuf,yytext); return QUESTION; }
<INITIAL>"="		{ C_STRCAT(commandbuf,yytext); return EQUAL; }
<INITIAL>"\="		{ C_STRCAT(commandbuf,yytext); return NOTEQUAL; }
<INITIAL>"~="		{ C_STRCAT(commandbuf,yytext); return NOTEQUAL; }
<INITIAL>"<"		{ C_STRCAT(commandbuf,yytext); return LESS; }
<INITIAL>">"		{ C_STRCAT(commandbuf,yytext); return GREATER; }
<INITIAL>"<>"		{ C_STRCAT(commandbuf,yytext); return NOTEQUAL; }
<INITIAL>"=<"		{ C_STRCAT(commandbuf,yytext); return LESSEQUAL; }
<INITIAL>"<="		{ C_STRCAT(commandbuf,yytext); return LESSEQUAL; }
<INITIAL>">="		{ C_STRCAT(commandbuf,yytext); return GREATEREQUAL; }
<INITIAL>"~"		{ C_STRCAT(commandbuf,yytext); return NOT; }
<INITIAL>"!"            { C_STRCAT(commandbuf,yytext); return CUT; }

<INITIAL>"%".*$		;	/* comment; ignore */
<INITIAL>"/*"	        { BEGIN(C_COMMENT); in_comment = 1;}
<C_COMMENT>[^*\n]*      ;      /* ignore anything that's not a '*' */
<C_COMMENT>"*"+[^*/\n]* ;     /* ignore '*'s not followed by '/'s */
<C_COMMENT>\n           { C_linenum++; linebuf[0] = '\0'; line_offset = 0;}
<C_COMMENT>"*"+"/"      { BEGIN(INITIAL); in_comment = 0;}

[ \t]  		;	 /* space/tab; ignore */
\n	 	{  C_linenum++; linebuf[0] = '\0'; line_offset = 0;}
.       	{                       /* any other single char; error */
		    printf("Error: Line %d: Illegal Character", C_linenum);
		    if (yytext[0]>=' ' && yytext[0] <='~')
			printf(": `%c'\n", yytext[0]);
		    else
			printf(", ASCII: %03o (octal)\n", yytext[0]);
		}

%%

int yywrap()
{
#ifdef FLEX_SCANNER
    if (!scanner_at_eof) return 0;
#endif

    if (in_comment) {
	fprintf(stderr, "ERROR: End of file reached inside comment.\n" );
	in_comment = 0;
    }

    fclose(yyin);
    stack_pop(fStackPtr) ;
    if (stack_empty(fStackPtr)) return 1 ;
    yyin = stack_top(fStackPtr) ;
    C_linenum = stack_top_file_line(fStackPtr);

    show_prompt = (yyin == stdin) ;
    if (show_prompt) {
        printf("%d:%s", command_count, prompt);
        fflush(stdout) ;
    }
    scanner_at_eof = 0;
    return 0 ;
}

