/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "profile.h"
#include <string.h>
#include <stdio.h>

ProfileInfo GlobalProfileInfo ;

void ProfileInfo::print(FILE *fd, char * str, int *predOrders, int numpreds) const
{
  fprintf(fd, "_____%s__PROFILE INFO_____\n", str) ;
  fprintf(fd, "%s\n", rule) ;
  if (numpreds && predOrders) {
    fprintf(fd, "Evaluation order : ");
    for (int i = 0; i < numpreds; i++)
      fprintf(fd, "%d ", predOrders[i]);
    fprintf(fd, "\n");
  }
  
  fprintf(fd, "Instantiations : (Successful) %4d,   (Unsuccessful) %4d\t|  ",
	  i_succesful, i_unsuccesful) ;
  fprintf(fd, "New Facts %4d \n", i_newfacts);
  fprintf(fd, "Unifies %d\t| Subsumes %d\t| Non Unifying tuples %4d\n",
	  unifies, subsumes, non_unifying_tuples);
  fprintf(fd, "GetNexts %4d\t| Deleted Tuples %4d\n\n",
	  getnexts, deleted_tuples);
}

void AddProfileInfo(ProfileInfo *A, ProfileInfo *B) 
{
  B->deleted_tuples += A->deleted_tuples ;
  B->non_unifying_tuples += A->non_unifying_tuples ;
  B->i_succesful    += A->i_succesful ;
  B->i_unsuccesful  += A->i_unsuccesful ;
  B->i_newfacts	  += A->i_newfacts ;
  B->getnexts	  += A->getnexts ;
  B->unifies	  += A->unifies ;
  B->subsumes	  += A->subsumes ;
}


