/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdio.h>
#include "parser.h"
#include "generic-rel.h"
#include "builtin-syms.h"
#include "parse-utils.h"
#include "profile.h"
#include "annotations.h"
#include "globals.h"

#define TMP_RELNAME  "__RelTemp"

extern int in_query_loop;
extern Association * DeleteInTab(struct SymbolTable *tab, ConstPointer arg);
extern void interpret_module(ParserStruct&);
extern void perform_rewriting(ParserStruct&);

static int is_recursive(ParserStruct &parserStruct)
{
  Literal *head = parserStruct.cur_rule->head;
  Literal *body_pred;

  for (int i = 0; i < parserStruct.rhspreds.length; i++) {
    body_pred = (Literal*)parserStruct.rhspreds.data[i] ;
    if ((head->pred == body_pred->pred) &&
	(head->arity() == body_pred->arity())) {
      return 1;
    }
  }
  return 0;
}

void AppendFunction(ParserStruct& parserStruct)
{
  if (in_query_loop) {
    if (parserStruct.rhspreds.length == 0) {
      fprintf(stderr, "CORAL::error : Empty rhs\n");
    }
    else if (parserStruct.rhspreds.length > 0) {
      StackMark stack_mark;
      ArrayBindEnv env0(parserStruct.rule_var_names.length);
#ifdef DO_PROFILE
      GlobalProfileInfo.clear() ;
#endif
      
      Relation *rel = make_relation(parserStruct.cur_rule->head->pred,
				    parserStruct.cur_rule->head->arity());

      Relation *temprel;
      if (is_recursive(parserStruct)) {
	// First create a temporary relation, and 
	// put the tuples generated by the rhs of
	// the APPEND statement into it.	    
	temprel = 
	  make_relation(TMP_RELNAME, parserStruct.cur_rule->head->arity());
      }
      else temprel = rel;

      int num_ans = QueryJoin(parserStruct, 0, &env0, &env0,
			      temprel,
			      &(parserStruct.cur_rule->head->args)) ;

      fprintf(exEnv.output_file,
	      "(Number of Tuples to Append = %d)\n", num_ans);

      if (temprel != rel) {
	// Then copy the tuples from the temporary relation
	// to the lhs relation.
	Tuple *tuple ;
	FOR_EACH_TUPLE(tuple, temprel) {
	  rel->insert_new(tuple) ;
	}END_EACH_TUPLE(tuple);
	
	// Finally, close the temporary relation
	temprel->empty_relation(0) ;
	DeleteInTab(CurDB->RelationTable, temprel->name);
	delete temprel ;
      }
      
      stack_mark.pop_to();
    }
  }
  else {
    fprintf(stderr, "CORAL::error :");
    fprintf(stderr, "Imperative statement inside module!\n");
  }
  fflush(exEnv.output_file);
}

void DeleteFunction(ParserStruct& parserStruct)
{
  if (in_query_loop) {
    if (parserStruct.rhspreds.length == 0) {
      fprintf(stderr, "CORAL::error : Empty rhs\n");
    }
    else if (parserStruct.rhspreds.length > 0) {
      StackMark stack_mark;
      ArrayBindEnv env0(parserStruct.rule_var_names.length);

#ifdef DO_PROFILE
      GlobalProfileInfo.clear() ;
#endif      
      
      Relation *rel = make_relation(parserStruct.cur_rule->head->pred,
				    parserStruct.cur_rule->head->arity());
      
      Relation *temprel;
      // First create a temporary relation, and 
      // put the tuples generated by the rhs of
      // the DELETE statement into it.	    
      temprel = 
	make_relation(TMP_RELNAME, parserStruct.cur_rule->head->arity());

      int num_ans = QueryJoin(parserStruct, 0, &env0, &env0,
			      temprel, 
			      &(parserStruct.cur_rule->head->args)) ;
      
      fprintf(exEnv.output_file,
	      "(Number of Tuples to Delete = %d)\n", num_ans);

      // Then delete the tuples in the temporary relation
      // from the lhs relation.
      Tuple *tuple ;
      FOR_EACH_TUPLE(tuple, temprel) {
	rel->tuple_delete(tuple);
      }END_EACH_TUPLE(tuple);
	
      // Finally, close the temporary relation
      temprel->empty_relation(0);
      DeleteInTab(CurDB->RelationTable, temprel->name);
      delete temprel ;
      
      stack_mark.pop_to();
    }
  }
  else {
    fprintf(stderr, "CORAL::error :");
    fprintf(stderr, "Imperative statement inside module!\n");
  }
  fflush(exEnv.output_file);
}

void AssignFunction(ParserStruct& parserStruct)
{
  if (in_query_loop) {
    if (parserStruct.rhspreds.length == 0) {
      fprintf(stderr, "CORAL::error : Empty rhs\n");
    }
    else if (parserStruct.rhspreds.length > 0) {
      StackMark stack_mark;
      ArrayBindEnv env0(parserStruct.rule_var_names.length);

#ifdef DO_PROFILE
      GlobalProfileInfo.clear() ;
#endif
      
      Relation *temprel;
      Relation *rel = make_relation(parserStruct.cur_rule->head->pred,
				    parserStruct.cur_rule->head->arity());

      if (is_recursive(parserStruct)) {
	// First create a temporary relation, and 
	// put the tuples generated by the rhs of
	// the ASSIGN statement into it.	    
	temprel = 
	  make_relation(TMP_RELNAME, parserStruct.cur_rule->head->arity());
	int num_ans = QueryJoin(parserStruct, 0, &env0, &env0,
				temprel, 
				&(parserStruct.cur_rule->head->args)) ;
	
	fprintf(exEnv.output_file,
		"(Number of Tuples to Assign = %d)\n", num_ans);
	
	// Then clear the lhs relation.
	rel->empty_relation(0);
	
	// Then copy the tuples from the temporary relation
	// to the lhs relation.
	Tuple *tuple ;
	FOR_EACH_TUPLE(tuple, temprel) {
	  rel->insert_new(tuple) ;
	}END_EACH_TUPLE(tuple)
	  
	// Finally, close the temporary relation
	temprel->empty_relation(0) ;
	DeleteInTab(CurDB->RelationTable, temprel->name);
	delete temprel ;
      }
      else {
	temprel = rel;
	// Clear the lhs relation.
	rel->empty_relation(0);
	int num_ans = QueryJoin(parserStruct, 0, &env0, &env0,
				temprel, 
				&(parserStruct.cur_rule->head->args)) ;
	
	fprintf(exEnv.output_file,
		"(Number of Tuples to Assign = %d)\n", num_ans);
      }
	    
      stack_mark.pop_to();
    }
  }
  else {
    fprintf(stderr, "CORAL::error :");
    fprintf(stderr, "Imperative statement inside module!\n");
  }
  fflush(exEnv.output_file);
}

void EndModuleFunction(ParserStruct& parserStruct)
{
  if (parserStruct.CurModule.PreProcessing) 
//  if (parserStruct.CurModule.Rewriting)
    perform_rewriting(parserStruct);
  else {
    interpret_module(parserStruct) ;
  }
  parserStruct.cur_rule = NULL;
}

void QueryFunction(ParserStruct& parserStruct)
{
  StackMark stack_mark;
  ArrayBindEnv env0(parserStruct.rule_var_names.length);
  
#ifdef DO_PROFILE
  GlobalProfileInfo.clear() ;
#endif

#ifdef CORAL_LEX
  // to get rid of the newline following the query from stdin
  if (exEnv.C_interactive_mode_default &&
      !fileStack.is_empty() &&
      fileStack.top_file() == stdin) {
    int c;
    c = getchar();
    if (c != '\n') ungetc(c, stdin);
  }
#endif

  int num_ans = QueryJoin(parserStruct, 0, &env0, &env0);
  fprintf(exEnv.output_file,
	  "(Number of Answers = %d)\n", num_ans);

  stack_mark.pop_to();
  parserStruct.cur_rule = NULL;
  fflush(exEnv.output_file);
}

void FactFunction(ParserStruct& parserStruct)
{
  if (parserStruct.rhspreds.length == 0) {
    Relation *rel;
    rel = find_external_relation(parserStruct.cur_rule->head->pred,
				 parserStruct.cur_rule->head->arity());
    // use the kludge that ensures that all builtins have count = -1
    if (rel && rel->count >=0 && 
	!(exEnv.C_insert_mode_default) && 
	!fileStack.is_empty() &&
	fileStack.top_file() == stdin) {
      fprintf(stderr, "CORAL::error : ");
      fprintf(stderr, "Not in insert mode !\n");
      return;
    }

    else if (!rel) {
      if (!(exEnv.C_insert_mode_default) && 
	  !fileStack.is_empty() &&
	  fileStack.top_file() == stdin) {
	fprintf(stderr, "CORAL::error : ");
	fprintf(stderr, "Not in insert mode !\n");
	return;
      }
      rel = make_relation(parserStruct.cur_rule->head->pred,
			  parserStruct.cur_rule->head->arity());
    }


/*****
    Tuple *tuple10 = new Tuple(parserStruct.cur_rule->head->args);
    tuple10->env_size =  parserStruct.rule_var_names.length;
    if (tuple10->env_size > 0)
      tuple10->bindenv = 
	new VersionedBindEnv(tuple10->env_size);
    
    if (! rel->insert_new(tuple10)) { 
      delete tuple10->_args;
      if (tuple10->bindenv)
	delete tuple10->bindenv;
    }
    delete tuple10;
*******/
    BindEnv *insert_env = NULL;
    if (parserStruct.rule_var_names.length > 0)
      insert_env = new VersionedBindEnv(parserStruct.rule_var_names.length);
    
    if (! rel->insert_new(parserStruct.cur_rule->head->args, insert_env)) { 
      if (insert_env)
	delete insert_env;
    }

  }

  else if (parserStruct.rhspreds.length > 0) {
    fprintf(stderr, "CORAL::error : ");
    fprintf(stderr, "Rule declared outside a module!\n");
  }
  
}

