/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "linked-rel.h"
#include "profile.h"
#include "globals.h"
#include "interp.h"

extern int subsumes_tuple(Tuple *tuple, Tuple *newtuple, int display);
extern int unify_literal(TupleIterator &iterator, Tuple *tuple, int display);

LinkedRelation::LinkedRelation(int new_arity, int delta) : TupleList(), 
	Relation(new_arity, delta) 
{ 
}

LinkedRMark::LinkedRMark()
{
    lastptr = NULL;
}

LinkedRMark::LinkedRMark(struct TupleLink **l)
{
    lastptr = l;
}

RMark * LinkedRelation::getMark()
{
    return new LinkedRMark(lastptr);
}

Tuple *LinkedRelation::get_next_tuple(TupleIterator& iterator)
{
#ifdef DO_PROFILE
   if (TableStackCount > 0)
     ((TableStack[TableStackCount-1])->moduledata->module_info.
       GlobalProfileInfo.getnexts)++;
   else
     (GlobalProfileInfo.getnexts)++ ;
#endif
  
  BindEnv *result_env = iterator.bindenv;
  iterator.tuple_env = NULL;


  if (exEnv.C_interrupt_raised) {
    iterator.set_no_match();
    return NULL;
  }

  // initialize
  if (iterator.ipos == 0) { 
    if (iterator.start_mark == NULL) iterator.ppos = &chain;
    else iterator.ppos = ((LinkedRMark*)iterator.start_mark)->lastptr;
    iterator.stack_mark.get_mark();
  }
  else iterator.stack_mark.pop_to();

  // The current position is remembered in (TupleLink**)iterator.ppos.
  TupleLink **next_ptr = (TupleLink**)iterator.ppos;
  StackMark stack_mark;

  for (;;) {
    if (*next_ptr == NULL) { 
      iterator.stack_mark.pop_to();
      iterator.set_no_match(); return NULL; 
    }
    if (iterator.end_mark)
      if (((LinkedRMark*)iterator.end_mark)->lastptr == next_ptr)
	{ 
	  iterator.stack_mark.pop_to();
	  iterator.set_no_match(); return NULL; 
	}
    iterator.ipos++;
    Tuple *tuple = (*next_ptr)->tuple;
    if (tuple->is_deleted()) { 
      // the tuple has been logically deleted

//^^^^^^^^^^^^^^^^^^^^^^^^^
      *(next_ptr) = (*next_ptr)->next;
      delete (*next_ptr);
//^^^^^^^^^^^^^^^^^^^^^^^^^

#ifdef DO_PROFILE
   if (TableStackCount > 0)
     (TableStack[TableStackCount-1]->moduledata->module_info.
       GlobalProfileInfo.deleted_tuples)++ ;
   else
     (GlobalProfileInfo.deleted_tuples)++ ;
#endif
      continue;
    }
  
    next_ptr = &(*next_ptr)->next;
    iterator.ppos = next_ptr;
    
    if (unify_literal(iterator, tuple, 0))
      return tuple;
    
    stack_mark.pop_to();
  }
}

void LinkedRelation::release(TupleIterator& )
{
    /* Do nothing, since TupleIterator does not maintain extra info to
    be released in the case of LinkedRelations. */
}

BindEnv *LinkedRelation::get_next(TupleIterator& iterator)
{
   Tuple *result = get_next_tuple(iterator);
   if (!result) return NULL;
   return iterator.bindenv;
}

int LinkedRelation::is_subsumed(Tuple *newtuple, RMark *start_mark, 
					RMark *end_mark)
{

    TupleLink **next;
    if (start_mark == NULL) next = &chain;
	else next = ((LinkedRMark*)start_mark)->lastptr;
    StackMark stack_mark;

    for (;;) {
	if (*next == NULL) { 
	     return is_agg_subsumed(newtuple, start_mark, end_mark);
	}
	if (end_mark)
	    if (((LinkedRMark*)end_mark)->lastptr == next) { 
		return is_agg_subsumed(newtuple, start_mark, end_mark); 
	    }
	Tuple *tuple = (*next)->tuple;
	next = &(*next)->next;

        if (tuple->is_deleted()) // tuple has been logically deleted
		{ 
//^^^^^^^^^^^^^^^^^^^^^^^^^
		  *(next) = (*next)->next;
                  delete (*next);
//^^^^^^^^^^^^^^^^^^^^^^^^^
#ifdef DO_PROFILE
        if (TableStackCount > 0)
	  (TableStack[TableStackCount-1]->moduledata->module_info.
	   GlobalProfileInfo.deleted_tuples)++ ;
	else
	  (GlobalProfileInfo.deleted_tuples)++ ;
#endif
		  continue;
		}
        
	if (subsumes_tuple(tuple, newtuple, (DISPLAY_INSERTIONS)) )
	    return 1;

	stack_mark.pop_to();
    }
}

/**************
 * divesh: the two LinkedRelation::insert's have been replaced by
 * a single LinkedRelation::insert_tuple(Tuple *)
 * Earlier there was a void TupleList::insert_tuple(Tuple *).
 * Since this would clash with virtual int Relation::insert_tuple(Tuple *)
 * when inherited by LinkedRelation, it has been changed (in linked-rel.h)
 * to void TupleList::tlist_insert_tuple(Tuple *)
**************/

/*******

int LinkedRelation::insert(ArgList& args, int env_size)
{
    Tuple *tuple = new Tuple(args);
    tuple->env_size = env_size;
    insert_tuple(tuple);
    return 1;
}

int LinkedRelation::insert(ArgList& args, BindEnv *env, int env_size)
{
    Tuple *tuple = new Tuple(args);
    tuple->bindenv = env;
    tuple->env_size = env_size;
    insert_tuple(tuple);
    return 1;
}

*******/

int LinkedRelation::insert_tuple(Tuple *tuple)
{	
    tlist_insert_tuple(tuple);
    count++;
    return 1;
}

void TupleList::free_all()
{
    TupleLink* next;
    for (TupleLink *link = chain; link != NULL; link = next) {
	next = link->next;
	// This doesn't free the components of the tuple.
	delete link->tuple;
	delete link;
    }
    chain = NULL;
    lastptr = &chain;
}

void LinkedRelation::empty_relation(int deleteTuples /* =0 */ )
{	// Empty out relation, but do NOT delete tuples (which may be shared)

    TupleLink* next;
    for (TupleLink *link = chain; link != NULL; link = next) {
	if (deleteTuples) delete link->tuple;
	next = link->next;
	delete link;
    }
    chain = NULL;
    lastptr = &chain;
}

