/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdio.h>
#include "rules.h"
#include "externs.h"
#include "term.h"
#include "unify.h"
#include "profile.h"
#include "globals.h"
#include "cor_error.h"
#include "interp.h"
#include <stdlib.h>

/*
extern "C" {
#include "obstack.h"
extern void _obstack_begin(struct obstack *, ...);
extern void _obstack_newchunk(struct obstack *, int);
}
*/

Term GlobalNewt;

#define DO_OCCUR_CHECK 0

/*------------------------------------------------------------------

 unify_binding:  
	This is used to bind a variable to a term.  The variable must be free.
	The term may actually be a variable interpreted in a bindenv.
	If so, it is dereferenced completely. This is actually essential 
	so that a variable is never bound to itself -- that would be a silly 
	(and wrong) thing to do.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

/*******************************
%     if (DO_OCCUR_CHECK) {
% 	// WARNING:: Incomplete implementation 
%         // Simple check - don't bind variable to itself, but return success. 
%         if (!(base_term->expr->kindof() == COR_VARIABLE && 
% 	        base_term->varnum() == var && base_term->bindenv == bindenv) ) 
% 	    return COR_U_SUCCEED;
% 	// Fill in the rest of the occur check code here ....
%     }
********************************/

inline int inline_unify_binding(BindEnv* bindenv, Variable var, Term term)
{
#ifdef DO_TRACE
    if (exEnv.dbg_unify) {
	fprintf(exEnv.trace_file,
		"[unify_binding(bindenv=0x%x, var#=%d, arg=0x%x=",
		bindenv, var, term.expr);
	term.expr->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ", bindenv=0x%x)]\n", term.bindenv);
    }
#endif

    // ASSERT((bindenv != NULL && bindenv->lookup(var).expr == NULL))

/****
    // if (DO_OCCUR_CHECK) do something				
	Term base_term = term;
	FULL_DEREFERENCE_TERM(base_term);
	if ( ! (base_term.bindenv == bindenv 
		&& base_term.expr->kindof() == COR_VARIABLE
		&& ((VarArg *)base_term.expr)->var == var )) {
            bindenv->bind(var, base_term);
            trail.PushTrail((bindenv), (var));
	    }
*******/
	FULL_DEREFERENCE_TERM(term);

/****
    if ((term.expr->kindof() != COR_VARIABLE) ||
	(term.bindenv != bindenv) ||
	(((VarArg *)term.expr)->var != var)) {
****/

    if ( ! (term.bindenv == bindenv 
	    && term.expr->kindof() == COR_VARIABLE
	    && ((VarArg *)term.expr)->var == var )) {
      bindenv->bind(var, term);
      trail.PushTrail((bindenv), (var));
    }	
    
    /* else:  don't bind variable to itself -- simply return success.
       This limited form of occur check is critical for 
       answer-return unification with non-ground facts and 
       return-unification optimizations. */
    
#ifdef DO_TRACE
    if (exEnv.dbg_unify) fprintf(exEnv.trace_file, "unify_binding succeeded.\n");
#endif
    return COR_U_SUCCEED;
}

int unify_binding(BindEnv* bindenv, Variable var, Term term)
{
	return inline_unify_binding(bindenv, var, term);
}


int subsumes_binding(BindEnv* bindenv, Variable var, Term term, int can_bind)
{
#ifdef DO_TRACE
    if (exEnv.dbg_unify) {
	fprintf(exEnv.trace_file,
		"[subsumes_binding(bindenv=0x%x, var=0x%x, arg=0x%x=",
		bindenv, var, term.expr);
	term.expr->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ", bindenv=0x%x)]\n", term.bindenv);
    }
#endif
    ASSERT((bindenv != NULL && bindenv->lookup(var).expr == NULL))

    Term base_term = term;
    FULL_DEREFERENCE_TERM(base_term);

    if (base_term.expr->kindof() == COR_VARIABLE && 
	    base_term.varnum() == var && base_term.bindenv == bindenv) 
	return COR_U_SUCCEED;

    if(!can_bind) 
        return(COR_U_FAIL);

    if (DO_OCCUR_CHECK) {
	// WARNING: Incomplete implementation
    }
    
    bindenv->bind(var, base_term);
    trail.PushTrail(bindenv, var);

#ifdef DO_TRACE
    if (exEnv.dbg_unify) fprintf(exEnv.trace_file,
				 "subsumes_binding succeeded.\n");
#endif
    return COR_U_SUCCEED;
}


/**************************************************************************/


/*
 * Unify the terms 'left' and 'right'.
 * Return COR_U_SUCCEED or COR_U_FAIL.
 *
 * WARNING:  COR_DONTCARE is dangerous:  make sure there is no underscore
 *		within a structire.  If you unify 
 *		f(_) with f(a), the result on the lhs will be 
 *		f(_), not f(a).  Thus the result may depend on 
 *		which side you choose!!  This is shady.
 *		In particular, the result of unifying 
 *		g(X,X,X) with g(f(_),f(a),Y) is order dependent!!
 */

unify_args(Term left, Term right)
{


 arg_kind left_kindof, right_kindof;

#ifdef DO_PROFILE
  if (TableStackCount > 0)
    (TableStack[TableStackCount-1]->moduledata->module_info.
     GlobalProfileInfo.unifies)++ ;
  else
    (GlobalProfileInfo.unifies)++ ;
#endif
  
#ifdef DO_TRACE
  if (exEnv.dbg_unify) {
    fprintf(exEnv.trace_file, "[unify_args(left=0x%x=", left.expr);
    left.printon(exEnv.trace_file);
    fprintf(exEnv.trace_file, ", right=0x%x=", right.expr);
    right.printon(exEnv.trace_file);
    fprintf(exEnv.trace_file,
	    ", left_bindings=0x%x, right_bindings=0x%x)]\n",
	    left.bindenv, right.bindenv);
  }
#endif
  FULL_DEREFERENCE_TERM(left);
  
  for(;;) {
    if (left.expr == right.expr && left.bindenv == right.bindenv)
      return COR_U_SUCCEED;

    left_kindof = left.kindof();
    right_kindof = right.kindof();

    switch (left_kindof) {
    case COR_VARIABLE:
      if ( right_kindof != COR_DONTCARE )
	return inline_unify_binding(left.bindenv, left.varnum(), 
				    right);
      /* Left was fully dereferenced earlier*/
      else return COR_U_SUCCEED;

    case COR_NUM_CONST:
      switch (right_kindof) {
      case COR_NUM_CONST:
	if (((NumArg *) right.expr)->num_kindof() == COR_ARITH_EXPR) {
	  ARITH_DEREFERENCE_TERM(right);
	}
	if (((NumArg*)left.expr)->compare(*((NumArg*)right.expr)))
	  return COR_U_FAIL;
	return COR_U_SUCCEED;
      case COR_VARIABLE:
	if ( ISFREE_TERM(&right) ) 
	  return inline_unify_binding(right.bindenv, right.varnum(), left);
	else {
	  FULL_DEREFERENCE_TERM(right);
	  continue;
	}
      case COR_DONTCARE: return (COR_U_SUCCEED);
      default : return (COR_U_FAIL);
      }

    case COR_SYMBOL_CONST:
      switch (right_kindof) {
      case COR_SYMBOL_CONST:
	if ((Symbol*)left.expr != (Symbol*)right.expr)
	  return COR_U_FAIL;
	return COR_U_SUCCEED;

      case COR_VARIABLE:
	if ( ISFREE_TERM(&right) ) 
	  return inline_unify_binding(right.bindenv, right.varnum(), left);
	else {
	  FULL_DEREFERENCE_TERM(right);
	  continue;
	}
	
      case COR_DONTCARE: return (COR_U_SUCCEED);
      default : return (COR_U_FAIL);
      }

    case COR_CONST_ARG:
      switch (right_kindof) {
      case COR_CONST_ARG:
	if (! left.expr->equals(right.expr))
	  return COR_U_FAIL;
	return COR_U_SUCCEED;
      case COR_VARIABLE:
	if ( ISFREE_TERM(&right) ) 
	  return inline_unify_binding(right.bindenv, right.varnum(), left);
	else {
	  FULL_DEREFERENCE_TERM(right);
	  continue;
	}
      case COR_DONTCARE: return (COR_U_SUCCEED);
      default: return COR_U_FAIL;
      }

    case COR_FUNCTOR:
      switch (right_kindof) {

      case COR_VARIABLE:
	if ( ISFREE_TERM(&right) )
	  return inline_unify_binding(right.bindenv, right.varnum(), left);
	else {
	  FULL_DEREFERENCE_TERM(right);
	  continue;
	}
      case COR_FUNCTOR: {
	FuncArg* left_func = (FuncArg*)left.expr;
	FuncArg* right_func = (FuncArg*)right.expr;
        
	if (left_func->functor() != right_func->functor())
	  return COR_U_FAIL;
        
	/** NOTE:
	  In the following code, after checking if a term is 
	  fully ground, we compute the hash value.  isConstant 
	  stores VarHashValue if it finds that there is a variable 
	  in the term.  If the term is infact
	  a constant,  hash stores the hash value.
	  
	  Hence, so long as this pair is always used together
	  no term is traversed more than twice by these functions. 
	  If we call only isConstant, ground terms can be traversed  
	  many times by these functions.  
	  If we call just hash, nonground terms can be traversed 
	  many times by these functions.
	  **/
	
	if (left_func->isConstant()) {
	  HashVal left_hash = left_func->hash(left.bindenv);
	  if (isGroundHashValue(left_hash) && right_func->isConstant()){
	    HashVal right_hash = right_func->hash(right.bindenv);
	    if ( isGroundHashValue(right_hash) ) {
	      if (left_hash != right_hash)
		return COR_U_FAIL;
#ifdef USE_HASHCONSING
	      else return(COR_U_SUCCEED);
#endif
	    }
	  }
	}
	return unify_arg_lists(left_func->args, right_func->args,
			       left.bindenv, right.bindenv);
      } // case COR_FUNCTOR
	
      case COR_GROUPING:
	CORAL_error(COR_INTERNAL_ERROR,"Grouping in unification.",
		    "unify_args()");
	
      default : return COR_U_FAIL;
      } // left=COR_FUNCTOR, switch (right->kindof())
	
      case COR_DONTCARE: return (COR_U_SUCCEED);

      case COR_RELATION: {
        switch (right_kindof) {
	case COR_VARIABLE: {
	  if ( ISFREE_TERM(&right) )
	    return unify_binding(right.bindenv, right.varnum(), left);
	  else {
	    FULL_DEREFERENCE_TERM(right);
	    return unify_args(right, left);
	  }
	}
	case COR_RELATION: {
	  
	  HashSimpleRelation* left_rel = (HashSimpleRelation*)left.expr;
	  HashSimpleRelation* right_rel = (HashSimpleRelation*)right.expr;
	  
	  if (left_rel->equals(right_rel) == 1) return(COR_U_SUCCEED);
	  
	  return(COR_U_FAIL);
	  
	}
	case COR_GROUPING:
	  CORAL_error(COR_INTERNAL_ERROR,"Grouping in unification.",
		      "unify_args()");
	  
	default : return COR_U_FAIL;
        }
      }
      
    case COR_GROUPING:
      CORAL_error(COR_INTERNAL_ERROR,"Grouping in unification.","unify_args()");
    default:
      fprintf(stderr,"Error! unify: default case yet to be implemented!\n");
      return COR_U_FAIL;      
    } // switch (left->kindof())
      
  } // for (;;) 
      
} // unify_args


unify_arg_lists(ArgList& left, ArgList& right,
		BindEnv *left_bindings, BindEnv *right_bindings )
{
#ifdef DO_TRACE
    if (exEnv.dbg_unify) fprintf(exEnv.trace_file, "unify_arg_lists called:\n");
#endif

    register int i, count = left.count();
    if (right.count() != count) return COR_U_FAIL;

    Term left_term, right_term;

    for ( i=0 ;  i < count ; i++ ) {
	left_term.expr = left[i];
	right_term.expr = right[i];
        left_term.bindenv = left_bindings;
        right_term.bindenv = right_bindings;
	if (unify_args(left_term, right_term) == COR_U_FAIL)
	    return COR_U_FAIL;
    }
#ifdef DO_TRACE
    if (exEnv.dbg_unify) fprintf(exEnv.trace_file,"unify_arg_lists succeeded\n");
#endif

    return COR_U_SUCCEED;
}


/***************************************************************************/

extern int subsumes_nested_arg_lists(ArgList& left, ArgList& right,
    BindEnv *left_bindings, BindEnv *right_bindings, int can_bind);

#define CAN_BIND 1

// ****
// The following fn. checks if left subsumes right
//	WARNING:  The code  assumes that left and right do not share any
//		  variables! If the do, right would have to be copied
//		  (recursively) so that it does not share any subterm 
//		  with left.
//	ASSUMPTIONS:
//		1) We assume that right and left don't share any variables.
//		2) right.bindenv can be NULL - this is fine since right
//			cannot be bound in any case.  Some checks for 
//			null bindenv are required as a result.
//		3) if the flag canbind is not set, then subsumption checks for 
//			equality - no variable binding  is allowed.
//			The equality is strict in that no variable renaming
//			is allowed.
//		4) If right.bindenv is not null, we need to know when a 
//			left variable is bound to a right variable.
//			
// ****


int subsumes_args(Term left, Term right, int can_bind)
{
#ifdef DO_PROFILE
      if (TableStackCount > 0)
	(TableStack[TableStackCount-1]->moduledata->module_info.
	 GlobalProfileInfo.subsumes)++ ;
      else
	(GlobalProfileInfo.subsumes)++ ;
#endif

#ifdef DO_TRACE
    if (exEnv.dbg_subsumes) {
	fprintf(exEnv.trace_file, "[subsumes_args(left=0x%x=", left.expr);
	left.expr->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ", right=0x%x=", right.expr);
	right.expr->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file,
		", left_bindings=0x%x, right_bindings=0x%x)]\n",
	       left.bindenv, right.bindenv);
    }
#endif
    if (left.expr == right.expr)
	if (left.bindenv == right.bindenv)
	    return COR_U_SUCCEED;
    
    switch (left.kindof()) {
      case COR_DONTCARE: return COR_U_SUCCEED;
      case COR_VARIABLE: 
      {
	    if (left.bindenv==NULL)  // Can happen is left was bound to a 
					// right variable and was dereferenced
		return(COR_U_FAIL);
	    if ( ISFREE_TERM(&left) )
	        return subsumes_binding(left.bindenv, left.varnum(), right, 
				can_bind);
#if 1	/* WARNING:  Assumes that left bindings never cross over into right
		hand side.  Is reasonable only if left is always a 
		database fact, in which case it's bindings are purely local.
		MAKE SURE that this assumption is valid!!
	*/
	    else return subsumes_args(left.dereference_var(), right, can_bind);
#else
	    else return subsumes_args(left.dereference_var(), right, 
				right.bindenv?0:can_bind);
			// if right.bindenv is not null, left.bindenv
			// must have been empty, so dereferencing left
			// makes us cross over into right.  Hence set can_bind
			// to 0; 
#endif
      }
      case COR_NUM_CONST:
	if (((NumArg *) left.expr)->num_kindof() == COR_ARITH_EXPR) {
	  ARITH_DEREFERENCE_TERM(left);
	}
      case COR_SYMBOL_CONST:
      case COR_CONST_ARG:
	switch (right.kindof()) {
	  case COR_DONTCARE: return COR_U_FAIL;
	  case COR_VARIABLE: {
	    if (right.bindenv == NULL || ISFREE_TERM(&right) )
		return (COR_U_FAIL);
	    return subsumes_args(left, right.dereference_var(), can_bind);
	        /* can_bind might start out bound, but not set by subsumes */
	  }
	  case COR_NUM_CONST:
	    if (((NumArg *) right.expr)->num_kindof() == COR_ARITH_EXPR) {
	      ARITH_DEREFERENCE_TERM(right);
	    }
	    FULL_DEREFERENCE_TERM(right);
	    if (left.kindof() != COR_NUM_CONST
		|| ((NumArg*)left.expr)->compare(*((NumArg*)right.expr)))
		return COR_U_FAIL;
	    return COR_U_SUCCEED;
	  case COR_SYMBOL_CONST:
            if (left.kindof() != COR_SYMBOL_CONST ||
                 (Symbol*)left.expr != (Symbol*)right.expr)
                  return COR_U_FAIL;
              return COR_U_SUCCEED;
	  case COR_CONST_ARG:
              if (left.kindof() != COR_CONST_ARG ||
                  ! left.expr->equals(right.expr))
                  return COR_U_FAIL;
              return COR_U_SUCCEED;

	  case COR_FUNCTOR:
	  case COR_RELATION:
	     return COR_U_FAIL;
	  case COR_GROUPING:
            CORAL_error(COR_INTERNAL_ERROR,"Grouping in subsumption check.",
                        "subsumes_args()");
	  default:
	     return COR_U_FAIL;
	}

      case COR_RELATION:
        switch (right.kindof()) {
            case COR_DONTCARE: return COR_U_FAIL;
            case COR_VARIABLE: {
               if (right.bindenv == NULL || ISFREE_TERM(&right) )
                   return (COR_U_FAIL);
               return subsumes_args(left, right.dereference_var(), can_bind);
                  /* can_bind might start out bound, but not set by subsumes */
            }
          case COR_NUM_CONST:
          case COR_SYMBOL_CONST:
          case COR_CONST_ARG:
          case COR_FUNCTOR:
               return COR_U_FAIL;
          case COR_GROUPING:
            CORAL_error(COR_INTERNAL_ERROR,"Grouping in subsumption check.",
                        "subsumes_args()");
          case COR_RELATION: {

            Relation *left_rel = (Relation*)left.expr;
            Relation *right_rel = (Relation*)right.expr;

            if (left_rel->equals(right_rel) == 1) return COR_U_SUCCEED ;
            return COR_U_FAIL ;
          }
          default:
               return COR_U_FAIL;
        }

      case COR_FUNCTOR:
	switch (right.kindof()) {
	  case COR_DONTCARE: return COR_U_FAIL;
	  case COR_VARIABLE: {
	    if (right.bindenv == NULL || ISFREE_TERM(&right) )
		return (COR_U_FAIL);
	    return subsumes_args(left, right.dereference_var(), can_bind);
	        /* can_bind might start out bound, but not set by subsumes */
	  }
	  case COR_NUM_CONST:
          case COR_SYMBOL_CONST:
          case COR_CONST_ARG:
	  case COR_RELATION:
	       return COR_U_FAIL;
	  case COR_FUNCTOR: {
	    FuncArg* left_func = (FuncArg*)left.expr;
	    FuncArg* right_func = (FuncArg*)right.expr;

	    if (left_func->functor() != right_func->functor())
		return COR_U_FAIL;
    	        if (left_func->isConstant()) {
    	            HashVal left_hash = left_func->hash(left.bindenv);
    	            if (isGroundHashValue(left_hash) && right_func->isConstant()){
    	                HashVal right_hash = right_func->hash(right.bindenv);
    		        if ( isGroundHashValue(right_hash) ) {
    	                    if (left_hash != right_hash)
    		                return COR_U_FAIL;
#if USE_HASHCONSING
   			    else return(COR_U_SUCCEED);
#endif
    		        }
    	            }
    	        }
	     return subsumes_nested_arg_lists(
				left_func->args, right_func->args,
				left.bindenv, right.bindenv, can_bind);
        
    	   } // case COR_FUNCTOR

           case COR_GROUPING:
            CORAL_error(COR_INTERNAL_ERROR,"Grouping in subsumption check.",
                        "subsumes_args()");
           default:
                return(COR_U_FAIL);
           }
      case COR_GROUPING:
        CORAL_error(COR_INTERNAL_ERROR,"Grouping in subsumption check.",
                    "subsumes_args()");

      default:
	fprintf(stderr,"Error! subsumes: default case yet to be implemented!\n");

    }
    return(COR_U_FAIL);
}

int subsumes_nested_arg_lists(ArgList& left, ArgList& right,
    BindEnv *left_bindings, BindEnv *right_bindings, int can_bind)
{
#ifdef DO_TRACE
    if (exEnv.dbg_subsumes) {
	fprintf(exEnv.trace_file, 
		"[subsumes_nested_arg_listss(left&=0x%x", &left);
	fprintf(exEnv.trace_file, ", right&=0x%x", &right);
	fprintf(exEnv.trace_file, 
		", left_bindings=0x%x, right_bindings=0x%x)]\n",
	       left_bindings, right_bindings);
    }
#endif

    Term left_term, right_term;
    left_term.bindenv = left_bindings;
    right_term.bindenv = right_bindings;
    int i = left.count();
    if (right.count() != i) return COR_U_FAIL;
    for ( ; --i >= 0; ) {
	left_term.expr = left[i];
	right_term.expr = right[i];
        if (subsumes_args(left_term, right_term, can_bind) == COR_U_FAIL)
            return COR_U_FAIL;
    }
    return COR_U_SUCCEED;
}

int subsumes_arg_lists(ArgList& left, ArgList& right,
    BindEnv *left_bindings, BindEnv *right_bindings)
{
#ifdef DO_TRACE
    if (exEnv.dbg_subsumes) {
	fprintf(exEnv.trace_file, "[subsumes_arg_lists(left&=0x%x", &left);
	fprintf(exEnv.trace_file, ", right&=0x%x", &right);
	fprintf(exEnv.trace_file, 
		", left_bindings=0x%x, right_bindings=0x%x)]\n",
	       left_bindings, right_bindings);
    }
#endif


    /********  ERROR -- TO BE FIXED
    // WARNING::  ReturnUnify optimizations needed here!!!
    .. fix subsumes to assume that one of the arguments is in 
    ..   a normal form where there are no cross bindenv bindings.
    ..   we can then use this fact to avoid checks for all_free etc.
    ..   Perhaps we can pass in the bindenv that is in normal form as an
    ..   argument when called from subsumes_tuple, so that all_free is 
    ..   used for all current used.
    *******************************/

#if 0
    /* ERROR:  By commenting out the following code, we make an assumption 
	that left bindings never cross into
	right.
	MAKE SURE that this assumption is valid (esp. in ord-search)
    */
    if ( ! ( right_bindings==NULL || 
	     (left_bindings != NULL && left_bindings->all_free()) ||
	     left.isConstant() // ||
	     // left_bindings->is_versioned();
	   ) ) {
	fprintf(stderr,"System Error: subsumes_arg_lists works only %s %s",
		"when either right_bindings is null, \n \t "
		"or left_bindings is all_free.\n");
	return(COR_U_FAIL);
	}
#endif 

    return subsumes_nested_arg_lists(left, right, left_bindings, 
		right_bindings, CAN_BIND);
}


int subsumes(BindEnv* env1, ArgList& arg2, BindEnv* env2)
{
    return(subsumes_arg_lists(arg2, arg2, env1, env2));
}

/****************************************************************************/


/**************
*  subsumes_tuple(tuple, newtuple, display):
* 	Checks if tuple subsumes newtuple, and prints a message if display is
* 	set.  If tuple does not have a bindenv it creates one of the required
* 	size.
*
*  equal_tuples(tuple1, tuple2, display):
*	Checks if each of tuple1 and tuple2 subsumes the other.
***************/
int subsumes_tuple( Tuple *tuple, Tuple *newtuple, int display)
{
    StackMark unify_mark;
    int stat;

static ArrayBindEnv NilEnv (0);
    if (tuple->bindenv) {
	stat = subsumes_arg_lists(tuple->args(), newtuple->args(),
			tuple->bindenv, newtuple->bindenv);
	unify_mark.pop_to();
    }
    else if(tuple->env_size!=0) {
	ArrayBindEnv tuple_env(tuple->env_size);
	stat = subsumes_arg_lists(tuple->args(), newtuple->args(), 
		&tuple_env, newtuple->bindenv);
	unify_mark.pop_to();
     }
     else {
	stat = subsumes_arg_lists(tuple->args(), newtuple->args(), 
			&NilEnv, newtuple->bindenv);
        unify_mark.pop_to();
    }

    if (stat && display) {
	fprintf(exEnv.trace_file, ") - subsumed by (");
	tuple->printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ")]\n");
    }
    return stat;
}

int subsumes_value(AggregateKind aggkind, Arg *val1, Arg *val2, BindEnv *env1,
		BindEnv *env2) 
{

    // Returns 1 if val1 (new value) subsumes val2 (old value),
    //   -1 if val2 (old value) subsumes val1 (new value) and
    // returns 0 if the values are equal.

    
    StackMark stackmark;
    Term term1(val1, env1);
    Term term2(val2, env2);
    FULL_DEREFERENCE_TERM(term1);
    FULL_DEREFERENCE_TERM(term2);

    // First dispose off any selection
    if (aggkind == AnyAggregation)  {
      /***************
      if (! term1.isConstant() || ! term2.isConstant()) {
            fprintf(stderr,
          "Error: Aggregate Selection: aggregated argument not a constant\n");
          return 0;
      }
      ****************/

      int stat = unify_args(term1,term2);
      stackmark.pop_to();
        if (stat==COR_U_SUCCEED)
          return 0;
      else return -1;  // new value is subsumed if don't unify
    }

    if (term1.expr->kindof() != COR_NUM_CONST ||
    	term2.expr->kindof() != COR_NUM_CONST ) { 
        fprintf(stderr,
    	   "Aggregate Selection: aggregated argument not a number\n");
	stackmark.pop_to();
    	return 0;
     }
     int stat = ((NumArg*)(term1.expr))->compare(*((NumArg*)(term2.expr)) );
     // stat is pos if term1.expr is greater, neg if lesser, and 0 if equal

     if (aggkind == MinAggregation)
    	stat = -stat;
     else if (aggkind != MaxAggregation) {
	CORAL_error(COR_BAD_ANNO, "Bad aggregation type", "subsumes_value");
	stat = 0;
     }
   
     stackmark.pop_to();
     return stat;
}

int equal_tuples( Tuple *tuple1, Tuple *tuple2, int display)
{
    return (subsumes_tuple(tuple1, tuple2, display) &&
		subsumes_tuple(tuple2, tuple1, display));
}

static int is_answer_fact( TupleIterator& iterator, Tuple *) {

    if (iterator.relation->r_kind == COR_R_ANSWER)
	return 1;
    return 0;
}

/*********************************************
* 	// Shady check - assumes answer fact is the delta relation, and
* 	// hence the last arg must be a free var.
* 	// If supfact is to be fetched, the last arg is the goalid arg, and
* 	// would have been bound. 
* 
*     int numargs = iterator.arg_list.count();
* 
*     Arg *lastarg = iterator.arg_list.arg(numargs-1);
* 
*     if (! is_var(lastarg) ) {
* 	fprintf(stderr,
*       "Internal Error: is_answer_fact - bad last argument - not a variable.\n");
* 	return 0;
*     }
* 
*     Term term (lastarg, iterator.bindenv);
*     FULL_DEREFERENCE_TERM(term);
*     if (term.expr == lastarg)    // Var was free 
* 	return 1;
*     else return 0;
* }
* 
**********************************************/

static void bind_free_iterator_args (TupleIterator& iterator, Tuple *tuple) {

    // NOTE:  this is called only for the supplementary literal, and hence 
    //		there should be no nested structures.

    int i;
    Arg *arg;

    for(i=0; i < iterator.arg_list.count(); i++) {
       arg = iterator.arg_list.arg(i);
       if ( arg->kindof() == COR_VARIABLE ) {
    	     Term term (arg, iterator.bindenv);
	     FULL_DEREFERENCE_TERM(term);
             if (term.kindof() == COR_VARIABLE) {   // Bind it 
                  Term tuple_term(tuple->arg(i), iterator.tuple_env);
    	          inline_unify_binding(iterator.bindenv, term.varnum(), 
				tuple_term);
	     }
       	}
    }
}



int unify_literal(TupleIterator& iterator, Tuple *tuple, int display)
{

  StackMark unify_mark;
  
  if (CurrModuleInfo->NonGroundFacts) {

    if ((USING_RETURN_UNIFY) && (iterator.unification_number == 2) &&
	(iterator.relation->r_kind == COR_R_SUPPLEMENTARY)) { 
      if (iterator.prev_tuple->parid == tuple->contid) {
#ifdef DO_TRACE
	if (exEnv.dbg_return_unify)
	  fprintf(exEnv.trace_file, 
		  "** Return unify - succeeded\n");
#endif
	iterator.tuple_env = iterator.prev_bindenv;
	bind_free_iterator_args(iterator, tuple);
	iterator.reset_no_match(); 
#ifdef DO_TRACE
	if (display) {
	  fprintf(exEnv.trace_file,
		  "HashSimpleRelation: get_next_tuple: ");
	  iterator.relation->name->print(NULL,exEnv.trace_file);
	  fprintf(exEnv.trace_file,"(");
	  tuple->printon(exEnv.trace_file);
	  fprintf(exEnv.trace_file,
		  ") [env_size=%d] \n", tuple->env_size);
	}
#endif
	return 1;
	
      }
    }
  }


  Tuple *newtuple = NULL;  // Renamed version of given tuple

  if (CurrModuleInfo->NonGroundFacts) {

    if (USING_RETURN_UNIFY && (iterator.unification_number > 2))
    {
	// rename the tuple, and resize iterator.bindenv.
	// Don't do this for the first literal, since we can avoid renaming 
	//    facts for that literal when return-unification succeeds.
	//    If return-unification fails, the renaming is done in a lazy
	//    manner.
	newtuple = tuple->rename(iterator.prev_bindenv);
        iterator.tuple_env = newtuple->bindenv;
	tuple = newtuple;
    }
    else { 
        // why do this if there are only ground facts ?? - PRAVEEN
	iterator.tuple_env = tuple->make_bindenv_version();
    }
  }

  if (unify_arg_lists(iterator.arg_list, tuple->args(),
	      	iterator.bindenv, iterator.tuple_env )) {
/****
  if (unify_arg_lists(iterator.temp_arglist, tuple->args(),
	      	iterator.bindenv, iterator.tuple_env )) {
***/
        // Remove this line ?? ___ EFFICIENCY1
	iterator.reset_no_match(); 
#ifdef DO_TRACE
	if (display) {
	    fprintf(exEnv.trace_file, "HashSimpleRelation: get_next_tuple: ");
	    iterator.relation->name->print(NULL,exEnv.trace_file);
	    fprintf(exEnv.trace_file,"(");
	    tuple->printon(exEnv.trace_file);
	    fprintf(exEnv.trace_file, ") [env_size=%d] \n", tuple->env_size);
	}
#endif

	return 1 ;
    }

#ifdef DO_PROFILE
    if (TableStackCount > 0)
       (TableStack[TableStackCount-1]->moduledata->module_info.
         GlobalProfileInfo.non_unifying_tuples)++ ;
      else
        (GlobalProfileInfo.non_unifying_tuples)++ ;
#endif

    unify_mark.pop_to();

  if (CurrModuleInfo->NonGroundFacts) {
    // All this is only for non-ground facts !!
    if (iterator.tuple_env) {
	delete iterator.tuple_env;
	iterator.tuple_env = NULL;
    }

    if (newtuple && newtuple != tuple) {
	// rename created a new tuple, which is no longer required
	delete newtuple;  // Unification failed.
    }
  }
  return 0;
}
