/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/


#include "arg.h"
#include "builtin-rel.h"
#include "externs.h"
#include "globals.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <a.out.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <machine/param.h>
#include <unistd.h>


#define DUMMY_FN_NAME "_CORAL_dummy"
#define CORAL_FILENAME_TEMPFILE  "_fname_coral.temp"

#ifndef __GNUC__
#ifndef UNIX_HP
extern "C"  char *sbrk(int);
extern "C"  read(int, char *, int);
#endif
extern "C"  close(int);
#endif

extern char *strip_quotes(char *);
extern char coral_name[];

struct exec_function {
  caddr_t   func;
  struct exec_function *next;
  exec_function() {next = NULL;}
};

static struct exec_function * incr_load(const char *fname)
{
  char filename[200];
  strcpy(filename, fname);

  char buf[1000] ;
  int fd ,len ;
  len = strlen(filename);


  // first determine the full pathname of this program !

  sprintf(buf, "which %s 2>/dev/null > %s", coral_name, CORAL_FILENAME_TEMPFILE);

  if (system(buf)) {
    fprintf(exEnv.error_file, "unable to determine pathname of executing program :");
    fprintf(exEnv.error_file, " assuming %s\n", coral_name);
  }
  else {
    FILE *fd;
    if (!(fd = fopen(CORAL_FILENAME_TEMPFILE, "r"))) {
      fprintf(exEnv.error_file, "unable to determine name of executing program :");
      fprintf(exEnv.error_file, " assuming %s\n", coral_name);
      unlink(CORAL_FILENAME_TEMPFILE);
    }
    else {
      fgets(coral_name, 200, fd);
      // the last character is a \n, and needs to be overwritten
      coral_name[strlen(coral_name)-1] = '\0';
      fclose(fd);
      unlink(CORAL_FILENAME_TEMPFILE);
    }    
  }


  // Check that the file is a .o file
  if (filename[len-2] != '.') {
    fprintf(exEnv.error_file, "Input file should be a .C file, a .S file\n");
    fprintf(exEnv.error_file, "or a .o file compiled with the -G 0 option\n");
    return NULL ;
  }
  if ((filename[len-1] != 'o') || (filename[len-2] != '.')) {
    if ((filename[len-1] != 'C') && (filename[len-1] != 'S')) {
      fprintf(exEnv.error_file, "Input file should be a .C file, a .S file\n");
      fprintf(exEnv.error_file, "or a .o file compiled with the -G 0 option\n");
      return NULL ;
    }
    if (filename[len-1] == 'S') {
      sprintf(buf, "translator -i %s -o %s", filename, filename);
      buf[strlen(buf)-1] = 'C';
      if (system(buf)) {
	fprintf(exEnv.error_file, "Could not run the translator on %s\n", filename);
	return NULL ;
      }
      filename[len-1] = 'C' ;
    }	

#ifdef __GNUC__
    sprintf(buf, "gcc -c -w -G 0 -I%s/includes %s", exEnv.coral_path, filename);
#else
    sprintf(buf, "CC -c -w -G 0 -I%s/includes %s", exEnv.coral_path, filename);#
#endif

    if (system(buf)) {
      fprintf(exEnv.error_file, "Could not compile %s\n", filename);
      return NULL ;
    }
#ifdef DEBUG
    fprintf(exEnv.error_file, "Compiled file %s\n", filename);
#endif
    filename[len-1] = 'o' ;
  }

  FILE *fdes ;

  // Create the loadable code with all references patched
  // .................................................
  caddr_t oadx = (caddr_t)sbrk(0);
  caddr_t adx = ((char*)oadx) + NBPG - (((int)oadx) % NBPG);

  sprintf(buf, "ld -N -T %X -A %s %s -o %s.new", adx, coral_name, filename, filename);

  if (system(buf)) {
    fprintf(exEnv.error_file, "Failed to load\n");
    sprintf(buf, "%s.new", filename);
    unlink(buf);
    return NULL ;
  }

#ifdef DEBUG
  fprintf(exEnv.error_file, "created file %s.new with references resolved\n", filename);
#endif

  sprintf(buf, "%s.new", filename);
  strcpy(filename, buf);

  // Perform the incremental load
  // ............................

  caddr_t ldadx;

#ifdef UNIX_MIPS
  fd = open(buf, O_RDONLY, 0);

  struct filehdr Filehdr;
  struct aouthdr Aouthdr;
  read(fd, (char *)&Filehdr, sizeof(struct filehdr));
  read(fd, (char *)&Aouthdr, sizeof(struct aouthdr));
  
  sbrk(NBPG - (((int)oadx) % NBPG));

  ldadx = (caddr_t)sbrk((int)(Aouthdr.tsize + 
					Aouthdr.dsize + Aouthdr.bsize));


  lseek(fd, (int)(N_TXTOFF(Filehdr, Aouthdr)), SEEK_SET);
  read(fd, ldadx, ((int)(Aouthdr.tsize + Aouthdr.dsize + Aouthdr.bsize)));
#endif /* UNIX_MIPS */

#ifdef UNIX_SPARC
  fd = open(buf, O_RDONLY);

  struct exec Exec;
  read(fd, (char *)&Exec, sizeof(struct exec));
  sbrk(PAGSIZ - (((int)oadx) % PAGSIZ));

  ldadx = (caddr_t)sbrk((int)(Exec.a_text + Exec.a_data + Exec.a_bss));
  read(fd, ldadx, ((int)(Exec.a_text + Exec.a_data)));
#endif


  close(fd);

#ifdef DEBUG
  fprintf(exEnv.error_file, "load addr is %X \n", (int)ldadx);
#endif

  // retrieve the relocated address of the extern function
  // .....................................................

  sprintf(buf, "nm %s | grep %s > _CORAL.load_tmp2", filename, DUMMY_FN_NAME);
  if (system(buf)) {
    fprintf(exEnv.error_file, "Unable to locate installing function %s in relocated code\n",
	    DUMMY_FN_NAME);
    unlink(filename); unlink("_CORAL.load_tmp2");
    delete ldadx;
    return NULL ;
  }

  if (!(fdes = fopen("_CORAL.load_tmp2", "r"))) {
    fprintf(exEnv.error_file, "Unable to open temporary file _CORAL.load_tmp2\n");
    unlink(filename); unlink("_CORAL.load_tmp2");
    delete ldadx ;
    return NULL ;
  }

  // retrieve the address of the extern function
  int return_address ; char temp_char;
  struct exec_function *func_list = new struct exec_function;

  if (fscanf(fdes, "%X %c %s", &return_address, &temp_char, buf) != 3) {
    fprintf(exEnv.error_file, "Unable to recover relocated installing function address\n");
    fclose(fdes);
    unlink(filename); unlink("_CORAL.load_tmp2");
    delete ldadx;
    return func_list ;
  }

  struct exec_function *temp; int count  = 0;
  temp = func_list->next;
  func_list->next = new struct exec_function;
  func_list->next->func = (caddr_t)return_address;
  func_list->next->next = temp;
  count++;
  
  while (fscanf(fdes, "%X T %s", &return_address, buf) == 2) {
    temp = func_list->next;
    func_list->next = new struct exec_function;
    func_list->next->func = (caddr_t)return_address;
    func_list->next->next = temp;
    count++;
  }

  fclose(fdes);
  unlink(filename);
  unlink("_CORAL.load_tmp2");

  return func_list;
}

#define FAIL_RETURN {iterator.set_no_match(); return;}

void loadIncrFile(char *filename, TupleIterator& iterator)
{
  typedef void (*PF)(...);
  
  struct exec_function *func_list = incr_load(filename);
  if (!func_list || !(func_list->next)) {
    fprintf(exEnv.error_file, "CORAL :: Error -- incremental load failure\n");
    delete [] filename ;
    FAIL_RETURN;
  }
  while (func_list->next) {
    PF anewfunc = (PF) func_list->next->func;
    (*anewfunc)();
    struct exec_function *temp = func_list->next;
    delete func_list;
    func_list = temp;
  }
}

