/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/** hashtable.C
	This file contains code for generic hash tables.
	The only data type that can be stored in the table is void *.
	NULL pointers may not be stored in the table.
	A hash value must be provided with the datum.  Also a function
	that can compare two void *'s must be provided.
**/

#include "config.h"
#include "hashtable.h"
#include "externs.h"
#include "globals.h"
#include <stdlib.h>
#include <string.h>

GenericHashTable::GenericHashTable( EqualsFn eqf1, int initsize1 /* = 128 */,
	double incr_ratio1 /* = 2.0 */, double max_occupancy1 /* = 2.0 */)
{
  if (incr_ratio1 <= 0.0) incr_ratio1 = exEnv.C_incr_ratio_default;
  if (max_occupancy1 <= 0.0) max_occupancy1 = exEnv.C_max_occupancy_default;
  equalsfn = eqf1;
  max_size = initsize1;
  cur_size = 0;
  incr_ratio = incr_ratio1;
  max_occupancy = max_occupancy1;
  limit = int(max_size * max_occupancy);
}



CoreHashTable::CoreHashTable(EqualsFn eqf1, int initsize1, 
		double incr_ratio1, double max_occupancy1)
	: GenericHashTable(eqf1, initsize1, incr_ratio1, max_occupancy1)
{
  table = new HashEntry[max_size];
  // bzero(table, max_size *sizeof(HashEntry) );
  memset(table, 0, max_size *sizeof(HashEntry) );
}

	
/** the insert function returns the argument entry if entry did not
	already exist, else it returns the address of the existing 
	element that equals entry (under equalsfn). If to_delete is set
	and the input entry is already in the table, the input entry
	is deleted to recover the storage allotted to it. to_delete
	is a var parameter that on return specifies whether a delete
	occured within this function **/

void * CoreHashTable::insert(void *entry, int hashval, int& to_delete)
{
  int bucket = hashval % max_size;
  
  ASSERT (entry != NULL);

  if (table[bucket].data == NULL) {
    table[bucket].data = entry;
    table[bucket].hashval = hashval;
  }
  else {
    HashEntry *temp_entry = table + bucket;
    while (temp_entry) {
      if ((temp_entry->hashval == hashval) &&
	  ((*equalsfn)(temp_entry->data, entry))) {
	if (to_delete) delete entry ;
	return (temp_entry->data );
      }
      temp_entry = temp_entry->next;
    }
    temp_entry = new HashEntry;
    temp_entry->data = table[bucket].data;
    temp_entry->hashval = table[bucket].hashval;
    temp_entry->next = table[bucket].next;
    table[bucket].next = temp_entry;
    table[bucket].data = entry;
    table[bucket].hashval = hashval;
  }

  cur_size++;
  rehash_if_needed();
  to_delete = 0 ;           // Specify that no delete has occured
  return entry;
}

/********************  
 ************** implementing a hash table in this fashion (as an
 open hash table with linear probing overflow, is most inefficent !
          -- PRAVEEN

void * CoreHashTable::insert(void *entry, int hashval, int& to_delete)
{
  int startbucket = hashval % max_size;
  int bucket;
  
  ASSERT (entry != NULL);

  for(bucket = startbucket; ;) {
    if (table[bucket].data == NULL)
      break;
//    if ((*equalsfn)(table[bucket].data,entry)) {
    if ((table[bucket].hashval == hashval) &&
	((*equalsfn)(table[bucket].data,entry))) {
      if (to_delete) delete entry ;
      return (table[bucket].data );
    }
    bucket = ( bucket+1) % max_size;
    ASSERT (bucket != startbucket); // It is critical that the table
                                    // never be full.
  }
  table[bucket].data = entry;
  table[bucket].hashval = hashval;
  cur_size++;
  rehash_if_needed();
  to_delete = 0 ;           // Specify that no delete has occured
  return entry;
}

void * CoreHashTable::lookup(void *entry, int hashv)
{

	int startbucket = hashv % max_size;	
	int bucket;

	for(bucket = startbucket; ;) {
	    if (table[bucket].data == NULL)
		return(0);
//	    if (equalsfn(table[bucket].data,entry))
	    if ((table[bucket].hashval == hashv) &&
		((*equalsfn)(table[bucket].data,entry)))
		return (table[bucket].data );
	    bucket = ( bucket+1) % max_size;
	    ASSERT (bucket != startbucket); // It is critical that the table
					// never be full.
	}
}
******************/

void * CoreHashTable::lookup(void *entry, int hashv)
{
  int bucket = hashv % max_size;

  if (table[bucket].data == NULL) return NULL;

  HashEntry *temp_entry = table + bucket;
  while (temp_entry) {
    if ((temp_entry->hashval == hashv) &&
	((*equalsfn)(temp_entry->data, entry)))
      return (temp_entry->data );

    temp_entry = temp_entry->next;
  }

  return NULL;

}

void CoreHashTable::rehash_bigger()
{
  int old_max_size = max_size;
  int i;
  
  max_size =  int(max_size * incr_ratio);
  limit = int(max_size * max_occupancy);
  cur_size = 0;
  
  HashEntry *old_table = table;
  HashEntry *temp_entry;
  table = new HashEntry[max_size];
  //bzero(table, max_size *sizeof(HashEntry) );
  memset(table, 0, max_size *sizeof(HashEntry) );
  for (i=0; i< old_max_size; i++) {
    if (!old_table[i].data) continue;
    temp_entry = old_table + i;
    while (temp_entry) {
      insert(temp_entry->data, temp_entry->hashval);
      temp_entry = temp_entry->next;
    }
  // there is a memory leak here, as the Hash_Entry structs in the
  // list do not reclaimed . should add code to do this at some point -- PRAVEEN

    /***
    if ( old_table[i].data )
      insert(old_table[i].data, old_table[i].hashval);
      *****/
  }
  delete old_table;
}


