/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "arg.h"
#include "generic-rel.h"
#include "externs.h"
#include <stdlib.h>
#include "globals.h"
#include "gennum.h"

extern ArrayBindEnv UnusedEnv;

Grouping::Grouping(int argcount)
{
    nestedArgs = FuncArg::New(NestedSymbol, argcount);
    index = 0;
    kind = NoAggregation;
}

Grouping::Grouping(FuncArg *func, int _index)
{
    nestedArgs = func;
    index = _index;
    kind = NoAggregation;
}

Arg* Grouping::simplify(BindEnv *context,
			TermLink*& renamed_vars, BindEnv *const_env,
			BindEnv *rename_only_env) 
{
    switch (kind) {
      case SetAggregation:
      case NoAggregation: {
	Relation *rel = new HashSimpleRelation(nested_set_arity, 0,
					       COR_DEFAULT_SET_BUCKETS);
	rel->name = NestedSymbol;
	// Relation *rel = AllocRelation(NestedSymbol, arity());
        rel->set_subsumption( this->check_subsum );
	ArgList *copy_args = ArgList::New(arity());
	// WARNING - the following may not be quite right
	int env_size = CopyArgs(copy_args->first(), first(),
				context, arity(), const_env,
				rename_only_env);
	Tuple *tuple1 = new Tuple(copy_args);
	tuple1->env_size = env_size;
	if (kind == SetAggregation) {
	   if (!rel->is_subsumed(tuple1))
		  rel->insert_tuple(tuple1);
		}
	else
		rel->insert_tuple(tuple1);
	return rel;
      }
      case CountAggregation:
	return (Arg *) One;

      case ProductAggregation:
      case SumAggregation:
      case MinAggregation:
      case MaxAggregation:
	if (arity() != 1) { // ERROR!
	    fprintf(stderr, "Grouping::simplify: bad arity\n");
	    return (Arg *) Zero;
	}
	return first()[0]->simplify(context, renamed_vars, const_env, 
			rename_only_env);
      case AvgAggregation: // Not implemented!
	return (Arg *) Zero;
      default :
	return (Arg *) Zero;
    }
}

/*****************************/


// Count and Sum:   These currently work ONLY if they are called in a 
//		 stratified fashion.  That is, if a relation is defined using
//		 count or sum, it better not be recursive.
// Max and Min:	    These currently work in some non-stratified cases.
//		 If a new tuple is found to be better than an old one,
//		 the old one is deleted and the do_insert flag is set so that
//		 the new tuple is inserted later on.


/****************************/

int Grouping::update_tuple(Relation *orig_rel, Tuple *tuple, 
		int argnum, BindEnv *context, int &do_insert)
{

    TermLink *renamed_vars = NULL;
    ASSERT(argnum < tuple->arity() );
    /* This code will not work if val has variables in it */
    Arg *val = (Arg *) first()[0]->simplify(context, renamed_vars, NULL,0);
		   /* context, renamed_vars, const_env, const_env_max_vars */
    if (!val->isConstant()) {
	fprintf(stderr,"Grouping::update_tuple - val is not a constant.\n");
    }

    switch (kind) {
	  case SetAggregation:
      case NoAggregation: {
 	if (tuple->args()[argnum]->kindof() != COR_RELATION) {
	    fprintf(stderr, 
		"Error: grouping - expected relation argument to insert into");
	    do_insert = 0;
	    return(0);
	}
	// this creates a copy of the original tuple and updates
	// the value in the grouping argument.  the original tuple is left
	// where it was, and it is marked deleted -- so as to not
	// affect indices, etc.
	Tuple *new_tuple = new Tuple();
	*new_tuple = *tuple;

	Relation *rel = (Relation *)new_tuple->args()[argnum];
		// = AllocRelation(NestedSymbol, arity());
	rel->_hash = UnknownHashValue; 
		// so that a new hash value will be computed for the set
	ArgList *copy_args = ArgList::New(arity());

	/*********************************
	// WARNING::  ReturnUnify optimizations needed here!!!
	....
	.... See how this is affected by and will affect return unify 
	.... optimizations
	....
	**********************************/

	int env_size = CopyArgs(copy_args->first(), first(),
				context,  arity(), &UnusedEnv);
	Tuple *tuple1 = new Tuple(copy_args);
	tuple1->env_size = env_size;
	if (kind == SetAggregation) {
	   if (!rel->is_subsumed(tuple1))
	     rel->insert_tuple(tuple1);
	   }
	else
		rel->insert_tuple(tuple1);

	// NOTE: add rel->env_size and update it here.
	// also add rel->hash_val and rel->id and update them
	// also do this whenever nested relations are created.
	// (see gram.y)

	tuple->do_delete();
	orig_rel->insert_tuple(new_tuple);

	do_insert = 0;
	return 0;
       }
      case CountAggregation: {
	 if (tuple->args()[argnum]->kindof() != COR_NUM_CONST ) { // ERROR!
	    fprintf(stderr,
		  "Grouping::update_tuple: CountAggregation: not a number!\n");
	    return 0;
	 }

	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.
	 Tuple *new_tuple = new Tuple();
	 *new_tuple = *tuple;
	 new_tuple->args()[argnum] = (Arg *)
			((Numeric *)tuple->args()[argnum])->add(*One); 
	 tuple->do_delete();
	 orig_rel->insert_tuple(new_tuple);

	 do_insert = 0;
	 return 1;
       }

      case SumAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(stderr,
		     "Grouping::update_tuple: SumAggregation: bad arity\n");
	    return 0;
	 }
	 if (tuple->args()[argnum]->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) { // ERROR!
	    fprintf(stderr,
		     "Grouping::update_tuple: SumAggregation: not a number!\n");
		return 0;
	 }
		

	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.
	 Tuple *new_tuple = new Tuple();
	 *new_tuple = *tuple;
	 new_tuple->args()[argnum] = (Arg *) 
		((Numeric*)(tuple->args()[argnum]))->add(
			*(Numeric*)val ); 
	 tuple->do_delete();
	 orig_rel->insert_tuple(new_tuple);

	 do_insert = 0;
	 return 1;

       }

      case ProductAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(stderr,
		     "Grouping::update_tuple: ProductAggregation: bad arity\n");
	    return 0;
	 }
	 if (tuple->args()[argnum]->kindof() != COR_NUM_CONST ||
		val->kindof() != COR_NUM_CONST) { // ERROR!
	    fprintf(stderr,
		     "Grouping::update_tuple: ProductAggregation: not a number!\n");
		return 0;
	 }
		

	 // this creates a copy of the original tuple with the updated
	 // value in the grouping argument.  the original tuple is left
	 // where it was, and it is marked deleted -- so as to not
	 // affect indices, etc.
	 Tuple *new_tuple = new Tuple();
	 *new_tuple = *tuple;
	 new_tuple->args()[argnum] = (Arg *) 
		((Numeric*)(tuple->args()[argnum]))->mul(
			*(Numeric*)val ); 
	 tuple->do_delete();
	 orig_rel->insert_tuple(new_tuple);

	 do_insert = 0;
	 return 1;

       }

      case MinAggregation:
      case MaxAggregation: {
	 if (arity() != 1) { // ERROR!
	    fprintf(stderr,
		   "Grouping::update_tuple: Min/MaxAggregation: bad arity\n");
	    return 0;
	 }
	 if (tuple->args()[argnum]->kindof() != COR_NUM_CONST) { // ERROR!
	    fprintf(stderr,
		   "Grouping::update_tuple: Min/MaxAggregation: not a number\n");
		return 0;
	 }
	 int stat = ((NumArg*)(tuple->args()[argnum]))->compare(
			*(NumArg*) val) ;
	 if (kind == MaxAggregation)
		stat = -stat;
	 if (stat <= 0) { 	// No replacement to be done.
	     do_insert = 0;
	     return 0;
	 }
#ifdef DO_TRACE
	if (exEnv.dbg_aggregates)
	    fprintf(exEnv.trace_file,
		    "Min/Max aggregation - new extreme value found\n");
#endif
	 // Old way - direct modification: tuple->args()[argnum] = val;
	 // do_insert starts off as 1, and need not be changed here.
	 // If it is set to 0 by any update_tuple, there is no need to 
	 //	insert the new tuple.
	 tuple->do_delete();
	 return 1;
        }
      case AvgAggregation: // Not implemented!
      	fprintf(stderr,"Grouping::update_tuple: Average not yet %s\n",
		      "implemented");

	return 0;
      default :
	return 0;
    }
}

void Grouping::print(BindEnv* env, FILE *file, char *) const
{
  this->print(env, file);
}

/** Tarun **/
void Grouping::print_dump(BindEnv *env, FILE *file) const
{
    fprintf(file, "\"");
    print(env, file);
    fprintf(file, "\"");
}

void Grouping::print(BindEnv* env, FILE *file) const
{
    switch (kind) {
      case NoAggregation:
	fputs("<", file); break;
      case SetAggregation:
	fputs("makeset(<", file); break;
      case SumAggregation:
	fputs("sum(<", file); break;
      case ProductAggregation:
	fputs("prod(<", file); break;
      case CountAggregation:
	fputs("count(<", file); break;
      case MinAggregation:
	fputs("min(<", file); break;
      case MaxAggregation:
	fputs("max(<", file); break;
      case AvgAggregation:
	fputs("avg(<", file); break;
      default :
	break;
    }
    Arg** arg_ptr = first();
    int i = arity();
    for (;;) {
	(*arg_ptr++)->print(env, file);
	if (--i == 0)
	    break;
	fputs(", ", file);
    };
    fprintf(file, kind == NoAggregation ? ">" : ">)");
}

void Grouping::sprint(char *str, int *pos, BindEnv *env) const
{
    switch (kind) {
      case NoAggregation:
	sprintf(str + *pos, "<");
	(*pos)++ ;
	break;
      case SetAggregation:
	sprintf(str + *pos, "set(<");
	*pos += 5;
	break;
      case SumAggregation:
	sprintf(str + *pos, "sum(<");
	*pos += 5;
	break;
      case ProductAggregation:
	sprintf(str + *pos, "prod(<");
	*pos += 6;
	break;
      case CountAggregation:
	sprintf(str + *pos, "count(<");
	*pos += 7 ;
	break;
      case MinAggregation:
	sprintf(str + *pos, "min(<");
	*pos += 5;
	break;
      case MaxAggregation:
	sprintf(str + *pos, "max(<");
	*pos += 5;
	break;
      case AvgAggregation:
	sprintf(str + *pos, "avg(<");
	*pos += 5;
	break;
      default :
	break;
    }
    Arg** arg_ptr = first();
    int i = arity();
    for (;;) {
	(*arg_ptr++)->sprint(str, pos, env);
	if (--i == 0)
	    break;
	sprintf(str + *pos, ", ");
	*pos += 2 ;
    };
    sprintf(str + *pos, kind == NoAggregation ? "> " : ">)");
    *pos += 2 ;
}
