/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	Software :: U.W.Madison

	db-builtins.C

	Contains code for builtin relations that handle multiple 
	databases.

 ***********************************************************************/

#include <stdio.h>
#include <string.h>
#include "builtin-rel.h"
#include "gennum.h"
#include "unify.h"
#include "globals.h"
#include "parser.h"
#include "interface.h"
#include "generic-index.h"
#include <limits.h>

extern DatabaseStruct *createDB(Name dbname);
extern int destroyDB(Name dbname);
extern int currentDB(Name dbname);
extern int saveDB(Name dbname, FILE *);
extern int renameDB(Name dbname, Name newName);
extern int copyToDB(FuncArg *srcrel, Name dbname, FuncArg *dstrel);
extern int addToDB(FuncArg *srcrel, Name dbname, FuncArg *dstrel);
extern int openRelInCurDB(FuncArg *rel, Name dbname) ;
extern int removeRelFromDB(FuncArg *rel, Name dbname) ;
extern int clearRelInDB(FuncArg *rel, Name dbname) ;
extern int listRelsInDB(Name dbname, FILE *);
extern int listEveryDB();

extern char *mk_tmp_file_name(char *name); /* defined in user-builtin2.C */
extern FILE *open_file(char *name);

extern char *strip_quotes(char *) ;
extern int C_linenum;
extern scanner_at_eof;

int macro_pipe[2] ;

#undef FAIL_RETURN
#define FAIL_RETURN {iterator.set_no_match(); return iterator.bindenv;}

#ifdef UNIX_HP
#undef PIPE_MAX
#define PIPE_MAX 5000
#endif

/*****************************************************************/

BindEnv *CreateDBSolver(BuiltinRelation& , TupleIterator& iterator)
{
    if (iterator.arg_list.count() != 1) {
      CORAL_error(COR_BAD_ARITY, "1 argument to ws_create needed", NULL);
      FAIL_RETURN
      }

    else {
      Term term1 (iterator.arg_list[0], iterator.bindenv);
      FULL_DEREFERENCE_TERM (term1);
      if (term1.expr->kindof() != COR_SYMBOL_CONST ) {
	CORAL_error(COR_BAD_ARG_TYPE, NULL, "CreateDBSolver");
	term1.printon(stderr);
	fprintf(stderr,"\n");
	FAIL_RETURN
	}
      
      char *actual_string = strip_quotes(SymbolString(term1.expr));
      createDB(EnterSymbol(actual_string));
      delete actual_string ;

    }
    return iterator.bindenv ;	  
}

BindEnv *DestroyDBSolver(BuiltinRelation&, TupleIterator& iterator)
{
    if (iterator.arg_list.count() != 1) {
      CORAL_error(COR_BAD_ARITY, "1 argument to ws_destroy needed", NULL);
      FAIL_RETURN
      }

    else {
      Term term1 (iterator.arg_list[0], iterator.bindenv);
      FULL_DEREFERENCE_TERM (term1);
      if (term1.expr->kindof() != COR_SYMBOL_CONST ) {
	CORAL_error(COR_BAD_ARG_TYPE, NULL, "DestroyDBSolver");
	term1.printon(stderr);
	fprintf(stderr,"\n");
	FAIL_RETURN
	}

      char *actual_string = strip_quotes(SymbolString(term1.expr));
      destroyDB(EnterSymbol(actual_string));
      delete actual_string ;

    }
    return iterator.bindenv ;	  
}


BindEnv *CurrentDBSolver(BuiltinRelation&, TupleIterator& iterator)
{
    if (iterator.arg_list.count() == 0) {
      fprintf(stderr, "Current Workspace is : %s\n", SymbolString(CurDB->name));
      return iterator.bindenv ;
    }

    if (iterator.arg_list.count() != 1) {
      CORAL_error(COR_BAD_ARITY, "1 argument to ws_current needed", NULL);
      FAIL_RETURN
      }
    else {
      Term term1 (iterator.arg_list[0], iterator.bindenv);
      FULL_DEREFERENCE_TERM (term1);
      if (term1.expr->kindof() != COR_SYMBOL_CONST ) {
	CORAL_error(COR_BAD_ARG_TYPE, NULL, "CurrentDBSolver");
	term1.printon(stderr);
	fprintf(stderr,"\n");
	FAIL_RETURN
	}

      char *actual_string = strip_quotes(SymbolString(term1.expr));
      currentDB(EnterSymbol(actual_string));
      delete actual_string ;

    }
    return iterator.bindenv ;	  
}

BindEnv * ListDBSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if (iterator.arg_list.count() != 0) {
    CORAL_error(COR_BAD_ARITY, "no arguments to list_ws needed", NULL);
    FAIL_RETURN
  }

  listEveryDB();

  return iterator.bindenv ;
}

BindEnv *SaveDBSolver(BuiltinRelation&, TupleIterator& iterator)
{
  char *actual_string1, *actual_string2 ;

  if ((iterator.arg_list.count() > 2) || (iterator.arg_list.count() < 1)) {
    CORAL_error(COR_BAD_ARITY, "2 arguments to ws_save needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "SaveDBSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  if (iterator.arg_list.count() == 2) {
    Term term2 (iterator.arg_list[1], iterator.bindenv);
    FULL_DEREFERENCE_TERM (term2);
    if (term2.expr->kindof() != COR_SYMBOL_CONST) {
      CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "SaveDBSolver");
      term2.printon(stderr);
      fprintf(stderr,"\n");
      FAIL_RETURN;
    }
    actual_string2 = strip_quotes(SymbolString(term2.expr));
  }
  else actual_string2 = NULL ;

  actual_string1 = strip_quotes(SymbolString(term1.expr));

  FILE *fd ;
  if (!(fd = fopen(actual_string1, "a"))) {
    CORAL_error(COR_CANNOT_OPEN_FILE, actual_string1, "SaveDBSolver");
    delete [] actual_string1 ;
    if (actual_string2) delete [] actual_string2 ;
    FAIL_RETURN    
  }

  saveDB(actual_string2 ? EnterSymbol(actual_string1) : NULL, fd);
	
  fclose(fd);
  delete [] actual_string1 ;
  if (actual_string2) delete [] actual_string2 ;

  return iterator.bindenv ;	  
}

BindEnv *RenameDBSolver(BuiltinRelation&, TupleIterator& iterator)
{
  char *actual_string1, *actual_string2 ;

  if ((iterator.arg_list.count() < 1) || (iterator.arg_list.count() > 2)){
    CORAL_error(COR_BAD_ARITY, "2 arguments to ws_rename needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "RenameDBSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  if (iterator.arg_list.count() == 1) {
    actual_string1 = strip_quotes(SymbolString(term1.expr));
    renameDB(CurDB->name, EnterSymbol(actual_string1));
    
    delete [] actual_string1 ;
    return iterator.bindenv ;	  
  }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term2);
  if (term2.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "RenameDBSolver");
    term2.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
  }
    actual_string1 = strip_quotes(SymbolString(term1.expr));
    actual_string2 = strip_quotes(SymbolString(term2.expr));

    renameDB(EnterSymbol(actual_string1), EnterSymbol(actual_string2));
    
    delete [] actual_string1 ;
    delete [] actual_string2 ;

  return iterator.bindenv ;	  
}

BindEnv *ListRelationSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if (iterator.arg_list.count() != 1) {
    CORAL_error(COR_BAD_ARITY, "1 argument to listrel needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a func-arg", "ListRelationSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN;
  }			

  RelationTypeDefault temp = exEnv.C_relation_type_default;
  exEnv.C_relation_type_default = COR_LIST_RELATION;
  make_relation(((FuncArg *)(term1.expr))->functor(), 
		((FuncArg *)(term1.expr))->arity());
  exEnv.C_relation_type_default = temp;
}

BindEnv *OpenRelSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if (iterator.arg_list.count() != 2) {
    CORAL_error(COR_BAD_ARITY, "2 arguments to rel_open needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a func-arg", "OpenRelSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term2);
  if (term2.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "OpenRelSolver");
    term2.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  char *actual_string2 = strip_quotes(SymbolString(term2.expr));

  openRelInCurDB((FuncArg *)term1.expr, EnterSymbol(actual_string2));
	
  delete [] actual_string2 ;

  return iterator.bindenv ;	  
}


BindEnv * RelDisplay(BuiltinRelation&, TupleIterator& iterator)
{
  char name[100];
  char *tmp_file_name = mk_tmp_file_name(name);
  FILE *tmp_file = open_file(tmp_file_name);
  if (!tmp_file) {
    FAIL_RETURN
  }


  if (iterator.arg_list.count() == 0)
    {
      listRelsInDB(CurDB->name, tmp_file);
    }

  else if (iterator.arg_list.count() == 1)
    {
      Term term1 (iterator.arg_list[0], iterator.bindenv);
      FULL_DEREFERENCE_TERM (term1);
      if (term1.expr->kindof() != COR_SYMBOL_CONST) {
	CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "RelDisplay") ;
	term1.printon(stderr);
	fprintf(stderr,"\n");
	FAIL_RETURN
	}
      char *actual_string = strip_quotes(SymbolString(term1.expr));
      listRelsInDB(EnterSymbol(actual_string), tmp_file);
      delete actual_string ;
    }

  else {
    fclose(tmp_file);
    CORAL_error(COR_BAD_ARITY, "0 or 1 argument to list_rels needed", NULL);
    FAIL_RETURN
  }

  fclose(tmp_file);

  char name1[100];
  char *tmp_file_name1 = mk_tmp_file_name(name1);

  char buf[200];
  sprintf(buf, "sort +0 +0 %s > %s", tmp_file_name, tmp_file_name1);
  if (system(buf)) {
    DisplayFile(tmp_file_name);
  }
  else {
    DisplayFile(tmp_file_name1);
    unlink(tmp_file_name1);
  }

  unlink(tmp_file_name);
  return iterator.bindenv ;
}

BindEnv *CloseRelSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if ((iterator.arg_list.count() != 2) && (iterator.arg_list.count() != 1)) {
    CORAL_error(COR_BAD_ARITY, "1 or 2 arguments to rel_open needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a func-arg", "CloseRelSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  if (iterator.arg_list.count() == 1) {
    removeRelFromDB((FuncArg *)term1.expr, CurDB->name);
    return iterator.bindenv ;
  }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term2);
  if (term2.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "CloseRelSolver");
    term2.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
  }
  char *actual_string2 = strip_quotes(SymbolString(term2.expr));
  removeRelFromDB((FuncArg *)term1.expr, EnterSymbol(actual_string2));

  delete actual_string2 ;
  return iterator.bindenv ;	  

}

BindEnv *ClearRelSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if ((iterator.arg_list.count() != 2) && (iterator.arg_list.count() != 1)) {
    CORAL_error(COR_BAD_ARITY, "1 or 2 arguments to rel_open needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a func-arg", "ClearRelSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  if (iterator.arg_list.count() == 1) {
    clearRelInDB((FuncArg *)term1.expr, CurDB->name);
    return iterator.bindenv ;
  }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term2);
  if (term2.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "ClearRelSolver");
    term2.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
  }

  char *actual_string2 = strip_quotes(SymbolString(term2.expr));
  clearRelInDB((FuncArg *)term1.expr, EnterSymbol(actual_string2));

  delete [] actual_string2 ;
  return iterator.bindenv ;	  
}

BindEnv *CopyRelSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if ((iterator.arg_list.count() != 2) && (iterator.arg_list.count() != 3)) {
    CORAL_error(COR_BAD_ARITY, "2 or 3 arguments to rel_add needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a relation template",
		"CopyRelSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term2);
  if (term2.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "CopyRelSolver");
    term2.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
  }

  char *actual_string2 = strip_quotes(SymbolString(term2.expr));

  if (iterator.arg_list.count() == 2) {
    copyToDB((FuncArg *)term1.expr, EnterSymbol(actual_string2),
	    (FuncArg *)term1.expr);
    delete [] actual_string2 ;
    return iterator.bindenv ;
  }

  Term term3 (iterator.arg_list[2], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term3);
  if (term3.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a relation template",
		"CopyRelSolver");
    term3.printon(stderr);
    fprintf(stderr,"\n");
    delete [] actual_string2 ;
    FAIL_RETURN
  }

  copyToDB((FuncArg *)term1.expr, EnterSymbol(actual_string2),
	  (FuncArg *)term3.expr);

  delete [] actual_string2 ;
  return iterator.bindenv ;
}

BindEnv *AddRelSolver(BuiltinRelation&, TupleIterator& iterator)
{
  if ((iterator.arg_list.count() != 2) && (iterator.arg_list.count() != 3)) {
    CORAL_error(COR_BAD_ARITY, "2 or 3 arguments to rel_add needed", NULL);
    FAIL_RETURN
  }

  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term1);
  if (term1.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a relation template",
		"AddRelSolver") ;
    term1.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
    }

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term2);
  if (term2.expr->kindof() != COR_SYMBOL_CONST) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a symbol", "AddRelSolver");
    term2.printon(stderr);
    fprintf(stderr,"\n");
    FAIL_RETURN
  }

  char *actual_string2 = strip_quotes(SymbolString(term2.expr));

  if (iterator.arg_list.count() == 2) {
    addToDB((FuncArg *)term1.expr, EnterSymbol(actual_string2),
	    (FuncArg *)term1.expr);
    delete [] actual_string2 ;
    return iterator.bindenv ;
  }

  Term term3 (iterator.arg_list[2], iterator.bindenv);
  FULL_DEREFERENCE_TERM (term3);
  if (term3.expr->kindof() != COR_FUNCTOR) {
    CORAL_error(COR_BAD_ARG_TYPE, "should be a relation template",
		"CloseRelSolver");
    term3.printon(stderr);
    fprintf(stderr,"\n");
    delete [] actual_string2 ;
    FAIL_RETURN
  }

  addToDB((FuncArg *)term1.expr, EnterSymbol(actual_string2),
	  (FuncArg *)term3.expr);

  delete [] actual_string2 ;
  return iterator.bindenv ;	  
}

// This is an example of how to 'macro' a number of builtins under
// a single name -- PRAVEEN. More work needs to be done on this
BindEnv *ListAllSolver(BuiltinRelation&, TupleIterator& iterator)
{
#ifdef PIPE_MAX
  char buf[PIPE_MAX];
#else
  char buf[_POSIX_PIPE_BUF] ;
#endif

  pipe(macro_pipe) ;
 
  sprintf(buf, "list_dbs. \n list_rels. \n");
#ifdef PIPE_MAX
  ASSERT(strlen(buf) < PIPE_MAX) ;
#else
  ASSERT(strlen(buf) < _POSIX_PIPE_BUF) ;
#endif
  write(macro_pipe[1], buf, strlen(buf));
  close(macro_pipe[1]);

  FILE *tmp_fd = fdopen(macro_pipe[0], "r");
  show_prompt = 0 ;
  fileStack.set_top_file_line(C_linenum);
  fileStack.push(tmp_fd,0) ;
  C_linenum = 0;
  yyin = tmp_fd ;
  scanner_at_eof = 0;

  return iterator.bindenv ;	  
}

/*
BindEnv *MakePersistentSolver(BuiltinRelation&, TupleIterator& iterator)
{
#ifdef PIPE_MAX
  char buf[PIPE_MAX];
#else
  char buf[_POSIX_PIPE_BUF] ;
#endif

  pipe(macro_pipe) ;
  sprintf(buf, "schema(");
  int pos = strlen("schema(") ;
  iterator.arg_list.sprint(buf, &pos) ;
  sprintf(buf + pos, ").\n%s.\n%s.\n%s",
	  "create_db(__tmp)",
	  "current_db(__tmp)",
	  "rel_open(");
  pos = strlen(buf) ;
  iterator.arg_list.sprint(buf, &pos) ;
  sprintf(buf + pos, ", db_rels).\n%s.\n",
	  "copy_rel(
  
#ifdef PIPE_MAX
  ASSERT(strlen(buf) < PIPE_MAX) ;
#else
  ASSERT(strlen(buf) < _POSIX_PIPE_BUF) ;
#endif
  write(macro_pipe[1], buf, strlen(buf));
  close(macro_pipe[1]);

  FILE *tmp_fd = fdopen(macro_pipe[0], "r");
  show_prompt = 0 ;
  fileStack.set_top_file_line(C_linenum);
  fileStack.push(tmp_fd,0) ;
  C_linenum = 0;
  yyin = tmp_fd ;
  scanner_at_eof = 0;

  return iterator.bindenv ;	  
}

*/


BindEnv *ClearDBSolver(BuiltinRelation&, TupleIterator& iterator)
{
#ifdef PIPE_MAX
  char buf[PIPE_MAX];
#else
  char buf[_POSIX_PIPE_BUF] ;
#endif
  Name name ;

  if (iterator.arg_list.count() > 1) {
    CORAL_error(COR_BAD_ARITY, "1 argument to ws_clear needed", NULL);
    FAIL_RETURN
  }

  if (iterator.arg_list.count() == 0)
    name = CurDB->name;
  else {
    Term term1 (iterator.arg_list[0], iterator.bindenv);
    FULL_DEREFERENCE_TERM (term1);
    if (term1.expr->kindof() != COR_SYMBOL_CONST ) {
      CORAL_error(COR_BAD_ARG_TYPE, NULL, "ClearDBSolver");
      term1.printon(stderr);
      fprintf(stderr,"\n");
      FAIL_RETURN
    }
    name = (Name)(term1.expr);
  }

  pipe(macro_pipe) ;
  sprintf(buf, "%s%s %s%s %s%s%s%s %s%s%s%s",
	  SymbolString(CreateDBSymbol),"(\"__tmp\").\n",
	  SymbolString(CurrentDBSymbol),"(\"__tmp\").\n",
	  SymbolString(DestroyDBSymbol), "(", SymbolString(name) , ").\n",
	  SymbolString(RenameDBSymbol),"(\"__tmp\",", SymbolString(name), ").\n");

  
#ifdef PIPE_MAX
  ASSERT(strlen(buf) < PIPE_MAX) ;
#else
  ASSERT(strlen(buf) < _POSIX_PIPE_BUF) ;
#endif

  write(macro_pipe[1], buf, strlen(buf));
  close(macro_pipe[1]);

  FILE *tmp_fd = fdopen(macro_pipe[0], "r");
  show_prompt = 0 ;
  fileStack.set_top_file_line(C_linenum);
  fileStack.push(tmp_fd,0) ;
  C_linenum = 0;
  yyin = tmp_fd ;
  scanner_at_eof = 0;

  return iterator.bindenv ;	  
}
