/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdio.h>
#include <strings.h>
#include "coral-includes.h"

#define MAXPATHLEN  100 	/* Maximum length of file path name */

extern int in_query_loop;
extern char* prompt ;
extern int show_prompt ;
extern int C_linenum;

extern "C" int yyparse();
extern int DisplayFile(char *);
extern int set_output_file(char *file_name);

/*--------------------------------------------------------------- *
NAME : GetFilePointers 

FUNCTION : Reads the filenames specified in src_strin, opens the files,
	   and saves the file pointer into f_stack. Also deletes the
	   .M files corresponding to the opened files.

 *--------------------------------------------------------------- */
int GetFilePointers(char ** src_str, FStack& f_stack, int max_files)
{
  int    count = 0 ; FILE *tmp_fd ;
  char temp_str[200];

  while ((count < max_files)&&(*src_str[count] != '-'))
    {
      if (tmp_fd = fopen(src_str[count],"r")) {
	f_stack.push(tmp_fd,0, src_str[count]) ;
	sprintf(temp_str, "%s.M", src_str[count]);
	unlink(temp_str);
      }
      else
	CORAL_error(COR_FILE_NOT_FOUND, src_str[count], "GetFileList");
      count++;
    }
  return(count);
}

void InvertFileStack(FStack& fs1, FStack& fs2)
{
// This line makes sure that the scanner returns finally to stdin
   fs1.push(stdin,0, "stdin") ;
   while(!fs2.is_empty()) {
	fs1.push(fs2.top_file(), fs2.top_file_line(), fs2.top_file_name());
	fs2.pop() ;
   }
}

/*--------------------------------------------------------------- *
NAME : Command_Line_Error 

FUNCTION : Prints error message about command line error

 *--------------------------------------------------------------- */
void Command_Line_Error(char * str)
{
  fprintf(stderr, "Input syntax : %s [-o/O <output-file>][-f/F <input-file1> ...]\n", str);
  fprintf(stderr,"	-q                Enable quiet mode\n");
  fprintf(stderr,"	-Q                Disable quiet mode\n");
  fprintf(stderr,"	-i                Enable interactive mode\n");
  fprintf(stderr,"	-I                Disable interactive mode\n");
  fprintf(stderr,"	-w                Enable insert mode\n");
  fprintf(stderr,"	-W                Disable insert mode\n");
  fprintf(stderr,"	-o output_file    Specify output file\n");
  fprintf(stderr,"      -f <in_file>%s     Specify input files\n", "+");

  exit(1);
}

main(int ac, char **av)
{
    int		i;
    FStack tmp_fstack ;

    for (i=1; i<ac && *av[i]=='-'; ++i)
      {
	switch (av[i][1])
	  {
	    case 'q':                          /* Quiet mode ON */
		exEnv.C_quiet_mode_default = 1;
		break;

	    case 'Q':                          /* Quiet mode OFF : default */
		exEnv.C_quiet_mode_default = 0;
		break;

	    case 'f':                          /* Input files */
	    case 'F':
		if (av[i][2] != '\0') Command_Line_Error(av[0]);

		i += GetFilePointers((char **)(av+i+1), tmp_fstack,
					(int)(ac - i -1));
		break;

	    case 'o':                      /* Output file */
		if ((av[i][2] != '\0')||(i == ac-1)) Command_Line_Error(av[0]);

		if (!set_output_file(av[++i])) {
		  fprintf(stderr, "%s error: Cannot set output file to %s\n",
			  av[0], av[i]);
		  exit(1);
		}

/*		if ((yyout = fopen(av[++i], "w")) == NULL)
		  {
		    fprintf(stderr, "%s error: Cannot create temp file %s\n",
		        av[0],av[i]);
	            exit(1);
		  }
*/
		break ;

	    case 'i':                     /* Interactive mode ON : default */
		exEnv.C_interactive_mode_default = 1;
		break;

	    case 'I':                     /* Interactive mode OFF */
		exEnv.C_interactive_mode_default = 0;
		break;

	    case 'w':                     /* Insert mode ON : default */
		exEnv.C_insert_mode_default = 1;
		break;

	    case 'W':                     /* Insert mode OFF */
		exEnv.C_insert_mode_default = 0;
		break;


            default :
		Command_Line_Error(av[0]);

	      }
      }
    if (i<ac) Command_Line_Error(av[0]);

    InvertFileStack(fileStack, tmp_fstack) ;
    yyin = fileStack.top_file() ;
    C_linenum = fileStack.top_file_line();
    show_prompt = (yyin == stdin) ;

    in_query_loop = 1;

    exEnv.C_exec_mode = COR_DOING_INTERPRET ;

    init_coral(av[0]) ;

    if (!exEnv.C_quiet_mode_default) {
      // Print preliminary message
      char name_buffer[1000] ;
      sprintf(name_buffer, "%s%s/init.msg", exEnv.coral_path, HELP_PATH);
      DisplayFile(name_buffer);
    }

    while (yyparse()) {
	printf("syntax error -- skipping to next period\n");
    }

    exit_coral();
    if (!exEnv.C_quiet_mode_default) {
      printf("\nHave a good day, %s !\n", cuserid(NULL));
    }
    exit(0);

}

/* ------------------------------------------------------------- */
