/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	cor_error.C
 ***********************************************************************/

#include <stdio.h>
#include "cor_error.h"
#include "globals.h"


static char* Error_Table[] = {
	"",      // 0 
	"syntax error", 	// COR_BAD_SYNTAX            	-1
	"unknown annotation", 	// COR_BAD_ANNO			-2
	"quit inside module", 	// COR_QUIT_IN_MODULE 		-3
	"not implemented" , 	// COR_NOT_IMPLEMENTED		-4
	"illegal insert of tuple into relation", 
				//COR_BAD_TUPLE_INSERT 		-5
	"illegal call of empty_relation()", 
				// COR_BAD_EMPTY_REL 		-6
	"bad argument list" , 	// COR_BAD_ARGLIST		-7
	"bad argument type" , 	// COR_BAD_ARG_TYPE		-8
	"non-numeric arguments passed to builtin relation" , 
				// COR_NON_NUMERIC_ARGS		-9
	"comparison of two non-numbers" , 
				// COR_NON_NUMERIC_COMP		-10
	"wrong arity" , 	// COR_BAD_ARITY		-11
	"not a valid relation name" , 
				// COR_BAD_REL_NAME 		-12
	"unknown global variable" , 
				// COR_BAD_GLOBAL_VAR		-13
	"empty argument list" , // COR_EMPTY_ARGLIST		-14
	"argument should be a string" , 
				// COR_NON_STRING_ARG		-15
	"cannot find file" , 	// COR_FILE_NOT_FOUND		-16
	"failed to execute command" , 
				// COR_FAILED_COMMAND 		-17
	"nested set is not ground" , 
				// COR_NESTED_SET_NOT_GROUND	-18
	"bad schema definition",// COR_BAD_SCHEMA		-19
	"too many arguments" ,  // COR_TOO_MANY_ARGS		-20
	"error in index" ,	// COR_INDEX_ERR		-21
	"bad database tuple" ,  // COR_BAD_TUPLE		-22
	"Exodus error" ,	// COR_ESM_ERR			-23
	"multiple ws error" ,	// COR_MULTIPLE_DB_ERR		-24
        "grouping operator in rule body", //COR_GROUPING_ON_RHS -25
	"" ,
	"" ,
	"exhausted free store !!", // COR_NO_MEMORY		-28
	"internal system error --- please notify software supplier" ,
				// COR_INTERNAL_ERROR	        -29
	"unable to find relation" , 
			// COR_REL_NOT_FOUND    -WARNING_MESSAGE_INDEX = -30
	"cannot open file" ,	// COR_CANNOT_OPEN_FILE
	"received signal signifying exception" , // COR_SIGNAL_RECEIVED
	"duplicate schema defintion", // COR_DUP_SCHEMA  
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	"" ,
	""  
	// ERROR_TABLE_SIZE 
        } ;

/*------------------------------------------------------------------
 Function Behaviour :: Prints error message, followed by optional
 message and optional function name.

 Oddities/Quirks :: Error codes are defined in cor_error.h
 The constant WARNING_MESSAGE_INDEX must be properly defined.

 -------------------------------------------------------------------*/
void CORAL_error(int err_code, char *msg, char *fn_name)
{
	err_code = -err_code;
	if (err_code >= WARNING_MESSAGE_INDEX)
	  fprintf(exEnv.error_file, "\nCORAL :: Warning --- ");
	else
	  fprintf(exEnv.error_file, "\nCORAL :: Error --- ");
 
	if ((err_code < ERROR_TABLE_SIZE)&&(err_code > -1))
		fprintf(exEnv.error_file, " %s", Error_Table[err_code]);
	if (msg != NULL)
		fprintf(exEnv.error_file, " :%s", msg) ;
	fprintf(exEnv.error_file,"\n");
#ifdef DEBUG
	if (fn_name)
	   fprintf(exEnv.error_file, "Warning/error flagged in function %s()\n",fn_name);
#endif

}
