/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	builtin-rel.C

	Contains built-in relation declarations to implement
	arithemetic built-in relations, and declarations of
	all other builtin relations implemented in user-builtin1.C
	and user-builtin2.C

	IMPORTANT !! To add new builtin relations, make a declaration
	in the function initBuiltins() at the end of this file.

 ***********************************************************************/
#include <stdio.h>
#include <strings.h>
#include "arg.h"
#include "builtin-rel.h"
#include "gennum.h"
#include "unify.h"
#include "hash.h"
#include "builtin-syms.h"
#include "externs.h"
#include "parser.h"
#include "interface.h"
#include "globals.h"
#include "pipelined.h"

extern DatabaseStruct BuiltinDB ;
extern ModuleInfo * CurrModuleInfo;

void InsertBuiltin(Name n, Relation *r)
{
  if (!BuiltinDB.RelationTable)
    BuiltinDB.RelationTable = AllocTab(COR_RELATION_TABLE_INCR, NULL);
  Insert(BuiltinDB.RelationTable, n, r);
}

/***********
 * divesh: virtual int BuiltinRelation::insert has been replaced by
 * virtual int BuiltinRelation::insert_tuple(Tuple *)
***********/

/***********

int BuiltinRelation::insert(ArgList& args, int env_size) 
{
  StackMark stackmark0;
  ArrayBindEnv *env = new ArrayBindEnv (env_size);
  TupleIterator it(this, args, env, NULL, NULL) ;
  it.get_next() ;
  int stat =  !(it.no_match());
  stackmark0.pop_to();
  delete env;
  return stat;
}

************/

int BuiltinRelation::insert_tuple(Tuple *tuple)
{
  ArgList& args = tuple->args();
  int env_size = tuple->env_size;

  StackMark stackmark0;
  ArrayBindEnv *env = new ArrayBindEnv (env_size);
  TupleIterator it(this, args, env, NULL, NULL) ;
  it.get_next() ;
  int stat =  !(it.no_match());
  stackmark0.pop_to();
  delete env;
  //return stat;
  return 0;
}

int BuiltinRelation::insert_new(ArgList &args, BindEnv *env,
		BindEnv *, Tuple *, int )
{
    BindEnv *new_env;
    int env_size;

    if (env==NULL) {
      	env_size = args.max_vars();
      	if (env_size != 0)
            new_env = new ArrayBindEnv(args.max_vars());
	else new_env = NULL;
    }
    else 
      	new_env = env;

    StackMark stackmark0;
    TupleIterator it(this, args, new_env, NULL, NULL) ;
    it.get_next() ;
    int stat =  !(it.no_match());
    stackmark0.pop_to();
    if (new_env && new_env != env) 
        delete new_env;
    return stat;
}

BuiltinRelation::BuiltinRelation(int a, Name n, SolveProc solve_proc)
{
    count = -1;  // NOTE: this is a kludge to easily identify a builtin relation
    single_success = 1;
    _arity = a;
    name = n;
    solver = solve_proc;
    InsertBuiltin(n, this);
}

BuiltinRelation::BuiltinRelation(char *predname, int arity, 
						UserRelProc solver)
{
    add_builtin(predname, arity, solver);
}

BuiltinRelation::BuiltinRelation(char *predname, int arity, 
				                     UserTupleProc solver)
{
    add_builtin(predname, arity, solver);
}

BuiltinUnaryRelation::BuiltinUnaryRelation(int a, Name n, AggProc agg_op)
: BuiltinRelation(a, n, NULL)
{
  op = agg_op;
}

BuiltinBinaryRelation::BuiltinBinaryRelation(int a, Name n, BinaryProc bin_op)
: BuiltinRelation(a, n, NULL)
{
  op = bin_op;
}

BuiltinCompareRelation::BuiltinCompareRelation(int a, Name n, CompareProc c_op)
: BuiltinRelation(a, n, NULL)
{
  op = c_op;
}

void BuiltinRelation::print_name( FILE *outf)
{
  if (arity() >= 0)
    fprintf(outf, "%15s/%d\t : (builtin)\n", SymbolString(name), arity()) ;
  else
    fprintf(outf, "%15s/-\t : (builtin)\n", SymbolString(name), arity()) ;

}

BindEnv * BuiltinRelation::get_next(TupleIterator &iterator)
{
   if (iterator.ipos > 0) 
   { 
     iterator.stack_mark.pop_to();
     iterator.set_no_match();
#ifdef DO_TRACE
     if (exEnv.dbg_get_next) {
       fprintf(exEnv.trace_file, "Builtin Relation: %s - no more answers\n",
	       name->string());
     }
#endif
     return iterator.bindenv;
   }
#ifdef DO_TRACE
   if (exEnv.dbg_get_next) {
     fprintf(exEnv.trace_file, 
	     "Builtin Relation: Starting on %s ( ", name->string());
     iterator.arg_list.print(iterator.bindenv, exEnv.trace_file);
     fprintf(exEnv.trace_file,")\n");
   }
#endif
   iterator.stack_mark.get_mark();
   iterator.ipos++;
   return( solver(*this, iterator) );
}

void BuiltinRelation::release(TupleIterator &)
{
    /* Do nothing.  Subclasses of builtin relation that store structures in
	TupleIterator may redefine this function to release allocated space.
    */
}

/*******************

BindEnv * BuiltinUnaryRelation::get_next(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
		iterator.stack_mark.pop_to();
		iterator.set_no_match(); return env;
	}
	iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 2)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

    Term terms[2];
    for (int i = 0; i < 2; i++) {
      terms[i].expr = iterator.arg_list[i];
      terms[i].bindenv = env;
      FULL_DEREFERENCE_TERM(terms[i]);
    }

    // Arg *rel_arg = terms[0].expr;
    Relation *rel;
    switch (terms[0].kindof()) {
      case COR_RELATION:
			// rel = (Relation*)rel_arg;
			rel = (Relation*)terms[0].expr;
			break;
      case COR_FUNCTOR:
			rel = find_relation(((FuncArg*)terms[0].expr)->_functor,
			   ((FuncArg*)terms[0].expr)->args.count());
			if (rel == NULL) {
	    		CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
				iterator.stack_mark.pop_to();
	    		return NULL ;
			}
			break;
       case COR_SYMBOL_CONST:
                rel = find_relation((Name)terms[0].expr, -1);
            if (rel == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
      default:
			CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
			iterator.stack_mark.pop_to();
			return NULL ;
    }
    Term result_term;
    result_term.expr = (Arg*)(*op)(rel);
    result_term.bindenv = NULL;

    if (result_term.expr == NULL) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
      return env;
    }

    if ( ! unify_args (result_term, terms[1])) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
    }

    return(env);
}


BindEnv * BuiltinBinaryRelation::get_next(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) { 
      iterator.stack_mark.pop_to();
      iterator.set_no_match(); 
      return env;
    }
    iterator.ipos++;
    iterator.stack_mark.get_mark();

    Term terms[3];
    for (int i = 0; i < 3; i++) {
	terms[i].expr = iterator.arg_list[i], terms[i].bindenv = env;
	FULL_DEREFERENCE_TERM(terms[i]);
    }
    
#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file, "BuiltinRelation:"); 
	terms[2].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, " = %s (", SymbolString(name));
	terms[0].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ",");
	terms[1].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ")\n");
    }
#endif

    // Specialized for numeric binary operations 
    // WARNING: These operators work only one way currently. There should 
    //	be different operators called depending on the binding pattern.
    
    if ( terms[0].kindof() != COR_NUM_CONST || terms[1].kindof() != COR_NUM_CONST) {
	CORAL_error(COR_NON_NUMERIC_ARGS, NULL, "get_next");
	fprintf(exEnv.error_file,"(");
	terms[0].printon(exEnv.error_file);
	fprintf(exEnv.error_file,",");
	terms[1].printon(exEnv.error_file);
	fprintf(exEnv.error_file,")\n");
	iterator.set_no_match();
	iterator.stack_mark.pop_to();
	return env;
    }

    Term result_term;
    result_term.expr = (Arg*)(*op)(terms[0].expr, terms[1].expr);
    result_term.bindenv = NULL;
    if (result_term.expr == NULL) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
      return env;
    }
    
    if (! unify_args (result_term, terms[2])) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
      return env;
    }

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,"Result = "); 
	terms[2].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, "\n");
    }
#endif

    return env;
}

BindEnv * BuiltinCompareRelation::get_next(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
		iterator.stack_mark.pop_to();
		iterator.set_no_match(); return env; 
    }
    iterator.ipos++;
	iterator.stack_mark.get_mark();

    Term terms[2];
    for (int i = 0; i < 2; i++) {
	terms[i].expr = iterator.arg_list[i], terms[i].bindenv = env;
	FULL_DEREFERENCE_TERM(terms[i]);
    }
    
    if ( ! (*op)(terms[0], terms[1]))
		iterator.set_no_match();
	if (iterator.no_match())
		iterator.stack_mark.pop_to();
    return (env);
}
*************/

static Term static_terms[3];
static Term usable_terms[10];

BindEnv * BuiltinUnaryRelation::get_next(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
		iterator.stack_mark.pop_to();
		iterator.set_no_match(); return env;
	}
	iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 2)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

   // Term terms[2];
    for (int i = 0; i < 2; i++) {
      static_terms[i].expr = iterator.arg_list[i];
      static_terms[i].bindenv = env;
      FULL_DEREFERENCE_TERM(static_terms[i]);
    }

    Relation *rel;
    switch (static_terms[0].kindof()) {
      case COR_RELATION:
			rel = (Relation*)static_terms[0].expr;
			break;
      case COR_FUNCTOR:
			rel = find_relation(((FuncArg*)static_terms[0].expr)->_functor,
			   ((FuncArg*)static_terms[0].expr)->args.count());
			if (rel == NULL) {
	    		CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
				iterator.stack_mark.pop_to();
	    		return NULL ;
			}
			break;
       case COR_SYMBOL_CONST:
                rel = find_relation((Name)static_terms[0].expr, -1);
            if (rel == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
      default:
			CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
			iterator.stack_mark.pop_to();
			return NULL ;
    }

    //Term result_term;
    usable_terms[0].expr = (Arg*)(*op)(rel);
    usable_terms[0].bindenv = NULL;

    if (usable_terms[0].expr == NULL) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
      return env;
    }

    if ( ! unify_args (usable_terms[0], static_terms[1])) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
    }

    return(env);
}


BindEnv * BuiltinBinaryRelation::get_next(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) { 
      iterator.stack_mark.pop_to();
      iterator.set_no_match(); 
      return env;
    }
    iterator.ipos++;
    iterator.stack_mark.get_mark();

    // Term terms[3];
    for (int i = 0; i < 3; i++) {
	static_terms[i].expr = iterator.arg_list[i], static_terms[i].bindenv = env;
	FULL_DEREFERENCE_TERM(static_terms[i]);
    }
    
#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file, "BuiltinRelation:"); 
	static_terms[2].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, " = %s (", SymbolString(name));
	static_terms[0].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ",");
	static_terms[1].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, ")\n");
    }
#endif

    /* Specialized for numeric binary operations */
    /* WARNING: These operators work only one way currently. There should 
	be different operators called depending on the binding pattern.
     */
    if ( static_terms[0].kindof() != COR_NUM_CONST || static_terms[1].kindof() != COR_NUM_CONST) {
	CORAL_error(COR_NON_NUMERIC_ARGS, NULL, "get_next");
	fprintf(exEnv.error_file,"(");
	static_terms[0].printon(exEnv.error_file);
	fprintf(exEnv.error_file,",");
	static_terms[1].printon(exEnv.error_file);
	fprintf(exEnv.error_file,")\n");
	iterator.set_no_match();
	iterator.stack_mark.pop_to();
	return env;
    }

    //Term result_term;
    usable_terms[0].expr = (Arg*)(*op)(static_terms[0].expr, static_terms[1].expr);
    usable_terms[0].bindenv = NULL;
    if (usable_terms[0].expr == NULL) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
      return env;
    }
    
    if (! unify_args (usable_terms[0], static_terms[2])) {
      iterator.set_no_match();
      iterator.stack_mark.pop_to();
      return env;
    }

#ifdef DO_TRACE
    if (exEnv.dbg_get_next) {
	fprintf(exEnv.trace_file,"Result = "); 
	static_terms[2].printon(exEnv.trace_file);
	fprintf(exEnv.trace_file, "\n");
    }
#endif

    return env;
}

BindEnv * BuiltinCompareRelation::get_next(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
		iterator.stack_mark.pop_to();
		iterator.set_no_match(); return env; 
    }
    iterator.ipos++;
	iterator.stack_mark.get_mark();

    //Term terms[2];
    for (int i = 0; i < 2; i++) {
	static_terms[i].expr = iterator.arg_list[i], static_terms[i].bindenv = env;
	FULL_DEREFERENCE_TERM(static_terms[i]);
    }
    
    if ( ! (*op)(static_terms[0], static_terms[1]))
		iterator.set_no_match();
	if (iterator.no_match())
		iterator.stack_mark.pop_to();
    return (env);
}

Tuple * FuncOp(Tuple * query)
{

 if (query->arity() != 3)
  {
    fprintf(exEnv.error_file, "Three arguments required for Functor.\n");
    return NULL;
  }
 Arg * arg0 = (query->args())[0];
 Arg * arg1 = (query->args())[1];
 Arg * arg2 = (query->args())[2];

 if ( (arg0->kindof() != COR_VARIABLE) && (arg0->kindof() != COR_FUNCTOR)
      && (arg0->kindof() != COR_SYMBOL_CONST) )
    {
      fprintf(exEnv.error_file, "First argument should be a variable or functor\n");
      return NULL;
    }
 else if ((arg0->kindof() == COR_FUNCTOR)
          || (arg0->kindof() == COR_SYMBOL_CONST))
    {
    Name func_name;
    Arg * num;
      if (arg0->kindof() == COR_SYMBOL_CONST)
        {
            // char * _name = ((Name)arg0)->string();
            // func_name = AllocSymbol(_name, -1);
			func_name = (Name)arg0;
            num = new FixInt(0);
        }
      else
        {
            // func_name = AllocSymbol(functor_name(arg0), -1);
			func_name = ((FuncArg *) arg0)->functor();
            ArgList * func_list = functor_args(arg0);
            num = new FixInt(func_list->arity());
        }
      ArgList * alist = ArgList::New(3);
      (*alist)[0] = arg0;
      (*alist)[1] = func_name;
      (*alist)[2] = num;

      Tuple * result = new Tuple(alist);
      return result;
    }
 else if ((arg0->kindof() == COR_VARIABLE)
            && (arg1->kindof() == COR_SYMBOL_CONST)
              && (arg2->kindof() == COR_NUM_CONST))
    {
      if (!is_int(arg2))
       {
          fprintf(exEnv.error_file, "Third argument should be of integer type.\n");
          return NULL;
        }

//      FuncArg * new_arg =
//    FuncArg::New(AllocSymbol(((Name)arg1)->string(), -1), make_int(arg2));

      FuncArg * new_arg =
          FuncArg::New((Name)arg1, make_int(arg2));
      int i;
      int index = make_int(arg2);
      for (i = 0;i < index; i++)
        new_arg->args[i] = make_arg(i);
   
      ArgList * alist = ArgList::New(3);
      (*alist)[0] = new_arg;
      (*alist)[1] = arg1;
      (*alist)[2] = arg2;

      Tuple * result = new Tuple(alist);
      result->bindenv = new ArrayBindEnv(index, -1);
      return result;
    }

 fprintf(exEnv.error_file, "Wrong argument types supplied to Functor\n");
 return NULL;

 }

Tuple * ArgOp(Tuple * query)
{

 if (query->arity() != 3)
  {
    fprintf(exEnv.error_file, "Three arguments required for Arg.\n");
    return NULL;
  }
 Arg * arg0 = (query->args())[0];
 Arg * arg1 = (query->args())[1];
 Arg * arg2 = (query->args())[2];

  if ((arg0->kindof() == COR_NUM_CONST)
          && (arg1->kindof() == COR_FUNCTOR))
    {
      if (! is_int(arg0))
       {
        fprintf(exEnv.error_file, "First argument should be of integer type.\n");
        return NULL;
       }
      ArgList * func_list = functor_args(arg1);
      int num = make_int(arg0);
      if (num > func_list->arity())
       {
        fprintf(exEnv.error_file, "Not enough arguments in arg.\n");
        return NULL;
       }
      Arg * new_arg = func_list->arg(num-1);
      ArgList * alist = make_arglist3(arg0, arg1, new_arg);

      Tuple * result = new Tuple(alist);
      result->bindenv = query->bindenv;
      return result;
    }

 fprintf(exEnv.error_file, "Wrong argument types supplied to Arg\n");
 return NULL;

 }

#undef FAIL_RETURN
#define FAIL_RETURN  {iterator.set_no_match(); return NULL;} 

BindEnv * UnivSolver(BuiltinRelation& , TupleIterator& iterator)
{
  if (iterator.arg_list.count() != 2)
    {
      fprintf(exEnv.error_file, "Two arguments required for Univ.\n");
      FAIL_RETURN ;
    }
  
  Term term1 (iterator.arg_list[0], iterator.bindenv);
  FULL_DEREFERENCE_TERM(term1);

  Term term2 (iterator.arg_list[1], iterator.bindenv);
  FULL_DEREFERENCE_TERM(term2);

  if (term1.expr->kindof() == COR_VARIABLE)
    {
      //if (term2.expr->kindof() != COR_FUNCTOR)
      if (!is_list(term2.expr))
	{
	  fprintf(exEnv.error_file, "Second argument must be a list\n");
	  FAIL_RETURN;
	}
      
      Term first_arg_term(make_car(term2.expr), iterator.bindenv);
      FULL_DEREFERENCE_TERM(first_arg_term);

      if (first_arg_term.expr->kindof() != COR_SYMBOL_CONST)
	{
	  fprintf(exEnv.error_file,
		  "First element of list must be functor name\n");
	  FAIL_RETURN ;
	}
      
      Term rest_arg_term(make_cdr(term2.expr), iterator.bindenv);
      FULL_DEREFERENCE_TERM(rest_arg_term);

      if (((FuncArg *)(rest_arg_term.expr))->functor() == ConsSymbol)
	{
	  ArgList * arg_list;
	  ArgList * temp_list = ArgList::New(1);
	  Term  temp_term;
	  temp_term.expr = make_car(rest_arg_term.expr);
	  temp_term.bindenv = iterator.bindenv;
	  FULL_DEREFERENCE_TERM(temp_term);
	  arg_list = ArgList::New(1);
	  (*arg_list)[0] = temp_term.expr;
	  int count = 1;
	  for (;;)
	    {
	      rest_arg_term.expr = make_cdr(rest_arg_term.expr);
	      rest_arg_term.bindenv = iterator.bindenv;
	      FULL_DEREFERENCE_TERM(rest_arg_term);

	      if (((FuncArg *)(rest_arg_term.expr))->functor() == ConsSymbol)
		{
		  temp_term.expr = make_car(rest_arg_term.expr);
		  temp_term.bindenv = iterator.bindenv;
		  FULL_DEREFERENCE_TERM(temp_term);
		  (* temp_list)[0] = temp_term.expr;
		  arg_list = concat_arglists(arg_list, temp_list);
		  count++;
		}
	      else if ((Arg *)(rest_arg_term.expr) == NilArg)
		break;
	      else
		{
		  fprintf(exEnv.error_file, "Error in  list argument.\n");
		  return NULL;
		}
	    }
	  
	  FuncArg *fun_arg = FuncArg::New((Name)(first_arg_term.expr), count);
	  int i;
	  
	  for (i = 0; i < count; i++)
	    (fun_arg->args)[i] = (*arg_list)[i];
	  
	  Term new_term(fun_arg, iterator.bindenv);
	  StackMark stackmark;
	  if (!unify_args(term1, new_term)) {
	    stackmark.pop_to();
	    FAIL_RETURN;
	  }
	  return iterator.bindenv;
	}
      else if ((Arg *)(rest_arg_term.expr) == NilArg)
	{
	  FuncArg * fun_arg = FuncArg::New((Name)(first_arg_term.expr), 0);

	  Term new_term(fun_arg, iterator.bindenv);
	  StackMark stackmark;
	  if (!unify_args(term1, new_term)) {
	    stackmark.pop_to();
	    FAIL_RETURN;
	  }
	  return iterator.bindenv;
	}
      else
	{
	  fprintf(exEnv.error_file, "List type needed as second argument.\n");
	  FAIL_RETURN;
	}
    }
  
  if (term1.expr->kindof() != COR_FUNCTOR)
    {
      fprintf(exEnv.error_file, "First argument must be a functor\n");
      FAIL_RETURN;
    }

  int num = ((FuncArg *)term1.expr)->arity();
  Arg * name_arg = make_arg(functor_name(term1.expr));
  if (num == 0)
    {
      //make list with just the name 
      Arg * arg_list = make_cons(name_arg, NilSymbol);

      Term new_term(arg_list, iterator.bindenv);
      StackMark stackmark;
      if (!unify_args(term2, new_term)) {
	stackmark.pop_to();
	FAIL_RETURN;
      }
      return iterator.bindenv;
    }

  // else forming the list 

  Arg  * arg_list = make_cons(((FuncArg *)term1.expr)->args[num-1], NilSymbol);
  int i;
  for (i = (num-2); i >= 0; i--)
    arg_list = make_cons( ((FuncArg *)term1.expr)->args[i], arg_list );
  
  arg_list = make_cons(name_arg, arg_list);
  
  Term new_term(arg_list, iterator.bindenv);
  StackMark stackmark;
  if (!unify_args(term2, new_term)) {
    stackmark.pop_to();
    FAIL_RETURN;
  }
  return iterator.bindenv;
}

BindEnv * CallSolver(TupleIterator& iterator)
{
	BindEnv *env = iterator.bindenv;

	Relation  *rel;
	TupleIterator *iter;

	if (iterator.ipos++ == 0)
	  {
		iterator.stack_mark.get_mark();
		int num = iterator.arg_list.arity();
		if (num != 1)
		  {
			fprintf(exEnv.error_file, "Call takes only one argument.\n");
			iterator.set_no_match();
			//return iterator.bindenv;
			return NULL;
		  }
		Term term(iterator.arg_list[0], env);
		FULL_DEREFERENCE_TERM(term);

		/* Is this necessary ?? PRAVEEN

		  if ( term.expr->kindof() == COR_VARIABLE )
		  term = env->lookup(((VarArg *)term.expr)->var);
		  */

		if ( term.expr->kindof() != COR_FUNCTOR )
		  {
			fprintf(exEnv.error_file, "Wrong type of argument supplied to call.\n");
			iterator.set_no_match();
			//return iterator.bindenv;
			return NULL;
		  }
		FuncArg * rel_name = (FuncArg *)term.expr;
		rel = find_relation(rel_name->functor(), rel_name->arity());
		if (!rel)
		  {
			fprintf(exEnv.error_file,"Relation %s with arity %d not found.\n",
				(rel_name->functor())->string(), rel_name->arity());
			iterator.set_no_match();
			//return iterator.bindenv;
			return NULL;
		  }
	
		/* check arity as find_relation does not */
		if ((rel->arity() > 0) && 
		    (rel->arity() != rel_name->arity()))
		  {
		    fprintf(exEnv.error_file,"Relation arity does not match.\n");
		    iterator.set_no_match();
		    // return iterator.bindenv;
		    return NULL;
		  }


        iter = new TupleIterator(rel, rel_name->args, env);
        iterator.answer_iterator = iter;
        }
    else
        {
            iterator.stack_mark.pop_to();
            iter = iterator.answer_iterator;
            rel = iter->relation;
        }

    BindEnv * result = iter->get_next();
    if (iter->no_match())
      {
        iterator.set_no_match();
        return NULL;
      }
    else
      {
        iterator.reset_no_match();
        return result;
      }

}


const Arg * AddOp(const Arg *arg0, const Arg* arg1)
{
    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
	return NULL;
    return num0->add(*num1);
}

const Arg * SubOp(const Arg *arg0, const Arg* arg1)
{
    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
	return NULL;
    return num0->sub(*num1);
}

const Arg * MulOp(const Arg *arg0, const Arg* arg1)
{
    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
	return NULL;
    return num0->mul(*num1);
}

const Arg * DivOp(const Arg *arg0, const Arg* arg1)
{
    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
	return NULL;
    return num0->div(*num1);
}

const Arg * SumOp(Relation * rel)
{
    Arg * total = make_arg(0);
    StackMark stack_mark0;
    ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
    ArgList * args = make_vararglist(rel->arity());
    TupleIterator * iter = new TupleIterator(rel, *args, env0);
    for(;;) {
    Tuple * ret_tuple = iter->get_next_tuple();

    if (iter->no_match())
        break;

    if   ((ret_tuple->arity() != 1)
      || ( (ret_tuple->arg(0))->kindof() != COR_NUM_CONST)  )
        {
fprintf(exEnv.error_file, "Error: Sum: Set must contain numeric constants as elements.\n")
;
          return NULL;
        }

    const Numeric *num0 = total->numeric() ;
    const Numeric *num1 = (ret_tuple->arg(0))->numeric();
    if (num0 == NULL || num1 == NULL)
        {
fprintf(exEnv.error_file, "Error: Sum: Set must contain numeric constants as elements.\n")
;
            return NULL;
         }

    total = (Arg*)num0->add(*num1);
    }
    stack_mark0.pop_to();
    return total;

}

const Arg * ProdOp(Relation * rel)
{
    Arg * total = make_arg(1);
    StackMark stack_mark0;
    ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
    ArgList * args = make_vararglist(rel->arity());
    TupleIterator * iter = new TupleIterator(rel, *args, env0);
    for(;;) {
    Tuple * ret_tuple = iter->get_next_tuple();

    if (iter->no_match())
        break;

    if   ((ret_tuple->arity() != 1)
      || ( (ret_tuple->arg(0))->kindof() != COR_NUM_CONST)  )
        {
fprintf(exEnv.error_file, "Error: Prod: Set must contain numeric constants as elements.\n")
;
          return NULL;
        }

    const Numeric *num0 = total->numeric() ;
    const Numeric *num1 = (ret_tuple->arg(0))->numeric();
    if (num0 == NULL || num1 == NULL)
        {
fprintf(exEnv.error_file, "Error: Prod: Set must contain numeric constants as elements.\n")
;
            return NULL;
         }

    total = (Arg*)num0->mul(*num1);
    }
    stack_mark0.pop_to();
    return total;

}
const Arg * CountOp(Relation * rel)
{
/*
  int total = 0 ;
  StackMark stack_mark0;
  ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
  ArgList * args = make_vararglist(rel->arity());
  TupleIterator * iter = new TupleIterator(rel, *args, env0);

  for(;;)
  {
    BindEnv *env1 = iter->get_next();
    if (iter->no_match()) break;
    total = total + 1 ;
  }
  stack_mark0.pop_to();
  return MakeFixInt(total);
*/
  return MakeFixInt(rel->count);
}

int LssOp(Term&, Term&);
const Arg * MinOp(Relation * rel)
{
    int first_tuple_flag = 1;
    Tuple * ret_tuple;
    Arg * min;
    StackMark stack_mark0;
    ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
    ArgList * args = make_vararglist(rel->arity());
    TupleIterator * iter = new TupleIterator(rel, *args, env0);
    for(;;) {
    if (first_tuple_flag)
       {
            ret_tuple = iter->get_next_tuple();
            if (iter->no_match())
              {
                fprintf(exEnv.error_file, "Error: Min: No elements in the set.\n");
                return NULL;
              }
            min = ret_tuple->arg(0);
            first_tuple_flag = 0;
        }
     else
        ret_tuple = iter->get_next_tuple();

    if (iter->no_match())
        break;

    if  ( (ret_tuple->arity() != 1)
      || ( (ret_tuple->arg(0))->kindof() != COR_NUM_CONST)  )
        {
fprintf(exEnv.error_file, "Error: Min: Set must contain numeric constants as elements.\n");
          return NULL;
        }

    if (!first_tuple_flag)
     {
        Term *num0 = new Term(min) ;
        Term *num1 = new Term(ret_tuple->arg(0));
        if (!LssOp(*num0, *num1))
            min = ret_tuple->arg(0);
      }
   }
    stack_mark0.pop_to();
    return min;
}

int GrtOp(Term&, Term&);
const Arg * MaxOp(Relation * rel)
{
    int first_tuple_flag = 1;
    Tuple * ret_tuple;
    Arg * max;
    StackMark stack_mark0;
    ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
    ArgList * args = make_vararglist(rel->arity());
    TupleIterator * iter = new TupleIterator(rel, *args, env0);
    for(;;) {
    if (first_tuple_flag)
       {
            ret_tuple = iter->get_next_tuple();
            if (iter->no_match())
              {
                fprintf(exEnv.error_file, "Error: Max: No elements in the set.\n");
                return NULL;
              }
            max = ret_tuple->arg(0);
            first_tuple_flag = 0;
        }
     else
        ret_tuple = iter->get_next_tuple();

    if (iter->no_match())
        break;

    if ( (ret_tuple->arity() != 1)
      || ( (ret_tuple->arg(0))->kindof() != COR_NUM_CONST)  )
        {
fprintf(exEnv.error_file, "Error: Max: Set must contain numeric constants as elements.\n");
          return NULL;
        }

    if (!first_tuple_flag)
     {
        Term *num0 = new Term(max) ;
        Term *num1 = new Term(ret_tuple->arg(0));
        if (!GrtOp(*num0, *num1))
            max = ret_tuple->arg(0);
      }
   }
    stack_mark0.pop_to();
    return max;
}

const Arg * AvgOp(Relation * rel)
{
    Arg * total = make_arg(0);
    int num = 0;
    StackMark stack_mark0;
    ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
    ArgList * args = make_vararglist(rel->arity());
    TupleIterator * iter = new TupleIterator(rel, *args, env0);
    for(;;) {
    Tuple * ret_tuple = iter->get_next_tuple();

    if (iter->no_match())
        break;

    if   ((ret_tuple->arity() != 1)
      || ( (ret_tuple->arg(0))->kindof() != COR_NUM_CONST)  )
        {
fprintf(exEnv.error_file, "Error: Avg: Set must contain numeric constants as elements.\n");
          return NULL;
        }

    const Numeric *num0 = total->numeric() ;
    const Numeric *num1 = (ret_tuple->arg(0))->numeric();
    if (num0 == NULL || num1 == NULL)
        {
fprintf(exEnv.error_file, "Error: Avg: Set must contain numeric constants as elements.\n");
            return NULL;
         }

    total = (Arg*)num0->add(*num1);
    num++;
    }
    stack_mark0.pop_to();
    if (num > 0)
     {
        const Numeric *sum = total->numeric();
        const Numeric *divisor = (make_arg(num))->numeric();
        total = (Arg*)sum->div(*divisor);
     }
    return total;
}


/******************* JOSEPH ***************/

int EquOp(Term& term0, Term& term1)
{
    return unify_args(term0, term1);
}

int NeqOp(Term& term0, Term& term1)
{
    return !unify_args(term0, term1);
}

int CompareNumeric(Term& term0, Term& term1, char *name)
{
     const Numeric *num0 = term0.expr->numeric();
     const Numeric *num1 = term1.expr->numeric();
     if (num0 == NULL || num1 == NULL) {
	 CORAL_error(COR_NON_NUMERIC_COMP, NULL, "CompareNumeric") ;
	 term0.printon(exEnv.error_file);
	 fprintf(exEnv.error_file, " %s ", name);
	 term1.printon(exEnv.error_file);
	 fprintf(exEnv.error_file, "!\n");
	 abort();
     }
     return num0->compare(*num1);
}

int LssOp(Term& term0, Term& term1)
{
     return CompareNumeric(term0, term1, "<") < 0;
}

int GrtOp(Term& term0, Term& term1)
{
     return CompareNumeric(term0, term1, ">") > 0;
}

int LeqOp(Term& term0, Term& term1)
{
     return CompareNumeric(term0, term1, "<=") <= 0;
}

int GeqOp(Term& term0, Term& term1)
{
     return CompareNumeric(term0, term1, ">=") >= 0;
}

BuiltinSetRelation::BuiltinSetRelation(int a, Name n, SetProc set_proc)
: BuiltinRelation(a, n, NULL)
{
  op = set_proc;
  single_success = 0;  
}
BindEnv * BuiltinSetRelation::get_next(TupleIterator& iterator)
{
   return( op(iterator) );
}


BindEnv * MemberSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;

    Relation *rel;
    ArgList *args;
    TupleIterator *iter;
    if (iterator.ipos++ == 0)
       {
        iterator.stack_mark.get_mark();
        int num = iterator.arg_list.arity() - 1;

        args = ArgList::New(num);

        Term term(iterator.arg_list[0], env);
        FULL_DEREFERENCE_TERM(term);
        if ( term.expr->kindof() == COR_FUNCTOR )
          {
            FuncArg * rel_name = (FuncArg *)term.expr;
            rel = find_relation(rel_name->functor(), rel_name->arity());

            if (!rel)
              {
                fprintf(exEnv.error_file,"Relation %s with arity %d not found.\n",
                    (rel_name->functor())->string(), rel_name->arity());
                iterator.set_no_match();
                return iterator.bindenv;
               }
          }
        else if ( term.expr->kindof() == COR_SYMBOL_CONST )
           {
                rel = find_relation((Name)term.expr, -1);

                if (!rel)
                  {
                    fprintf(exEnv.error_file,"Relation %s not found.\n", ((Name)term.expr)
->string());
                    iterator.set_no_match();
                    return iterator.bindenv;
                   }
            }
        else if ( term.expr->kindof() == COR_RELATION )
            rel = (Relation *)term.expr;
        else
          {
            fprintf(exEnv.error_file,
		    "Wrong 1st argument provided to Member: %s\n",
		    SymbolString(term.expr));
	    
            iterator.set_no_match();
            return iterator.bindenv;
          }

        if ((rel->arity() > 0) && (rel->arity() != num))
          {
            fprintf(exEnv.error_file,"Relation arity does not match.\n");
            iterator.set_no_match();
            return iterator.bindenv;
           }

        for (int i = 1; i <= num; i++)
            (*args)[i-1] = iterator.arg_list[i];

        iter = new TupleIterator(rel, *args, env);
        iterator.answer_iterator = iter;
        }
    else
        {
            iterator.stack_mark.pop_to();
            iter = iterator.answer_iterator;
            rel = iter->relation;
        }



    BindEnv * result = iter->get_next();
    if (iter->no_match())
      {
        iterator.set_no_match();
        return NULL;
      }
    else
      {
        iterator.reset_no_match();
        return result;
      }

}

BindEnv * MemTupleSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;

    Relation *rel;
    TupleIterator *iter;
    if (iterator.ipos++ == 0)
       {
        iterator.stack_mark.get_mark();
        int num = iterator.arg_list.arity() - 1;

        Term term(iterator.arg_list[0], env);
        FULL_DEREFERENCE_TERM(term);
        if ( term.expr->kindof() == COR_FUNCTOR )
          {
            FuncArg * rel_name = (FuncArg *)term.expr;
            rel = find_relation(rel_name->functor(), rel_name->arity());

            if (!rel)
              {
                fprintf(exEnv.error_file,"Relation %s with arity %d not found.\n",
                    (rel_name->functor())->string(), rel_name->arity());
                iterator.set_no_match();
                return iterator.bindenv;
               }
          }
        else if ( term.expr->kindof() == COR_SYMBOL_CONST )
           {
                rel = find_relation((Name)term.expr, -1);

                if (!rel)
                  {
                    fprintf(exEnv.error_file,"Relation %s not found.\n",
                        ((Name)term.expr)->string());
                    iterator.set_no_match();
                    return iterator.bindenv;
                   }
            }
        else if ( term.expr->kindof() == COR_RELATION )
            rel = (Relation *)term.expr;
        else
          {
            fprintf(exEnv.error_file, "Wrong first argument provided to MemTuple.\n");
            iterator.set_no_match();
            return iterator.bindenv;
          }
        ArgList * args = make_vararglist(rel->arity());
        ArrayBindEnv *env0 = new ArrayBindEnv (rel->arity());
        iter = new TupleIterator(rel, *args, env0);
        iter->stack_mark.get_mark();
        iterator.answer_iterator = iter;
        }
    else
        {
            iterator.stack_mark.pop_to();
            /* iter->stack_mark.pop_to(); */
            /* delete iter->bindenv; */
            iter = iterator.answer_iterator;
            rel = iter->relation;
        }

    for (;;)
     {
        Tuple * ret_tuple = iter->get_next_tuple();
        if (iter->no_match())
          {
            iterator.set_no_match();
            return NULL;
          }
        FuncArg * func = (FuncArg *)make_arg("", ret_tuple->_args);

        Term lterm(iterator.arg_list[1], env);
        Term rterm(func, iter->bindenv);
        if (unify_args(lterm, rterm))
          {
            iterator.reset_no_match();
            return iterator.bindenv;
          }
    }

}

BindEnv * MultiUnionSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
        iterator.stack_mark.pop_to();
        iterator.set_no_match(); return env;
    }
    iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 3)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

    Term terms[3];
    for (int i = 0; i < 3; i++) {
    terms[i].expr = iterator.arg_list[i];
    terms[i].bindenv = env;
    FULL_DEREFERENCE_TERM(terms[i]);
      }

    Relation *rels[2];
    for (i = 0; i < 2; i++)
    {
      switch (terms[i].kindof())
       {
        case COR_RELATION:
            rels[i] = (Relation*)terms[i].expr;
            break;
        case COR_FUNCTOR:
            rels[i] = find_relation(((FuncArg*)terms[i].expr)->_functor,
               ((FuncArg*)terms[i].expr)->args.count());
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        case COR_SYMBOL_CONST:
            rels[i] = find_relation((Name)terms[i].expr, -1);
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        default:
            CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
            iterator.stack_mark.pop_to();
            return NULL ;
        }
    }
    StackMark stack_mark0;

    ArrayBindEnv * env0 = new ArrayBindEnv(rels[0]->arity());
    ArgList * args0 = make_vararglist(rels[0]->arity());
    ArrayBindEnv * env1 = new ArrayBindEnv(rels[1]->arity());
    ArgList * args1 = make_vararglist(rels[1]->arity());
    ArrayBindEnv * env2 = new ArrayBindEnv(rels[1]->arity());
    ArgList * args2 = make_vararglist(rels[1]->arity());
    ArrayBindEnv * env3 = new ArrayBindEnv(rels[1]->arity());
    ArgList * args3 = make_vararglist(rels[1]->arity());

    if (rels[0]->arity() != rels[1]->arity())
      {
        fprintf(exEnv.error_file,"Error: Union: Both sets must have equal arity\n");
        iterator.stack_mark.pop_to();
        return NULL;
      }

    Relation  *union_rel = new HashSimpleRelation(rels[0]->arity());
    
	TupleIterator * iter0 = new TupleIterator(rels[0], *args0, env0);
	TupleIterator * iter1 = new TupleIterator(rels[1], *args1, env1);
	TupleIterator * iter2 = new TupleIterator(rels[1], *args2, env2);
	TupleIterator * iter3 = new TupleIterator(union_rel, *args3, env3);

    Tuple *ret_tuple;
    for(;;)
     {
        ret_tuple = iter0->get_next_tuple();
        if (iter0->no_match())
           break;

       if (!union_rel->insert(ret_tuple))
        {
            fprintf(exEnv.error_file,"Error: Union: Cannot build union.\n");
            iterator.stack_mark.pop_to();
            return NULL;
        }
      }
	
	/* second relation */
    Tuple *ret_tuple2;
	int _arity = rels[1]->arity();
    for (;;)
     {
        ret_tuple = iter1->get_next_tuple();
        if (iter1->no_match())
           break;

		/* if there is a match find out how many copies there are */
		StackMark stack_mark2;
		iter2->reset();
		for ( int i = 0; i < _arity; i++)
		  (iter2->arg_list)[i] = ret_tuple->arg(i);
		int rel2_count = 0;
		/* looping through the second relation */
		for (;;)
		 {
			ret_tuple2 = iter2->get_next_tuple();
			if (iter2->no_match())
			 {
           		stack_mark2.pop_to();
			  	iter2->release();
				break;
			 }
			rel2_count++;
		  }

		 /* find out how many copies are there in the union */
		 StackMark stack_mark3;
		 iter3->reset();
		 for ( i = 0; i < _arity; i++)
			(iter3->arg_list)[i] = ret_tuple->arg(i);
		 int union_count = 0;
		 /* loop through the union */
		 for (;;)
		   {
			ret_tuple2 = iter3->get_next_tuple();
			if (iter3->no_match())
			 {
			   stack_mark3.pop_to();      
		  	   iter3->release();
			   break;
		 	  }
			union_count++;
		   }
	
	   /* insert number of extra copies in union */
	   for (i = 0; i < (rel2_count - union_count); i++)	
        if (!union_rel->insert(ret_tuple))
         {
            fprintf(exEnv.error_file,"Error: Union: Cannot build union.\n");
            iterator.stack_mark.pop_to();
            return NULL;
          }
    }


    stack_mark0.pop_to();
    Term result_term;
    result_term.expr = union_rel;
    result_term.bindenv = NULL;
    if ( ! unify_args (result_term, terms[2]))
      iterator.set_no_match();

    if (iterator.no_match())
        iterator.stack_mark.pop_to();
    return(env);

}

BindEnv * UnionSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
        iterator.stack_mark.pop_to();
        iterator.set_no_match(); return env;
    }
    iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 3)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

    Term terms[3];
    for (int i = 0; i < 3; i++) {
    terms[i].expr = iterator.arg_list[i];
    terms[i].bindenv = env;
    FULL_DEREFERENCE_TERM(terms[i]);
      }

    Relation *rels[2];
    for (i = 0; i < 2; i++)
    {
      switch (terms[i].kindof())
       {
        case COR_RELATION:
            rels[i] = (Relation*)terms[i].expr;
            break;
        case COR_FUNCTOR:
            rels[i] = find_relation(((FuncArg*)terms[i].expr)->_functor,
               ((FuncArg*)terms[i].expr)->args.count());
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        case COR_SYMBOL_CONST:
            rels[i] = find_relation((Name)terms[i].expr, -1);
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        default:
            CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
            iterator.stack_mark.pop_to();
            return NULL ;
        }
    }
    StackMark stack_mark0;

    ArrayBindEnv * env0 = new ArrayBindEnv(rels[0]->arity());
    ArgList * args0 = make_vararglist(rels[0]->arity());
    TupleIterator * iter0 = new TupleIterator(rels[0], *args0, env0);

    ArrayBindEnv * env1 = new ArrayBindEnv(rels[1]->arity());
    ArgList * args1 = make_vararglist(rels[1]->arity());
	TupleIterator * iter1 = new TupleIterator(rels[1], *args1, env1);

    if (rels[0]->arity() != rels[1]->arity())
      {
        fprintf(exEnv.error_file,"Error: Union: Both sets must have equal arity\n");
        iterator.stack_mark.pop_to();
        return NULL;
      }

    Relation  *union_rel = new HashSimpleRelation(rels[0]->arity());

    Tuple *ret_tuple;
    for(;;)
     {
        ret_tuple = iter0->get_next_tuple();
        if (iter0->no_match())
           break;

       if (!union_rel->insert(ret_tuple))
        {
            fprintf(exEnv.error_file,"Error: Union: Cannot build union.\n");
            iterator.stack_mark.pop_to();
            return NULL;
        }
      }

    for (;;)
     {
        ret_tuple = iter1->get_next_tuple();
        if (iter1->no_match())
           break;

       if (!union_rel->insert(ret_tuple))
        {
            fprintf(exEnv.error_file,"Error: Union: Cannot build union.\n");
            iterator.stack_mark.pop_to();
            return NULL;
        }
      }


    stack_mark0.pop_to();
    Term result_term;
    result_term.expr = union_rel;
    result_term.bindenv = NULL;
    if ( ! unify_args (result_term, terms[2]))
      iterator.set_no_match();

    if (iterator.no_match())
        iterator.stack_mark.pop_to();
    return(env);

}

BindEnv * IntersectionSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
        iterator.stack_mark.pop_to();
        iterator.set_no_match(); return env;
    }
    iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 3)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

    Term terms[3];
    for (int i = 0; i < 3; i++) {
    terms[i].expr = iterator.arg_list[i];
    terms[i].bindenv = env;
    FULL_DEREFERENCE_TERM(terms[i]);
      }

    Relation *rels[2];
    for (i = 0; i < 2; i++)
    {
      switch (terms[i].kindof())
       {
        case COR_RELATION:
            rels[i] = (Relation*)terms[i].expr;
            break;
        case COR_FUNCTOR:
            rels[i] = find_relation(((FuncArg*)terms[i].expr)->_functor,
               ((FuncArg*)terms[i].expr)->args.count());
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        case COR_SYMBOL_CONST:
            rels[i] = find_relation((Name)terms[i].expr, -1);
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        default:
            CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
            iterator.stack_mark.pop_to();
            return NULL ;
        }
    }
    StackMark stack_mark0;

    ArrayBindEnv * env0 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env1 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env2 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env3 = new ArrayBindEnv(rels[0]->arity());
    ArgList * args0 = make_vararglist(rels[0]->arity());
    ArgList * args1 = make_vararglist(rels[0]->arity());
    ArgList * args2 = make_vararglist(rels[0]->arity());
    ArgList * args3 = make_vararglist(rels[0]->arity());

    if (rels[0]->arity() != rels[1]->arity())
      {
        fprintf(exEnv.error_file,"Error: Intersection: Both sets must have equal arity\n");
        iterator.stack_mark.pop_to();
        return NULL;
      }

    Relation  *intersection_rel = new HashSimpleRelation(rels[0]->arity());


    Tuple *ret_tuple0;
    Tuple *ret_tuple1;
    TupleIterator * iter0 = new TupleIterator(rels[0], *args0, env0);
    TupleIterator * iter1 = new TupleIterator(rels[0], *args1, env1);
    TupleIterator * iter2 = new TupleIterator(rels[1], *args2, env2);
    TupleIterator * iter3 = 
		new TupleIterator(intersection_rel, *args3, env3);
	int _arity = rels[1]->arity();
	/* loop through outer relation */
    for(;;)
     {
        ret_tuple0 = iter0->get_next_tuple();
        if (iter0->no_match())
           break;

		/* see if tuple already in intersection */
		StackMark stack_mark3;
		iter3->reset();
		for (int i = 0; i < _arity; i++)
			 (iter3->arg_list)[i] = ret_tuple0->arg(i);
		
		ret_tuple1 = iter3->get_next_tuple();
		if (!iter3->no_match())
		  {
			 stack_mark3.pop_to();
			 iter3->release();
			 continue;
		   }
				
		/* loop through relation again to count number of copies */
		StackMark stack_mark1;
        iter1->reset();
		for (i = 0; i < _arity; i++)
             (iter1->arg_list)[i] = ret_tuple0->arg(i);
		int rel1_count = 0;
		for(;;)
		  {
        	ret_tuple1 = iter1->get_next_tuple();
        	if (iter1->no_match())
		  	  {
    	   		stack_mark1.pop_to();
		   		iter1->release();
           		break;
		   	  }
			 rel1_count++;
		   }

		/* loop through second relation to find number of copies */
		StackMark stack_mark2;
        iter2->reset();
		for (i = 0; i < _arity; i++)
             (iter2->arg_list)[i] = ret_tuple0->arg(i);
		int rel2_count = 0;
		for(;;)
		 {
			ret_tuple1 = iter2->get_next_tuple();
			if (iter2->no_match())
			  {
				 stack_mark2.pop_to();
				 iter2->release();
				 break;
			  }
			  rel2_count++;
		 }

		if (rel2_count == 0)
		   continue;

		int min;
		if (rel2_count < rel1_count)
		   min = rel2_count;
		else
		   min = rel1_count;

		for ( i = 0; i < min ; i++)
        if (!intersection_rel->insert(ret_tuple0))
          {
            fprintf(exEnv.error_file,"Error: Intersection: Cannot build Intersection.\n");
            iterator.stack_mark.pop_to();
            return NULL;
          }
    }

    stack_mark0.pop_to();
    Term result_term;
    result_term.expr = intersection_rel;
    result_term.bindenv = NULL;
    if ( ! unify_args (result_term, terms[2]))
      iterator.set_no_match();

    if (iterator.no_match())
        iterator.stack_mark.pop_to();
    return(env);

}

BindEnv * DiffSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
        iterator.stack_mark.pop_to();
        iterator.set_no_match(); return env;
    }
    iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 3)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

    Term terms[3];
    for (int i = 0; i < 3; i++) {
    terms[i].expr = iterator.arg_list[i];
    terms[i].bindenv = env;
    FULL_DEREFERENCE_TERM(terms[i]);
      }

    Relation *rels[2];
    for (i = 0; i < 2; i++)
    {
      switch (terms[i].kindof())
       {
        case COR_RELATION:
            rels[i] = (Relation*)terms[i].expr;
            break;
        case COR_FUNCTOR:
            rels[i] = find_relation(((FuncArg*)terms[i].expr)->_functor,
               ((FuncArg*)terms[i].expr)->args.count());
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        case COR_SYMBOL_CONST:
            rels[i] = find_relation((Name)terms[i].expr, -1);
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        default:
            CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
            iterator.stack_mark.pop_to();
            return NULL ;
        }
    }
    StackMark stack_mark0;

    ArrayBindEnv * env0 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env1 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env2 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env3 = new ArrayBindEnv(rels[0]->arity());
    ArgList * args0 = make_vararglist(rels[0]->arity());
    ArgList * args1 = make_vararglist(rels[0]->arity());
    ArgList * args2 = make_vararglist(rels[0]->arity());
    ArgList * args3 = make_vararglist(rels[0]->arity());

    if (rels[0]->arity() != rels[1]->arity())
      {
        fprintf(exEnv.error_file,"Error: Intersection: Both sets must have equal arity\n");
        iterator.stack_mark.pop_to();
        return NULL;
      }

    Relation  *diff_rel = new HashSimpleRelation(rels[0]->arity());


    Tuple *ret_tuple0;
    Tuple *ret_tuple1;
    TupleIterator * iter0 = new TupleIterator(rels[0], *args0, env0);
    TupleIterator * iter1 = new TupleIterator(rels[0], *args1, env1);
    TupleIterator * iter2 = new TupleIterator(rels[1], *args2, env2);
    TupleIterator * iter3 = 
		new TupleIterator(diff_rel, *args3, env3);
	int _arity = rels[1]->arity();
	/* loop through outer relation */
    for(;;)
     {
        ret_tuple0 = iter0->get_next_tuple();
        if (iter0->no_match())
           break;

		/* see if tuple already in difference */
		StackMark stack_mark3;
		iter3->reset();
		for (int i = 0; i < _arity; i++)
			 (iter3->arg_list)[i] = ret_tuple0->arg(i);
		
		ret_tuple1 = iter3->get_next_tuple();
		if (!iter3->no_match())
		  {
			 stack_mark3.pop_to();
			 iter3->release();
			 continue;
		   }
				
		/* loop through relation again to count number of copies */
		StackMark stack_mark1;
        iter1->reset();
		for (i = 0; i < _arity; i++)
             (iter1->arg_list)[i] = ret_tuple0->arg(i);
		int rel1_count = 0;
		for(;;)
		  {
        	ret_tuple1 = iter1->get_next_tuple();
        	if (iter1->no_match())
		  	  {
    	   		stack_mark1.pop_to();
		   		iter1->release();
           		break;
		   	  }
			 rel1_count++;
		   }

		/* loop through second relation to find number of copies */
		StackMark stack_mark2;
        iter2->reset();
		for (i = 0; i < _arity; i++)
             (iter2->arg_list)[i] = ret_tuple0->arg(i);
		int rel2_count = 0;
		for(;;)
		 {
			ret_tuple1 = iter2->get_next_tuple();
			if (iter2->no_match())
			  {
				 stack_mark2.pop_to();
				 iter2->release();
				 break;
			  }
			  rel2_count++;
		 }

		for ( i = 0; i < (rel1_count - rel2_count) ; i++)
        if (!diff_rel->insert(ret_tuple0))
          {
            fprintf(exEnv.error_file,"Error: Difference: Cannot build Difference.\n");
            iterator.stack_mark.pop_to();
            return NULL;
          }
    }

    stack_mark0.pop_to();
    Term result_term;
    result_term.expr = diff_rel;
    result_term.bindenv = NULL;
    if ( ! unify_args (result_term, terms[2]))
      iterator.set_no_match();

    if (iterator.no_match())
        iterator.stack_mark.pop_to();
    return(env);

}


BindEnv * SubsetSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
        iterator.stack_mark.pop_to();
        iterator.set_no_match(); return env;
    }
    iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() != 2)
      {
        fprintf(exEnv.error_file, "Error: Wrong number of arguments provided.\n");
        return NULL;
      }

    Term terms[2];
    for (int i = 0; i < 2; i++) {
    terms[i].expr = iterator.arg_list[i];
    terms[i].bindenv = env;
    FULL_DEREFERENCE_TERM(terms[i]);
      }

    Relation *rels[2];
    for (i = 0; i < 2; i++)
    {
      switch (terms[i].kindof())
       {
        case COR_RELATION:
            rels[i] = (Relation*)terms[i].expr;
            break;
        case COR_FUNCTOR:
            rels[i] = find_relation(((FuncArg*)terms[i].expr)->_functor,
               ((FuncArg*)terms[i].expr)->args.count());
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        case COR_SYMBOL_CONST:
            rels[i] = find_relation((Name)terms[i].expr, -1);
            if (rels[i] == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        default:
            CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
            iterator.stack_mark.pop_to();
            return NULL ;
        }
    }
    StackMark stack_mark0;
    ArrayBindEnv * env0 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env1 = new ArrayBindEnv(rels[0]->arity());
    ArrayBindEnv * env2 = new ArrayBindEnv(rels[0]->arity());
    ArgList * args0 = make_vararglist(rels[0]->arity());

    ArgList * args1 = make_vararglist(rels[0]->arity());
    ArgList * args2 = make_vararglist(rels[0]->arity());

    if (rels[0]->arity() != rels[1]->arity())
      {
        fprintf(exEnv.error_file,"Error: Subset: Both sets must have equal arity\n");
        iterator.stack_mark.pop_to();
        return NULL;
      }

    Relation  *subset_rel = new HashSimpleRelation(rels[0]->arity());


    Tuple *ret_tuple0;
    Tuple *ret_tuple1;
    int no_match = 0;
    TupleIterator * iter0 = new TupleIterator(rels[0], *args0, env0);
    TupleIterator * iter1 = new TupleIterator(rels[0], *args1, env1);
    TupleIterator * iter2 = new TupleIterator(rels[1], *args2, env2);
    int _arity = rels[1]->arity();
    /* loop through outer relation */
    for(;;)
     {
        ret_tuple0 = iter0->get_next_tuple();
        if (iter0->no_match())
           break;

        /* loop through relation again to count number of copies */
        StackMark stack_mark1;
        iter1->reset();
        for (i = 0; i < _arity; i++)
             (iter1->arg_list)[i] = ret_tuple0->arg(i);
        int rel1_count = 0;
        for(;;)
          {
            ret_tuple1 = iter1->get_next_tuple();
            if (iter1->no_match())
              {
                stack_mark1.pop_to();
                iter1->release();
                break;
              }
             rel1_count++;
           }

        /* loop through second relation to find number of copies */
        StackMark stack_mark2;
        iter2->reset();
        for (i = 0; i < _arity; i++)
             (iter2->arg_list)[i] = ret_tuple0->arg(i);
        int rel2_count = 0;
        for(;;)
         {
            ret_tuple1 = iter2->get_next_tuple();
            if (iter2->no_match())
              {
                 stack_mark2.pop_to();
                 iter2->release();
                 break;
              }
              rel2_count++;
         }
     if (rel1_count > rel2_count)
      {
         no_match = 1;
         break;
      }

    }

    stack_mark0.pop_to();
    if (!no_match)
        iterator.reset_no_match();
    else
     {
        iterator.set_no_match();
        iterator.stack_mark.pop_to();
     }
    return(env);

}

static BindEnv * MakeSetSolver(TupleIterator& iterator)
{
    BindEnv *env = iterator.bindenv;
    if (iterator.ipos > 0) {
        iterator.stack_mark.pop_to();
        iterator.set_no_match(); return env;
    }
    iterator.stack_mark.get_mark();
    iterator.ipos++;

    if ((iterator.arg_list).count() < 2)
      {
        fprintf(exEnv.error_file, "Error: Not enough arguments provided.\n");
        return NULL;
      }

    Term terms[2];
    for (int i = 0; i < 2; i++) {
    terms[i].expr = iterator.arg_list[i];
    terms[i].bindenv = env;
    FULL_DEREFERENCE_TERM(terms[i]);
      }

    Relation *rel;
      switch (terms[0].kindof())
       {
        case COR_RELATION:
            rel = (Relation*)terms[0].expr;
            break;
        case COR_FUNCTOR:
            rel = find_relation(((FuncArg*)terms[0].expr)->_functor,
               ((FuncArg*)terms[0].expr)->args.count());
            if (rel == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        case COR_SYMBOL_CONST:
            rel = find_relation((Name)terms[0].expr, -1);
            if (rel == NULL) {
                CORAL_error(COR_REL_NOT_FOUND, NULL, "get_next");
                iterator.stack_mark.pop_to();
                return NULL ;
            }
            break;
        default:
            CORAL_error(COR_BAD_ARG_TYPE, NULL, "get_next");
            iterator.stack_mark.pop_to();
            return NULL ;
        }
    StackMark stack_mark0;

    ArrayBindEnv * env0 = new ArrayBindEnv(rel->arity());
    ArgList * args0 = make_vararglist(rel->arity());
    ArrayBindEnv * env1 = new ArrayBindEnv(rel->arity());
    ArgList * args1 = make_vararglist(rel->arity());


    Relation  *set_rel = new HashSimpleRelation(rel->arity());

    TupleIterator * iter0 = new TupleIterator(rel, *args0, env0);
    TupleIterator * iter1 = new TupleIterator(set_rel, *args1, env1);


    Tuple *ret_tuple0;
    Tuple *ret_tuple1;
	int _arity = rel->arity();
    for(;;)
     {

      ret_tuple0 = iter0->get_next_tuple();
      if (iter0->no_match())
         break;

	  StackMark stack_mark1;
      iter1->reset();
	  for(int i = 0; i < _arity; i++)
         (iter1->arg_list)[i] = ret_tuple0->arg(i);

      ret_tuple1 = iter1->get_next_tuple();
      if (!iter1->no_match())
	   {
		 stack_mark1.pop_to();
		 iter1->release();
         continue;
	   }

	  stack_mark1.pop_to();
	  iter1->release();
      if (!set_rel->insert(ret_tuple0))
       {
        fprintf(exEnv.error_file,"Error: Set: Cannot build set.\n");
        iterator.stack_mark.pop_to();
        return NULL;
       }
     }

    stack_mark0.pop_to();
    Term result_term;
    result_term.expr = set_rel;
    result_term.bindenv = NULL;
    if ( ! unify_args (result_term, terms[1]))
      iterator.set_no_match();

    if (iterator.no_match())
        iterator.stack_mark.pop_to();
    return(env);

}





/** **************************************************************** **/

BuiltinFailRelation::BuiltinFailRelation(int a, Name n)
: BuiltinRelation(a, n, NULL)
{
}

extern BindEnv *RelOptionsSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *DebugSolver(BuiltinRelation& rel, TupleIterator& iterator);

BuiltinTraceRelation::BuiltinTraceRelation(int a, Name n)
 : BuiltinRelation(a, n, RelOptionsSolver)
{
}

BuiltinDebugRelation::BuiltinDebugRelation(int a, Name n)
 : BuiltinRelation(a, n, DebugSolver)
{
}

const Arg * LShiftOp(const Arg *arg0, const Arg* arg1)
{

    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
        return NULL;

    if ((num0->fixint()) && (num1->fixint()))
        {
        fix_int sum = ((FixInt *)num0)->ival() << ((FixInt *)num1)->ival();
        return MakeFixInt(sum);
        }
    fprintf(exEnv.error_file, "One of the arguments to LShiftOp is not FixInt.\n");
    return NULL;
}

const Arg * RShiftOp(const Arg *arg0, const Arg* arg1)
{

    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
        return NULL;

    if ((num0->fixint()) && (num1->fixint()))
        {
        fix_int sum = ((FixInt *)num0)->ival() >> ((FixInt *)num1)->ival();
        return MakeFixInt(sum);
        }
    fprintf(exEnv.error_file, "One of the arguments to RShiftOp is not FixInt.\n");
    return NULL;
}

const Arg * BitorOp(const Arg *arg0, const Arg* arg1)
{

    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
        return NULL;

    if ((num0->fixint()) && (num1->fixint()))
        {
        fix_int sum = ((FixInt *)num0)->ival() | ((FixInt *)num1)->ival();
        return MakeFixInt(sum);
        }
    fprintf(exEnv.error_file, "One of the arguments to Bitwise Or Op is not FixInt.\n");
    return NULL;
}

const Arg * BitandOp(const Arg *arg0, const Arg* arg1)
{

    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
        return NULL;

    if ((num0->fixint()) && (num1->fixint()))
        {
        fix_int sum = ((FixInt *)num0)->ival() & ((FixInt *)num1)->ival();
        return MakeFixInt(sum);
        }
    fprintf(exEnv.error_file, "One of the arguments to Bitwise And Op is not FixInt.\n");
    return NULL;
}

const Arg * BitxorOp(const Arg *arg0, const Arg* arg1)
{

    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
        return NULL;

    if ((num0->fixint()) && (num1->fixint()))
        {
        fix_int sum = ((FixInt *)num0)->ival() ^ ((FixInt *)num1)->ival();
        return MakeFixInt(sum);
        }
    fprintf(exEnv.error_file, "One of the arguments to Exclusive Or Op is not FixInt.\n");
    return NULL;
}

const Arg * ModOp(const Arg *arg0, const Arg* arg1)
{

    const Numeric *num0 = arg0->numeric();
    const Numeric *num1 = arg1->numeric();
    if (num0 == NULL || num1 == NULL)
        return NULL;

    if ((num0->fixint()) && (num1->fixint()))
        {
        fix_int sum = ((FixInt *)num0)->ival() % ((FixInt *)num1)->ival();
        return MakeFixInt(sum);
        }
    fprintf(exEnv.error_file, "One of the arguments to Mod Op is not FixInt.\n");
    return NULL;
}

static BindEnv *CutSolver(BuiltinRelation& , TupleIterator& iterator)
{
  if (CurrModuleInfo->UsePipelining && iterator.calling_pei)
    iterator.calling_pei->cut_crossed = 1;
  return iterator.bindenv;
}

static BindEnv *QuitSolver(BuiltinRelation&, TupleIterator& iterator)
{
  exEnv.C_interrupt_raised = 2;
  return iterator.bindenv;
}

extern BindEnv *GoalIdOp(BuiltinRelation& goal_id, TupleIterator& iter);
extern BindEnv *HelpSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *SlowConsultSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *DisplaySolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *PrintSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *StartTimeSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *EndTimeSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *ShellSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *RelDisplay(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *pipeInSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *pipeOutSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *writeTableSolver(BuiltinRelation& rel,TupleIterator& iterator);
extern BindEnv *deltaIndexSolver(BuiltinRelation& rel,TupleIterator& iterator);
extern BindEnv *addIndexSolver2(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *addIndexSolver1(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *HistorySolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *AliasSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *DisplayDefaultsSolver(BuiltinRelation& rel,
				      TupleIterator& iterator);
extern BindEnv *ResetDefaultsSolver(BuiltinRelation& rel,
				    TupleIterator& iterator);


extern BindEnv *CreateDBSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *DestroyDBSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *CurrentDBSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *SaveDBSolver(BuiltinRelation& rel, TupleIterator& iterator) ;
extern BindEnv *RenameDBSolver(BuiltinRelation& rel, TupleIterator& iterator) ;
extern BindEnv *ClearDBSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *ListDBSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *OpenRelSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *CloseRelSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *ClearRelSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *CopyRelSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *AddRelSolver(BuiltinRelation& rel, TupleIterator& iterator);
extern BindEnv *InsertFactSolver(BuiltinRelation& rel,TupleIterator& iterator);
extern BindEnv *DeleteFactSolver(BuiltinRelation& rel,TupleIterator& iterator);
extern BindEnv *ListRelationSolver(BuiltinRelation& rel,TupleIterator& iterator);

extern Tuple   *PowSolver(Tuple* in);
extern Tuple   *AbsSolver(Tuple* in);
extern Tuple   *CputimeSolver(Tuple* in);
extern Tuple   *CreateSetSolver(Tuple* in);
extern Tuple   *AddElemSolver(Tuple* in);

extern char *ArrayDestructorString;
extern char *ArrayConstructorString;
extern char *LogicalArrayConstructorString;
extern char *ArrayLookupString;
extern char *ArrayBindString, *LogicalArrayBindString;
extern BindEnv *ArraySolver(BuiltinRelation& rel,
              TupleIterator& iterator);
extern BindEnv *ArrayDestructSolver(BuiltinRelation& rel,
              TupleIterator& iterator);
extern BindEnv *ArrayLookupSolver(BuiltinRelation& rel,
              TupleIterator& iterator);
extern BindEnv *ArrayBindSolver(BuiltinRelation& rel,
              TupleIterator& iterator);
extern BindEnv *LogicalArrayBindSolver(BuiltinRelation& rel,
				       TupleIterator& iterator);

extern BindEnv *ArgTypeSolver(BuiltinRelation&, TupleIterator& iterator);


// **** All builtin relations should be declared within this function ***
void initBuiltins()
{
  BuiltinRelation *temp ;

  temp = new BuiltinSetRelation(-1, EnterSymbol("memtuple"), MemTupleSolver);
  temp = new BuiltinSetRelation(-1, EnterSymbol("member"), MemberSolver); 
  temp = new BuiltinSetRelation(1, EnterSymbol("call"), CallSolver);
  temp = new BuiltinRelation(2, EnterSymbol("univ"), UnivSolver);
  temp = new BuiltinSetRelation(2, EnterSymbol("subset"), SubsetSolver);
  temp = new BuiltinSetRelation(3, EnterSymbol("unionsum"), UnionSolver);
  temp = new BuiltinSetRelation(3, EnterSymbol("unionmax"),MultiUnionSolver);
  temp = new BuiltinSetRelation(3, EnterSymbol("inter"), IntersectionSolver);
  temp = new BuiltinSetRelation(3, EnterSymbol("difference"), DiffSolver);
  temp = new BuiltinSetRelation(2, EnterSymbol("make_set"), MakeSetSolver);
 
  temp = new BuiltinUserTupleRelation(3, EnterSymbol("functor"), FuncOp);
  temp = new BuiltinUserTupleRelation(3, EnterSymbol("arg"), ArgOp);
  temp = new BuiltinUserTupleRelation(3, EnterSymbol("pow"), PowSolver);
  temp = new BuiltinUserTupleRelation(1, CreateSetSymbol, CreateSetSolver);
  temp = new BuiltinUserTupleRelation(3, AddElemSymbol, AddElemSolver);
  temp = new BuiltinUserTupleRelation(2, AbsOpSymbol, AbsSolver);

  temp = new BuiltinBinaryRelation(3, LShiftOpSymbol, LShiftOp);
  temp = new BuiltinBinaryRelation(3, RShiftOpSymbol, RShiftOp);
  temp = new BuiltinBinaryRelation(3, BitandOpSymbol, BitandOp);
  temp = new BuiltinBinaryRelation(3, BitorOpSymbol, BitorOp);
  temp = new BuiltinBinaryRelation(3, BitxorOpSymbol, BitxorOp);
  temp = new BuiltinBinaryRelation(3, ModOpSymbol, ModOp);

  temp = new BuiltinBinaryRelation(3, AddOpSymbol, AddOp);
  temp = new BuiltinBinaryRelation(3, SubOpSymbol, SubOp);
  temp = new BuiltinBinaryRelation(3, MulOpSymbol, MulOp);
  temp = new BuiltinBinaryRelation(3, DivOpSymbol, DivOp);
  
  temp = new BuiltinUnaryRelation(2, SumOpSymbol, SumOp);
  temp = new BuiltinUnaryRelation(2, ProdOpSymbol, ProdOp);
  temp = new BuiltinUnaryRelation(2, CountOpSymbol, CountOp);
  temp = new BuiltinUnaryRelation(2, MaxOpSymbol, MaxOp);
  temp = new BuiltinUnaryRelation(2, MinOpSymbol, MinOp);
  temp = new BuiltinUnaryRelation(2, AvgOpSymbol, AvgOp);

  temp = new BuiltinCompareRelation(2, EquOpSymbol, EquOp);
  temp = new BuiltinCompareRelation(2, NeqOpSymbol, NeqOp);
  temp = new BuiltinCompareRelation(2, LssOpSymbol, LssOp);
  temp = new BuiltinCompareRelation(2, GrtOpSymbol, GrtOp);
  temp = new BuiltinCompareRelation(2, LeqOpSymbol, LeqOp);
  temp = new BuiltinCompareRelation(2, GeqOpSymbol, GeqOp);

  temp = new BuiltinFailRelation(0, FailSymbol) ;
  temp = new BuiltinRelation(0, CutSymbol, CutSolver) ;
  temp = new BuiltinRelation(0, QuitSymbol, QuitSolver) ;
  temp = new BuiltinRelation(1, GoalIdOpSymbol, GoalIdOp);

  temp = new BuiltinTraceRelation(-1, ExplainOnSymbol);
  temp = new BuiltinTraceRelation(-1, ExplainOffSymbol);
  temp = new BuiltinTraceRelation(-1, TraceSymbol);
  temp = new BuiltinTraceRelation(-1, UntraceSymbol);
  temp = new BuiltinTraceRelation(-1, ProfileOnSymbol);
  temp = new BuiltinTraceRelation(-1, ProfileOffSymbol);

  temp = new BuiltinDebugRelation(-1, SetSymbol)    ;
  temp = new BuiltinDebugRelation(-1, ClearSymbol)  ;
  temp = new BuiltinDebugRelation(2, AssignSymbol) ;

  temp = new BuiltinRelation(-1, HelpSymbol, HelpSolver)    ;
  temp = new BuiltinRelation(1, ConsultSymbol, SlowConsultSolver) ;
  temp = new BuiltinRelation(-1, DisplaySymbol, DisplaySolver)  ;
  temp = new BuiltinRelation(-1, PrintfSymbol, PrintSolver) ;
  temp = new BuiltinRelation(-1, StartTimerSymbol,StartTimeSolver);
  temp = new BuiltinRelation(-1, DisplayTimerSymbol, EndTimeSolver);
  temp = new BuiltinUserTupleRelation(1, EnterSymbol("cputime"), CputimeSolver);
  temp = new BuiltinRelation(1, EnterSymbol("shell"), ShellSolver);
  temp = new BuiltinRelation(-1, ListRelsInDBSymbol, RelDisplay);
  temp = new BuiltinRelation(1, PipeInSymbol, pipeInSolver);
  temp = new BuiltinRelation(2, PipeOutSymbol, pipeOutSolver);
  temp = new BuiltinRelation(2, WriteTableSymbol, writeTableSolver);
  temp = new BuiltinRelation(-1, IndexDeltaSymbol, deltaIndexSolver);
  temp = new BuiltinRelation(1, MakeIndexSymbol, addIndexSolver1) ;
  temp = new BuiltinRelation(2, AliasSymbol, AliasSolver) ;
  temp = new BuiltinRelation(0, DisplayDefaultsSymbol, DisplayDefaultsSolver) ;
  temp = new BuiltinRelation(0, ResetDefaultsSymbol, ResetDefaultsSolver) ;

  temp = new BuiltinRelation(1, CreateDBSymbol, CreateDBSolver) ;
  temp = new BuiltinRelation(1, DestroyDBSymbol, DestroyDBSolver) ;
  temp = new BuiltinRelation(-1, CurrentDBSymbol, CurrentDBSolver) ;
  temp = new BuiltinRelation(2, SaveDBSymbol, SaveDBSolver);
  temp = new BuiltinRelation(2, RenameDBSymbol, RenameDBSolver);
  temp = new BuiltinRelation(1, ClearDBSymbol, ClearDBSolver);
  temp = new BuiltinRelation(1, ListDBSymbol, ListDBSolver) ;
  temp = new BuiltinRelation(1, EnterSymbol("ord_rel"), ListRelationSolver) ;
  temp = new BuiltinRelation(2, OpenRelInDBSymbol, OpenRelSolver) ;
  temp = new BuiltinRelation(1, CloseRelSymbol, CloseRelSolver) ;
  temp = new BuiltinRelation(1, ClearRelSymbol, ClearRelSolver) ;
  temp = new BuiltinRelation(1, CopyRelToDBSymbol, CopyRelSolver) ;
  temp = new BuiltinRelation(1, AddRelToDBSymbol, AddRelSolver) ;
  temp = new BuiltinRelation(1, EnterSymbol("insert"), InsertFactSolver);
  temp = new BuiltinRelation(1, EnterSymbol("delete"), DeleteFactSolver);
  temp = new BuiltinRelation(1, EnterSymbol("history"), HistorySolver);


  temp = new BuiltinRelation(1, EnterSymbol(ArrayDestructorString),
			     ArrayDestructSolver);
  temp = new BuiltinRelation(1, EnterSymbol(LogicalArrayConstructorString),
			     ArraySolver);
  temp = new BuiltinRelation(1, EnterSymbol(ArrayConstructorString),
			     ArraySolver);
  temp = new BuiltinRelation(1, EnterSymbol(ArrayLookupString),
			     ArrayLookupSolver);
  temp = new BuiltinRelation(1, EnterSymbol(ArrayBindString),
			     ArrayBindSolver);
  temp = new BuiltinRelation(1, EnterSymbol(LogicalArrayBindString),
			     LogicalArrayBindSolver);

  temp = new BuiltinRelation(1, IsConstantSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsVarSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsListSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsFunctorSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsNumSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsStringSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsIntSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsLongSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsShortSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsFloatSymbol, ArgTypeSolver);
  temp = new BuiltinRelation(1, IsDoubleSymbol, ArgTypeSolver);

}
