/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifdef __GNUG__
#ifdef USEGNUGPRAGMAS
#pragma implementation "arg.h"
#endif
#endif
#include "generic-rel.h"
#include <stdio.h>
#include "rules.h"
#include "globals.h"
#include "unify.h"
#include <stdlib.h>
#include <string.h>
#include "hashtable.h"
#include "term.h"
#include "gennum.h"

DontCareArg TheDontCareArg;

static int C_NewFunctorCount = 0;
static int C_NewFunctorSize = 0;
static int C_DeleteFunctorCount = 0;
static int C_DeleteFunctorSize = 0;
static int C_NewArgListCount = 0;
static int C_NewArgListSize = 0;
int C_NewTupleCount = 0;
int C_NewTupleSize  = 0;
int C_DeleteTupleCount = 0;
int C_DeleteTupleSize  = 0;
int C_ConstructEnvCount = 0;
int C_ConstructEnvSize = 0;
int C_DestructEnvCount = 0;
int C_DestructEnvSize = 0;
extern int C_NewIntCount, C_NewDoubleCount;
int C_NewGArraySize = 0;
int C_DeleteGArraySize = 0;
extern int C_NewHashIndex, C_NewHashIndexSize;
extern int C_DeleteHashIndex, C_DeleteHashIndexSize;
extern int C_NewHashRelation, C_DeleteHashRelation;
extern int C_PipelinedConstructs, C_PipelinedDestructs;
extern int C_tupleiterConstructs, C_tupleiterDestructs;

extern ArrayBindEnv UnusedEnv;


void Arg::print(BindEnv *, FILE *) const
{
}

void Arg::print(BindEnv *, FILE *, char *) const
{
}

void Arg::printon(FILE *, char *) const
{
}


/********************************************************************/

int VarLink::contains(VarArg *arg)
{
    for(VarLink* cur=this; cur!= NULL; cur = cur->next) {
	if (cur->arg->var == arg->var)
	    return 1;
    }
    return 0;
}

/********************************************************************/

FuncArg * FuncArg::New(Name op, int arg_count)
{
    FuncArg dummy(op, arg_count);
    struct dummy_class {
	char c[sizeof(FuncArg)];
    };
    int size = sizeof(FuncArg) + arg_count * sizeof(ArgPtr);
#ifdef DEBUG
    C_NewFunctorCount++;
    C_NewFunctorSize+=size;
#endif
#ifdef DO_GC
    if (FuncArg::__GCPointers == 0)
	FuncArg::__GCPointers =
	    gcregistercallback((GCCALLBACKPROC)&FuncArg::GCPointers,
			       "FuncArg");
    FuncArg *arg = (FuncArg*)
	gcalloc(GCBYTEStoWORDS(size), FuncArg::__GCPointers);
#else
    FuncArg *arg = (FuncArg*)new char[size];
#endif
    *(dummy_class*)arg = *(dummy_class*)&dummy;
    return arg;
}

/********************************************************************/

ArgList * ArgList::New(int arg_count)
{
    int size = sizeof(ArgList) + arg_count * sizeof(ArgPtr);
#ifdef DEBUG
    C_NewArgListCount++;
    C_NewArgListSize+=size;
#endif
#ifdef DO_GC
    if (ArgList::__GCPointers == 0)
	ArgList::__GCPointers =
	    gcregistercallback((GCCALLBACKPROC)&ArgList::GCPointers,
			       "ArgList");
    ArgList *args = (ArgList*)
	gcalloc(GCBYTEStoWORDS(size), ArgList::__GCPointers);
#else
    ArgList *args = (ArgList*)new char[size];
#endif
    /* The following loop has a <= since args[0] is really a count */
    for(int i=0; i<= arg_count;i++) 
	*(((Arg**)args)+i) = NULL;
    args->set_count(arg_count);
    return args;
}

/*************************************************************************/


ArgList *vararglist(int n)
{
    ArgList *al = ArgList::New(n);
    for(int i =0; i<n; i++) {
	(*al)[i] = make_var(i);
    }
    return al;
}

/*************************************************************************/

arg_kind Symbol::kindof() const
{
	return COR_SYMBOL_CONST;
}

HashVal Symbol::hash(BindEnv* /*env = 0*/) 
{
    return IntToHash((int)SymbolHash(this));
}

int back_slash_quotes=0;


arg_kind DontCareArg::kindof() const 
{
    return COR_DONTCARE; 
}

arg_kind VarArg::kindof() const
{
    return COR_VARIABLE;
}

arg_kind FuncArg::kindof() const 
{ 
    return COR_FUNCTOR;
}

arg_kind NumArg::kindof() const
{
    return COR_NUM_CONST;
}

numarg_kind NumArg::num_kindof() const
{
    return COR_NOT_A_NUMBER;
}

arg_kind Grouping::kindof() const 
{
    return COR_GROUPING; 
}

/*************************************************************************/
/*------------------------------------------------------------------
 *::print(BindEnv *env, FILE *file)
	Interpret (*this) in env, and print it out on to the file.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/
/** Tarun **/
void ArgList::print_dump(BindEnv *env, FILE *file) const
{
    int i = 0;
    FOR_EACH_ARG(arg, *this) {
    if (i)
        fprintf(file, ",");
    i++;
    arg->print_dump(env, file);
    } END_EACH_ARG
}

void ArgList::print(BindEnv *env, FILE *file) const
{
    int i = 0;
    FOR_EACH_ARG(arg, *this) {
	if (i)
	    fprintf(file, ",");
	i++;
	arg->print(env, file);
    } END_EACH_ARG
}

void ArgList::print(BindEnv *env, FILE *file, char *) const
{
	print(env, file);
}

void Symbol::print(BindEnv*, FILE *file) const
{
    if (this == NilSymbol)
	fprintf(file, "[]");
    else if ( ! back_slash_quotes) {
      char *tmp = SymbolString(sym_name());
//      if (tmp[0] != '\"') fprintf(file, "\"");
      fprintf(file, "%s", tmp);
//      if (tmp[strlen(tmp)-1] != '\"') fprintf(file, "\"");
    }
    else {     // This part entered only for the compiled CORAL version (outdated)
	char *ptr = SymbolString(sym_name());
	register int i = (int) sym_name()->length();
	while (--i >= 0) {
	    register char ch = *ptr++;
	    if (ch == '\\' || ch == '\"') fprintf(file, "\\%c", ch);
	    else if (ch >= ' ' && ch < 127) putc(ch, file);
	    else fprintf(file, "\\%03o", ch);
	}
    }
}

extern char *strip_quotes(char *);
void Symbol::print(BindEnv *env, FILE *file, char *fmt_str) const
{
    char * temp = fmt_str;

    while (*temp != '\0')
      {
        if (*temp == 's') break;
        temp++;
      }

    if (*temp == '\0')
      {
        fprintf( stderr,
           "Incorrect format statement provided to print string.\n");
        print(env, file);
      }
    else
     {
        if (this == NilSymbol)
            fprintf(file, "[]");
        else
            fprintf(file, fmt_str, strip_quotes(SymbolString(sym_name())));
     }
}


void DontCareArg::print(BindEnv*, FILE *file) const
{
    fprintf(file, "_");
}

void DontCareArg::print(BindEnv*, FILE *file, char *) const
{
    fprintf(file, "_");
}


void VarArg::print(BindEnv* env, FILE *file) const
{
    if (env == NULL || env->lookup(var).expr == NULL)
	fprintf(file, "%s", SymbolString(var_name()));
    else env->lookup(var).printon(file) ;	
}

void VarArg::print(BindEnv* env, FILE *file, char *fmt_str) const
{
    char * temp = fmt_str;

    while (*temp != '\0')
      {
        if (*temp == 's') break;
        temp++;
      }

    if (*temp == '\0')
      {
        fprintf( stderr,
           "Incorrect format statement provided to print string.\n");
        print(env, file);
      }
    else
     {
        if (env == NULL || env->lookup(var).expr == NULL)
            fprintf(file, fmt_str, SymbolString(var_name()));
        else env->lookup(var).printon(file) ;
     }
}


void FuncArg::print(BindEnv* env, FILE *file) const
{
    if (functor() == ListSymbol) {
	fprintf(file, "[");
	args.print(env, file);
	fprintf(file, "]");
    }
    else if (functor() == ConsSymbol) {
	fprintf(file, "[");
	const FuncArg *cdr = this;
	for (;;) {
	    cdr->args[0]->print(env, file);
	    Arg *cdr_arg = cdr->args[1];
	    cdr = (FuncArg*)cdr_arg;
	    if ((Arg*)cdr == (Arg*)NilArg) break;
	    if (cdr->kindof() != COR_FUNCTOR
		|| cdr->functor() != ConsSymbol) break;
	    fprintf(file, ",");
	}
	if ((Arg*)cdr != (Arg*)NilArg) {
	    fprintf(file, "|");
	    cdr->print(env, file);
	}
	fprintf(file, "]");
    }
    else {
	fprintf(file, "%s(", SymbolString(functor()));
	args.print(env, file);
	fprintf(file, ")");
    }
}

void FuncArg::print(BindEnv* env, FILE *file, char *) const
{
    print(env, file);
}


/*****************************************************************************/

/*------------------------------------------------------------------
 *::sprint(char *string, int* pos, BindEnv *env)
	print the argument on string, starting at *pos.  Update *pos
	to be the position of the end of the printed argument.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

void ArgList::sprint(char* str, int* pos, BindEnv *env) const
{
    int i = 0;
    FOR_EACH_ARG(arg, *this) {
	if (i) {
	    sprintf(str + *pos, ",");
	    (*pos)++ ;
	}
	i++;
	arg->sprint(str, pos, env);
    } END_EACH_ARG
}

void Symbol::sprint(char* str, int* pos, BindEnv *) const
{
    if (this == NilSymbol) {
	sprintf(str + *pos, "[]");
	*pos += 2 ;
    }
    else {
        sprintf(str + *pos, "%s", SymbolString(sym_name()));
	*pos += SymbolLength(sym_name()) ;
    }
}


void DontCareArg::sprint(char* str, int* pos, BindEnv *) const
{
    sprintf(str + *pos, "_");
    (*pos)++ ;
}

void VarArg::sprint(char* str, int* pos, BindEnv *env) const
{
    if (env == NULL || env->lookup(var).expr == NULL) {
        sprintf(str + *pos, "%s", SymbolString(var_name()));
        *pos += SymbolLength(var_name()) ;
    }
    else (env->lookup(var).expr)->
			 sprint(str, pos, env->lookup(var).bindenv);

}


void FuncArg::sprint(char* str, int* pos, BindEnv *env) const
{
    if (functor() == ListSymbol) {
	sprintf(str + *pos, "[");
	(*pos)++ ;
	args.sprint(str, pos, env);
	sprintf(str + *pos, "]");
	(*pos)++ ;
    }
    else if (functor() == ConsSymbol) {
	sprintf(str + *pos, "[");
	(*pos)++ ;
	const FuncArg *cdr = this;
	for (;;) {
	    cdr->args[0]->sprint(str, pos, env);
	    Arg *cdr_arg = cdr->args[1];

	    cdr = (FuncArg*)cdr_arg;
	    if ((Arg*)cdr == (Arg*)NilArg) break;
	    if (cdr->kindof() != COR_FUNCTOR
		|| cdr->functor() != ConsSymbol) break;
	    sprintf(str + *pos, ",");
	    (*pos)++ ;
	}
	if ((Arg*)cdr != (Arg*)NilArg) {
	    sprintf(str + *pos, "|");
	    (*pos)++ ;
	    cdr->sprint(str, pos, env);
	}
	sprintf(str + *pos, "]");
	(*pos)++ ;
    }
    else {
	sprintf(str + *pos, "%s(", SymbolString(functor()));
	*pos += SymbolLength(functor()) + 1;
	args.sprint(str, pos, env);
	sprintf(str + *pos, ")");
	(*pos)++ ;
    }
}

/*************************************************************************/
/*------------------------------------------------------------------
 *::isConstant(): 
	Returns true if (this) has no variables in it, and returns 
	false otherwise.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

int ArgList::isConstant()
{
    FOR_EACH_ARG(arg, *this) {
	if (! arg->isConstant()) return (0); 
    } END_EACH_ARG
    return (1) ;
}

int ConstArg::isConstant() 
{ // This also covers Symbol !!
    return 1; 
}
int VarArg::isConstant() 
{
    return 0;
}
int DontCareArg::isConstant() 
{
    return 0;
}

int FuncArg::isConstant() 
{
    if (isGroundHashValue(_hash))
	return 1;
    if (_hash == VarHashValue)
	return 0;	
    FOR_EACH_ARG(arg, args) {
	if (!arg->isConstant()) {
	    _hash = VarHashValue;
	    return 0;
	}
    } END_EACH_ARG;
    return 1;
}

/*************************************************************************/
/*------------------------------------------------------------------

  *::simplify(BindEnv *env, TermLink *& renamed_vars, BindEnv* dont_rename_env,
		BindEnv *rename_only_env)
	Renames the variables in (this) interpreted in env.  
	- renamed_vars is a list of variable names along with their new names
	(their position in the list + dont_rename_env_max_var gives the new
	name).
	- dont_rename_env is a bindenv, the variables in which need not be 
	renamed.  Any structure that is interpreted in dont_rename_env is left
	unchanged by simplify.  
	- rename_only_env -- if this is non-null, and an argument is found
		to be from a bindenv other than dont_rename_env and
		rename_only_env, simplify returns failure.
		If this is null, all bindenvs other than dont_rename_env are
		renamed.

 Oddities/Quirks :: 

	WARNING:
	-  This function assumes that if rename_only_var is non null, 
	    the function has been called recursively from backpatch_trail.
	    In this case, there is no need to follow terms that are
	    interpreted in const_env.

	- Variables of the form _X1, _X2, ...  should not be generated 
	elsewhere in the system.  They are reserved for this function to 
	generate.

 -------------------------------------------------------------------*/

Arg* Arg::simplify(BindEnv *, TermLink*&, BindEnv *, 
				BindEnv * ) 
	{ return this; }
Arg* VarArg::simplify(BindEnv* env, TermLink*& renamed_vars, 
		BindEnv* const_env, BindEnv *rename_only_env) 
{	
    Term term;
    if (env != NULL) 
	term = env->lookup(var);

    if (rename_only_env && env != rename_only_env && env != const_env)
	return NULL;
    if (env == const_env && (env == NULL || term.expr==NULL) )
	return(this);
    if (env == NULL || term.expr == NULL) {
	TermLink *tlink = renamed_vars;
	int new_i = 0;
	for ( ; tlink != NULL; tlink = tlink->next, new_i++)
	    if(tlink->old_var == var && tlink->old_bindenv == env) 
		return tlink->new_arg;
	tlink = new TermLink;
	tlink->next = renamed_vars;
	renamed_vars = tlink;
	tlink->old_var = var;
	tlink->old_bindenv = env;
	char varname[100];
	sprintf(varname, "_X%d", const_env->max_var_number()+new_i);
	tlink->new_arg = new VarArg(EnterSymbol(varname),
			const_env->max_var_number()+new_i);
	return tlink->new_arg;
    }
    else
    return term.expr->simplify( term.bindenv, renamed_vars, const_env, 
					rename_only_env);
}

Arg* FuncArg::simplify(BindEnv *env, TermLink*& renamed_vars, 
		BindEnv *const_env, BindEnv *rename_only_env) 
{
    int changes = 0;

    if (isConstant())
	return this;

    if (rename_only_env) {
	if (env != const_env && env != rename_only_env)
	    return NULL;

	// WARNING:
	//    this assumes that if rename_only_var is non-null, the function 
	//    has been called recursively from backpatch_trail.
	//    In this case, there is no need to follow terms that are
	//    interpreted in const_env.

	if (env == const_env)
	    return this;
    }

    /*************************
    //  Used to do the following as an efficiency hack, but it isn't fast
    //  any more.
    // if ((env==const_env) &&  (env->all_free()) )
    //	return this;
    *************************/

    FuncArg *this_copy = FuncArg::New(functor(), count());
    const Arg** dstPtr = this_copy->args.first();
    FOR_EACH_ARG(arg, args) {
	*dstPtr = arg->simplify(env, renamed_vars, const_env, rename_only_env);
	if (*dstPtr == NULL) {  // simplify failed due to rename_only_env
	    ::delete this_copy;
	    return NULL;
	}
	if (*dstPtr != arg) changes = 1;
	dstPtr++;
    } END_EACH_ARG;
    if (changes) {
    	this_copy->hash(); /* computes, and if the term is ground, stores
				the hash value */
    	return (Arg*)this_copy;
    }
    else {
	::delete this_copy; /* So that no recursive delete calls are made. */
	return(this);
    }
}

/*************************************************************************/

/*------------------------------------------------------------------

int CopyArgs(register ArgPtr* new_args, register ArgPtr *old_args,
	     BindEnv *env, int arity, BindEnv *dont_rename_env)

	Copy and simplify from old_args to new_args. 
   	Return the number of variables in new_args (return -1 if this is 
	unknown). 

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

int CopyArgs(register ArgPtr* new_args, register ArgPtr *old_args,
	     BindEnv *env, int arity, BindEnv *dont_rename_env,
	     BindEnv *rename_only_env)
{
    ASSERT((rename_only_env==NULL));
    if (dont_rename_env == NULL)
	dont_rename_env = &UnusedEnv;
    TermLink *renamed_vars = NULL;
    register int i;
    for (i = 0; i < arity; i++, old_args++, new_args++) {
	*new_args = (Arg*)(*old_args)->simplify(env, renamed_vars, 
			dont_rename_env, rename_only_env);
    }

    for (i = 0; renamed_vars != NULL; i++) {
	TermLink *tlink = renamed_vars;
	renamed_vars = tlink->next;
	delete tlink;
    }

    int newsize = dont_rename_env->max_var_number() + i;
    if (dont_rename_env != &UnusedEnv) {
	dont_rename_env->resize( newsize ) ;
    }
    return newsize;
}


/*------------------------------------------------------------------


- int SimpleCopyArgs(ArgList *new_arglist, ArgList *old_arglist,
		BindEnv *rule_env, BindEnv *dont_rename_env,
		TermLink *&renamed_vars)

	This function copies out old_arglist into new_arglist.  It dereferences
	variables when copying and if the variable is in rule_env, it is
	renamed to be in dont_rename_env.  renamed_vars is a list of 
	rule variables that were renamed earlier by a call to 
	backpatch_bindenvs.

 Oddities/Quirks ::

	ASSUMPTION:  backpatching has already been done, so that all bindings
	are either to dont_rename_env or to rule_env.

-------------------------------------------------------------------*/


int SimpleCopyArgs(ArgList *new_arglist, ArgList *old_arglist,
		BindEnv *rule_env, BindEnv *dont_rename_env,
		TermLink *&renamed_vars)
{
    register int i;

    ArgPtr *new_args = new_arglist->first();
    ArgPtr *old_args = old_arglist->first();
    int arity = old_arglist->arity();

    for (i = 0; i < arity; i++, old_args++, new_args++) {
	*new_args = (Arg*)(*old_args)->simplify(rule_env, renamed_vars, 
			dont_rename_env, /*rename_only_env=*/ rule_env);
	ASSERT((*new_args!=NULL));
    }

    for (i = 0; renamed_vars != NULL; i++) {
	TermLink *tlink = renamed_vars;
	renamed_vars = tlink->next;
	delete tlink;
    }

    if (dont_rename_env != &UnusedEnv) {
	dont_rename_env->resize(dont_rename_env->max_var_number() + i ) ;
    }

    return dont_rename_env->max_var_number() + i;
}

/*************
int backpatch_bindenvs(StackMark start, BindEnv *dont_rename_env, 
			BindEnv *rule_env, TermLink *&renamed_vars) 


    (Author:  Sudarshan)

    (This function is related to return-unification.)

    This function backpatches bindings by going through the trail, in
    order to pretend as if the rule variables were renamed before unification.

    Any variables that were bound to a rule variable are now re-bound
    after dereferencing them.  
    
    If the dereferencing leads to a 
    binding in a bindenv other than rule_env or dont_rename_env,
    backpatch_bindenvs fails.  This cannot happen when return-unification
    succeeds, since there is only one bindenv other than rule_env.
    Failure also cannot happen for the case of rules with exactly one 
    derived body literal.

    If the dereferencing leads to a structure interpreted in the rule
    bindenv, this structure is renamed, using calls to arg::simplify.
    Note that as before, if other bindenvs are encountered, failure results.
    If a structure is interpreted in dont_rename_env, it need not be
    recursively traversed --- before rule application, the bindenv has 
    only local bindings, and hence there are no cross bindings.  Any cross
    bindings are created during rule application, and are hence backpatched
    here.

    The new variable names start from after the last variable in 
    dont_rename_env.  
    
    A list of renamed rule variables is returned in 
    renamed_vars - the ordering corresponds to the new names of the 
    variables.

    This backpatching does not rename free variables in the head of the
    rule that are not pointed to by any variables that got bound during
    earlier unification.
    Renaming those variables is handled separately after the call to
    backpatch_bindenvs.

    Note that rule variable bindings are not changed during backpatching,
    since these bindings have to be undone on backtracking.
    Backpatching conflicts with backtracking -- if X was bound to Y, and 
    later Y was bound to 1, backpatching may bind X to 1.  When backtracking
    reaches Y, it is unbound, and X ought to be bound to Y at this point.
    But path-compression during backpatching will screw up, since X will
    stay bound to 1.

    (See note re. how fact bindenvs are handled in this respect.)

    Note that backpatch_bindenvs takes time proportional to the size of the
    rule and to the number of bindings that were created in trail in the
    course of this inference (multiplied by the acceess cost of variables
    in the bindenvs).

    return status:
	0       - failure - can't backpatch the bindings.
	1       - success
**************/

int backpatch_bindenvs(StackMark start, BindEnv *dont_rename_env, 
			BindEnv *rule_env, TermLink *&renamed_vars) 
{
    Term binding;

    for(int i= start.trail_index(); i < trail.TrailSize; i++) {
	if (trail[i].var < 0) // Not a variable binding
	    continue;

	// WARNING:
	//  In the following, do not change rule var bindings --
	//  they have to be restored on backtracking,
	//  and backpatching can screw up backtracking
	//  the fact bindenv (there is only one) can be backpatched
	//  since it is copied before backpatching.
	// 
	//  This does not affect the complexity of the Opt-NG-SN
	//  algorithm, since  the amount of work done in backpatching
	//  each binding is quite small


	binding = trail[i].bindenv->lookup(trail[i].var);

	if (binding.bindenv == dont_rename_env)
	    continue;  // No need to fix the binding
	 
	FULL_DEREFERENCE_TERM(binding);

	if (binding.bindenv == dont_rename_env) {
	    if (trail[i].bindenv != rule_env)
	        trail[i].bindenv->bind(trail[i].var, binding);
	    continue;
	}
	else if (binding.bindenv != rule_env) {
	    if ( ! binding.expr->isConstant())
		  	// Binding to another bindenv -- cannot backpatch
		goto fail_return;

	    // binding.expr is a constant.  Can use dont_rename_env for it
	    binding.bindenv = dont_rename_env;
	    if (trail[i].bindenv != rule_env)
	        trail[i].bindenv->bind(trail[i].var, binding);
	    continue;
	}
	else  { 	// binding.bindenv == rule_env
	    Arg *deref_arg = binding.expr->simplify(binding.bindenv,
			   renamed_vars, dont_rename_env, rule_env);
	    if (!deref_arg)  // patching of binding failed.
		goto fail_return;
	    binding.expr = deref_arg;
	    binding.bindenv = dont_rename_env;
	    if (trail[i].bindenv != rule_env)
	        trail[i].bindenv->bind(trail[i].var, binding);
	    continue;
	}
    }

    return 1;

fail_return:
    for (i = 0; renamed_vars != NULL; i++) {
	TermLink *tlink = renamed_vars;
	renamed_vars = tlink->next;
	delete tlink;
    }
    return 0;
}

/*------------------------------------------------------------------

  ArgList* SimplifyVars(BindEnv *env, int num_vars, Symbol** rule_var_names )

	Copy and simplify variables 1 to num_vars and return. 

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

ArgList* SimplifyVars(BindEnv *env, int num_vars, Symbol** rule_var_names )
{
    TermLink *renamed_vars = NULL;
    register int i;
    ArgList *new_args = ArgList::New(num_vars);
    Name dummyvarname = EnterSymbol("Xerror");

    /** Variables in env should not be renamed:  These are the variables in 
	the query.  If we have ?q(X,Y), and bindings X->X0, X0->Y, 
	we would otherwise rename Y in the bindings to say X_0, but not be 
	able to change the variable Y in the query.  The result would then 
	read X=X__0, Y=Y, which is wrong **/

    for (i = 0; i < num_vars; i++) {
	VarArg *var = new VarArg (rule_var_names[i], i);
	(*new_args)[i] = (Arg *) var->simplify(env, renamed_vars, env, NULL);
	if ( (*new_args)[i] != var) delete var;
    }
    for (i = 0; renamed_vars != NULL; i++) {
	TermLink *tlink = renamed_vars;
	renamed_vars = tlink->next;
	delete tlink;
    }
    return(new_args);
}


/*************************************************************************/

/*------------------------------------------------------------------
 *::var_list(VarLink *rest)

	Return (reversed) list of all variables in 'this'. Append 'rest' 
	to the end.  Default: there are no variables in 'this'.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

VarLink * Arg::var_list(VarLink *rest) { return rest; }
VarLink * VarArg::var_list(VarLink *rest)
{
    /* Check for duplicates. */
    VarLink *link;
    for (link = rest; link != NULL; link = link->next) {
	if (link->arg->var == var) return rest;
    }
    return new VarLink(this, rest);
}
VarLink * FuncArg::var_list(VarLink *rest)
{
    FOR_EACH_ARG(farg, args) {
	rest = farg->var_list(rest);
    } END_EACH_ARG;
    return rest;
}

VarLink * ExprArg::var_list(VarLink *rest)
{
    rest = left_arg->var_list(rest);
    if (right_arg) 
	rest = right_arg->var_list(rest);
    return rest;
}

VarLink *ArgList::var_list(VarLink *rest)
{
    FOR_EACH_ARG(targ,*this) {
	rest = targ->var_list(rest);
    } END_EACH_ARG;
    return rest;
}
/*************************************************************************/

/*------------------------------------------------------------------
  *::max_vars()

	Returns 1 + the number of the highest numbered variable in (*this).

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

Variable  Arg::max_vars()
{
    VarLink *rest, *prev, *cur;
    Variable max_var_num=-1;

    rest = this->var_list(NULL);
    for( cur=rest;  cur; ) {
	if (cur->arg->var > max_var_num)
	    max_var_num = cur->arg->var;
	prev = cur;
	cur = cur->next;
	delete prev;
    }
    return max_var_num+1;

}

Variable  ArgList::max_vars() 
{

    VarLink *rest, *prev, *cur;
    Variable max_var_num=-1;

    rest = this->var_list(NULL);
    for( cur=rest;  cur; ) {
	if (cur->arg->var > max_var_num)
	    max_var_num = cur->arg->var;
	prev = cur;
	cur = cur->next;
	delete prev;
    }
    return max_var_num+1;
}


/*************************************************************************/

/*------------------------------------------------------------------
 *::equals(Arg *arg)

	Returns true if (this) is equal to arg, false otherwise.
	Note that no bindenv is provided, so this really works only
	for constant structures.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

int Arg::equals(Arg *)
{
    fprintf(stderr, 
	"System Error: equals() called on class for which it is not defined\n");
    return 0;
}

int Symbol::equals(Arg *arg2)
{
    if (arg2->kindof() != COR_SYMBOL_CONST)
	return (0);
    return(this == (Symbol *)arg2);
}

int DontCareArg::equals(Arg *arg2) 
{
    if (arg2->kindof() != COR_DONTCARE)
	return(0);
    return(1);
}

int VarArg::equals(Arg *arg2)
{

    if (arg2->kindof() != COR_VARIABLE)
	return (0);
    return (var == ((VarArg *)arg2)->var) ;
}

int NumArg::equals(Arg *arg2)
{
    if (arg2->kindof() != COR_NUM_CONST)
	return (0);
    return( ! compare(*((NumArg*)arg2)) );
}

int FuncArg::equals(Arg *arg2)
{
    if (arg2->kindof() != COR_FUNCTOR)
	return (0);
    if ( !(functor()->equals(((FuncArg*)arg2)->functor()) ))
	return (0);
    if ( arity() != ((FuncArg*)arg2)->arity() ) 
	return (0);
    if ( _hash != arg2->hash() && isGroundHashValue(_hash)
		&& isGroundHashValue(arg2->hash()) )
	return(0);
#if USE_HASHCONSING
    if ( hash() == arg2->hash() && isGroundHashValue(hash()) ) 
	return (1);
#endif
    /* When called on ground terms, and with hashconsing in use, this
	function will never reach this point */
    for (int i=0; i< arity(); i++)
	if ( ! args[i]->equals( ((FuncArg *)arg2)->args[i]) )
	    return(0);
    return (1);
}

int Grouping::equals(Arg *arg2)
{
    if (arg2->kindof() != COR_GROUPING)
	return (0);
    fprintf(stderr, "Grouping::equals not yet implemented \n");
    return(0);
}

/*************************************************************************/

/*------------------------------------------------------------------
 *::hash(BindEnv *env)

	Compute the hash/hashcons value of (this) interpreted in env.

  ArgList::hash(BitVector& bv, BindEnv *env)

	Computes the hash value of the set of arguments specified by
	bitvector bv.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

HashVal ArgList::hash(BitVector& bv, BindEnv* env )
{
    HashVal ihash = 0;
    HashVal arg_hash;
    register int bv_i;
    for (bv_i=0; bv_i < count(); bv_i++) {
	if (bv.test(bv_i)) {
	    // should probably also check that "bv" has the right count.
	    arg_hash = (*this)[bv_i]->hash(env);
	    if (arg_hash == VarHashValue)
		return arg_hash;
	    ihash = (ihash * 31) ^ arg_hash;
	}
    } 
    return IntToHash(ihash);
}

HashVal ArgList::hash(BindEnv* env )
{
    HashVal ihash = 0;
    HashVal arg_hash;
    register int bv_i;
    for (bv_i=0; bv_i < count(); bv_i++) {
	arg_hash = (*this)[bv_i]->hash(env);
	if (arg_hash == VarHashValue)
	    return arg_hash;
	ihash = (ihash * 31) ^ arg_hash;
    } 
    return IntToHash(ihash);
}


HashVal Arg::hash(BindEnv* /*env = 0*/) 
{
    // Default function - overridden in subclasses.
    return VarHashValue;
}


#if USE_HASHCONSING
int equal_funcargs(void *a, void*b)
{
  FuncArg *fa = (FuncArg *)a;
  FuncArg *fb = (FuncArg *)b;
  int i;
  
  if (fa->functor() != fb->functor() || fa->arity() != fb->arity())
    return(0);
  
  /** Each of the tests in the following loop should be constant time,
   * since the args are ground, and hashconsing is used,
   * and the hash values of the args should have been computed
   * already.
   **/
  for(i=0; i < fa->arity(); i++)
    if ( ! fa->args[i]->equals(fb->args[i]) ) 
      return(0);
  return(1);
}

CoreHashTable *hashcons_table;
void createFunctorTable()
{
  hashcons_table = new CoreHashTable(equal_funcargs, 1000);
}

/** the creation of CoreHashTable *hashcons_table has been added to init_coral.
    This is so that defaults from exEnv can be used in it. 
 CoreHashTable hashcons_table(equal_funcargs, 1000);

**/

/** WARNING:  the only FuncArg addresses may be entered into 
  hashcons_table - inserting anything else will cause the 
  system to crash! 
  Further, the addresses inserted should not be equal to 
  VarHashValue or UnknownHashValue!!
  **/
#endif

HashVal FuncArg::hash(BindEnv *env /*= 0*/) 
{
    if ( isGroundHashValue(_hash) )
	return _hash;
    int i;
    int is_const = 1;
    if ( _hash == VarHashValue && env == NULL ) // FuncArg has variables,
			// and they are definitely not bound.
	return VarHashValue;


#define MAX_HASH_ARITY  8
    HashVal *hash_vals;
    HashVal hashval_tab[MAX_HASH_ARITY];
	/** Optimization to reduce calls to new and delete **/
    if (arity() <= MAX_HASH_ARITY)
	hash_vals = hashval_tab;
    else hash_vals = new HashVal[arity()];

    HashVal ihash = SymbolHash(_functor);
    _hash = VarHashValue;
    i=-1;
    FOR_EACH_ARG(farg, args) {
	hash_vals[++i] = farg->hash(env);
	if (hash_vals[i] == VarHashValue) {
	    if ( arity() > MAX_HASH_ARITY) 
		delete [arity()] hash_vals;
	    return VarHashValue;
	}
	if ( ! farg->isConstant() ) /* Guaranteed to take constant time for
					all system defined types */
	    is_const = 0;
	ihash = (ihash * 3) ^ hash_vals[i];
    } END_EACH_ARG;

    if (is_const) {
#if USE_HASHCONSING
        _hash = (HashVal) hashcons_table->insert(this, IntToHash(ihash));
#else
        _hash = IntToHash(ihash);
#endif
	if ( arity() > MAX_HASH_ARITY) 
	    delete [arity()] hash_vals;
        return (_hash);
    }

#if USE_HASHCONSING

    // Otherwise, a new functor must be created
    FuncArg *fa = FuncArg::New(functor(), arity());
    for(i=0; i<arity(); i++) {
	if ( args[i]->isConstant() )
	    fa->args[i] = args[i];
	else if (args[i]->kindof()==COR_VARIABLE) {
	    ASSERT(env != NULL);
	    Term t = ((VarArg *)args[i])->dereference(env);
	    ASSERT(t.expr!=NULL && t.expr->kindof() != COR_VARIABLE);
	    if (t.expr->isConstant())
		fa->args[i] = t.expr;
	    else {
		ASSERT(t.expr->kindof()==COR_FUNCTOR);
		fa->args[i] = (Arg *) (hash_vals[i]);  
	    }
	}
	else {
	    ASSERT(args[i]->kindof()==COR_FUNCTOR);
	    fa->args[i] = (Arg *) (hash_vals[i]);  
			// arg[i] is a ground FuncArg. Since hashconsing 
			//	is used, the hash value of each such arg 
			//	is a pointer to a constant term that is 
			//	equal to the arg
	}
   }
   HashVal tmp_hash ; int to_delete = 1 ;
   tmp_hash = (HashVal) hashcons_table->insert(fa, IntToHash(ihash), to_delete);

   // Make sure that fa wasn't deleted inside insert()
   if (!to_delete) fa->_hash = tmp_hash ;
#ifdef DEBUG
   else {
     int size = sizeof(FuncArg) + arity() * sizeof(ArgPtr);
     C_DeleteFunctorCount++;
     C_DeleteFunctorSize+=size;
   }
#endif

   if ( arity() > MAX_HASH_ARITY) 
       delete [arity()] hash_vals;
   return tmp_hash;
#else
   if ( arity() > MAX_HASH_ARITY) 
       delete [arity()] hash_vals;
   return IntToHash(ihash);
#endif
}


HashVal VarArg::hash(BindEnv *env /*= 0*/) 
{
    if (env == NULL) return VarHashValue;
    Term term = env->lookup(var);
    if (term.expr == NULL) return VarHashValue;
    return term.expr->hash(term.bindenv);
}

/*************************************************************************/

const Numeric * Arg::numeric() const { return NULL; }

/*************************************************************************/

/*------------------------------------------------------------------
 *::scan_vars(void *data, VarFunc *func)

	Executes the specified function for each variable in (this).
	- this is the first argument of the function call.
	- data is the second argument of the function call.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/

int Arg::scan_vars(void *, VarFunc *)
{
    return 0;
}

int VarArg::scan_vars(void *data, VarFunc *func)
{
    return func(this, data);
}

int FuncArg::scan_vars(void *data, VarFunc *func)
{
    FOR_EACH_ARG(arg, this->args) {
	int code = arg->scan_vars(data, func);
	if (code) return code;
    } END_EACH_ARG
}

/*************************************************************************/

int NumArg::compare(const Root& other) const
{
    return (unsigned long)this - (unsigned long)&other;
}

void NumArg::print(BindEnv*, FILE *file) const
{
    this->printon(file);
}

void NumArg::print(BindEnv*, FILE *file, char *fmt_str) const
{
    this->printon(file, fmt_str);
}

void NumArg::sprint(char* str, int* pos, BindEnv *) const
{
    sprintf(str + *pos, "%s", "<some number>") ;
    *pos += strlen("<some number>") ;
}

/************************************************************************/


#include "globals.h"

void DumpCounts(FILE *fd = stdout)
{
    fprintf(fd, 
	"[Tuples:  Constructs: %d (size: %d), Destructs: %d (size: %d)]\n",
	    C_NewTupleCount, C_NewTupleSize,
	    C_DeleteTupleCount, C_DeleteTupleSize);
    fprintf(fd, 
	"[BindEnv: Constructs: %d (size: %d), Destructs: %d (size: %d)]\n",
    	  C_ConstructEnvCount, C_ConstructEnvSize,
    	  C_DestructEnvCount, C_DestructEnvSize);
    fprintf(fd,
	    "[Functor Constructs: %d (size: %d), Destructs: %d (size: %d)]\n",
	    C_NewFunctorCount, C_NewFunctorSize,
	    C_DeleteFunctorCount, C_DeleteFunctorSize);
    fprintf(fd, "[ArgList Constructs: %d (size: %d)]\n",
    	C_NewArgListCount, C_NewArgListSize);
    fprintf(fd, "[Integer constructs: %d, Double constructs: %d]\n",
	 C_NewIntCount, C_NewDoubleCount);
    fprintf(fd, "[Arrays: construct size: %d, destruct size: %d]\n",
	C_NewGArraySize, C_DeleteGArraySize );
    fprintf(fd, 
	"[HashIndex: constructs: %d (size: %d), destructs %d (size: %d)]\n",
	  C_NewHashIndex, C_NewHashIndexSize,
	  C_DeleteHashIndex, C_DeleteHashIndexSize) ;
    fprintf(fd, "[HashRelation: constructs: %d, destructs: %d]\n",
	  C_NewHashRelation, C_DeleteHashRelation);
    /**********
    fprintf(fd, "[PipelinedExecInfo: Constructs: %d, Destructs: %d]\n",
    	C_PipelinedConstructs, C_PipelinedDestructs);
    fprintf(fd, "[TupleIterators: construct size: %d, destruct size: %d]\n",
	  C_tupleiterConstructs * sizeof(TupleIterator),
	  C_tupleiterDestructs * sizeof(TupleIterator));
    ***********/
}

void ResetCounts()
{
	C_NewTupleCount = C_NewTupleSize = 0;
	C_DeleteTupleCount = C_DeleteTupleSize = 0;
	C_ConstructEnvCount = C_ConstructEnvSize = 0;
	C_DestructEnvCount = C_DestructEnvSize = 0;
	C_NewFunctorCount = C_NewFunctorSize = 0;
	C_NewArgListCount = C_NewArgListSize = 0;
	C_NewIntCount = C_NewDoubleCount = 0;
	C_NewGArraySize = C_DeleteGArraySize = 0;
	C_NewHashIndex =  C_NewHashIndexSize = 0;
	C_DeleteHashIndex =  C_DeleteHashIndexSize = 0;
	C_NewHashRelation = C_DeleteHashRelation = 0;

}

struct CountDummy {
     CountDummy() { };
    ~CountDummy() { if (exEnv.profile_scc) DumpCounts(); }
};
static CountDummy foo;


#ifdef DO_GC
void VarArg::GCPointers() { }

void FuncArg::GCPointers()
{
    register int i = args.count();
    register Arg** arg_vec = args.first();
    for ( ;--i >= 0; arg_vec++) {
	gcpointer(*arg_vec);
    }
}
#endif


void NumArg::dump(int , FILE *)
{
}

void Double::dump(int , FILE *)
{
}

void FixInt::dump(int , FILE *)
{
}

void SmallInt::dump(int , FILE *)
{
}

void Symbol::dump(int , FILE *)
{
}

void DontCareArg::dump(int , FILE *)
{
}

void VarArg::dump(int , FILE *)
{
}

void FuncArg::dump(int , FILE *)
{
}

void Grouping::dump(int , FILE *)
{
}

/*******************************************/

extern const Arg *AddOp(const Arg*, const Arg*);
extern const Arg *SubOp(const Arg*, const Arg*);
extern const Arg *MulOp(const Arg*, const Arg*);
extern const Arg *DivOp(const Arg*, const Arg*);
extern const Arg *LShiftOp(const Arg*, const Arg*);
extern const Arg *RShiftOp(const Arg*, const Arg*);
extern const Arg *BitxorOp(const Arg*, const Arg*);
extern const Arg *BitandOp(const Arg*, const Arg*);
extern const Arg *BitorOp(const Arg*, const Arg*);
extern const Arg *ModOp(const Arg*, const Arg*);

numarg_kind ExprArg::num_kindof() const
{
    return COR_ARITH_EXPR;
}

Arg *ExprArg::simplify(BindEnv *context, TermLink *&renamed_vars, 
		    BindEnv *const_env, BindEnv *rename_only_env)
{
    if (op_arity == 1) {
	if (op == SubOpSymbol) {
	    return (Numeric *) SubOp(Zero, left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == BitnotOpSymbol) {
	    return (Numeric *) BitxorOp(MinusOne, left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else {
	    fprintf(stderr, "Unknown operator %s", SymbolString(op));
	    fflush(stderr);
	    return (Arg *) Zero;
	       // if NULL is returned, it might crash straightaway
	       // this way it continues execution
	}
    }
    else {
        ASSERT((op_arity == 2));
	if (op == AddOpSymbol) {
	    return (Numeric *) AddOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == SubOpSymbol) {
	    return (Numeric *) SubOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == MulOpSymbol) {
	    return (Numeric *) MulOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == DivOpSymbol) {
	    return (Numeric *) DivOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == IDivOpSymbol) {
	    return (Numeric *) DivOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	    // WARNING: this may have to be changed if IDivOp is defined!
	}
	else if (op == LShiftOpSymbol) {
	    return (Numeric *) LShiftOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == RShiftOpSymbol) {
	    return (Numeric *) RShiftOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == BitxorOpSymbol) {
	    return (Numeric *) BitxorOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == BitandOpSymbol) {
	    return (Numeric *) BitandOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == BitorOpSymbol) {
	    return (Numeric *) BitorOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else if (op == ModOpSymbol) {
	    return (Numeric *) ModOp(left_arg->simplify(context,
		renamed_vars, const_env, rename_only_env), 
		right_arg->simplify(context,
		renamed_vars, const_env, rename_only_env));
	}
	else {
	    fprintf(stderr, "Unknown operator %s", SymbolString(op));
	    fflush(stderr);
	    return (Arg *) Zero;
	}
    }
}

HashVal ExprArg::hash(BindEnv *context)
{
    TermLink *renamed_vars = NULL;
    Arg *a1 = simplify(context, renamed_vars, context, NULL);
    if (a1)
      return a1->hash(context);
    else return VarHashValue;
}

/** Tarun **/
void ExprArg::print_dump(BindEnv *env, FILE *file) const
{
    fprintf(file, "\"");
    print(env, file);
    fprintf(file, "\"");
}

void ExprArg::print(BindEnv *env, FILE *file) const
{
    fprintf(file, "(");
    if (op_arity == 1) {
    if (op == SubOpSymbol) {
        fprintf(file, "-");
        left_arg->print(env, file);
    }
    else {
        fprintf(stderr, "Unknown operator %s", SymbolString(op));
        fflush(stderr);
        Zero->print(env, file);
    }
    }
    else {
        ASSERT((op_arity == 2));
    left_arg->print(env, file);
    if (op == AddOpSymbol) {
        fprintf(file, "+");
    }
    else if (op == SubOpSymbol) {
        fprintf(file, "-");
    }
    else if (op == MulOpSymbol) {
        fprintf(file, "*");
    }
    else if (op == DivOpSymbol) {
        fprintf(file, "/");
    }
    else if (op == IDivOpSymbol) {
        fprintf(file, "//");
    }
    else if (op == LShiftOpSymbol) {
        fprintf(file, "<<");
    }
    else if (op == RShiftOpSymbol) {
        fprintf(file, ">>");
    }
    else if (op == BitxorOpSymbol) {
        fprintf(file, SymbolString(BitxorOpSymbol));
    }
    else if (op == BitandOpSymbol) {
        fprintf(file, SymbolString(BitandOpSymbol));
    }
    else if (op == BitorOpSymbol) {
        fprintf(file, SymbolString(BitorOpSymbol));
    }
    else if (op == BitnotOpSymbol) {
        fprintf(file, SymbolString(BitnotOpSymbol));
    }
    else if (op == ModOpSymbol) {
        fprintf(file, " mod ");
    }
    else {
        fprintf(stderr, "Unknown operator %s", SymbolString(op));
        fflush(stderr);
    }
    right_arg->print(env, file);
    }
    fprintf(file, ")");
}

void ExprArg::printon(FILE *file) const
{
    fprintf(file, "(");
    if (op_arity == 1) {
	if (op == SubOpSymbol) {
	    fprintf(file, "-");
	    left_arg->printon(file);
	}
	else {
	    fprintf(stderr, "Unknown operator %s", SymbolString(op));
	    fflush(stderr);
	    Zero->printon(file);
	}
    }
    else {
        ASSERT((op_arity == 2));
	left_arg->printon(file);
	if (op == AddOpSymbol) {
	    fprintf(file, "+");
	}
	else if (op == SubOpSymbol) {
	    fprintf(file, "-");
	}
	else if (op == MulOpSymbol) {
	    fprintf(file, "*");
	}
	else if (op == DivOpSymbol) {
	    fprintf(file, "/");
	}
	else if (op == IDivOpSymbol) {
	    fprintf(file, "//");
	}
	else if (op == LShiftOpSymbol) {
	    fprintf(file, "<<");
	}
	else if (op == RShiftOpSymbol) {
	    fprintf(file, ">>");
	}
	else if (op == BitxorOpSymbol) {
	    fprintf(file, SymbolString(BitxorOpSymbol));
	}
	else if (op == BitandOpSymbol) {
	    fprintf(file, SymbolString(BitandOpSymbol));
	}
	else if (op == BitorOpSymbol) {
	    fprintf(file, SymbolString(BitorOpSymbol));
	}
	else if (op == BitnotOpSymbol) {
	    fprintf(file, SymbolString(BitnotOpSymbol));
	}
	else if (op == ModOpSymbol) {
	    fprintf(file, " mod ");
	}
	else {
	    fprintf(stderr, "Unknown operator %s", SymbolString(op));
	    fflush(stderr);
	}
	right_arg->printon(file);
    }
    fprintf(file, ")");
}

void ExprArg::printon(FILE *, char *) const
{
}

void ExprArg::dump(int , FILE *)
{
}
