/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef __GNUC__
#include <malloc.h>
#endif
#include <new.h>
#include <strings.h>

#include "rules.h"
#include "externs.h"
#include "globals.h"

#include "interp.h"
extern char *simplify_index(ArgList *pat, int n_var, ArgList *boundvars);
extern int count_var_list(VarLink *rest);
extern int subsumes_arg_lists(ArgList& left, ArgList& right,
    BindEnv *left_bindings, BindEnv *right_bindings);
extern void sprint_adornment(char *buf, BitVector* a);

/********************************************************************/

/*************** Annotation code ************************************/

int duplicate_index(PredAnnotations *annos, Symbol *pred,
		     BitVector *bv,ArgList *al1, int num_vars, ArgList *al2)
{
  StackMark stackmark;
  char buf[500];

  for (; annos; annos = annos->next()) {

   // sprintf(buf, "%s", SymbolString(pred));
    sprintf(buf, "%s", SymbolString(annos->pred));
    if (annos->adorn)
	sprint_adornment(buf+strlen(buf), annos->adorn);

    if (((pred == annos->pred) || (pred == EnterSymbol(buf))) && 
	((bv == annos->adorn) ||
		      (bv && annos->adorn && (*bv == *(annos->adorn))))) { 
      if (!al2 && !annos->arglist2)
	if ((*al1)[0] == ((*(annos->arglist1))[0])) return 1;
      else if (al2 && annos->arglist2) {
	ArrayBindEnv pat_env1(num_vars);
	ArrayBindEnv pat_env2(num_vars);
	ArrayBindEnv pat_env3(num_vars);
	ArrayBindEnv pat_env4(num_vars);

	/** check if pattern and the var_names of each subsume 
	  that of the other **/
	
	if ((subsumes_arg_lists(*concat_arglists(al1, al2), 
		     *concat_arglists(annos->arglist1, annos->arglist2),
			    &pat_env1, &pat_env2) == COR_U_SUCCEED) &&
	    (subsumes_arg_lists(
		     *concat_arglists(annos->arglist1, annos->arglist2),
		     *concat_arglists(al1, al2),
				&pat_env3, &pat_env4) == COR_U_SUCCEED)) {
	  stackmark.pop_to();
	  return 1;
	}
	  
	
      }
    }
    stackmark.pop_to();
  }

  // for good measure
  stackmark.pop_to();
  return 0;
}

void add_make_index_annotation(PredAnnotations *& annos, Symbol *pred,
			       Symbol *adorn_string,ArgList *al1, ArgList *al2)
{


  BitVector *bitv = NULL;
  if (adorn_string) {
    bitv = new BitVector(SymbolLength(adorn_string));
    int i;
    char *ap;
    for(i=0,ap = SymbolString(adorn_string);i<SymbolLength(adorn_string); 
	i++, ap++) 
      if ( *ap == 'b') bitv->set(i);
  }

  VarLink *rest;
  char *argindex = NULL;
  int num_vars = 0;

  if (al2) {
    rest = al1->var_list(NULL);
    rest = al2->var_list(rest);
    num_vars = count_var_list(rest);
    argindex = simplify_index(al1, num_vars , al2);
  }

  if (argindex) {
    al1 = ArgList::New(1);
    (*al1)[0] = EnterSymbol(argindex);
    al2 = NULL;
  }

  if (duplicate_index(annos, pred, 
		      bitv, al1, num_vars, al2)) {
    return;
  }
  
  PredAnnotations *pa = 
    new PredAnnotations (pred, annos);
			 
  pa->arglist1=al1;
  pa->arglist2=al2;
  pa->adorn = bitv;
  annos = pa;
}

/* WARNING:
	The bitvector passed to this function must be on static storage.
	It is not copied out.
*/


void add_make_index_annotation(PredAnnotations*& annos, Symbol *pred,
			       BitVector *bv,
			       ArgList *al1, ArgList *al2)
{
  VarLink *rest;
  char *argindex = NULL;
  int num_vars = 0;

  if (al2) {
    rest = al1->var_list(NULL);
    rest = al2->var_list(rest);
    num_vars = count_var_list(rest);
    argindex = simplify_index(al1, num_vars, al2);
  }

  if (argindex) {
    al1 = ArgList::New(1);
    (*al1)[0] = EnterSymbol(argindex);
    al2 = NULL;
  }

  if (duplicate_index(annos, pred, 
		      bv, al1, num_vars, al2)) {
    return;
  }
  PredAnnotations *pa = 
    new PredAnnotations (pred, annos);
  pa->arglist1=al1;
  pa->arglist2=al2;
  pa->adorn = bv;
  annos = pa;
}


void add_prioritize_annotation(ParserStruct& parserStruct, Symbol *pred,
                        Symbol *adorn_string, ArgList *al1, Arg *op_arg)
{
    PredAnnotations *pa = new PredAnnotations (pred,
      parserStruct.prioritize_annotations);
    pa->arglist1=al1;
    pa->arglist2=NULL;
    if (adorn_string) { /* adornment specified */
      int i;
      char *ap;
      pa->adorn = new BitVector(SymbolLength(adorn_string));
      for(i=0,ap = SymbolString(adorn_string); i<SymbolLength(adorn_string);
                              i++, ap++)
          if ( *ap == 'b') pa->adorn->set(i);
    }
    else pa->adorn = NULL;
    pa->op_arg = op_arg;
    parserStruct.prioritize_annotations = pa;
    parserStruct.CurModule.HasPrioritize = 1;
}

void add_agg_sel_annotation(ParserStruct& parserStruct,
			Symbol *pred, Symbol *adorn_string,
			ArgList *al1, ArgList *al2, Arg *op_arg)
{

    PredAnnotations *pa = new PredAnnotations (pred,
	parserStruct.agg_sel_annotations);
    pa->arglist1=al1;
    pa->arglist2=al2;
    if (adorn_string) { /* adornment specified */
	int i;
	char *ap;
	pa->adorn = new BitVector(SymbolLength(adorn_string));
	for(i=0,ap = SymbolString(adorn_string); i<SymbolLength(adorn_string);
				i++, ap++)
	    if ( *ap == 'b') pa->adorn->set(i);
    }
    else pa->adorn = NULL;
    pa->op_arg = op_arg;
    parserStruct.agg_sel_annotations = pa;
}

/************************************
 * divesh:
 * void add_allowed_adornment(Name pred_name, ArgList* args);
 * void add_allowed_adornment(Name pred_name, char* adorn_string,
 *		int adorn_length);
 * void add_disallowed_adornment(Name pred_name, ArgList* args);
 * void add_disallowed_adornment(Name pred_name, char* adorn_string,
 *              int adorn_length);
 * allow for 'a' (for any) to be specified along with 'b' and 'f'
************************************/

extern void add_allowed_adornment(ParserStruct&, Name, char*, int);
extern void add_disallowed_adornment(ParserStruct&, Name, char*, int);

void add_allowed_adornment(ParserStruct& parserStruct, Name pred_name,
			   ArgList* args)
{
    for (int i=0;i < args->count();i++) {
	if ((*args)[i]->kindof() != COR_SYMBOL_CONST) {
	    fprintf(stderr, "Bad kind of adornment for allowed adorns %s.\n",
			pred_name->string());
	    continue;
	}
	Name adornname = (Name)(*args)[i];

	add_allowed_adornment(parserStruct, pred_name, adornname->string(), 
			adornname->length());
    }
}

void add_allowed_adornment(ParserStruct& parserStruct, Name pred_name,
			   char* adorn_string, int adorn_length)
{
    char *temp_adorn_string = adorn_string;

    for (int i=0; i < adorn_length;i++) {
	char adorn_char = *temp_adorn_string++;
	switch (adorn_char) {
	    case 'b':
		break;
	    case 'f':
		break;
	    case 'a':
		{
		char *new_adorns = new char[adorn_length+1];
		strcpy(new_adorns, adorn_string);
		new_adorns[i] = 'b';
		add_allowed_adornment(parserStruct, pred_name, new_adorns,
				      adorn_length);
		new_adorns[i] = 'f';
		add_allowed_adornment(parserStruct, pred_name, new_adorns,
				      adorn_length);
		delete new_adorns;
		return;
		}
	    default:
		fprintf(stderr, "Bad character in adornment string '%s'\n",
			adorn_string);	
		return;
	}
    }

    // should come here only if all the characters in adorn_string are
    // either 'b' or 'f'

    BitVector *bv = new BitVector();

    ConvertAdornment(*bv, adorn_string, adorn_length); 
    PredAnnotations *pa = new PredAnnotations (pred_name, 
			      parserStruct.AllowedAdornList);
    pa->arglist1=pa->arglist2=NULL;
    pa->adorn = bv;
    parserStruct.AllowedAdornList = pa;
}

void add_disallowed_adornment(ParserStruct& parserStruct, Name pred_name,
			      ArgList* args)
{
    for (int i=0;i < args->count();i++) {
	if ((*args)[i]->kindof() != COR_SYMBOL_CONST) {
	    fprintf(stderr, "Bad kind of adornment for disallowed adorns %s.\n",
			pred_name->string());
	    continue;
	}
	Name adornname = (Name)(*args)[i];

	add_disallowed_adornment(parserStruct, pred_name, adornname->string(), 
			adornname->length());
    }
}

void add_disallowed_adornment(ParserStruct& parserStruct, Name pred_name, 
			      char* adorn_string, int adorn_length) 
{
    char *temp_adorn_string = adorn_string;

    for (int i=0; i < adorn_length;i++) {
	char adorn_char = *temp_adorn_string++;
	switch (adorn_char) {
	    case 'b':
		break;
	    case 'f':
		break;
	    case 'a': 
		{
		char *new_adorns = new char[adorn_length+1];
		strcpy(new_adorns, adorn_string);
		new_adorns[i] = 'b';
		add_disallowed_adornment(parserStruct, pred_name, new_adorns,
					 adorn_length);
		new_adorns[i] = 'f';
		add_disallowed_adornment(parserStruct, pred_name, new_adorns,
					 adorn_length);
		delete new_adorns;
		return;
		}
	    default:
		fprintf(stderr, "Bad character in adornment string '%s'\n",
			adorn_string);	
		return;
	}
    }

    // should come here only if all the characters in adorn_string are
    // either 'b' or 'f'

    BitVector *bv = new BitVector();

    ConvertAdornment(*bv, adorn_string, adorn_length); 
    PredAnnotations *pa = new PredAnnotations (pred_name, 
			      parserStruct.DisallowedAdornList);
    pa->arglist1=pa->arglist2=NULL;
    pa->adorn = bv;
    parserStruct.DisallowedAdornList = pa;
}

void add_multiset_annotation(ParserStruct& parserStruct, Symbol *pred,
			     ArgList *al1, int check_subsum)
{

    if (al1->count()) {
	FOR_EACH_ARG(arg,*al1) {
	    if(arg->kindof() != COR_SYMBOL_CONST)
		fprintf(stderr, 
			"Error: Bad argument to multiset annotation for %s\n", 
			pred->string() );
	    else {
                PredAnnotations *pa = new PredAnnotations (pred,
			       parserStruct.MultisetAnnotations);
    		pa->arglist1=NULL;
		pa->check_subsum = check_subsum;
    		parserStruct.MultisetAnnotations = pa;
		Symbol *adorn_string = (Symbol *)arg;
		int i;
		char *ap;
		pa->adorn = new BitVector(SymbolLength(adorn_string));
		for(i=0,ap = SymbolString(adorn_string); 
				i<SymbolLength(adorn_string); i++, ap++) 
	    	    if ( *ap == 'b') pa->adorn->set(i);
	    }

	} END_EACH_ARG
    }
    else {
        PredAnnotations *pa = new PredAnnotations (pred,
		       parserStruct.MultisetAnnotations);
        pa->arglist1=al1;
	pa->adorn = NULL;
	pa->check_subsum = check_subsum;
        parserStruct.MultisetAnnotations = pa;
    }

}

void update_anno_list(Name name, BitVector &adorn, PredAnnotations *anno) 
{
    for (; anno != NULL; anno = anno->next()) {
      if (anno->pred == name && anno->adorn == NULL) {
          PredAnnotations *newanno = new PredAnnotations(anno->pred, NULL);
          *newanno = *anno;
          BitVector *newvec = new BitVector();
          *newvec = adorn;
          newanno->adorn = newvec;
          newanno->link(anno->next());
          anno->link(newanno);
      }
    }
}

void update_annotations(Name name, BitVector& adorn)
{
    update_anno_list(name, adorn, parserStruct.MultisetAnnotations);
    update_anno_list(name, adorn, parserStruct.agg_sel_annotations);
    update_anno_list(name, adorn, parserStruct.make_index_annotations);
    update_anno_list(name, adorn, parserStruct.prioritize_annotations);
    /* WARNING:  If more annotations are added, update this procedure
     as well as the printing procedures in unparse.C */
}



void annotation_error(PredAnnotations *anno, char *msg) 
{
    fprintf(stderr, "** Error in annotation: \n");
    anno->print(stderr);
    fprintf(stderr, "\n       -- %s.\n", msg);
}

void add_index_delta_annotation(ParserStruct& , 
				Symbol *, ArgList *)
{
    fprintf(stderr, "Sorry - add_index_delta_annotation not yet implemented\n");
}

void add_index_delta_annotation()
{
    fprintf(stderr, "Sorry - add_index_delta_annotation not yet implemented\n");
}


RuleAnnoCaseDetails *make_anno_case_details( Symbol *)
{
	return NULL;
}

RuleAnnoCaseDetails *make_anno_case_details( ArgPtr )
{
	return NULL;
}

RuleAnnoCaseDetails *make_anno_case_details( RuleAnnoCase *)
{
	return NULL;
}

RuleAnnoCaseName *make_anno_case_name(Symbol *)
{
	return NULL;
}

RuleAnnoCaseName *make_anno_case_name(ArgPtr)
{
	return NULL;
}

RuleAnnoCase *link_anno_case_list( RuleAnnoCase*, RuleAnnoCase*)
{
	return NULL;
}

RuleAnno *link_rule_anno(RuleAnno*, RuleAnno*)
{
	return NULL;
}


RuleAnnoCase *make_anno_case(RuleAnnoCaseName*, RuleAnnoCaseDetails*)
{
	return NULL;
}

RuleAnno     *make_anno(Symbol *, RuleAnnoCaseDetails*)
{
	return NULL;
}

