/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef PERSISTENT_REL_H
#define PERSISTENT_REL_H
#include "generic-sm.h"
#include "generic-rel.h"

#define Scanning_Persistent 1

class PersistentRel : public Relation {
 private:

  OID            oid;           // OID of FileDescStruct of the relation
  FileDescStruct fd;		// File descriptor

// Need representation of field types

  void insertObject(ArgList &arglist) ;
  Tuple *fileScanGetNext(TupleIterator &, int delete_flag = 0) ;
  Tuple *indexScanGetNext(TupleIterator&, int, int delete_flag = 0);

  // Returns position where an index entry can be made
  int canAddIndex() { return fd.canAddIndex() ;} ;
  Tuple *checkTuple(USERDESC *, TupleIterator&) ;
  int findIndex(TupleIterator&);

 public:
  PersistentRel(Name name, int arity, int& error);
  virtual void release(TupleIterator& iterator) ;
  virtual void print_name(FILE *file);
  virtual void print_facts(FILE *file, ArgList *arglist = NULL) const ;
  virtual BindEnv *get_next(TupleIterator&);
  virtual Tuple  *get_next_tuple(TupleIterator&) ;
  virtual int insert_tuple(Tuple *tuple);
  virtual int insert_new(ArgList& args, BindEnv* env,
			 BindEnv *dont_rename_env = NULL,
			 Tuple *parent_goal = NULL,
			 int dont_rename = 0); 
  
/**
  virtual int add_index(char *s, int dummy = -1);
  virtual int add_index(ArgList *args, int dummy = -1);
**/
  virtual int add_index(char *s, int dummy);
  virtual int add_index(ArgList *args, int dummy);

  virtual int tuple_delete(Tuple *tuple);
  // Empty tuples out of the relation
  virtual void empty_relation(int delete_tuples = 0); 
  void initialize_iterator( TupleIterator& );
  virtual int is_subsumed(Tuple *tuple, RMark *startmark= NULL, 
			RMark *endmark = NULL);

};

#endif 


