/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef GENERIC_SM_H
#define GENERIC_SM_H
#include "globals.h"
#include <stdio.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <libc.h>
#include <malloc.h>
#include <osfcn.h>
#include <setjmp.h>
#include "sm_client.h"

/*-- Macros that will soon be in sm_client.h !! --*/
#define INVALIDATE_VOLID(_vid)  (_vid = 0)
#define VOLID_IS_INVALID(_vid)  (_vid == 0)

#define INVALIDATE_BUFGROUP(_buffer) (_buffer = -1)
#define BUFGROUP_IS_INVALID(_buffer) (_buffer == -1)

#define INVALIDATE_CURSOR(_cur) (INVALIDATE_BUFGROUP((_cur).groupIndex))
#define CURSOR_IS_INVALID(_cur) (BUFGROUP_IS_INVALID((_cur).groupIndex))

//#define INVALIDATE_FID(_fid)    ((_fid).pid.volid = 0)
//#define FID_IS_INVALID(_fid)    ((_fid).pid.volid == 0)

//#define INVALIDATE_IID(_iid)    ((_iid).volid = 0)
//#define IID_IS_INVALID(_iid)    ((_iid).volid == 0)

//#define INVALIDATE_OID(_oid)    ((_oid).diskAddr.volid = 0)
//#define OID_IS_INVALID(_oid)    ((_oid).diskAddr.volid == 0)

//#define INVALIDATE_TID(_tid)    (_tid = NULL_TID)
//#define TID_IS_INVALID(_tid)    (_tid == NULL_TID)

//#define INVALIDATE_CURSOR(_cursor) ((_cursor).ndx.volid = 0)
//#define CURSOR_IS_INVALID(_cursor) ((_cursor).ndx.volid == 0)
/* ----------------------------------------------*/


class BufferGroup ;
class Transaction ;
class PersistentRel ;
class Catalog ;

extern int ErrorCheck(int, char *) ;

typedef enum {
  COR_INT_DBTYPE,
  COR_DOUBLE_DBTYPE,
  COR_STRING_DBTYPE,
  COR_INVALID_DBTYPE,
  } DBTermType ;
		 

/*
 * Class definition of a schema description
 */
class Schema {
  public :

  DBTermType  types[COR_MAX_ARGLIST_SIZE] ;
  int arity ;

  // Takes a schema definition as an ArgList
  Schema(ArgList &arglist, int& error) ;
  Schema() { arity = 0 ;};

  void operator=(Schema& schema2);
  DBTermType operator[](int index) {
    return (index < COR_MAX_ARGLIST_SIZE) ? types[index] : COR_INVALID_DBTYPE ;
  };

  void printon(FILE *outf) ;
  
};

/*
 * Class description of an index
 */
typedef enum {COR_BPLUSTREE, COR_HASHTABLE} PersIndexKind ;

// Dummy generic class declaration. In case hash indexes are added later.
class PersistentIndex {
  public :
  // Number of attributes on which the indexis created
  int arity;
//  virtual void operator=(PersistentIndex& index2) = 0 ;
  virtual PersIndexKind kindof() = 0 ;
  virtual int valid() = 0 ;
  virtual void create(char *, int, int) = 0 ;
  virtual void insert(USERDESC *, Schema&) = 0;
  virtual int matches(char *, int) = 0;
  virtual void destroy() = 0 ;
  virtual void print_adornment(FILE *outf) = 0;
};

class BPlusTreeIndex : public PersistentIndex {
  public :
  IID 	iid ;				// Index id
  char 	attrs[COR_MAX_ARGLIST_SIZE] ; 	// Specifies which attributes the index
					// is on. A non-zero value of an entry
					// implies that the index is based on
					// the corresponding attribute of the
					// relation
  virtual void operator=(BPlusTreeIndex& index2) {
    for (int i = 0; i < COR_MAX_ARGLIST_SIZE; i++ )
      attrs[i] = index2.attrs[i] ;
    iid = index2.iid ;
    arity = index2.arity ;
  };
  virtual PersIndexKind kindof() { return COR_BPLUSTREE; } ;
  virtual int  valid() { return !(IID_IS_INVALID(iid)) ;} ;
  BPlusTreeIndex() ;
  virtual void create(char *attr_str, int arity, int unique);
  virtual void insert(USERDESC *u_desc, Schema&);
  virtual int matches(char *attr_str, int arity);
  virtual void delete_entry(USERDESC *u_desc, Schema&);
  virtual void destroy() ;
  virtual void print_adornment(FILE *outf);  
};


/*
 * Structure of file descriptor object in catalog file on disk
 * Each field of the relation could possibly have an index.
 * This is sufficient because we are only considering ground
 * and flat tuples on disk.
 */
class FileDescStruct {
  friend class PersistentRel ;
  public :

  FileDescStruct() { INVALIDATE_FID(fid); num_indexes = 0 ; };

  // Takes schema description of a relation as a FuncArg parameter
  FileDescStruct( FuncArg *arg, int &error) ;

  FID		fid ;
  BPlusTreeIndex     indexes[COR_MAX_INDEXES] ;
  int           num_indexes ;
  Schema	schema ;
  int count;

  void copyDesc(FileDescStruct *);

  // Returns offset where an index entry can be made
  int canAddIndex();

  // Returns offset of the next valid index after offset i
  // The first time, this is called with i = -1
  int nextIndex(int i);

  // Adds an index at position 'offset' in the index array. The attributes
  // of the index are specified by buf.
  void addIndex(int offset, char *buf);

  // Delete an index whose offset is specified 
  void destroyIndex(int offset);

  // Adds an object to a specified index
  void addObjectToIndex(int offset, USERDESC *u_desc);

  // Find an index that best matches the given attr string
  virtual int findBestMatch(char *attr_str);

  // Return the arity of the specified index
  int indexArity(int index_offset) {
    return indexes[index_offset].arity ;
  };

  void print_index_adornments(FILE *outf);
};


class BufferGroup {
  public :
  int  bufGroup;
  FOUR size;
  int  policy;

  int open(FOUR size, int policy) {
    int e = sm_OpenBufferGroup(size, policy, &bufGroup, NOFLAGS);
    return ErrorCheck(e, "sm_OpenBufferGroup");
  };

  void close() ;

  BufferGroup() {INVALIDATE_BUFGROUP(bufGroup) ;};
  ~BufferGroup() {};
};


class Transaction {
  friend class StorageManager;

  private :
  TID tid;

  public :
  Transaction() {INVALIDATE_TID(tid) ;};

  void start() {
    if (TID_IS_INVALID(tid)) {
      int e = sm_BeginTransaction(&tid) ;
      ErrorCheck(e, "sm_BeginTransaction");
    }
  };
  int commit() ;

  void abort() {
    if (!TID_IS_INVALID(tid)) {
      int e = sm_AbortTransaction(tid);
      ErrorCheck(e, "sm_AbortTransaction");
    }
    INVALIDATE_TID(tid) ;
  };   

};

class Catalog {
  private :
  FID		cat_fid ;
  IID   	cat_iid ;

  public :
  // Check if a file is in the catalog
  int lookupFile(char *name, OID * oid) ;

  // Add a file to the catalog, and returns the FileDesc structure in obj
  int addFile(char *file_name, FileDescStruct *obj) ;

  // Delete a file from the catalog index
  int deleteFile(char *file_name, OID *oid) ;

  // Add an index to the catalog
  int addIndex(FileDescStruct *obj) ;

  // Initialize catalog
  int init(char *cat_file_name, char *cat_index_name) ;

  // List all files
  void listFiles(FILE *outf);

  // List all schemas
  void listSchemas(FILE *outf);

};

class StorageManager {

  private :
  Catalog        catalog ;
// Maybe this should have two buffer groups -- an MRU and an LRU
  BufferGroup    buf;
  Transaction    trans ;
  VOLID          _volid;

  public :
  StorageManager() { INVALIDATE_VOLID(_volid); };
  ~StorageManager() { shutdown() ;};
  void init() ;

  void shutdown() ;
  int bufGroup() { return buf.bufGroup ; } ;
  VOLID volid() { return _volid; } ;

  /* Transaction handling functions */

  void startTrans() {trans.start() ; };
  int commitTrans() {return trans.commit() ;};
  void abortTrans() {trans.abort() ;};


  /* Catalog handling functions */

  // Add a file to the catalog
  int addFile(Name name, int arity, FileDescStruct *obj);

  // Check if a file is in the catalog
  int lookupFile(Name name, int arity, OID* oid) ;

  // Delete a file from the catalog
  int deleteFile(Name name, int arity);

  // List all files/schemas
  void listFiles(FILE *outf);

  /* Object handling functions */

  // Retrieve an object specified by oid. Note that the object is PINNED
  // in the buffer pool !
  int retrieveObject(OID *oid, USERDESC ** u_desc) ;

  // Release (unpin) an object from the buffer pool.
  int releaseObject(USERDESC *u_desc) ;

  // Destroy an object. If bufGroup is 0, the object is in the catalog file.
  int destroyObject(OID *oid, int bufGroup);

};


extern StorageManager SM ;

#endif

