/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	more-builtins.C
	Contains some code for builtin relations, and some useful
	functions that are used by many builtin relations
 ***********************************************************************/
#ifdef WITH_PERSISTENCE

#include <stdio.h>
#include <string.h>
#include "builtin-rel.h"
#include "persistent-rel.h"

extern char *strip_quotes(char *);
extern int SM_initialized ;
extern int in_bulk_load;

/*------------------------------------------------------------------
  SchemaSolver()

  Solver function that is called when the builtin relation schema()
  is invoked.

 -------------------------------------------------------------------*/
BindEnv *SchemaSolver(BuiltinRelation&, TupleIterator& iterator)
{
  int cnt = 0 ;
  char err_str[100] ;

  if (!SM_initialized) {
    CORAL_error(COR_ESM_ERR, "dbserver not initialized", "SchemaSolver");
    iterator.set_no_match();
    return iterator.bindenv;
  }

    if (iterator.arg_list.count() > 0)
      {
	FOR_EACH_ARG(arg, iterator.arg_list){
	  cnt++ ;
	  if (arg->kindof() != COR_FUNCTOR) {
	    sprintf(err_str, "bad argument %d - should be a functor", cnt) ;
	    CORAL_error(COR_BAD_ARG_TYPE, err_str, "SchemaSolver") ;
	    iterator.set_no_match();
	    return iterator.bindenv;
	  }
	  
	  // Create a file descriptor for the new relation
	  int error = 0 ;
	  FileDescStruct *fd = new FileDescStruct((FuncArg *)arg, error) ;
	  
	  // Add the descriptor to the catalogs
	  if (!error)
	    SM.addFile(((FuncArg *)arg)->functor(),
		       ((FuncArg *)arg)->arity(), fd) ;
	  else {
	    CORAL_error(error, SymbolString(((FuncArg *)arg)->functor()),
			"SchemaSolver");
	    delete fd ;
	  }

	}END_EACH_ARG
      }
  return iterator.bindenv ;	  
}

/*------------------------------------------------------------------
  StartBulkLoadSolver()

  Solver function that is called when the builtin relation StartBulkLoad()
  is invoked.

 -------------------------------------------------------------------*/
BindEnv *StartBulkLoadSolver(BuiltinRelation& , TupleIterator& iterator)
{
  int cnt = 0 ;
  char err_str[100] ;

  if (!SM_initialized) {
    CORAL_error(COR_ESM_ERR, "dbserver not initialized", "SchemaSolver");
    iterator.set_no_match();
    return iterator.bindenv;
  }

  in_bulk_load = 1;

/*
  if (iterator.arg_list.count() > 0)
    {
      FOR_EACH_ARG(arg, iterator.arg_list){
	cnt++ ;
	if (arg->kindof() != COR_FUNCTOR) {
	  sprintf(err_str, "bad argument %d - should be a functor", cnt) ;
	  CORAL_error(COR_BAD_ARG_TYPE, err_str, "SchemaSolver") ;
	  iterator.set_no_match();
	  return iterator.bindenv;
	}
	
	// Create a file descriptor for the new relation
	  int error = 0 ;
	FileDescStruct *fd = new FileDescStruct((FuncArg *)arg, error) ;
	
	// Add the descriptor to the catalogs
	  if (!error)
	    SM.addFile(((FuncArg *)arg)->functor(),
		       ((FuncArg *)arg)->arity(), fd) ;
	  else {
	    CORAL_error(error, SymbolString(((FuncArg *)arg)->functor()),
			"SchemaSolver");
	    delete fd ;
	  }

	}END_EACH_ARG
      }
*/
  return iterator.bindenv ;	  
}

/*------------------------------------------------------------------
  EndBulkLoadSolver()

  Solver function that is called when the builtin relation EndBulkLoad()
  is invoked.

 -------------------------------------------------------------------*/
BindEnv *EndBulkLoadSolver(BuiltinRelation& , TupleIterator& iterator)
{
  int cnt = 0 ;
  char err_str[100] ;

  if (!SM_initialized) {
    CORAL_error(COR_ESM_ERR, "dbserver not initialized", "SchemaSolver");
    iterator.set_no_match();
    return iterator.bindenv;
  }

  in_bulk_load = 0;

/*
    if (iterator.arg_list.count() > 0)
      {
	FOR_EACH_ARG(arg, iterator.arg_list){
	  cnt++ ;
	  if (arg->kindof() != COR_FUNCTOR) {
	    sprintf(err_str, "bad argument %d - should be a functor", cnt) ;
	    CORAL_error(COR_BAD_ARG_TYPE, err_str, "SchemaSolver") ;
	    iterator.set_no_match();
	    return iterator.bindenv;
	  }
	  
	  // Create a file descriptor for the new relation
	  int error = 0 ;
	  FileDescStruct *fd = new FileDescStruct((FuncArg *)arg, error) ;
	  
	  // Add the descriptor to the catalogs
	  if (!error)
	    SM.addFile(((FuncArg *)arg)->functor(),
		       ((FuncArg *)arg)->arity(), fd) ;
	  else {
	    CORAL_error(error, SymbolString(((FuncArg *)arg)->functor()),
			"SchemaSolver");
	    delete fd ;
	  }

	}END_EACH_ARG
      }
*/
  return iterator.bindenv ;	  
}

#endif
