/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/****************************************************************************/
/* 	unit.c
	Add unit rules to the program
*/
/****************************************************************************/
#include "exist.h"
#include "externs.h"
#include "rules.h"

#define twoExpX(x) 	(2 << ((x) - 1)) 	/* 2 to the power of x */

extern void print_bits(BitVector b, int flag) ;
extern Literal * copyLiteral(Literal * p);
static struct rule *newUnitRule(Name *, int, Literal *);
static void findComb(BitVector&, struct combination *);
static int sameUnitRule(struct rule *, struct rule *);

struct combination {	/* store the possible combination of 'd' adornment */
	int numComb;			/* number of dontcare args for a head predicate */
	int pos[COR_MAX_COMB];		/* position of the 'd' arguments */
	BitVector vector[COR_MAX_COMB];	/* possible adornments covering the */
									/* adornment of the head predicate */
};

/****************************************************************************/
/* add unit rules with adornments covering the head predicates.
   For every head predicate that has 'd' arguments,
   there will be 2**(number of 'd' arguments)-1 unit rules added.  Thus,
   p[ndd] :- blah blah.  will lead to the addition of three unit rules:
   (1) p[ndd] :- p[nnd]. 
   (2) p[ndd] :- p[ndn]. 
   (3) p[ndd] :- p[nnn].
*/
/****************************************************************************/
struct rule *addUnitRules(struct rule *rules)
{
	struct rule *r, *tmp, *tmp2, *rr;
	int i;
	struct combination comb;

	for (r=rules; r!=NULL; r=(struct rule *)r->link.next) {
		if (!(r->head->adorn.any()))  
			continue;
		findComb(r->head->adorn, &comb);	
		for (i=0; i<twoExpX(comb.numComb)-1; i++) {
		    tmp = newUnitRule(r->var_names, r->num_var_names, r->head);
		    comb.vector[i].setlen(tmp->preds[0]->adorn.length);
		    tmp->preds[0]->adorn = comb.vector[i];

		    for (rr=rules;rr!=NULL;rr=(struct rule *)rr->link.next) {
			if (sameUnitRule(rr, tmp))
				break;
		    }
		    if (rr==NULL) {
			tmp2 = (struct rule *)r->link.next;
			r->link.next = (Link *)tmp;
			r = (struct rule *)r->link.next;
			r->link.next = (Link *)tmp2;
		    }
		}
	}
	return(rules);
}

/****************************************************************************/
/* return a pointer to the rule with rule->preds[0]->adorn assigned 0.
   COR_NOTE : All the arg pointers are pointing to the original rule, so
   be careful COR_NOT to dispose any pointers that look like they are not
   used anymore.
*/
/****************************************************************************/
static struct rule *newUnitRule(Name *var_names, int var_num, Literal *p)
{
	struct rule *r = new struct rule;
	register int i;

	r->var_names = new Name[var_num] ;
	for (i=0; i<var_num; i++)
		r->var_names[i] = var_names[i];
	r->num_preds = 1;
	r->sips = NULL;
	r->link.next = NULL;

	r->head = copyLiteral(p) ;
	r->head->adorn = p->adorn ;

	r->preds = new Literal *[1] ;
	r->preds[0] = copyLiteral(p) ;
	r->preds[0]->adorn = p->adorn ;
	r->preds[0]->adorn.clear();

	return(r);
}

/****************************************************************************/
/* return a struct with the number of 'd' adornments and their positions in
   the adorned vector
*/
/****************************************************************************/
static void findComb(BitVector &vector, struct combination *comb)
{
	int i, j;

	comb->numComb = 0;

	for (i=0; i<vector.length; i++) {/* find the number of 'd' args */
	    if (twoExpX(comb->numComb)>=COR_MAX_COMB) {
		fprintf(stderr, "Error in findComb: COR_MAX_COMB needs a bigger value\n");
		return ;
	    }
	    if (vector[i]) 	/* and remember their positions */
		comb->pos[comb->numComb++] = i;
	}

	for (i=0; i<twoExpX(comb->numComb); i++) { /* find all combinations */
	    for (j=0; j<comb->numComb; j++) {	  /* of coverings */
		if (i & (1 << j))
		    comb->vector[i].set(comb->pos[j]);
		else comb->vector[i].set(comb->pos[j], 0);
	    }
	}

}

/****************************************************************************/
static int sameUnitRule(struct rule *r1, struct rule *r2)
{
	if ((r1==NULL) || (r2==NULL))
		return(0);	/* something went wrong if returns here */
	if ((r1->num_preds != 1) || (r2->num_preds != 1))
		return(0);	/* r1 or r2 are not unit rules */

	if ((r1->head->predicate == r2->head->predicate) &&
		(r1->preds[0]->predicate == r2->preds[0]->predicate) &&
		(r1->head->adorn == r2->head->adorn) &&
		(r1->preds[0]->adorn == r2->preds[0]->adorn))
		    return(1);
	return(0);
}

/****************************************************************************/
static void printComb(struct combination comb)
{
	int j;

	fprintf(stderr, "\nThe combination:\n");
	for (j=0; j<comb.numComb; j++)
		fprintf(stderr, "comb.pos[%d]=%d\n", j, comb.pos[j]);
	for (j=0; j<twoExpX(comb.numComb); j++){
		fprintf(stderr, "comb.vector[%d]=",j);
		comb.vector[j].printon(stdout);
		fprintf(stderr, "\n");
	}
}

/****************************************************************************/
