/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

# include	"rules.h"
# include	"magic-externs.h"
extern int opt_share_functors;

void supopt()
/*
 * Perform a simple optimization to the supplementary magic rules: replace
 * all occurrences of supmagic_r_1 by the right-hand side of the rule defining
 * supmagic_r_1 and delete that rule.
 */
{
    int		i;
    Literal *	pred;
    Literal *	newpred;

    Link **	ruleptr;

    for (ruleptr = &magic_rules->chain; *ruleptr;) {
	Clause *magicrule = (Clause*)*ruleptr;
	/* delete any rule defining supmagic_r_1 */
	if (magicrule->head->kind == COR_SUPMAGIC &&
	  magicrule->head->pos == 1) {
#if 1
	    *ruleptr = magicrule->link.next;
#else
	    remove_rule(magicrule, magic_rules);
#endif
	    free (magicrule);
	    continue;
	}
	/* search for and replace uses of supmagic_r_1 */
	else for (i=0; i < magicrule->num_preds; ++i) {
	    pred = magicrule->preds[i];
	    if (pred->kind == COR_SUPMAGIC && pred->pos == 1) {
		/* ??? Change the following to deal with opt_share_functors **/
		newpred = build_magic_pred(NULL, pred->rule->head,0);
		magicrule->preds[i] = newpred;
		newpred->pred = pred->rule->head->pred;
		newpred->adorn = pred->rule->head->adorn;
	    }
	}
	ruleptr = &ruleptr[0]->next;
    }
}
