/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

# include	"rules.h"
# include	"magic-externs.h"
#include 	"interface.h"
#include     	<strings.h>
#include	"globals.h"

#ifndef MAX_NAME_LENGTH
#define MAX_NAME_LENGTH (256+1)
#endif

// Do this define in config.h !! PRAVEEN

extern int opt_share_functors;

extern VarLink * build_var_list(Literal * pred, VarLink *list);
static VarLink *vars_from(struct rule *adrule, int pred);
extern VarLink *vars_between(struct rule *adrule, int i, int j,
					VarLink *rest, int*);
static Literal * build_supmagic(struct rule *adrule,
		int rulenum, int pos, VarLink *var_list, int index_var_num);
/* unnecessary. this is moved to compile time : interp.C
void   generate_index_annotations(struct rule *magicrule);
void   generate_base_index_annotations(struct rule *magicrule);
extern void create_an_annotation(PredAnnotations *&, 
				 Literal *lit, VarLink *var_list);
*/
extern Name EquOpSymbol;
extern VarLink *intersect_var_lists(VarLink *varlist1, VarLink *varlist2);
extern void sprint_magic_name(char *buf, char *predname, char *adorn);
extern void sprint_magic_name(char *buf, char *predname, BitVector *adorn);
extern void sprint_pred_name(char *buf, char *predname, char *adorn);
extern void sprint_pred_name(char *buf, char *predname, BitVector *adorn);
VarArg *make_supindex_var(struct rule *adrule, int varnum, char letter);
static Literal *build_pred(struct rule *adrule, Literal *pred, int argum);
static Literal *build_goalid(struct rule *adrule, int argum, int usemagic);
static Literal *make_fail_literal();
static void add_interface_rules(struct collection *magic_rules, char *predname, 
				BitVector &adorn);
void add_interface_rules(struct collection *magic_rules, Name predname, 
				BitVector &adorn);
extern Literal *AllocLiteral(int arity);
extern int has_grouping_args(ArgList &args);
// Defined in annotations.C
extern void add_make_index_annotation(PredAnnotations* &, Symbol *pred,
				      BitVector *bv,
				      ArgList *al1, ArgList *al2);

static void create_supmagic_index(Literal *pred);
void do_supp_magic_on_rule(struct rule *, struct collection *) ;

/*********************************************************************/
//
// supmagic():
//	This function does an enhanced form of supplementary magic,
//		where each rule can have several body literals, but only the
//		first two literals can have derived predicates (i.e. predicates
//		defined in the given module.  
//	Semi-naive rewriting of such rules can safely permute these two 
//		derived literals if required, without causing any join 
//		order problems.
//
/*********************************************************************/

int suppress_allfree = 0; /* If set, suppress generation of magic 
			literals for predicates with all arguments free */
int  dont_create_sup0 = 1;

#ifdef INSERT_GOALID
int  add_fail_literal = 1; 
	/* WARNING:: DANGEROUS FEATURE - 
	If add_fail_literal is set, add a fail literal to magic rules - 
	the goalid builtin predicate in the supplementary rule must be fixed 
	to do the job of creating magic facts, and the magic rule is just 
	a dummy rule.  Note that a patch in interp.C ensures that fail is 
	always the first literal to be evaluated in all semi-naive rules.
	*/
#else
int  add_fail_literal = 0;
#endif

static int rule_num = 0;

void supmagic(struct collection *ad_rules, struct collection *magic_rules)
{

    rule_num = 0 ;
    FOR_EACH_RULE(adrule, ad_rules) {
	/*
	 * Construct the supplementary magic rules
	 */
	do_supp_magic_on_rule(adrule, magic_rules) ;
    } END_EACH_RULE

    if (parserStruct.CurModule.SupMagicIndexing) {
	// go through exported predicate list, and create interface rules. 
	for (ExportInfo *export_info = parserStruct.CurModule.ExportedPreds;
	     		export_info != NULL; export_info = export_info->next) 
	     add_interface_rules(magic_rules, export_info->pred_name, 
					export_info->adornment);

    }

}

/*
 * Construct the supplementary magic rules for adrule
 */
void do_supp_magic_on_rule(struct rule *adrule, struct collection *magic_rules)
{

    int	        i,j, num_base_lits;
    struct rule *	magicrule;
    Literal *	pred;
    Literal *	newhead;
    Literal *prev_sup;

    rule_num++;
    newhead = build_pred(adrule, adrule->head,0);

    for(j=0; ;) {
        if (j < adrule->num_preds && adrule->preds[j]->base_pred)
            j++;
    	else break;
    }
    num_base_lits = j;
    if ( num_base_lits < adrule->num_preds && dont_create_sup0
                  && ! parserStruct.CurModule.SupMagicIndexing
		  && ! parserStruct.CurModule.UseReturnUnify ) {
            /* Avoid generating sup_j_0 predicate - in most cases this
		is an unnecessary overhead, but is necessary when
        	using supplementary indexing or return unify*/
    	prev_sup = build_magic_pred(adrule, adrule->head,
				/* use_share_opt =*/ 0, /* argnum = */ 0);
    	num_base_lits = 0; 
    }
    else { // create sup_i_0 predicate
        magicrule = copy_rule(adrule);
        if (! parserStruct.CurModule.SupMagicIndexing || 
	      num_base_lits >= adrule->num_preds)
          alloc_preds(magicrule, num_base_lits+1);
        else alloc_preds(magicrule, num_base_lits+2);
        magicrule->preds[0] = build_magic_pred(adrule, adrule->head,
				/* use_share_opt =*/ 0, /* argnum =*/ 0);
    	int tmp_j;
    	for(tmp_j=0;tmp_j < num_base_lits; tmp_j++) {
      	    magicrule->preds[tmp_j+1] = adrule->preds[tmp_j];
    	}
    	if(num_base_lits >= adrule->num_preds) {
	  pred = newhead;
	  magicrule->head_deletes_count = adrule->head_deletes_count;
	  magicrule->head_deletes = adrule->head_deletes;
	}
    	else {
      		// *************
	        // pred = build_supmagic(adrule, rule_num, 0, 
		//	build_var_list(magicrule->preds[0], NULL), 
		//	/* next derived lit pos */    i+num_base_lits);
      		// *************
	        /* Keep only those vars that either appear in the head */
	        /* or later in the original rule AND appear in the body of 
	           the supplementary rule that we are going to generate */
	    VarLink *supvars = build_var_list(magicrule->preds[0], 
			vars_between(adrule, 0, num_base_lits-1, NULL, NULL));
      	    VarLink *latervars = build_var_list(newhead, 
					  vars_from(adrule,num_base_lits));
	    supvars = intersect_var_lists(supvars, latervars);
      	    pred = build_supmagic(adrule, rule_num, 0, supvars, 
			    /* next derived lit pos */	num_base_lits);
      	    if (parserStruct.CurModule.SupMagicIndexing) {
	        magicrule->preds[tmp_j+1] = 
	  	build_goalid(adrule, tmp_j, /*usemagic=*/ 1);
            }
    	}
            /* WARNING - unnecessary vars should be projected out above */
            /*		Perhaps all vars are necessary in this case though */
        magicrule->head = prev_sup = pred;
        add_rule(magicrule, magic_rules);
        //generate_base_index_annotations(magicrule);
        pred->rule = adrule;
    }
  
    for (i=num_base_lits; i < adrule->num_preds;) {
        /*
         * Generate a magic rule for each derived right-hand side predicate
         * that has an incoming arc in the sip
         */

        if ( 0 && 		// Don't use this for now.
	    ! adrule->preds[i]->base_pred && adrule->sips->sip_list ) {

	  /* WARNING: Eventually just sort the predicates in the 
	   sip order, and then do the sup magic is below */
          if(0) {
	
	    fprintf(stderr,"Error: supmagic cannot deal with sips yet\n");
	    struct sip *s;
	    for (s=adrule->sips->sip_list; s; s=s->next)
	    if (i == s->head-1) {
	        magicrule = copy_rule(adrule);
	        // rule_num++;
	        pred = build_magic_pred(adrule, adrule->preds[i],
		     /* use_share_opts= */ 0, /* argnum = */ i+1);
	        magicrule->head = pred;
	        if (parserStruct.CurModule.SupMagicIndexing)
	            create_supmagic_index(magicrule->head);
	          alloc_preds(magicrule, 1);
	        pred->rule = adrule;
	        pred = build_supmagic(adrule, rule_num, i+1,
				  build_var_list(prev_sup, NULL),
				  /* derived lit pos.??*/     i);
	        magicrule->preds[0] = pred;
	    
	        magicrule->type = COR_MAGICRULE ;
	        magicrule->source_rule = adrule ;
	        magicrule->source_pred = adrule->preds[i] ;
	        add_rule(magicrule, magic_rules);
	    
	        break;	/* only one magic rule per predicate */
	    }
      	  }
    	}
    
    if ( !(adrule->preds[i]->base_pred)) {
                magicrule = copy_rule(adrule);
                magicrule->head = build_magic_pred(adrule, adrule->preds[i],
				/* use_share_opt =*/ 0, /* argnum = */ i+1);
                if (parserStruct.CurModule.SupMagicIndexing)
		   create_supmagic_index(magicrule->head);

                if (parserStruct.CurModule.SupMagicIndexing && add_fail_literal){ 
			  /* See top of file for explanation */
		    alloc_preds(magicrule,2);
		    magicrule->preds[0] = make_fail_literal();
		    magicrule->preds[1] = prev_sup;
		}
		else {
		    alloc_preds(magicrule, 1);
		    magicrule->preds[0] = prev_sup;
		    magicrule->head->rule = adrule;
		}

		magicrule->type = COR_MAGICRULE ;
		magicrule->source_rule = adrule ;
		magicrule->source_pred = adrule->preds[i] ;

		if (magicrule->source_pred->negated ||
			  has_grouping_args(adrule->head->args)) {
		  if (!magicrule->clause_names) { // need to create a new name
		    magicrule->clause_names = new ClauseName();
		    magicrule->clause_names->name = DontCareSymbol;
		    magicrule->clause_names->next = NULL; // is this needed ???
		  }
		  magicrule->clause_names->negated = 1;
		}

		add_rule(magicrule, magic_rules);
	    }

	    // Generate supplementary rule/ final rule.

            for(j=0; ;) {
		if (i+j+1 < adrule->num_preds &&
				adrule->preds[i+j+1]->base_pred)
		    j++;
		else break;
	    }
	    num_base_lits = j;

	    magicrule = copy_rule(adrule);
	    if (i+num_base_lits+1 < adrule->num_preds) {
	       	/* Keep only those vars that either appear in the head */
		/* or later in the original rule AND appear in the body of 
			the supplementary rule that we are going to generate */
		VarLink *supvars = build_var_list(prev_sup, 
			vars_between(adrule, i, i+num_base_lits, NULL,NULL));
		VarLink *latervars = build_var_list(newhead, 
					vars_from(adrule,i+num_base_lits+1));
		supvars = intersect_var_lists(supvars, latervars);
	        pred = build_supmagic(adrule, rule_num, i+1, supvars, 
			/* next derived lit pos */ i+num_base_lits+1);
		/* WARNING:  Some space should be freed here */
	    }
           else {
               pred = newhead;
               magicrule->head_deletes_count = adrule->head_deletes_count;
               magicrule->head_deletes = adrule->head_deletes;
           }


	    int num_deriv_negated = 0;
	    if (parserStruct.CurModule.UseOrdSearch)
	    if (((adrule->preds[i]->negated) || ((pred == newhead) && 
				(has_grouping_args(newhead->args)))) && 
			(!parserStruct.CurModule.Monotonic) &&
			(!adrule->preds[i]->base_pred)){
		num_deriv_negated = 1;

/******* has been moved to main.C  --- PRAVEEN
		if (!parserStruct.CurModule.UseOrdSearch)
			// set ordered search
		    COR_set_use_ordsearch(parserStruct.CurModule, 1);
*******/
	    }

	    magicrule->head = pred;
	    pred->rule = adrule;
	    if (! parserStruct.CurModule.SupMagicIndexing || 
				!(i+num_base_lits+1 < adrule->num_preds))
	        alloc_preds(magicrule, 2+num_base_lits+num_deriv_negated);
	    else alloc_preds(magicrule, 2+num_base_lits+num_deriv_negated+1);
	    magicrule->preds[0] = prev_sup;
	    if (num_deriv_negated) {
		magicrule->preds[1] = build_magic_pred(adrule,
				adrule->preds[i], 0, i+1) ;
		magicrule->preds[1]->kind =  COR_DONE_MAGIC;
	    }

	    magicrule->preds[num_deriv_negated+1] = 
			build_pred(adrule, adrule->preds[i], i+1);
	    int tmp_j;
	    for(tmp_j=0;tmp_j<num_base_lits; tmp_j++) {
		magicrule->preds[tmp_j+num_deriv_negated+2] = 
			adrule->preds[i+tmp_j+1];
	    }
	    if (parserStruct.CurModule.SupMagicIndexing && 
				 (i+num_base_lits+1 < adrule->num_preds)) {
		magicrule->preds[tmp_j+num_deriv_negated+2] = 
			build_goalid(adrule, i+num_base_lits+1,
					/* usemagic =*/ 1);
	    }
	    i=i+num_base_lits+1;
	    prev_sup = pred;
	    add_rule(magicrule, magic_rules);
	    //generate_index_annotations(magicrule);
	    // print_rule(magicrule,stderr);

	   /* WARNING::  Create make_index annotation here!! */
	}
	/*
	 * Construct the modified rule
	 */
	// magicrule = copy_rule(adrule);
	// add_rule(magicrule, magic_rules);
	// rule_num++;
	// int magic_rule_num_preds=0;
	//
	// if ( opt_share_functors ) {
	/* Optimization to allow the head to share functors with the 
	* magic predicate in the body. */
	//    }
	// magicrule->head = adrule->head;
	// if (adrule->last_part >= 0) {/* >= 1 pred participates in sip */
	//    alloc_preds(magicrule, adrule->num_preds - adrule->last_part + 1);
	//     magicrule->preds[0] = prev_sup;
	//     for (j=1,i=adrule->last_part; i<adrule->num_preds; ++i)
	// 	magicrule->preds[j++] = adrule->preds[i];
	// }
	// else {/* must have empty sip (or rule) -- just add supmagic_r_1 */
	 //    alloc_preds(magicrule, adrule->num_preds + 1);
	 //    magicrule->preds[0] = prev_sup;
	 //    for (j=0; j<adrule->num_preds; ++j)
		// magicrule->preds[j+1] = adrule->preds[j];
	// }
}

void make_new_rule_vars(struct rule *, int )
{  /** This procedure adds new variable names to rule, and stores the 
	number of vars at the time it was called in old_num_var_names **/

fprintf(stderr, "make_new_rule_vars not implemented fully yet\n");


}

VarArg *new_rule_var(struct rule *, int )
{ // ** This procedure returns the newvarnum'th new rule variable.
  // ** The new variables must have been created by make_new_rule_vars
  // ******
    fprintf(stderr, "new_rule_var not implemented fully yet\n");
    return NULL;
}

VarArg *make_supindex_var(struct rule *adrule, int varnum, char letter = 'I')
{
    char n[30];
    int varpos;

    sprintf(n,"_%c%d", letter, varnum);
    Name name = EnterSymbol(n);
    for(varpos = 0; varpos < adrule->num_var_names; varpos++) {
	if (adrule->var_names[varpos] == name)
	    break;
    }
    if (varpos >= adrule->num_var_names) {
        adrule->num_var_names++;
        adrule->var_names = (Name *) realloc(adrule->var_names,  
			adrule->num_var_names * sizeof(Name) );
    }
    adrule->var_names[adrule->num_var_names-1] = name;
    return new VarArg(adrule->var_names[adrule->num_var_names-1], 
			varpos);
}

Name new_pred_name(Name name) 
{
   if (!parserStruct.CurModule.SupMagicIndexing)
	return name;
   char n[MAX_NAME_LENGTH];
   sprintf(n,"s_%s",name->string());
   return EnterSymbol(n);
}

Name new_pred_name(char *name) 
{
   if (!parserStruct.CurModule.SupMagicIndexing)
	return EnterSymbol(name);
   char *n = new char [strlen(name)+10];
   sprintf(n,"s_%s",name);
   Name newname = EnterSymbol(n);
   delete n;
   return newname;
}

Name new_interface_pred_name(char *name) 
{
   if (!parserStruct.CurModule.SupMagicIndexing)
	return EnterSymbol(name);
   char *n = new char [strlen(name)+10];
   sprintf(n,"sup_i_s_%s",name);	// Name is a hack to deal with
			// return unify - name MUST start with the same
			// prefix as supplementary literals (currently sup_)
   // sprintf(n,"m_i_s_%s",name);
   Name newname = EnterSymbol(n);
   delete n;
   return newname;
}

Literal * build_magic_pred(struct rule *adrule, Literal * pred, 
		int use_share_opt, int argnum)
/*
 * Construct an arg list containing only the bound args from the given pred
 */
{
    int			i;
    Arg **	arg_ptr;
    Literal *new_pred;
    int count = 0; /* count of bound args in pred */
    int new_rule_var_count = 0;

    i = 0;
    FOR_EACH_ARG(a, pred->args) {
	if (pred->adorn.test(i++))
	    count++;
    } END_EACH_ARG

    if(parserStruct.CurModule.SupMagicIndexing) count++;
    new_pred = (Literal*) AllocLiteral(count);
	// malloc(sizeof(Literal) + count * sizeof(ArgPtr));
        // new_pred->args.set_count(count);
    new_pred->kind = COR_MAGIC;
    arg_ptr = new_pred->args.first();
    if (parserStruct.CurModule.SupMagicIndexing)
 	*arg_ptr++ = make_supindex_var(adrule, argnum);	
    i = 0;
    FOR_EACH_ARG(a, pred->args) {
	if (pred->adorn.test(i++)) {
	    if (!use_share_opt || a->kindof() != COR_FUNCTOR)
	    	*arg_ptr++ = a;
	    else  *arg_ptr++ = new_rule_var(adrule, new_rule_var_count++);
	    }
    } END_EACH_ARG
    new_pred->base_pred = 0;
    new_pred->negated = 0 ;
    if (parserStruct.CurModule.SupMagicIndexing)
    	new_pred->pred = new_pred_name(pred->pred);
    else new_pred->pred = pred->pred;
    new_pred->adorn = pred->adorn;
    return new_pred;
}

Literal *build_interface_magic_pred(struct rule *adrule, Literal * pred,
		int use_share_opt, int argnum)
{
    Literal *mlit = build_magic_pred(adrule, pred, use_share_opt, argnum);
    mlit->pred = new_interface_pred_name(pred->pred->string());
    mlit->kind = COR_REGULAR;	/* So that m_ is not printed before predicate
					name */
    return mlit;
}

/*  Create a new predicate from pred.  The new predicate will have
	an extra argument if supplementary indexing rewriting is used.
	Create a variable using number ``argnum'' and use it in this 
	extra argument.
*/
static Literal *build_pred(struct rule *adrule, Literal *pred, int argnum)
{
   
    if (! parserStruct.CurModule.SupMagicIndexing)
	return pred;

    Arg **	arg_ptr;
    Literal *new_pred;
    int count = 0; /* count of args in pred */

    FOR_EACH_ARG(a, pred->args) {
	    count++;
    } END_EACH_ARG

    if(parserStruct.CurModule.SupMagicIndexing) count++;
    new_pred = (Literal*) AllocLiteral(count);
	// malloc(sizeof(Literal) + count * sizeof(ArgPtr));
        // new_pred->args.set_count(count);
    new_pred->kind = pred->kind;
    // new_pred->predicate = pred->predicate;
    new_pred->pred = new_pred_name(pred->pred);
    new_pred->adorn = pred->adorn;
    new_pred->base_pred = pred->base_pred;
    new_pred->negated = pred->negated ;

    arg_ptr = new_pred->args.first();
    if (parserStruct.CurModule.SupMagicIndexing)
 	*arg_ptr++ = make_supindex_var(adrule, argnum);	
    FOR_EACH_ARG(a, pred->args) {
	*arg_ptr++ = a;
    } END_EACH_ARG
    return new_pred;
}

/*****************
*  build_goalid:  if usemagic is set to 1, it assumes that  
*			adrule->preds[argnum] needs a goalid literal made 
*			for it.  It adds m_ and s_ prefixes and adds adornment.
*			It adds a goal-id arg, and projects out free args.
*			Typically called with literal from original rule.
*	  	  if usemagic is set to 0, m_ and s_ prefixes are not added,
*			It is assumed that  adrule->preds[argnum] is a valid
*			prototype, and merely has to have adornment added, 
*			and then enclosed within a goalid literal.  Typically
*			called with a magic literal that has been created.
* 
*****************/
static Literal *build_goalid(struct rule *adrule, int argnum, int usemagic)
{
   
    Arg **	arg_ptr;
    Literal *new_pred;
    FuncArg *new_func;
    int count = 0; /* count of args in pred */
    static char name[MAX_NAME_LENGTH];

    Literal *pred = adrule->preds[argnum];
    Name n;


    if (usemagic) {
	int i=0;
        n = new_pred_name(pred->pred);
    	sprint_magic_name(name, n->string(),&(pred->adorn));
 	FOR_EACH_ARG(a, pred->args) {
	     if (pred->adorn.test(i++))
		 count++;
	} END_EACH_ARG
	count++;	// for goalid variable
    } else {
    	FOR_EACH_ARG(a, pred->args) {
	    count++;
    	} END_EACH_ARG
	// goalid variable is assumed to be present already
	n = pred->pred;
    	sprint_pred_name(name, n->string(),&(pred->adorn));
    }

    new_func = FuncArg::New(EnterSymbol(name), count);
    arg_ptr = new_func->args.first();

    if(usemagic) {
        *arg_ptr++ = make_supindex_var(adrule, argnum+1);	
	int i = 0;
        FOR_EACH_ARG(a, pred->args) {
	    if (pred->adorn.test(i++)) {
		*arg_ptr++ = a;
	    }
	} END_EACH_ARG
    } else {
    	FOR_EACH_ARG(a, pred->args) {
	    *arg_ptr++ = a;
    	} END_EACH_ARG
    }

    new_pred = (Literal*) AllocLiteral(1);
	// malloc(sizeof(Literal) + count * sizeof(ArgPtr));
        // new_pred->args.set_count(count);
    new_pred->args[0] = new_func;
    new_pred->kind = COR_REGULAR;
    new_pred->predicate = FindPredicate(parserStruct, GoalIdOpSymbol,1);
    new_pred->pred = GoalIdOpSymbol;
    // new_pred->adorn = NULL;
    new_pred->base_pred = 1;
    new_pred->negated = 0 ;

    return new_pred;
}

int count_bound_functor_args(Literal *head) 
{
    int count = 0;
    int i = 0;

    FOR_EACH_ARG(a,head->args) {
    	if (head->adorn.test(i++) && a->kindof() == COR_FUNCTOR)
	    count++;
    } END_EACH_ARG
    
    return(count);
}

/****   make_functor_literal.
	The following fn is used in the opt_share_functors optimization.
	It creates a literal of the form "Var=term", where the var is 
	specified via newvarnum, and "term" is the argnum'th arg of head.
*****/

Literal *make_functor_literal(struct rule *newrule, Literal *head, 
					int argnum, int newvarnum)
{

fprintf(stderr, "make_functor_literal not implemented fully yet\n");

    Literal *new_pred; 
    Arg     **arg_ptr;
    new_pred = (Literal*)
	malloc(sizeof(Literal) + 2 * sizeof(ArgPtr));
    new_pred->kind = COR_REGULAR;
    new_pred->args.set_count(2);
    arg_ptr = new_pred->args.first();

    *arg_ptr++ = new_rule_var(newrule, newvarnum);
    *arg_ptr   = head->args[argnum];

    new_pred->base_pred = 1;
    new_pred->negated = 0 ;
    new_pred->pred = EquOpSymbol ;
    /* new_pred->adorn is not initialized */
    return new_pred;
}


void create_functor_literals(struct rule *)
{ // ** This procedure adds literals of the form var=term, for the 
  // ** opt_share_functors optimization


fprintf(stderr, "create_functor_literals not implemented yet\n");

}


Literal * build_head_pred(struct rule *newrule, Literal *oldhead)
{ // ** This procedure creates a head literal for the magic rule, and 
  // ** implements the opt_share_functors optimization if the global flag 
  // ** opt_share_functors is set

    int new_rule_var_count = 0;
    int i=0;
    Literal *new_pred; 
    Arg **arg_ptr;

    if (!opt_share_functors || 
		count_bound_functor_args(oldhead) == 0)
	return(oldhead);

fprintf(stderr, "build_head_pred not implemented fully yet\n");

    new_pred = (Literal*)
	malloc(sizeof(Literal) + oldhead->arity() * sizeof(ArgPtr));
    new_pred->kind = COR_REGULAR;
    new_pred->args.set_count(oldhead->arity());
    arg_ptr = new_pred->args.first();

    FOR_EACH_ARG(a, oldhead->args) {
	if ( oldhead->adorn.test(i++) && opt_share_functors && 
		a->kindof() == COR_FUNCTOR)
	    *arg_ptr++ = new_rule_var(newrule, new_rule_var_count++);
	else *arg_ptr++ = a;
    } END_EACH_ARG
    new_pred->base_pred = 0;
    new_pred->negated = 0 ;
    new_pred->pred = oldhead->pred;
    new_pred->adorn = oldhead->adorn;
    return new_pred;
}


static VarLink *vars_from(struct rule *adrule, int pred)
{
    int i;
    VarLink *result=NULL;
    for (i=pred; i < adrule->num_preds; i++)
	result = build_var_list(adrule->preds[i], result);
    return result;
}

/** WARNING: The following routine damages the varlists that are
	passed to it.
**/
static Literal * build_supmagic(struct rule *adrule, int rule_num, int pos,
			VarLink *var_list, int next_der_lit)
{
    Literal *pred;
    ArgPtr *arg_ptr;
    register VarLink *link;
    int var_count = 0;
    for (link = var_list ; link != NULL; link = link->next)
	var_count++;
    /********
    * if( parserStruct.CurModule.SupMagicIndexing && pos == 0) 
    *	var_count ++;
    ********/
    if (parserStruct.CurModule.SupMagicIndexing && 
		! (adrule->preds[next_der_lit]->base_pred) ) 
		// ! (adrule->preds[pos+1]->base_pred) ) 
	var_count ++;
    static char name[30];
    sprintf(name, "sup_%d_%d", rule_num, pos);
    pred = AllocLiteral(parserStruct, EnterSymbol(name), var_count);
    // Used to be pred = AllocLiteral(NULL, var_count);
    pred->kind = COR_SUPMAGIC;
    pred->pos = pos;
    arg_ptr = &pred->args[var_count];
    if (parserStruct.CurModule.SupMagicIndexing && 
		! (adrule->preds[next_der_lit]->base_pred) ) {
		// ! (adrule->preds[pos+1]->base_pred) ) {
	*--arg_ptr = make_supindex_var(adrule, next_der_lit+1);
	var_count--;
    }
    /***************
    * if( parserStruct.CurModule.SupMagicIndexing && pos == 0) {
    *	*--arg_ptr = make_supindex_var(adrule, 0);
    *	var_count--;
    * }
    ***************/
    for (link = var_list; --var_count >= 0; ) {
	ASSERT((link != NULL));
	VarLink *next = link->next;
	*--arg_ptr = link->arg;
	delete link;
	link = next;
    }
    return pred;
}


/** WARNING: The following routine damages the varlists that are
	passed to it.
**/
   /****
      We assume that the rule has at most two derived predicates,
	and these can occur only in the first two positions.
	The semi-naive versions of the rule can then at most interchange
	the first two literals in the rule.

      The join order for the semi-naive rewritten rules is  then assumed 
	to be left to right, except that the delta relation is moved up
	front.  Indices are generated for this join order.
    ****/
/********
void generate_index_annotations(struct rule * suprule)
{

    int i;

    if (suprule->num_preds > 1 && !(suprule->preds[1]->base_pred) ) {
	if (!parserStruct.CurModule.SupMagicIndexing) {
    	    create_an_annotation(parserStruct.make_index_annotations,
				 suprule->preds[0],
		intersect_var_lists( build_var_list(suprule->preds[0],NULL),
			build_var_list(suprule->preds[1],NULL) ) );
	    create_an_annotation(parserStruct.make_index_annotations,
				 suprule->preds[1], 
		intersect_var_lists( build_var_list(suprule->preds[0],NULL),
			build_var_list(suprule->preds[1],NULL) ));
	}
	else {
	    VarArg *var;
	    ASSERT(( suprule->preds[1]->args[0]->kindof() == COR_VARIABLE))
	    var = (VarArg *)suprule->preds[1]->args[0];
	    VarLink *vl = new VarLink(var, NULL);
	    create_an_annotation(parserStruct.make_index_annotations,
				 suprule->preds[0], vl);
	    vl = new VarLink(var, NULL);
	    create_an_annotation(parserStruct.make_index_annotations,
				 suprule->preds[1], vl);
	}
    }
    VarLink *leading_vars, *indexing_vars ;

    // The following code indexes base predicates in the rule 
    for(i=2; i < suprule->num_preds; i++) {
	leading_vars = vars_between(suprule,0,i-1,NULL,NULL);
	indexing_vars = intersect_var_lists( 
			build_var_list(suprule->preds[i],NULL),
			leading_vars);
	create_an_annotation(parserStruct.make_index_annotations,
			     suprule->preds[i], indexing_vars);
    }
}
************/
   /****
      This procedure assumes that the rule has at most one derived predicate
      (which must be in the first literal in the rule).

      The join order for the (possibly semi-naive rewritten) rule is  
      then assumed to be left to right.  Indices are generated for this 
      join order.
    ****/
/*****
void generate_base_index_annotations(struct rule * suprule)
{
    int i;
    VarLink *leading_vars, *indexing_vars ;

    // The following code indexes base predicates in the rule 
    for(i=1; i < suprule->num_preds; i++) {
	leading_vars = vars_between(suprule,0,i-1,NULL,NULL);
	indexing_vars = intersect_var_lists( 
			build_var_list(suprule->preds[i],NULL),
			leading_vars);
	create_an_annotation(parserStruct.make_index_annotations,
			     suprule->preds[i], indexing_vars);
    }
}
********/
void create_supmagic_index(Literal *pred)
{

    int arity = pred->args.count();
    char *buf = new char[arity+1];
/****  changed this ... PRAVEEN
    buf[0] = 'b';
    for (int i=1; i < arity; i++)
	buf[i] = 'f';
****/
    buf[0] = 'f';
    for (int i=1; i < arity; i++)
	buf[i] = 'b';

    buf[arity] = NULL;
    
    char *name = new char [strlen(pred->pred->string())+10];
    sprint_magic_name(name, pred->pred->string(),"");

    add_make_index_annotation(parserStruct.make_index_annotations,
			      EnterSymbol(name), &(pred->adorn), 
		make_arglist1(make_arg(buf)), NULL );
    delete buf;
    delete name;
}

void create_interface_index(Literal *pred)
{

    int arity = pred->args.count();
    char *buf = new char[arity+1];
    buf[0] = 'b';
    for (int i=1; i < arity; i++)
	buf[i] = 'f';
    buf[arity] = NULL;
    
    char *name = new char [strlen(pred->pred->string())+10];
    sprint_pred_name(name, pred->pred->string(),"");

    add_make_index_annotation(parserStruct.make_index_annotations,
			      EnterSymbol(name), &(pred->adorn), 
		make_arglist1(make_arg(buf)), NULL );
    delete buf;
    delete name;
}




Literal* make_vararglist_literal(struct rule *rule, Name name, int startvarnum, 
				int arity)
{
    int i;
    Literal *lit = AllocLiteral(parserStruct, name, arity);
    for(i=0; i < arity; i++) {
	lit->args[i] = make_supindex_var(rule, i+startvarnum, 'V');
    }
    return lit;
}

Literal* make_vararglist_literal(struct rule *rule, char *name, 
			int startvarnum, int arity)
{

    return make_vararglist_literal(rule, EnterSymbol(name), startvarnum, arity);
}


void add_interface_rules(struct collection *magic_rules, Name predname, 
				BitVector &adorn)
{
    add_interface_rules(magic_rules, predname->string(), adorn);
}

void add_interface_rules(struct collection *magic_rules, char * predname, 
				BitVector &adorn)
{
    struct rule *rule, *magicrule;

    static char name[MAX_NAME_LENGTH];
    Name n;

    int num_bound_args=0;
    for(int i=0; i < adorn.length; i++)
	if(adorn.test(i)) num_bound_args++;

    /****************************************************************/
    /*  The rule for initial magic predicate ... */
    /*   sup_i_s_<pred>(X1,..,Xn) :- 
			m_<pred>(X1,..,Xn), goal_id(m_<pred>(X1,..,Xn.)). */
    /***************************************************************/

    rule = copy_rule(NULL);
    rule->var_names = (Name *) malloc(sizeof(Name));  
		/* Dummy so realloc is not confused */
    alloc_preds(rule, 2);

    /* lit is a temporary literal to work off of */
    n = EnterSymbol(predname);
    Literal *lit = make_vararglist_literal(rule, n, 1, adorn.length);
    lit->adorn = adorn;

    rule->head  = build_interface_magic_pred(rule, lit, /*use_share_opt = */ 0,
					/* argnum = */ 1);
    create_interface_index(rule->head);

    /* Hack to meet the interface requirements of build_goalid */
    rule->preds[0] = lit;
    rule->preds[1] =  build_goalid(rule,/* pos = */ 0, /*usemagic=*/ 1);

    /* Warning - preds[0] is assigned twice.  Make sure the order is 
				preserved */
    int indexingstat = parserStruct.CurModule.SupMagicIndexing;
    parserStruct.CurModule.SupMagicIndexing = 0;	// To fool system into creating 
					// ordinary magic literal, without
					// supplementary indexing fields.
    rule->preds[0] = build_magic_pred(rule, lit, 0, 1);
    parserStruct.CurModule.SupMagicIndexing = indexingstat;

    magicrule = rule;
    add_rule(magicrule, magic_rules);

    /**************************************************************/
    /* Now the rule to create m_s_..(...) facts from m_i_s_..(...) facts */
    /*  m_s_<pred>(X1,..,Xn) :- sup_i_s_<pred>(X1,..,Xn)	         */
    /**************************************************************/

    rule = copy_rule(NULL);
    rule->var_names = (Name *) malloc(sizeof(Name));  
		/* Dummy so realloc is not confused */
    alloc_preds(rule, 1);

    if (add_fail_literal){ /* See top of file for explanation */
	alloc_preds(rule,2);
	rule->preds[0] = make_fail_literal();
    }
    else {
	alloc_preds(rule, 1);
    }
    lit = make_vararglist_literal(rule, n, 1, adorn.length);
    lit->adorn = adorn;


    rule->head = build_magic_pred(rule, lit, /*use_share_opt = */ 0,
						/* argnum = */ 1);

    if (parserStruct.CurModule.SupMagicIndexing)
	create_supmagic_index(rule->head);

    if (add_fail_literal) {
        rule->preds[1] = build_interface_magic_pred(rule, lit, 
				/*use_share_opt = */ 0, /* argnum = */ 1);
    }
    else rule->preds[0] = build_interface_magic_pred(rule, lit, 
				/*use_share_opt = */ 0, /* argnum = */ 1);
    add_rule(rule, magic_rules);

    /****************************************************************/

    /* And now the rule for exported predicate... */
    /*	p(..) :- sup_i_s_(..), s_p(..).		  */

    rule = copy_rule(NULL);
    rule->var_names = (Name *) malloc(sizeof(Name));  
		/* Dummy so realloc is not confused */
    alloc_preds(rule, 2);

    rule->head = make_vararglist_literal(rule, predname, 1, adorn.length);
    rule->head->adorn = adorn;

    rule->preds[0] = build_interface_magic_pred(rule, rule->head,
				    /*use_share_opt = */ 0, /* argnum = */ 1);
    /*** replace variables other than goalid variable by _ ***/
    for (int j=1;i < rule->preds[0]->args.count(); i++) {
	rule->preds[0]->args[j] = &TheDontCareArg;
    }

    rule->preds[1] = build_pred(rule, rule->head, /* argnum=*/ 1);
    add_rule(rule, magic_rules);

}


static Literal *make_fail_literal()
{
    Literal *pred;

    pred = AllocLiteral(parserStruct, FailSymbol, 0);
    pred->kind = COR_REGULAR;
    pred->base_pred = 1;
    return pred;
}
