/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

# include	"rules.h"
# include	"magic-externs.h"

static int	torder[MAX_RHSPREDS] ;

static void toporder(Clause *rule, int torder[] )
{
   static char	graph[MAX_RHSPREDS+1][MAX_RHSPREDS+1];
   /** graph(i,j) = 1 if there is a sip arc from pred[i] to pred[j] 
   	(i = 0 implies the head of the rule )
   **/
   static int 	countarr[MAX_RHSPREDS+1] ;
   static int 	noarcs[MAX_RHSPREDS+1] ;
   int		i, j, k, count;
   struct sip * s ;
   int b ;

	ASSERT(rule->num_preds <= MAX_RHSPREDS) ;
	for(i=0; i <= rule->num_preds ; i++ )
		countarr[i] = 0 ;

	/* Initialize graph */
	for (i=0; i<=rule->num_preds; ++i) {
	    for (j=0; j<=rule->num_preds; ++j)
		graph[i][j] = 0;
	    noarcs[i] = 1 ;
	}

	/* Construct graph from sips ans set up count array */
	for (s = rule->sips->sip_list; s; s = s->next) {
	    for (b = firstpredinsip(&s->tail); b>=0; 
				b = nextpredinsip(&s->tail, b)) {
		graph[b][s->head] = 1;
		noarcs[b] = noarcs[s->head] = 0 ;
		}
	}

    	for (i=0; i<=rule->num_preds; i++)
    	    for (j=0; j<=rule->num_preds; j++)
		if ( graph[i][j] ) countarr[j] ++ ;

	/* Force all preds with no incoming and no outgoing sip arcs to the 
		end of the rule by giving them a count of one*/
	for( i=1; i <= rule->num_preds; i++ ) 
		if ( noarcs[i] ) countarr[i] = 1 ;

	count = 0 ; 
    	for (k=0; k<=rule->num_preds; ++k){
    	    for (i=0; i<=rule->num_preds; ++i)
	    	if ( countarr[i] == 0 ) {
		    countarr[i] = -1 ; /* Mark as done */
		    if( i > 0 ) torder[i-1] = count ++ ;
		    /* bump down the pred numbering by 1 for torder to start
			body pred numbering at 0 */
		    for(j=1; j <= rule->num_preds ; j++ ) {
		    	if ( graph[i][j] ) {
			    countarr[j]-- ;
		    	    ASSERT( countarr[j] >= 0 ) ;
			    }
		    	}
		}
	    }


	/*  set up rule->last_part properly, and make sure the order of
	predicates in the rule body is such that anything beyond last_part
	does not participate in any sip. */

	rule->last_part = count -1 ; 
	/* Now tack on preds that had no sip arcs entering or leaving */
	for( i=1; i <= rule->num_preds; i++ ) {
	    if ( noarcs[i] ) {
	    	ASSERT( countarr[i] == 1 ) ;
	    	torder[i-1] = count++ ;
		}
	    }


#ifdef DEBUG
	if(0) {
	print_rule(rule, stderr) ;
	printf("torder array:") ;
	for ( i = 0; i < rule->num_preds ; i++ )
    		printf("%d ", i ) ;
	printf("\n") ;
	}
#endif

}

void siporder(struct collection *ad_rules)
/*
 * Reorder the right-hand sides of the adorned system so the predicate
 * occurrences follow the order induced by the sips
 */
{
    int 		i,b;
    struct sip *	s;
    struct sips * sp ;
    Literal *	newpreds[MAX_RHSPREDS];

    FOR_EACH_RULE(adrule, ad_rules) {

	/*
	printf("Here is the original rule\n");
	print_rule(adrule, stderr) ;
	printf("\n") ;
	*/

	toporder(adrule, torder) ;

	/* Rearrange right-hand side */
	for (i=0; i<adrule->num_preds; ++i) {
		newpreds[torder[i]] = adrule->preds[i];
	    }
	for (i=0; i<adrule->num_preds; ++i)
	    adrule->preds[i] = newpreds[i];

	/* Fix sips to reflect rearrangement */
	for ( sp = adrule->sips ; sp ; sp = sp->next ) {
	    for (s = sp->sip_list; s; s = s->next) {
		BitVector bitvec(s->tail.len());
	    	for (b = firstpredinsip(&s->tail); b>=0; 
				b = nextpredinsip(&s->tail, b)) {
		    if ( b == 0 ) /* head predicate */
		    	bitvec.set(0);
		    else /* add 1 since 0 is head */
			bitvec.set(torder[b-1]+1); 
		    }
	    	s->tail = bitvec;
	    	s->head = torder[s->head-1]+1 ;
	    }
	}

#ifdef DEBUG
	if(0) {
	printf("Modified original rule:\n") ;
	print_rule(adrule, stderr) ;
	printf("\n");
	}
#endif

    } END_EACH_RULE
}

/* Find a sip for a predicate in an adorned rule.
	Non-matching sips have already been discarded */
struct sip * findadsip(Clause * adrule, int p)
{
    struct sip * s;

    for (s=adrule->sips->sip_list; s; s=s->next)
	if (p == s->head-1) break ; 
		/* in sip, body pred numbering starts from 1 */
    return(s) ;
}
