/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include "factor.h"

extern void do_magic_on_rule(struct rule *, struct collection *) ;
extern void do_supp_magic_on_rule(struct rule *, struct collection *) ;
extern void add_interface_rules(struct collection *, Name, BitVector &adorn);
				
extern Literal *AllocLiteral(int) ;
extern Literal *build_magic_pred(struct rule *newrule, Literal *oldhead,
		int use_share_opt, int argnum = 0) ;

static void do_factor_non_recursive(struct rule *, struct collection *) ;
static void do_factor_rt_linear(struct rule *, struct collection *) ;
static void do_factor_lt_linear(struct rule *, struct collection *) ;
static void do_factor_pseudo_lt_linear(struct rule *, struct collection *) ;
static void do_factor_multi_linear(struct rule *, struct collection *) ;


FactorPredList factor_linear_preds, factor_magic_preds ;

static int in_factor_list(FactorPredList &factor_preds, Literal *lit)
{
  struct FactorPredList *temp = factor_preds.next ;

  while (temp != NULL) {
    if ((temp->lit->pred == lit->pred) && 
	(temp->lit->adorn == lit->adorn) &&
	(temp->lit->args.count() == lit->args.count())) return 1;
    temp = temp->next ;
  }
  return 0 ;
}

static void add_literal(FactorPredList &factor_preds, Literal *lit)
{
  struct FactorPredList *temp ;

  if (in_factor_list(factor_preds, lit)) return ;

  temp = new struct FactorPredList ;
  temp->lit = lit ;
  temp->next = factor_preds.next ;
  factor_preds.next = temp ;
}

static int add_variable(struct rule *rule, Name name)
{
  rule->var_names = (Name *)realloc((char *)(rule->var_names), 
			++(rule->num_var_names) * sizeof(Name)) ;
  rule->var_names[rule->num_var_names - 1] = name ;
  return rule->num_var_names - 1;
}

static VarArg * make_new_arg(struct rule *rule)
{
   static int count = 0 ;
   char buf[10]  ;

   sprintf(buf, "C__F%d", count++) ;
   Name tmp1 = EnterSymbol(buf);
   return new VarArg(tmp1, add_variable(rule, tmp1));
}

static Literal *make_new_lit(Literal *lit, int arity, pred_kind kind)
{
    Literal *new_lit; 

    new_lit = (Literal*) AllocLiteral(arity);
	// malloc(sizeof(Literal) + arity * sizeof(ArgPtr));
        // new_lit->args.set_count(arity);
    new_lit->kind = kind;
    new_lit->base_pred = ((kind == COR_MAGIC) ? 0 : lit->base_pred);
    new_lit->negated = ((kind == COR_MAGIC) ? 0 : lit->negated) ;
    new_lit->pred = lit->pred;

    return new_lit ;
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces bound args of lit by newly created variables

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/
static void new_bound_args(struct rule *rule, Literal *lit)
{
  ASSERT(lit != NULL && rule != NULL) ;
    for (int i=0; i< lit->args.count(); i++) {
	if (lit->adorn[i]) 
	  // The BOUND variables are replaced by new variables
	  lit->args[i] = make_new_arg(rule) ;
    }

}


/*------------------------------------------------------------------
 Function Behaviour :: Replaces left 1/2 of args of lit by newly created 
 variables

 Oddities/Quirks :: Used only for factor-magic literals

 -------------------------------------------------------------------*/
static void new_leftmost_args(struct rule *rule, Literal *lit)
{
    ASSERT(lit != NULL && rule != NULL) ;
    int len_by_2 = lit->args.count()/2 ;
    for (int i=0; i< len_by_2; i++)
	  lit->args[i] = make_new_arg(rule) ;
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces free args of lit1 by free args of lit2

 Oddities/Quirks :: The free arg counts of the two should be equal.
 Called with two literals of the same predicate.

 -------------------------------------------------------------------*/
static void free_args_from_free(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i = 0, j = 0 ;
    for (; i< lit1->args.count(); i++) {
	if (!lit1->adorn[i]) {
	  while ((j < lit2->args.count()) && (lit2->adorn[j])) j++ ;

	  // The FREE variables in lit1 are replaced by 
	  // FREE variables from lit2
	  lit1->args[i] = lit2->args[j++] ;
	}
    }
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces bound args of lit1 by bound args of lit2

 Oddities/Quirks :: The bound arg counts of the two should be the same.
 Called with two literals of the same predicate
 -------------------------------------------------------------------*/
static void bound_args_from_bound(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i = 0, j = 0 ;
    for (; i< lit1->args.count(); i++) {
	if (lit1->adorn[i]) {
	  while ((j < lit2->args.count()) && (!lit2->adorn[j])) j++ ;

	  // The BOUND variables in lit1 are replaced by 
	  // bound variables from lit2
	  lit1->args[i] = lit2->args[j++] ;
	}
    }
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces all args of lit1 by args of lit2

 Oddities/Quirks :: the arglist lengths shoud be the same. Called with two
 literals of the same predicate.

 -------------------------------------------------------------------*/
static void copy_all_args(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i = 0;
    for (; i< lit1->args.count(); i++) {
	  lit1->args[i] = lit2->args[i] ;
	}
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces rightmost 1/2 of the args of lit1 by 
 bound args of lit2

 Oddities/Quirks :: Called with a factor-magic literal and a literal
 of the same predicate. lit1's arglist is twice the length of the
 bound args of lit2.

 -------------------------------------------------------------------*/
static void rightmost_args_from_bound(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i, j = 0 ;
    for (i = lit1->args.count()/2; i< lit1->args.count(); i++) {
	  while (!lit2->adorn[j]) j++ ;
	  ASSERT(j < lit2->args.count());
	  lit1->args[i] = lit2->args[j++] ;
    }
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces leftmost 1/2 of the args of lit1 by 
 bound args of lit2

 Oddities/Quirks :: Called with a factor-magic literal and a literal
 of the same predicate. lit1's arglist is twice the length of the
 bound args of lit2.

 -------------------------------------------------------------------*/
static void leftmost_args_from_bound(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i = 0, j = 0 ;
    for (; i< lit1->args.count()/2; i++) {
	while (!lit2->adorn[j]) j++ ;
	ASSERT(j < lit2->args.count()) ;
	// The leftmost variables in lit1 are replaced by 
	// bound variables from lit2
	lit1->args[i] = lit2->args[j++] ;
    }
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces leftmost 1/2 of the args of lit1 by 
 the leftmost 1/2 of the args of lit2

 Oddities/Quirks :: Called with two factor-magic literals of the
 same predicate

 -------------------------------------------------------------------*/
static void leftmost_args_from_leftmost(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i = 0;
    for (; i< lit1->args.count()/2; i++)
	lit1->args[i] = lit2->args[i] ;
}

/*------------------------------------------------------------------
 Function Behaviour :: Replaces bound args of lit1 by the leftmost 1/2
 of the args of lit2

 Oddities/Quirks :: Called with a literal and a factor-magic literal of
 the same predicate. lit2's arglist length is twice the bound args of lit1

 -------------------------------------------------------------------*/
static void bound_args_from_leftmost(Literal *lit1, Literal *lit2)
{
  ASSERT(lit1 != NULL && lit2 != NULL) ;
  int i = 0;
  int j = 0;
    for (; i< lit1->args.count()/2; i++) {
//    for (i= lit2->args.count()/2;i < lit2->args.count(); i++) {
	  while (!lit1->adorn[j]) j++ ;
	  ASSERT(j < lit1->args.count());

	  lit1->args[j++] = lit2->args[i] ;
    }
}

static Literal * make_ord_lit( Literal *oldhead)
{
    Literal *new_lit; 

    new_lit = make_new_lit(oldhead, oldhead->arity(), COR_REGULAR);
    new_lit->adorn = oldhead->adorn;

    return new_lit;
}


static Literal *make_magic_factor_lit(Literal *lit )
{
    int i = 0, j = 0 ;
    Literal *new_lit;

    int count = lit->adorn.count() ; /* count of bound args in lit */
    new_lit = make_new_lit(lit, 2*count, COR_FACTORMAGIC) ;
    new_lit->adorn = lit->adorn;

    // Add to list of factor/magic literals
    add_literal(factor_magic_preds, new_lit) ;

    return new_lit;

}

/*------------------------------------------------------------------
 Function Behaviour :: Looks at all the factor-magic predicates
 newly created, and creates rules of the form mc_p(C,C) :- m_p(C).
 for each of them.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/
void add_default_rules(struct collection *magicrules)
{
  Clause *rule ; int i ;
  struct FactorPredList *temp = factor_magic_preds.next ;

  while (temp != NULL) {
    int count = temp->lit->adorn.count() ;
    rule = copy_rule(NULL) ;
    rule->head = make_new_lit(temp->lit, count*2, COR_FACTORMAGIC);
    rule->head->adorn = temp->lit->adorn ;
    rule->num_var_names = temp->lit->adorn.count();
    if (rule->num_var_names == 0) {
      rule->var_names = NULL;
    }
    else {
        // Keep the following as malloc so that 
        // we can realloc as required.
	rule->var_names = (Name*)malloc(rule->num_var_names * sizeof(Name));
	
	int j = -1 ;
	for (i=0; i< rule->num_var_names; ++i)
	  rule->var_names[i] = 
	    (Name)temp->lit->args[j=temp->lit->adorn.next(j)];
      }

    for (i=0; i< count; i++)
	  rule->head->args[i] = make_new_arg(rule) ;
    for (i = count; i < count*2; i++)
	  rule->head->args[i] = rule->head->args[i-count] ;

    alloc_preds(rule, 1);

    rule->preds[0] = make_new_lit(rule->head, count, COR_MAGIC);
    rule->preds[0]->adorn = rule->head->adorn ;

    for (i=0; i< rule->preds[0]->args.count(); i++)
	rule->preds[0]->args[i] = rule->head->args[i] ;

    add_rule(rule, magicrules) ;

    temp = temp->next ;
  }
  
}

/*------------------------------------------------------------------
 Function Behaviour :: Similar to the fn create_derived_magic_rules
 in fullmagic.C in the magic directory. Creates factor_magic rules
 for derived predicates on the rhs of a factored rule.

 Oddities/Quirks :: Uses standard l-to-r sips to generate rules.
 Does not use any user-provided sips, because their meaning in the
 factoring context is unclear.

 Have I over-simplified this ??? -- PRAVEEN

 -------------------------------------------------------------------*/
static void make_derived_magic_rules(struct rule *rule, 
			      struct collection *magic_rules,
			      int pred_index)
{
  Clause *	magicrule;

    if ((rule->preds[pred_index]->base_pred) ||
	(rule->preds[pred_index]->kind == COR_MAGIC))
      return ;

    magicrule = copy_rule(rule); /* copy proto header */
    magicrule->head = build_magic_pred(rule, rule->preds[pred_index], 0);
    alloc_preds(magicrule, pred_index);
    for (int i = 0; i< pred_index; i++)
      magicrule->preds[i] =  rule->preds[i];

    magicrule->type = COR_MAGICRULE ;
    magicrule->source_rule = rule ;
    magicrule->source_pred = rule->preds[pred_index] ;
    add_rule(magicrule, magic_rules);
}


/*------------------------------------------------------------------
 Function Behaviour :: Creates factored/magic rules from the rules
   in 'factor_rules'. The factor_status of these should already have been 
   assigned.

 Oddities/Quirks :: 

 -------------------------------------------------------------------*/
void factor_rewrite(struct collection *factor_rules, 
			struct collection *magic_rules)
{
    factor_linear_preds.init() ;
    factor_magic_preds.init() ;
    FOR_EACH_RULE(single_rule, factor_rules) {
	switch (single_rule->factor_status) {
/*
	case COR_NON_RECURSIVE :
	  do_factor_non_recursive(single_rule, magic_rules) ;
	  break  ;
*/
	case COR_RT_LINEAR :
	  do_factor_rt_linear(single_rule, magic_rules) ;
	  add_literal(factor_linear_preds, single_rule->head) ;
	  break  ;
	case COR_LT_LINEAR :
	  // If UseFactorMagic is set, lt_linear rules are treated
	  // the same as pseudo_lt_linear rules
	  if (parserStruct.CurModule.UseFactorMagic)
	    do_factor_pseudo_lt_linear(single_rule, magic_rules) ;
	  else
	    do_factor_lt_linear(single_rule, magic_rules) ;
	  add_literal(factor_linear_preds, single_rule->head) ;
	  break  ;
	case PSEUDO_LT_LINEAR :
	  do_factor_pseudo_lt_linear(single_rule, magic_rules) ;
	  add_literal(factor_linear_preds, single_rule->head) ;
	  break  ;
	case COR_MULTI_LINEAR :
	  do_factor_multi_linear(single_rule, magic_rules) ;
	  add_literal(factor_linear_preds, single_rule->head) ;
	  break  ;
	case COR_NON_LINEAR :
	  if (parserStruct.CurModule.UseSupplementaryMagic)
	    do_supp_magic_on_rule(single_rule, magic_rules) ;
	  else
	    do_magic_on_rule(single_rule, magic_rules) ;
	  break  ;  
	}
    } END_EACH_RULE

    FOR_EACH_RULE(single_rule, factor_rules) {
	if (single_rule->factor_status == COR_NON_RECURSIVE) {
	  if (in_factor_list(factor_linear_preds, single_rule->head))
	    do_factor_non_recursive(single_rule, magic_rules) ;
	  else if (parserStruct.CurModule.UseSupplementaryMagic)
	    do_supp_magic_on_rule(single_rule, magic_rules) ;
	  else
	    do_magic_on_rule(single_rule, magic_rules) ;
	}
    } END_EACH_RULE

    add_default_rules( magic_rules) ;

    // If SupMagicIndexing option is set, factoring will not have been
    // performed on any rule.

    if (parserStruct.CurModule.SupMagicIndexing) {
	// go through exported predicate list, and create interface rules. 
	for (ExportInfo *export_info = parserStruct.CurModule.ExportedPreds;
	     		export_info != NULL; export_info = export_info->next) 
	     add_interface_rules(magic_rules, export_info->pred_name, 
					export_info->adornment);

    }

}


/*** Rewrite non-recursive rules, according to Context Rule Factoring ***/

static void do_factor_non_recursive(struct rule *rule, struct collection *magic_rules)
{
  Clause *	magicrule;

    magicrule = copy_rule(rule);
    alloc_preds(magicrule, rule->num_preds + 1);

    magicrule->head = make_ord_lit( rule->head);
    magicrule->head_deletes_count = rule->head_deletes_count;
    magicrule->head_deletes = rule->head_deletes;
    new_bound_args(magicrule, magicrule->head) ;
    free_args_from_free(magicrule->head, rule->head) ;

    magicrule->preds[0] = make_magic_factor_lit( rule->head);
    leftmost_args_from_bound(magicrule->preds[0], magicrule->head) ;
    rightmost_args_from_bound(magicrule->preds[0], rule->head) ;

    for (int j=1,i=0;  i<rule->num_preds; ++j, ++i)
      magicrule->preds[j] = rule->preds[i];

    add_rule(magicrule, magic_rules);
    for (i=1; i < magicrule->num_preds; ++i)
        make_derived_magic_rules(magicrule, magic_rules, i) ;

}


/*** Rewrite right linear rules, according to Context Rule Factoring ***/

static void do_factor_rt_linear(struct rule *rule, struct collection *magic_rules)
{
  Clause *	magicrule;

    magicrule = copy_rule(rule);
    alloc_preds(magicrule, rule->num_preds);

    magicrule->head = make_magic_factor_lit( rule->head);
    new_leftmost_args(magicrule, magicrule->head) ;
    rightmost_args_from_bound(magicrule->head, rule->factor_pred) ;

    magicrule->preds[0] = make_magic_factor_lit( rule->head);
    leftmost_args_from_leftmost(magicrule->preds[0], magicrule->head) ;
    rightmost_args_from_bound(magicrule->preds[0], rule->head) ;

    for (int j=1,i=0;  i<rule->num_preds; ++i) {
      if (rule->preds[i] == rule->factor_pred) continue ;
      magicrule->preds[j] = rule->preds[i];
      j++ ;
    }

    add_rule(magicrule, magic_rules);
    for (i=1; i < magicrule->num_preds; ++i)
        make_derived_magic_rules(magicrule, magic_rules, i) ;
}


/*** Rewrite left linear rules, according to Context Rule Factoring ***/

static void do_factor_lt_linear(struct rule *rule, struct collection *magic_rules)
{
  Clause *	magicrule;

    magicrule = copy_rule(rule);
    alloc_preds(magicrule, rule->num_preds);

    magicrule->head = make_ord_lit( rule->head);
    magicrule->head_deletes_count = rule->head_deletes_count;
    magicrule->head_deletes = rule->head_deletes;
    new_bound_args(magicrule, magicrule->head) ;
    free_args_from_free(magicrule->head, rule->head) ;

    magicrule->preds[0] = make_ord_lit( rule->head);
    bound_args_from_bound(magicrule->preds[0], magicrule->head) ;
    free_args_from_free(magicrule->preds[0], rule->factor_pred) ;

    for (int j=1,i=0;  i<rule->num_preds; ++i) {
      if (rule->preds[i] == rule->factor_pred) continue ;
      magicrule->preds[j] = rule->preds[i];
      j++ ;
    }

    add_rule(magicrule, magic_rules);
    for (i=1; i < magicrule->num_preds; ++i)
        make_derived_magic_rules(magicrule, magic_rules, i) ;
}


/*** Rewrite pseudo left linear rules, according to Context Rule Factoring ***/

static void do_factor_pseudo_lt_linear(struct rule *rule,
				struct collection *magic_rules)
{
  Clause *	magicrule;

    magicrule = copy_rule(rule);
    alloc_preds(magicrule, rule->num_preds+1);

    magicrule->head = make_ord_lit( rule->head);
    magicrule->head_deletes_count = rule->head_deletes_count;
    magicrule->head_deletes = rule->head_deletes;
    new_bound_args(magicrule, magicrule->head) ;
    free_args_from_free(magicrule->head, rule->head) ;

    magicrule->preds[0] = make_magic_factor_lit( rule->head);
    leftmost_args_from_bound(magicrule->preds[0], magicrule->head) ;
    rightmost_args_from_bound(magicrule->preds[0], rule->head) ;

    magicrule->preds[1] = make_ord_lit( rule->head);
    bound_args_from_bound(magicrule->preds[1], magicrule->head) ;
    free_args_from_free(magicrule->preds[1], rule->factor_pred) ;

    for (int j=2,i=0;  i<rule->num_preds; ++i) {
      if (rule->preds[i] == rule->factor_pred) continue ;
      magicrule->preds[j] = rule->preds[i];
      j++ ;
    }

    add_rule(magicrule, magic_rules);
    for (i=1; i < magicrule->num_preds; ++i)
        make_derived_magic_rules(magicrule, magic_rules, i) ;
}


/*** Rewrite multi linear rules, according to Context Rule Factoring ***/

static void do_factor_multi_linear(struct rule *rule, struct collection *magic_rules)
{
  Clause *	magicrule;
  int num_preds, j_start = 0 ;

    magicrule = copy_rule(rule);
    num_preds = 
      (parserStruct.CurModule.UseFactorMagic ? rule->num_preds : rule->num_preds-1);
    alloc_preds(magicrule, num_preds);

    magicrule->head = make_magic_factor_lit( rule->head);
    new_leftmost_args(magicrule, magicrule->head) ;
    rightmost_args_from_bound(magicrule->head, rule->factor_pred) ;

    if (parserStruct.CurModule.UseFactorMagic) {
      magicrule->preds[0] = make_magic_factor_lit( rule->head);
      leftmost_args_from_leftmost(magicrule->preds[0], magicrule->head) ;
      rightmost_args_from_bound(magicrule->preds[0], rule->head) ;

      j_start = 1 ;
    }

    for (int j=j_start,i=0;  i<rule->num_preds; ++i) {
      if (rule->preds[i] == rule->factor_pred) continue ;
      if (rule->head->predicate != rule->preds[i]->predicate) {
	magicrule->preds[j] = rule->preds[i];
	j++ ;
	continue ;
      }
      magicrule->preds[j] = make_ord_lit( rule->preds[i]);
/*
      copy_all_args(magicrule->preds[j], rule->preds[i]);
      bound_args_from_leftmost(magicrule->preds[j], magicrule->head);
*/
      bound_args_from_bound(magicrule->preds[j], magicrule->head) ;
      free_args_from_free(magicrule->preds[j], rule->preds[i]) ;
      j++ ;
    }

    add_rule(magicrule, magic_rules);
    for (i=1; i < magicrule->num_preds; ++i)
        make_derived_magic_rules(magicrule, magic_rules, i) ;

}

