/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/****************************************************************************/
/*	reduce.c
	Discarding Rules
*/

#include "exist.h"
#include "rules.h"
#include "reduce.h"
#include "externs.h"

#define COR_MAX_PROJ 1000

extern void printUnitRules(struct unitR *, int);
extern void printProj(struct projection *, int) ;
extern void print_exist_rule(struct rule *rule, FILE *out);
extern void print_bits(BitVector , int, FILE *);

static struct rule *delUnitRules(struct rule *rules, struct projection *unitP,
				int  numUP);
static struct rule *deleteRule(struct rule *rules, int *delRule);
static int findUnitRules(struct rule *, struct unitR *) ;
static int DupUnitRule(struct unitR *, int, struct rule *, int);
static int unitRuleProj(struct unitR *, int, struct projection *);
static int projectArg(struct rule *, struct projection *);
static int dupSummary(struct projection *, int);
static void findEdge(unsigned int *, Literal *, Literal *);
static void mergeEdge(unsigned int *, unsigned int *, unsigned int *);
static int summary(struct projection *, int);
static void markDelRule(struct projection *,struct projection *,int,int,int *);
static void printProjs(struct projection *proj, int,
		       struct projection *uProj, int, FILE *);


/****************************************************************************/
/* rules point to the first rule in the program.  base will be filled in
   in the function where base[i] is marked COR_DERIVED if predicate with pred
   number i appears anywhere in the head of the rule
*/
/****************************************************************************/
struct rule *reduce(struct rule *rules)
                                      /* indexed by pred num */
{
	struct unitR unitR[COR_MAX_RULES];	/* store the unit rules */
	struct projection unitP[COR_MAX_PROJ]; 	/* projections for the unit rules */
	struct projection proj[COR_MAX_PROJ];	/* projections for the rules */
	int numUR;				/* number of unit rules */
	int numP;				/* number of projections */
	int numUP;			/* number of unit rules projections */
	int delRule[COR_MAX_RULES];		/* mark rules that should be deleted */

	/* add unit rules for each head predicates w/ 'd' arguments */
	rules = addUnitRules(rules);

	// fprintf(stderr, " added unit rules \n");
	// printAdorn(rules, 0);

	numUR = findUnitRules(rules, unitR);
	numUP = unitRuleProj(unitR, numUR, unitP);

	//fprintf(stderr, "numUR = %d, numUP = %d \n", numUR, numUP);

	/* find the initial set of arg projections, then compute the summary */
	numP = projectArg(rules, proj);

        //fprintf(stderr, "initial numP = %d\n", numP);

	numP = summary(proj, numP);

        //printProjs(proj, numP, unitP, numUP, stdout);

	markDelRule(unitP, proj, numUP, numP, delRule); 
	rules = deleteRule(rules, delRule);
	rules = delUnitRules(rules, unitP, numUP);

	return(rules);
}

static void printProj(struct projection& p, FILE *outf)
{
  int k;
  fprintf(outf, "head :: %s", 
	  SymbolString(p.h->head->predicate->name));
  print_bits(p.h->head->adorn, 0, outf);
  fprintf(outf, ", %d, tail :: %s", p.headRuleNum, 
	  SymbolString(p.t->preds[p.pInd]->predicate->name));
  print_bits(p.t->preds[p.pInd]->adorn, 0, outf);
  fprintf(outf,", %d :", p.ruleNum);

  for (k=0; k<5; k++)
    fprintf(outf, "%d", p.edge[k]);

  fprintf(outf, "\n");
}

static void printProjs(struct projection *proj, int numP,
		       struct projection *uProj, int numUP, FILE *outf)
{
  int i;

  fprintf(outf, "num unit projs = %d \n", numUP);

  for (i = 0; i < numUP; i++) {
    fprintf(outf, "(%d)", i);
    printProj(uProj[i], outf);
  }

  fprintf(outf, "num rule projs = %d \n", numP);
  for (i = 0; i < numP; i++) {
    fprintf(outf, "(%d)", i);
    printProj(proj[i], outf);
  } 
}

/****************************************************************************/
/* find all the unit rules and put them in the array unitRules. Return the
   number of unit rules. Unit rules incluede trivial unit rules of the
   form p[a] :- p[a].
*/
/****************************************************************************/
static int findUnitRules(struct rule *rules, struct unitR *u)
{
  struct rule *r;
  Literal *p;
  int i;
  
  for (r=rules, i=0; (r!=NULL) && (i<COR_MAX_RULES);
       r=(struct rule *)r->link.next) { 
    if (r->head == NULL) 		/* in case of empty head */
      continue;
    if (r->num_preds==1) {
      p = r->preds[0];
      if (p==NULL) {
	fprintf(stderr, "Error in findUnitRule: predicate doesn't exist\n");
	exit(0);
      }
//      if (!p->base_pred)
      if (1)
	if (!DupUnitRule(u,i,r,COR_NONTRIVIAL)) {
	  u[i].r = r;
	  u[i++].t = COR_NONTRIVIAL;
	  //fprintf(stderr, "hah : nontrivial %d\n", i);
	}
	else if (!DupUnitRule(u, i, r, COR_TRIVIAL)) {
	  u[i].r = r;
	  u[i++].t = COR_TRIVIAL;
	  //fprintf(stderr, "hoh : trivial %d\n", i);
	}
      
    }
  }
  if (i==COR_MAX_RULES) { 
    fprintf(stderr, "Error in findUnitRule: too many rules\n");
    fprintf(stderr, "Repair: the constant COR_MAX_RULES needs a bigger value.\n");
    exit(0);
  }
  return(i);
}

/****************************************************************************/
/* make sure there's no duplicate unit rules in the unit rule table
*/
/****************************************************************************/
static int DupUnitRule(struct unitR *u, int num, struct rule *r, int trivial)
{
	int i;

	if (r==NULL) {
		fprintf(stderr, "Error in DupUnitRule: null head\n");
		return(1);
	}
	if (r->head==NULL)
		return(1);

	if (r->preds[0]==NULL) {
		fprintf(stderr, "Error in DupUnitRule: missing body predicate\n");
		exit(0);
	}

	Literal *rh = r->head, *rp ;
	BitVector v1 = r->head->adorn, v2;
	
	if (trivial==COR_TRIVIAL) {
		rp = rh;
		v2 = v1;
	} else {
		rp = r->preds[0];
		v2 = r->preds[0]->adorn ;
	}
	for (i=0; i<num; i++) {
		Literal *h = u[i].r->head, *p ;
		BitVector v3 = u[i].r->head->adorn, v4 ;
		if (u[i].t==COR_TRIVIAL) {
			p = h;
			v4 = v3;
		} else {
			p = u[i].r->preds[0] ;
			v4 = u[i].r->preds[0]->adorn ;
		}
		if ((rh->predicate == h->predicate) && 
		    (rp->predicate == p->predicate) && (v1==v3) && (v2==v4))
			return(1);
	}
	return(0);
}

/****************************************************************************/
/* find the argument projection of the unit rules.  It searches through
   the unit rule table and finds the projection.  the proj[i].pInd will
   be -1 if the unit rule is a trivial rule.  It returns the number
   of argument projections.
*/
/****************************************************************************/
static int unitRuleProj(struct unitR *u, int num, struct projection *proj)
{
  int i, k;
  
  for (i=0; i<num; i++) {
    proj[i].h = proj[i].t = u[i].r;
    proj[i].b = NULL;
    proj[i].used = 0;
    for (k=0; k<COR_MAX_VARS; k++)
      proj[i].edge[k] = 0;
    if (u[i].t==COR_TRIVIAL) {
      proj[i].pInd = -1;   /* should make it a constant */
      findEdge(proj[i].edge, u[i].r->head, u[i].r->head);
    } else {
      proj[i].pInd = 0;    /* always the first predicate */
      findEdge(proj[i].edge, u[i].r->head, u[i].r->preds[0]);
    }
  }
  return(num); 	/* return the number of argument projections */
}

/****************************************************************************/
/* find out the initial set of argument projections from the given set
   of rules.  Arguemnt projections are obtain between the head predicate
   of each rule and its derived predicates.  The edges going out from
   each variable of the head predicate is stored in the integer array edge.
*/
/****************************************************************************/
static int projectArg(struct rule *rules, struct projection *proj)

{
  int i, j, k;
  int num;			/* TEMP, count the rule number */
  struct rule *r,  *b;
  
  i = 0;
  for (r=rules, num=0, b=NULL; (r!=NULL) && (i<COR_MAX_RULES); 
       b=r, r=(struct rule *)r->link.next, num++) {
    
    for (j=0; (j<r->num_preds) && (i<COR_MAX_RULES); j++)
//      if (!(r->preds[j]->base_pred)) {
      if (1) {
	proj[i].h = proj[i].t = r;
	
	/* rule number for tail predicate */
	proj[i].ruleNum = num;    
	
	/* use to trace the first proj */
	proj[i].headRuleNum = num;
	
	/* NOT USED ANYMORE */
	proj[i].b = b;
	
	/* the jth pred of rule r */
	proj[i].pInd = j;
	
	/* initialize the edges */
	for (k=0; k<COR_MAX_VARS; k++)
	  proj[i].edge[k] = 0;
	
	findEdge(proj[i].edge, r->head, r->preds[j]); 
	/* check duplicates */
	
	if (!dupSummary(proj, i))
	  i++; 
      }
  }
  
  if (i==COR_MAX_RULES) {
    fprintf(stderr, "Error in projectArg: too many projections\n");
    fprintf(stderr, "Repair: change the constant COR_MAX_RULES to a bigger value.\n");
    exit(0);
  }
  return(i);		/* return number of summaries */
}

/****************************************************************************/
/* dupSummary checks if the last summary of the projection array is a
   duplicate of the previous ones.  It checks the predicate numbers of
   both the head and tail predicates, their adornments and the head and
   tail rule numbers.
*/
/****************************************************************************/
static int dupSummary(struct projection *proj, int num)
{
  int i, j;
  Literal *p1, *p2;
  
  p1 = proj[num].h->head;
  p2 = proj[num].t->preds[proj[num].pInd];
  for (i=0; i<num; i++) {
    if ((proj[i].ruleNum==proj[num].ruleNum) &&
	(proj[i].headRuleNum==proj[num].headRuleNum) &&
	(proj[i].h->head->predicate==p1->predicate) && 
	(proj[i].h->head->adorn == p1->adorn) && 
	(proj[i].t->preds[proj[i].pInd]->predicate==p2->predicate) &&
	(proj[i].t->preds[proj[i].pInd]->adorn ==p2->adorn)) {
      for (j=0; j<COR_MAX_VARS; j++)
	if (proj[i].edge[j] != proj[num].edge[j])
	  break;
      if (j==COR_MAX_VARS)
	return(1);
    }
  }
  return(0);
}

/****************************************************************************/
/* find edges between the vars of the head predicate and the tail
   predicate. t is assumed to be a derived predicate.  There will
   be no edges to or from dontcare and non-variable arguemnts.
   An edge is marked for common variable names appeared in both
   the head and the tail predicate.
*/
/****************************************************************************/
static void findEdge(unsigned int *edge, Literal *h, Literal *t)
{
  int k = 0, j = 0;
  
  if ((h==NULL) || (t==NULL)) {
    fprintf(stderr, "Error in findEdge: null parameter\n");
    exit(0);
  }
  FOR_EACH_ARG(a, h->args) {
    j = 0;
    FOR_EACH_ARG(b, t->args) {
      if ((a->kindof() != COR_VARIABLE) || (h->adorn[k])) continue ;
      if ((b->kindof() != COR_VARIABLE) || (t->adorn[k])) continue ;
      if (((VarArg *)a)->var == ((VarArg *)b)->var)
	edge[k] |= (1<<j) ;
      j++;  
    }END_EACH_ARG;
    k++;
  }END_EACH_ARG
}

/****************************************************************************/
/* merge edge1 and edge2 and put the result in edge3
*/
/****************************************************************************/
static void mergeEdge(unsigned int *edge1, unsigned int *edge2, unsigned int *edge3)
{
  int i, j, k;
  
  for (i=0; i<COR_MAX_VARS; i++) {
    if (edge1[i] != 0) {
      for (j=0; j<COR_MAX_VARS; j++)
	if (edge1[i] & (1<<j)) {
	  edge3[i] = edge2[j];
	  break;
	}      
    } else 
      edge3[i] = 0;	/* 0 means no path */
  }
}

/****************************************************************************/
/* generate all possible summaries from the initial set of argument
   projections, and append the newly generated summaries to the end
   of the argument projections.
*/
/****************************************************************************/
static int summary(struct projection *proj, int num)
{
  int i, j, k;
  
  for (i=0; i<num; i++) {
    Literal *p = proj[i].t->preds[proj[i].pInd] ;
    BitVector v = proj[i].t->preds[proj[i].pInd]->adorn;
    for (j=0; j<num; j++) {
      Literal *h = proj[j].h->head;
      if ((p->predicate == h->predicate) && 
	  (v == h->adorn)) {
	proj[num].h = proj[i].h;
	proj[num].t = proj[j].t;
	proj[num].pInd = proj[j].pInd;
	proj[num].b = proj[j].b;
	proj[num].ruleNum = proj[j].ruleNum;
	proj[num].headRuleNum = proj[i].headRuleNum;
	for (k=0; k<COR_MAX_VARS; k++)
	  proj[num].edge[k] = 0;
	mergeEdge(proj[i].edge, proj[j].edge, proj[num].edge);
	if (!dupSummary(proj, num)) 
	  num++;
      }
    }
  }
  return(num);	/* return number of projections */
}

/***************************************************************************/
/* Checks that proj[i] corresponds to the same head and tail predicates
   as hp and tp. hv and tv are the corresponding adornments of hp and tp.
*/
/***************************************************************************/
static int isSimilarSummary(struct projection *proj,
			    int j /* uproj_index */,
			    Literal *hp, BitVector& hv,
			    Literal *tp, BitVector& tv)
{
  if  ((hp->predicate ==proj[j].h->head->predicate) &&
       (hv==proj[j].h->head->adorn) &&
       (tp->predicate == proj[j].t->preds[proj[j].pInd]->predicate) &&
       (tv==proj[j].t->preds[proj[j].pInd]->adorn)) {
    return 1;
  }
  return 0;
}

/***************************************************************************/
/* Checks the edges of proj[j] and uproj[i]
   as hp and tp. hv and tv are the corresponding adornments of hp and tp.
*/
/***************************************************************************/
static int hasIdenticalEdges(struct projection* uProj,
			      struct projection* proj,
			      int i /*uproj_index*/, int j /*proj_index*/)
{
  int k;

  for (k=0; k<COR_MAX_VARS; k++)
    if (proj[j].edge[k] != uProj[i].edge[k])
      return 0;	/* found a different edge */
  return 1;
}

/****************************************************************************/
/* uProj is the argument projections of the unit rules, proj is the argument
   projections of the set of rules.  numU and numP are the numbers of argument
   projections for unit rules and the rules respectively.

   deleteRule tries to compare the summaries of the rules with the argument
   projection of the unit rules found.  If the argument projection of a 
   unit rule p_a :- p1_a1. is identical to all the summaries of the form
   p_a :- p1_a1. then the rules associated with p1_a1 is marked.  The 
   parameter delRule will store the marked/unmarked rules.  No rules are
   actually deleted in this function.
*/
/****************************************************************************/
static void markDelRule(struct projection *uProj, struct projection *proj,
				int numUP, int numP, int *delRule)
/* int delRule[];  return the rule numbers which should be deleted */
{
  int i, j, k, l, d;
  int delete_flag = 0;
  int r[COR_MAX_PROJ];	/* mark all the summaries of the same form */

  //fprintf(stderr, "markDelRule :: numUP = %d, numP = %d\n", numUP, numP);
  
  for (i=0; i<COR_MAX_RULES; i++)
    delRule[i] = 0;		/* no rule should be deleted yet */
  for (i=0; i<numUP; i++) {
    Literal *hp = uProj[i].h->head , *tp;
    BitVector hv = uProj[i].h->head->adorn, tv;
    if (uProj[i].pInd<0) {
      tp = hp;
      tv = hv;
    } else {
      tp = uProj[i].t->preds[uProj[i].pInd] ;
      tv = uProj[i].t->preds[uProj[i].pInd]->adorn ;
    }

#if 0
    fprintf(stderr, "head predicate is : %s :", SymbolString(hp->predicate->name));
    print_exist_rule(uProj[i].h, stderr);
    fprintf(stderr, "tail predicate is : %s :", SymbolString(tp->predicate->name));
    print_exist_rule(uProj[i].t, stderr);
#endif

    for (j=0; j<numP; j++) {
      delete_flag = 0;
      d = 0;
      if ((isSimilarSummary(proj, j, hp, hv, tp, tv)) &&
	  (hasIdenticalEdges(uProj, proj, i, j))){
	/** 
	 ** This projection is identical to the unit projection uproj[i] **
	 ** Now check if all other projections/summaries corresponding to *
	 ** the same head and tail are also identical to the unit projection *
	 ** If so, we can mark the tail rule as deleteable *
	 **/
	r[d++] = j;
	delete_flag = 1;
	//fprintf(stderr, "found a similar proj %d\n", j);
	for (l=j+1; l<numP; l++) {
	  if (isSimilarSummary(proj, l, hp, hv, tp, tv) &&
	      (proj[l].ruleNum == proj[j].ruleNum) &&
	      (proj[l].pInd == proj[j].pInd)) {
	    //fprintf(stderr, "found another ? %d ", l);
	    if (!hasIdenticalEdges(uProj, proj, i, l)) {
	      delete_flag = 0;
	      //fprintf(stderr, " no !!\n");
	      break;
	    }
	    else {
	      //fprintf(stderr, " yes\n");
	      r[d++] = l;
	    }
	  }
	}
      }
      if ((d>0) && (delete_flag)) { /* COR, I'M NOT SURE ABOUT THIS :-) */
	/* ...try not to delete the unit rules */
	for (k=0; k<d; k++) {
	  if (proj[r[k]].t->num_preds > 1) {
	    delRule[proj[r[k]].ruleNum] = 1;
	    //fprintf(stderr, "marking rule no : %d\n", proj[r[k]].ruleNum);
	    if ((hp->predicate==tp->predicate) && 
		(!( hv == tv)))
	      /* mark the unit rule */
	      /* not to delete it later */
	      uProj[i].used = 1;	
	  }
#if 0
	  else {
	    fprintf(stderr, "rule with numpreds == 1 :");
	    print_exist_rule(proj[r[k]].t ,stderr);
          }
#endif

	}
      }

    }
  } /* for */
}

/****************************************************************************/
/* the actual deletion of rules takes place here.
   It looks at the array delRule to see which rule is marked for deletion.
   NOTE: It won't delete the first rule even if it is marked.
   DOES IT MAKE SENSE NOT TO DELETE THE QUERY?
*/
/****************************************************************************/
static struct rule *deleteRule(struct rule *rules, int *delRule)
{
  int i;
  struct rule *r, *b;
  
  for (r=rules, b=NULL, i=0; (r!=NULL) && (i<COR_MAX_RULES); 
       r=(struct rule *)r->link.next, i++) {
    if ((delRule[i]==1) && (b!=NULL)) {
     //fprintf(stderr, "hah ! a deletd rule; numpreds = %d\n ", r->num_preds);
     //print_exist_rule(r, stderr);
      if (r->num_preds > 1) {
	/* jump over the deleted rule */
	b->link.next = r->link.next;
      }
    } else
      b = r;
  }
  if (i==COR_MAX_RULES) {
    fprintf(stderr, "Error in deleteRule: too many rules\n");
    exit(1);
  }
  return(rules);
}

/****************************************************************************/

static int unitRuleUsed(struct rule *r, struct projection *unitP, int numUP)
{
	register int i;

	for (i=0; i<numUP; i++) {
		if (unitP[i].used)	
			return(1);
	}
	return(0);
}

/*****************************************************************************/
static struct rule *delUnitRules(struct rule *rules, struct projection *unitP,
				int  numUP)
{
	struct rule *r, *b;

	if (rules==NULL)
		return(NULL);
	for (r=(struct rule *)rules->link.next, b=rules; r!=NULL; 
			r=(struct rule *)r->link.next) {
		if ((r->num_preds==1) && 
		    (r->head->predicate == r->preds[0]->predicate)) {
			if (r->head->adorn == r->preds[0]->adorn) {
				b->link.next = r->link.next;
			} else if (!unitRuleUsed(r, unitP, numUP)) {
				b->link.next = r->link.next;
			} else
				b = r;
		} else
			b = r;
	}
	return(rules);
}

/*****************************************************************************/






