/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/****************************************************************************/
/*	print.c :: contains all print routines for magic and exist
*/
/****************************************************************************/
#include "exist.h"
#include "globals.h"
#include "rules.h"
#include "reduce.h"
#include "factor.h"

extern void print_sips(struct rule *, struct sips *, FILE *);
extern void print_make_index_annotations(FILE *file);
extern void print_MultisetAnnotations(FILE *file);

extern void print_Annotations(ModuleInfo&, FILE *, PredAnnotations *,
			      PredAnnotations *, PredAnnotations *,
			      PredAnnotations *, PredAnnotations *);


/****************************************************************************/
void print_bits(BitVector b, int flag, FILE *outf) 
{
    register int i;
    char c[32];
    char ch;

    if (b.length == 0) return ;
    fprintf(outf, "_");
    ch = (flag==0) ? 'd':'_';

    for (i=0; i<b.length; ++i)
	c[i] = b[i] ? ch : 'n';

    c[b.length]='\0';

    fprintf(outf, "%s", c);
}

/****************************************************************************/
void print_bits(BitVector b, int flag)
{
   print_bits(b, flag, stderr);
}

/****************************************************************************/
void printUnitRules(struct unitR *u, int num)
{
	int i;
	Literal *h, *p;

	fprintf(stderr, "\nUnit rules:\n");
	for (i=0; i<num; i++) {
		if (u[i].r==NULL) {
			fprintf(stderr, "Error in printUnitRule: null rule\n");
			exit(0);
		}
		h = u[i].r->head;
		if (u[i].t==COR_TRIVIAL) 
			p = h;
		else 
			p = u[i].r->preds[0];

		fprintf(stderr, "(%d) %s[", i+1, SymbolString(h->name()));
		print_bits(h->adorn, 0);
		fprintf(stderr, "] :- %s[", SymbolString(p->name()));
		print_bits(p->adorn, 0);
		fprintf(stderr, "].\t(%s)\n",u[i].t==COR_TRIVIAL ? "trivial": "nontrivial");
	}
}

/****************************************************************************/
/* print the projection arguments and summaries, if any
*/
/****************************************************************************/
void printProj(struct projection *proj, int num)
{
	int i, j;
	Literal *p1, *p2;

	fprintf(stderr, "\nArgument projections:\n");
	for (i=0; i<num; i++) {
		p1 = proj[i].h->head; 
		if (proj[i].pInd >= 0)
			p2 = proj[i].t->preds[proj[i].pInd];
		else 
			p2 = proj[i].t->head;
		fprintf(stderr, "[%d] (%s[", i+1, SymbolString(p1->name()));
		print_bits(p1->adorn, 0);
		fprintf(stderr, "](");

		proj[i].h->head->args.printon(stdout);
		fprintf(stderr, ") %s[", SymbolString(p2->name()));
		print_bits(p2->adorn, 0);
		fprintf(stderr, "](");
		if (proj[i].pInd >=0)
		    proj[i].t->preds[proj[i].pInd]->args.printon(stdout);
		else 
		    proj[i].h->head->args.printon(stdout);
		fprintf(stderr, "))\t");

		j = 0 ;
		FOR_EACH_ARG(a, p1->args) {
			fprintf(stderr, " %d", proj[i].edge[j++]);
		}END_EACH_ARG
		fprintf(stderr, "\n");
	}
}


/****************************************************************************/

static void print_exist_pred(Literal *p, FILE *out)
{
    if ( p->negated ) fprintf(out, " not ") ;
    PrintSymbol(p->name(), out);
    
// Dont print adornments for base predicates.
// Also dont print adornments for predicates with all args needed -- this 
// ensures that the name of the predicate remains the same as in the 
// original program, so that makeindex annotations, etc are unaffected.
    if ((!(p->base_pred)) && (p->adorn.any()))
	print_bits(p->adorn, 0, out);

    fprintf(out, "(");

    int k=0, j=0;
    FOR_EACH_ARG(a, p->args) {
	if (!p->adorn[k]) {
	    if (j) fprintf(out, ",");
	    a->print(NULL, out);
	    j++;
	}
	else if (p->base_pred) {
	    if (j) fprintf(out, ",");
	    TheDontCareArg.print(NULL, out);
	    j++;
	}
	k++ ;
    }END_EACH_ARG
    fprintf(out, ")");

}

/****************************************************************************/

void print_exist_rule(struct rule *rule, FILE *out)
{

    int j;
    for (ClauseName *cname = rule->clause_names; cname; cname = cname->next)
        fprintf(out, "%s: ", SymbolString(cname->name));
    print_exist_pred(rule->head, out);
    if (rule->num_preds > 0 || rule->sips != NULL) {
        fprintf(out, " :- ");
        for (j = 0; j < rule->num_preds; ++j) {
            print_exist_pred(rule->preds[j], out);
            if (j < rule->num_preds - 1)
                fprintf(out, ", ");
        }
        if (j==0)
            fprintf(out, "true");       /* print "true" if no rhs preds */
        if (rule->sips) {
            fprintf(out, " \n \t \t alias ");
            print_sips(rule, rule->sips, out);
        }
    }
    fprintf(out, ".");

    fprintf(out, "\n");
}

/****************************************************************************/ 
/* if flag==0, print "nd",  if flag==1, print "n_"  
*/
/****************************************************************************/ 
void printAdorn(struct rule *rules, int flag)
{
    struct rule *r;
    int j=1;

    for (r=rules; r; r = (struct rule *)r->link.next) {
	fprintf(stderr, "[%d]\t", j++);
	print_exist_rule(r, stderr);
      }

}

/****************************************************************************/ 

void print_exist(struct rule *rules, FILE *outf)
{

    if (rules == NULL){
	fprintf(stderr, "CORAL:: WARNING !! Existential Optimization");
	fprintf(stderr, " results in module with no rules\n");
	return;
    } 

    if (parserStruct.CurModule.name)
	fprintf(outf, "module %s.\n", SymbolString(parserStruct.CurModule.name));
    for (ExportInfo *export_info = parserStruct.CurModule.ExportedPreds;
	 export_info != NULL;
	 export_info = export_info->next) {
	fprintf(outf, "export %s[", export_info->pred_name->string());
	if (export_info->adorn_symbol)
	    fputs(export_info->adorn_symbol->string(), outf);
	fprintf(outf, "].\n");
    }

    print_Annotations(parserStruct.CurModule, outf,
		      parserStruct.make_index_annotations ,
		      parserStruct.agg_sel_annotations ,
		      parserStruct.AllowedAdornList ,
		      parserStruct.MultisetAnnotations ,
		      parserStruct.prioritize_annotations);

    struct rule *r;
    for (r=rules; r; r = (struct rule *)r->link.next)
	print_exist_rule(r, outf);

    fprintf(outf, "end_module.\n") ;
}

/****************************************************************************/ 
static void print_status(struct rule *rule, FILE *out)
{
  char *str ;
  switch(rule->factor_status) {
  case 0 : str = "COR_NON_RECURSIVE   " ; break ;
  case 1 : str = "COR_RT_LINEAR       " ; break ;
  case 2 : str = "COR_LT_LINEAR       " ; break ;
  case 3 : str = "PSEUDO_LT_LINEAR" ; break ;
  case 4 : str = "COR_MULTI_LINEAR    " ; break ;
  default : str = "COR_NON_LINEAR     " ; break ;
  }
  fprintf(out, "%s : ", str) ;
}

/****************************************************************************/ 

void print_factor(struct collection *factor_rules, FILE *outf,
		  int show_status)
{

    if ((struct rule *)(factor_rules->chain) == NULL) {
      fprintf(stderr,
	      "CORAL:: WARNING !! Magic/Factoring for %s results in module with no rules\n",
	      parserStruct.CurModule.name->string());
      return;
    } 

    if (parserStruct.CurModule.name)
	fprintf(outf, "module %s.\n", SymbolString(parserStruct.CurModule.name));
    for (ExportInfo *export_info = parserStruct.CurModule.ExportedPreds;
	 export_info != NULL;
	 export_info = export_info->next) {
	fprintf(outf, "export %s[", export_info->pred_name->string());
	if (export_info->adorn_symbol)
	    fputs(export_info->adorn_symbol->string(), outf);
	fprintf(outf, "].\n");
    }

    print_Annotations(parserStruct.CurModule, outf,
		      parserStruct.make_index_annotations ,
		      parserStruct.agg_sel_annotations ,
		      parserStruct.AllowedAdornList ,
		      parserStruct.MultisetAnnotations ,
		      parserStruct.prioritize_annotations);


    FOR_EACH_RULE(factorrule, factor_rules) {
      if (show_status)
	print_status(factorrule, outf) ;
      print_rule(factorrule, outf);
    } END_EACH_RULE

    fprintf(outf, "end_module.\n\n") ;
}

/****************************************************************************/ 
