/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include 	"factor.h"

//extern void print_rule(struct rule *, FILE *) ;

/***************************************************************************/
static int right_linear(struct rule * rule)
{

   Literal *pred = NULL ;

   // Only one literal should have the same predicate as the head
   for (int i = 0; i< rule->num_preds; i++) {
	if (rule->head->predicate == rule->preds[i]->predicate) {
	    // If the head predicate has already occured in the rule
	    if (pred) return 0 ;
	    pred = rule->preds[i];
	}
   }

   if (pred == NULL) return 0 ;

   // This literal should have the same adornment as the head
   if (!(rule->head->adorn == pred->adorn))
	return 0 ;

   // Checking conditions on variables in the predicates !!

   for (i=0; i< pred->adorn.len(); i++) {

	if (!(pred->adorn[i])) {
	    // The FREE variables of pred should be identical to the free
	    // variables of the head predicate
	    if (!(pred->args[i]->equals(rule->head->args[i]))) return 0 ;

	    // Check that the free variables do not occur
	    // anywhere else in the rule.
	    for (int j = 0; j < rule->num_preds; j++)
		if (rule->preds[j] != pred)
		    for (int k = 0; k < rule->preds[j]->args.count(); k++)
			if (pred->args[i]->equals(rule->preds[j]->args[k]))
				return 0 ;
	}

	else {
	    // The BOUND variables of pred should appear in one of the
	    // body literal or as a bound variable of the head literal
	    int var_found = 0 ;

	    for (int j = 0; j < rule->head->adorn.len(); j++)
		if ((pred->args[i]->equals(rule->head->args[j]))
			&&(rule->head->adorn[j])) {
		    var_found = 1;
		    break ;
		}

	    if (var_found) continue ;

	    for (j = 0; j < rule->num_preds; j++)
		if (rule->preds[j] != pred) {
		    for (int k = 0; k < rule->preds[j]->args.count(); k++) {
			if (pred->args[i]->equals(rule->preds[j]->args[k])) {
			    var_found = 1 ;
			    break ;
			}
		    }
		    if (var_found) break ;
		}
	    if (!(var_found))  return 0 ;
	    
	}
    }

   rule->factor_status = (int) COR_RT_LINEAR ;
   rule->factor_pred = pred ;
   return 1 ;
}

/***************************************************************************/
static int left_linear(struct rule * rule)
{

   Literal *pred = NULL ;
   int pseudo_linear = 0 ;

   // Only one literal should have the same predicate as the head
   for (int i = 0; i< rule->num_preds; i++) {
	if (rule->head->predicate == rule->preds[i]->predicate) {
	    // If the head predicate has already occured in the rule
	    if (pred) return 0 ;
	    pred = rule->preds[i];
	}
   }

   if (pred == NULL) return 0 ;

   // This literal should have the same adornment as the head
   if (!(rule->head->adorn == pred->adorn))
	return 0 ;

   // Checking conditions on variables in the predicates !!

   for (i=0; i< pred->adorn.len(); i++) {
	if (pred->adorn[i]) {
	    // The BOUND variables of pred should be identical to the bound
	    // variables of the head literal
	    if (!(pred->args[i]->equals(rule->head->args[i]))) return 0 ;

	    // Check that the bound variables do not occur
	    // anywhere else in the rule. If this condition is not
	    // satisfied, the rule could still be PSEUDO_LT_LINEAR

	    if (pseudo_linear) continue ;
	    for (int j = 0; j < rule->num_preds; j++)
		if (rule->preds[j] != pred) {
		    for (int k = 0; k < rule->preds[j]->args.count(); k++)
			if (pred->args[i]->equals(rule->preds[j]->args[k])) {
			    pseudo_linear = 1 ;
			    break ;
			}
		    if (pseudo_linear) break ;
		}
	}

	else {
	    // The FREE variables of pred should be different from all
	    // bound variables of pred (i.e) of the head literal

	    for (int j = 0; j < rule->head->adorn.len(); j++)
		if ((pred->args[i]->equals(rule->head->args[j]))
			&&(rule->head->adorn[j]))
		    return 0 ;
	    
	}
    }

   
   rule->factor_status = (pseudo_linear) ? (int) PSEUDO_LT_LINEAR :
					   (int) COR_LT_LINEAR ;
   rule->factor_pred = pred ;

   return 1 ;
}

/***************************************************************************/
// Tests to see if the particular literal 'pred' is the one on which
// the multi-linear conditions hold

static int test_multi_linear(struct rule *rule, Literal *pred)
{
 // The adornment should be the same as for the head literal
   if (!(rule->head->adorn == pred->adorn))
	return 0 ;

   for (int i=0; i< pred->adorn.len(); i++) {
	if (pred->adorn[i]) {
	    // The BOUND variables of pred should appear in one of the
	    // body literal but NOT as a bound variable of the head literal
	    int var_found = 0 ;

	    for (int j = 0; j < rule->head->adorn.len(); j++)
		if ((pred->args[i]->equals(rule->head->args[j]))
			&&(rule->head->adorn[j])) return 0 ;

	    for (j = 0; j < rule->num_preds; j++)
		if (rule->preds[j] != pred) {
		    for (int k = 0; k < rule->preds[j]->args.count(); k++) {
			if (pred->args[i]->equals(rule->preds[j]->args[k])) {
			    var_found = 1 ;
			    break ;
			}
		    }
		    if (var_found) break ;
		}
	    if (!(var_found))  return 0 ;
	    
	}
	else {
	    // The FREE variables of pred should be identical to the free
	    // variables of the head predicate
	    if (!(pred->args[i]->equals(rule->head->args[i]))) return 0 ;

	    // Check that the free variables do not occur
	    // anywhere else in the rule.
	    for (int j = 0; j < rule->num_preds; j++)
		if (rule->preds[j] != pred)
		    for (int k = 0; k < rule->preds[j]->args.count(); k++)
			if (pred->args[i]->equals(rule->preds[j]->args[k]))
				return 0 ;

	}
   }
   return 1 ;
}
/***************************************************************************/
static int multi_linear(struct rule * rule)
{
  Literal *pred = NULL , *the_pred = NULL;
  int preds_found = 0;

  for (int i = 0; i< rule->num_preds; i++) {
    pred = rule->preds[i] ;
    if (rule->head->predicate == pred->predicate) {
      // The predicate is the same as the head predicate
      preds_found++ ;

      if (test_multi_linear(rule, pred)) {
	// The literal satisfies the COR_MULTI_LINEAR requirements

	if (the_pred) return 0 ;
	the_pred = pred;
      }

      else {
	// The literal has the same predicate as the head
	// but does not satisfy the COR_MULTI_LINEAR requirements

	for (int k=0; k< pred->adorn.len(); k++) {
	  if (rule->head->adorn[k]) {
	    //The BOUND variables should be identical to the head
	    if (!(pred->args[k]->equals(rule->head->args[k])))
	      return 0 ;
	  }
	  else {
	    // Any other variables are disjoint from the bound
	    // variables of the head literal
	      
	    for (int j = 0; j < rule->head->adorn.len(); j++)
	      if ((pred->args[k]->equals(rule->head->args[j]))
		  &&(rule->head->adorn[j]))
		return 0 ;
	    
	  }
	}
      }
    }

    else {
      // The predicate is the different from the head predicate
      // All its variables ahould be disjoint from the bound variables
      // of the head literal.

	for (int k=0; k< pred->adorn.len(); k++) {
	  for (int j = 0; j < rule->head->adorn.len(); j++)
	    if ((pred->args[k]->equals(rule->head->args[j]))
		&&(rule->head->adorn[j]))
	      return 0 ;
	}   
    }
  }
  
  if (preds_found < 2 || !the_pred) return 0 ;
  
  rule->factor_status = (int) COR_MULTI_LINEAR ;
  rule->factor_pred = the_pred ;
  return 1 ;
}

/***************************************************************************/
int assign_linear_status(struct rule *rule)
{

// NOTE :: Have to check that the head has all distinct variables

/*
#ifdef DEBUG
    fprintf(stderr, "Checking a rule \n") ;
    print_rule(rule, stderr) ;
#endif
*/

    if (!rule->recursive) {
	rule->factor_status = (int) COR_NON_RECURSIVE ;
	rule->factor_pred = NULL ;
	return 1 ;
    }

    if (right_linear(rule)) {
      return 1 ;
    }

    if (left_linear(rule)) {
      return 1 ;
    }

    if (multi_linear(rule)) {
      return 1 ;
    }

    rule->factor_status = (int) COR_NON_LINEAR ;
    rule->factor_pred = NULL ;
    return 0 ;

}

