/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/** fullmagic.c 
* 
* Assumptions:  Adorned rules (in the structure as_rules) have been sorted 
*        	in sip order already
**/
#include	"rules.h"
#include	"magic-externs.h"
#include	"externs.h"
extern int opt_share_functors;
extern int debugmagic ;
extern int suppress_allfree;	/* suppress generation of magic predicates for
					predicates with all args free */
void do_magic_on_rule(struct rule *, struct collection *) ;
void create_derived_magic_rules(struct rule *, struct collection *, int);

void nomagic(struct collection *rules)
{
    int j;
    struct rule *magicrule;

    init_collection(magic_rules, 0);
    FOR_EACH_RULE(rule, rules) {
	magicrule = copy_rule(rule);
	magicrule->head = rule->head;
	alloc_preds(magicrule, rule->num_preds );
	for (j=0; j<rule->num_preds; ++j)
	    magicrule->preds[j] = rule->preds[j];
	add_rule(magicrule, magic_rules);
    } END_EACH_RULE
}

void fullmagic(struct collection *ad_rules, struct collection *magic_rules)
{

    FOR_EACH_RULE(adrule, ad_rules) {
	/*
	 * Construct the magic rules
	 */
	do_magic_on_rule(adrule, magic_rules) ;

    } END_EACH_RULE

}

extern int has_grouping_args(ArgList &args);

int compute_deriv_negated(struct rule *adrule)
{
    // this is used to compute the number of "done_m_" literals
    // to be added in the magic rule.
    // there are two cases:
    // (1) if there is aggregation in the head, then pre-processing
    //     guarantees that only one "done_m_" literal needs to be 
    //     added to the rule.
    // (2) if there is genuine negation in the body of the rule, add
    //     as many "done_m_" as there are negated literals

    int ret_val = 0;

    // for monotonic programs, there is no need to add any done_m_ literals
    if (parserStruct.CurModule.Monotonic) return ret_val;

    if (has_grouping_args(adrule->head->args))
	ret_val = 1;
    else { // there is genuine negation in the head of the rule
        for (int i=0; i < adrule->num_preds; ++i) 
	    if (adrule->preds[i]->negated && (!adrule->preds[i]->base_pred)) 
		    // negated and derived predicates
	        ++ret_val;
    }
    return ret_val;
}

void do_magic_on_rule(struct rule * adrule, struct collection * magic_rules)
{
    	int			i,j;
    	Clause *	magicrule;

    	if (debugmagic) {
      	    printf("Original rule :\n") ;
	    print_rule(adrule,stderr);
	}

// NOTE: The following code is for Ordered Search 
//       It finds the number of derived negated literals in the body of 
//       a rule and hence the number of "done_m_" literals to be added
//	 Also, it always uses ordered search whenever a derived negated
//	 literal is encountered.

	int num_deriv_negated = compute_deriv_negated(adrule);
	// number of negated derived literals in adrule

/****** has been moved to main.C --- PRAVEEN

	if ((!parserStruct.CurModule.UseOrdSearch) && (num_deriv_negated > 0)){
		// set ordered search
	    COR_set_use_ordsearch(parserStruct.CurModule, 1);
	}
*******/

    	for (i=0; i < adrule->num_preds; ++i)
	    create_derived_magic_rules(adrule, magic_rules, i) ;

	/*
	 * Construct the modified rule
	 */

	magicrule = copy_rule(adrule);

	if (! (allargsfree(& adrule->head->adorn) && suppress_allfree)) {
	    int num_bound_functor_args = 0;
	    if (opt_share_functors) {
		    /* Optimization to let the head share functors with the 
			magic predicate in the body */
		num_bound_functor_args = count_bound_functor_args(adrule->head);
		/* Create new variables for functor args */
		make_new_rule_vars(magicrule, num_bound_functor_args);
	    }
	    alloc_preds(magicrule, adrule->num_preds + 1 +
				num_deriv_negated + 
				num_bound_functor_args);
	    magicrule->head = build_head_pred(magicrule, adrule->head);
	    magicrule->preds[0] = build_magic_pred(magicrule, adrule->head,
						opt_share_functors) ;
	    if (opt_share_functors)
		create_functor_literals(magicrule);
	    for (j=num_bound_functor_args+1,i=0; 
					i<adrule->num_preds; ++j, ++i){
		// NOTE: The following code is for Ordered Search
		if ((parserStruct.CurModule.UseOrdSearch) && 
			(!parserStruct.CurModule.Monotonic) &&
			((has_grouping_args(adrule->head->args)) || 
				(adrule->preds[i]->negated)) && 
			(!adrule->preds[i]->base_pred)) {
		    magicrule->preds[j] = build_magic_pred(magicrule, 
				adrule->preds[i], 0) ;
		    magicrule->preds[j++]->kind = COR_DONE_MAGIC;
		}

		magicrule->preds[j] = adrule->preds[i];
	     }
	  }
	else { /*copy out the original rule */
	    magicrule->head = adrule->head;
	    alloc_preds(magicrule, adrule->num_preds + num_deriv_negated);
	    for (j=0, i=0; i<adrule->num_preds; ++j,++i) {

		// NOTE: The following code is for Ordered Search
		if ((parserStruct.CurModule.UseOrdSearch) &&
			(!parserStruct.CurModule.Monotonic) &&
			((has_grouping_args(adrule->head->args)) ||
				(adrule->preds[i]->negated)) &&
			(!adrule->preds[i]->base_pred)) {
		    magicrule->preds[j] = build_magic_pred(magicrule, 
				adrule->preds[i],0) ;
		    magicrule->preds[j++]->kind = COR_DONE_MAGIC;
		}

		magicrule->preds[j] = adrule->preds[i];
	     }
	  }

	magicrule->head_deletes_count = adrule->head_deletes_count;
	magicrule->head_deletes = adrule->head_deletes;
	add_rule(magicrule, magic_rules);
}

/*
 * Generate a magic rule for each derived right-hand side predicate
 * that has an incoming arc in the sip
 * Currently handles only linear sips
 */
void create_derived_magic_rules(struct rule *adrule,
				struct collection *magic_rules,
				int pred_index)
{
  int		j,p;
  Clause *	magicrule;
  struct sip *	s;

    if (adrule->preds[pred_index]->base_pred) return ;

    if( adrule->sips->sip_list )
      s = findadsip(adrule, pred_index) ;
    else s = NULL ;
    
    magicrule = copy_rule(adrule); /* copy proto header */
    magicrule->head = build_magic_pred(adrule, adrule->preds[pred_index], 0);
    if ( s ) {
      alloc_preds(magicrule, numpredsinsip(&s->tail));
      for(j=0,p=firstpredinsip(&s->tail); p >= 0; 
	  p = nextpredinsip(&s->tail,p) ) {
	if(p==0) /* Head predicate */ {
	  if ( !(allargsfree(& adrule->head->adorn) && suppress_allfree))
	    magicrule->preds[j++] = build_magic_pred(adrule, adrule->head, 0);
	     
	  /* else do nothing */
	}
	else {
	  /******************************/
	  // NOTE: The following code is for Ordered Search
	  // NOTE: There can be no grouping in the head of a magic rule
	  
	  if ((parserStruct.CurModule.UseOrdSearch) &&
		(adrule->preds[p-1]->negated) &&	
		(!adrule->preds[p-1]->base_pred)) {
	    magicrule->preds[j] = build_magic_pred(adrule,
			adrule->preds[p-1], 0) ;
	    magicrule->preds[j++]->kind = COR_DONE_MAGIC;
	  }	
	  /******************************/
	  magicrule->preds[j++] =  adrule->preds[p-1];
	}
      }
      magicrule->num_preds = j ;
    }
    else if ( ! (allargsfree( &adrule->preds[pred_index]->adorn) &&
		 suppress_allfree))
      { 	
	magicrule->num_preds = 0 ;
      }
    else return ;
    
    if ( ! (allargsfree( & magicrule->head->adorn) && 
	    suppress_allfree)) {
		/******* Used to be::  magicrule->num_preds > 0 ) { ****/
      magicrule->type = COR_MAGICRULE ;
      magicrule->source_rule = adrule ;
      magicrule->source_pred = adrule->preds[pred_index] ;

      if (magicrule->source_pred->negated || 
		has_grouping_args(adrule->head->args)) {
	if (!magicrule->clause_names) { // need to create a new name
	  magicrule->clause_names = new ClauseName();
	  magicrule->clause_names->name = DontCareSymbol;
	  magicrule->clause_names->next = NULL; // is this needed ???
	}
	magicrule->clause_names->negated = 1;
      }

      add_rule(magicrule, magic_rules);
      
      if(debugmagic) {
	fprintf(stderr," Magic rule:\n") ;
	print_rule(magicrule, stderr) ;
	fprintf(stderr,"\n") ;
      }
      
    }
    else if (debugmagic)
      fprintf(stderr,"No magic rule generated here-null rule body\n");
}

