/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef CORAL_FACTOR_H

#define CORAL_FACTOR_H

#include        "globals.h"

typedef enum{  COR_NON_RECURSIVE,
               COR_RT_LINEAR,
	       COR_LT_LINEAR,
	       PSEUDO_LT_LINEAR,
	       COR_MULTI_LINEAR,
	       COR_MIXED_LINEAR,
	       COR_NON_LINEAR } LinearKind ;

typedef struct FactorPredList FactorPredList ;

struct FactorPredList {
  Literal *lit ;
  struct FactorPredList *next ;
  FactorPredList() { lit = NULL; next = NULL ; }
  void init() { FactorPredList *tmp1, *tmp2 ;
	   tmp1 = next ;
	   while (tmp1) { tmp2 = tmp1->next; delete tmp1; tmp1 = tmp2 ; }
	   next = NULL ; lit = NULL ;
	 }
} ;

extern FactorPredList factor_linear_preds, factor_magic_preds ;

extern int assign_linear_status(struct rule *) ;
extern void factor_rewrite(struct collection *, struct collection *) ;
extern void adorn(struct collection *, struct collection *) ;
extern void print_factor(struct collection *, FILE *, int);
extern void mark_basepreds(struct collection *);

#endif /* !CORAL_FACTOR_H */
