/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/** defunct.C: **/

#include "globals.h"
#include "rules.h"
#include "funct.h"
#include "exist.h"
#include <string.h>

extern void print_bits(BitVector, int, FILE *) ;
extern int rule_var_enter(Name);
extern void get_terms(Literal *, TermList *) ;
extern TermList *find_arg( TermList *, Arg *) ;
extern void add_arg( TermList *, Arg *, ArgList *, int, TermList *) ;
static void make_distinct_vars(struct rule *);
static void collect_terms( struct rule * , TermList *);
static void explode( TermList * );
static void associate_vars( struct rule * , TermList *);
static void freeup(TermList *) ;
static void reverse_list(TermList *) ;

extern int orig_rule_count ;
static int var_count = 0 ;
static int duplicate_var_count = 0;


/***************************************************************************/
void defunctify( struct rule *rules , TermList **terms)
{
  struct rule *r ;
  int i;

/* Process rules */
    for (i=0,r=rules; r; r=(struct rule *)(r->link.next), i++) {

        // This check is just to ensure that the TermList array
	// has one slot for every rule.
        ASSERT( i < orig_rule_count);

	/* ensure that all non-functor arguments are variables,
	   by introducing additional equ_(X,Y) literals on the rhs */
	/* NOTE:: this should actually be handled along with
	   functors in an identical fashion. This current approach is
	   only a kludge --- PRAVEEN */
        make_distinct_vars(r);

	terms[i] = new TermList ;
	/* collect set of all terms with function symbols */
	collect_terms(r, terms[i]) ;

	/* generate subterms for the set of subterms and associate 
    	using forward pointers.  */
	explode(terms[i]) ;

	/* reverse the term list, so that nested funcargs are expanded
	   in the right order */
	reverse_list(terms[i]) ;

	/* do a scan from smallest subterm, and associate with 
	   each term a unique variable symbol */
	associate_vars(r, terms[i]) ;

	}
}

/***************************************************************************/

static int add_variable(struct rule *rule, Name name)
{
  rule->var_names = (Name *)realloc(rule->var_names, 
			++(rule->num_var_names) * sizeof(Name)) ;
  rule->var_names[rule->num_var_names - 1] = name ;
  return rule->num_var_names - 1;
}

/*
 * Add a literal of the form equ_(old_arg, new_vararg).
 */
static void add_equ_literal(struct rule *rule, Arg *arg0, Arg *arg1)
{
  Literal *tmp2 = AllocLiteral(parserStruct, EquOpSymbol, 2);
			       
  tmp2->adorn.clear() ;
  tmp2->args[0] = arg0;
  tmp2->args[1] = arg1;
  tmp2->base_pred = 1 ;
  rule->preds = (Literal **)realloc(rule->preds, 
				    ++(rule->num_preds) * sizeof(Literal *));
  rule->preds[rule->num_preds - 1] = tmp2 ;
}

static void replace_equ_literal(struct rule *rule, Literal *lit)
{
  int j;
  ASSERT(lit != NULL);
  if (lit->name() != EquOpSymbol) return; // this should not happen

  for (j = 0; j < rule->head->args.arity(); j++)
    if (rule->head->args[j] == lit->args[1]) {
      rule->head->args[j] = lit->args[0];
      return;
    }
  
  for (int i = 0; i < rule->num_preds; i++) {
    if (rule->preds[i] == lit) break;
    for (j = 0; j < rule->preds[i]->args.arity(); j++)
      if (rule->preds[i]->args[j] == lit->args[1]) {
	rule->preds[i]->args[j] = lit->args[0];
	return;
      }
  }
}

static Arg * make_new_var(struct rule *rule, Name name)
{
  char buf[100];

  sprintf(buf, "V%s__%d", SymbolString(name), var_count++) ;
  Name tmp1 = EnterSymbol(buf);
  return (new VarArg(tmp1, add_variable(rule, tmp1)));
}

static void make_distinct_vars(struct rule *rule, Literal *lit)
{
  ASSERT( lit != NULL ) ;

  int j = 0 ;
  Arg *a;
  for (j = 0; j < (lit->args).arity() ; j++) {
    a = (lit->args)[j];
    switch (((lit->args)[j])->kindof()) {
      case COR_NUM_CONST :
      case COR_SYMBOL_CONST :
      case COR_RELATION :
      case COR_GROUPING :
	a = (lit->args)[j];
	(lit->args)[j] = make_new_var(rule, lit->name());
	duplicate_var_count++;
	add_equ_literal(rule, a, (lit->args)[j]);
	break;

      case COR_VARIABLE :
      case COR_DONTCARE :
	int i;
	for (i = j+1; i < (lit->args).arity(); i++)
	  if (((VarArg *)(lit->args)[i])->var_name() == 
	      ((VarArg *)(lit->args)[j])->var_name()) {
	    a = lit->args[i];
	    lit->args[i] = make_new_var(rule, lit->name()) ;
	    duplicate_var_count++;
	    add_equ_literal(rule, a, (lit->args)[i]);
	  }
	  else 
	break;

      default : break;
      }
  }
}

static void make_distinct_vars(struct rule *rule)
{
  int i;

  duplicate_var_count = 0;
  make_distinct_vars(rule, rule->head) ;
  for( i = 0 ; i < rule->num_preds ; i++ ) {
    if (rule->preds[i]->name() != EquOpSymbol)
      make_distinct_vars(rule, rule->preds[i]) ;
  }

  // Ghastly kludge to store the number of extra predicates
  // created in this phase. old_num_var_names is a field
  // that is not being used, so i'm using it for this purpose -- PRAVEEN
  rule->old_num_var_names = duplicate_var_count;

}

/***************************************************************************/
/** 
This only collects top level terms that are arguments of predicates in a rule 
**/
/***************************************************************************/
static void collect_terms( struct rule *rule , TermList *terms) 
{
  int i ;

    get_terms(rule->head, terms ) ;
    TRACE((stderr, "Got terms for head\n")) ;
    for( i = 0 ; i < rule->num_preds ; i++ ) {
	get_terms( rule->preds[i], terms ) ;
	TRACE((stderr, "Got new set of terms for body pred\n" ) ) ;
	}
    TRACE((stderr, "finished collecting terms\n")) ;
}

/***************************************************************************/
/** When exploding a term, we look at each sub term.  If the subterm is 
	already present in the final list, we add a forward pointer from
	the term to the unique copy in the final list.  If it is not present,
	we copy the subterm and introduce it at the end of final list.  We also 
	introduce a forward pointer from the subterm to the copy in the
	final list.  We iteratively end up exploding all subterms since they
	are put at the end of final list and are eventually processed by this
	procedure.
**/
/***************************************************************************/
static void explode(TermList *terms )
{
  TermList *tmp_terms = terms->next ;

  for (; tmp_terms; tmp_terms = tmp_terms->next) {
	ASSERT ( tmp_terms->func_arg->kindof() == COR_FUNCTOR ) ;
	int j = 0 ;
	FOR_EACH_ARG(a, ((FuncArg *)(tmp_terms->func_arg))->args) {
	    if (a->kindof() == COR_FUNCTOR) {
		TermList *tmp = find_arg(terms, a) ;
		add_arg(terms,a,&(((FuncArg *)(tmp_terms->func_arg))->args),
			j, tmp);
	    }
	    j++ ;
	} END_EACH_ARG
   }
  TRACE((stderr, "Exploded term list\n")) ;

}

/***************************************************************************/
/** Associates a new variable with each occurrence of a term in the 
	exploded term list associated with the rule.  
**/
/***************************************************************************/
static void associate_vars( struct rule * rule, TermList *terms )
{
  char buf[100] ;

    for( terms = terms->next ; terms; terms = terms->next ) {

	if (terms->similar) {
	    TermList *tmp = terms->similar ;
	    while (tmp->similar) tmp = tmp->similar ;
	    (*((ArgList *)(terms->arg_list)))[terms->arg_pos] = 
			tmp->var_arg ;
//			terms->similar->var_arg ;
	    terms->var_arg = tmp->var_arg ;
//	    terms->var_arg = terms->similar->var_arg ;
	    continue ;
	}	    

	sprintf(buf, "%s__%d", SymbolString(terms->func_arg->functor()),
				var_count) ;

	Name tmp1 = EnterSymbol(buf);
	terms->var_arg = new VarArg(tmp1, add_variable(rule, tmp1));
	(*((ArgList *)(terms->arg_list)))[terms->arg_pos] = terms->var_arg ;

//	Now add an extra predicate to the rule
// COR_NOTE :: Forced to use realloc() here instead of new() because
// alloc_preds() initially used malloc !!! --- PRAVEEN

	sprintf(buf, "func__%d", var_count++); 
	Literal *tmp2 = AllocLiteral(parserStruct, EnterSymbol(buf),
				terms->func_arg->count()+1);
	tmp2->adorn.clear() ;
	for (int k=0; k< terms->func_arg->count();k++)
		tmp2->args[k] = terms->func_arg->args[k] ;
	tmp2->args[k] = terms->var_arg  ;
	tmp2->base_pred = 1 ;
	rule->preds = (Literal **)realloc(rule->preds, 
			++(rule->num_preds) * sizeof(Literal *));
	rule->preds[rule->num_preds - 1] = tmp2 ;
	terms->dummy_pred = tmp2 ;

    }

    TRACE((stderr, "Finished associating vars\n")) ;
}

/***************************************************************************/
static void freeup(TermList *terms)
{
    if (!terms) return ;
    while (terms) {
	TermList *tmp = terms->next ;
	delete terms ;
	terms = tmp ;
    }
}

/***************************************************************************/
static void reverse(TermList *terms)
{
   if (terms->next == NULL) return ;
   reverse(terms->next) ;
   terms->next->next = terms ;
   terms->next = NULL ;
}

static void reverse_list(TermList *terms)
{
   TermList *tmp = terms->next ;
   if (!tmp) return ;
   while (tmp->next) tmp = tmp->next ;
   reverse(terms->next) ;
   terms->next = tmp ;
}

/***************************************************************************/
static FuncArg * in_termlist(TermList *terms, VarArg *a, Literal * &pred)
{
  if (!terms)  return NULL;

  for (terms = terms->next; terms; terms= terms->next) {
	if (a->var_name() == terms->var_arg->var_name()) {
	    pred = terms->dummy_pred ;
	    return terms->func_arg ;
	}
  }
  return NULL ;
}

static FuncArg * in_termlist(TermList **terms, VarArg *a, Literal * &pred)
{
  for (int j=0; j< orig_rule_count; j++) {
     FuncArg * tmp_funcarg = in_termlist(terms[j], a, pred) ;
     if (tmp_funcarg)
	return tmp_funcarg ;
  }
  return NULL ;
}

static void remove_special_pred(struct rule *rule, Literal *pred)
{
    for (int i = 0; i< rule->num_preds; i++) {
	if ((pred->name() == rule->preds[i]->name()) &&
		pred->arity() == rule->preds[i]->arity()) break ;
    }

// If not found, return ---- this should not happen !!
    if (i == rule->num_preds) return ;

// Copy the adornment in the literal 
    pred->adorn = rule->preds[i]->adorn ;

// Remove the literal from the rule
    for (; i< rule->num_preds; i++) rule->preds[i] = rule->preds[i++] ;
    (rule->num_preds)-- ;
}

/***************************************************************************
 replace dummy variables by original func args
***************************************************************************/
static void restore_arglist(struct rule *rule,TermList **terms,
				ArgList &alist, Literal *p)
{
	int k = 0 ;
	FuncArg * f_arg ;
	FOR_EACH_ARG(a, alist) {

	    if (p && p->adorn[k])
		alist[k] = &TheDontCareArg ;

	    if (a->kindof() != COR_VARIABLE) continue ;

// At this point, all args must be of type VARARG
	    ASSERT ( a->kindof() == COR_VARIABLE ) ;
	    Literal *tmp_pred = NULL;
	    if (f_arg = in_termlist(terms, (VarArg *)a, tmp_pred)) {
		
		remove_special_pred(rule, tmp_pred) ;
		if (alist[k] != &TheDontCareArg) {
		    alist[k] = f_arg ;
		    restore_arglist(rule, terms, f_arg->args, tmp_pred);
		}
	    }
	    k++ ;
	} END_EACH_ARG
}


/***************************************************************************/
void functify(struct rule *rules, TermList **terms)
{

  int i, j;
  struct rule * r ;

// Process rules 

    for (i=0,r=rules; r; r=(struct rule *)(r->link.next), i++) {
	// Process predicates
	restore_arglist(r, terms, r->head->args, NULL) ;
	for (j=0; j< r->num_preds; j++)
	  restore_arglist( r, terms, r->preds[j]->args , NULL);
	for (j=0; j< r->old_num_var_names; j++)
	  replace_equ_literal(r, r->preds[r->num_preds - j -1]);
	r->num_preds -= r->old_num_var_names;
    }
}
