/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/
/*****************************************************************************/
/*	 cleanup.h
*/
/*****************************************************************************/
#define COR_UNSOLVED 0
#define COR_SOLVED 1

/*****************************************************************************/
/* struct ruleNode and struct predNode are defined for constructing the
   rule/goal graph defined in Recursive Query Processing Strategies
   [Bancilhon, Ramakrishnan].  Struct ruleNode is the "oval node" and
   struct predNode is the "square node".
*/
/*****************************************************************************/
typedef struct predNode predNode ;
typedef struct ruleNode ruleNode ;
typedef struct unreachTable unreachTable ;

struct ruleNode {
	struct rule *r;		/* associated rule if node==RULENODE */
	int solved;		/* if the rule is solvable (can exit) */
	Predicate *head;	/* head predicate */
	struct ruleNode *next;  /* next rule */
	ruleNode() {} ;
	ruleNode(struct rule *rule) {
	     r = rule;
	     solved = COR_UNSOLVED;
	     if (rule->head) 
		head = rule->head->predicate;
	     else
		head = NULL;
	     next = NULL;
	}

};

// Using a list implementation. This is inefficient -- but since
// existential query opt. is being done on a per module basis
// one hopes that the number of predicates in a module will not be
// unreasonably large --- PRAVEEN.

struct predNode {	  /* will be an array of size = rule->num_preds */
        Predicate *pred;  
	int solved;	  /* if predicate is solvable, solved==1 */
	int numRule;	  /* number of rules with this predicate in the body */
	struct ruleNode **r;
	               /* point to the rules which has pred in the rule body */
	struct predNode *next;
	predNode() { next = NULL ;};
	predNode(Literal *p, int rule_count) { 
	                         pred = p->predicate; 
				 solved = p->base_pred ? COR_SOLVED : COR_UNSOLVED ;
				 numRule = 0 ;
				 r = new struct ruleNode *[rule_count];
			       };
	void addRNode(struct ruleNode *rNode) { r[numRule++] = rNode ;};
};

struct unreachTable {
        Predicate *pred ;
	BitVector vector[32];    // What sort of constant is this ??? - PRAVEEN
	int numMarked;
	void add_bv(BitVector& bv) {vector[numMarked++] = bv;};
};


/*****************************************************************************/
