/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/* scanner.h
*/

#define MAX_CORAL_VARIABLES 100   /* per command */

/* Names for the type of all lexemes: */

typedef enum
{
  /* Literals */
  LX_IDENTIFIER, LX_INTEGER, LX_STRING, LX_DOUBLE,
  LX_COR_IDENTIFIER, LX_EXPR,  


  /*keywords*/
  KW_EXPORT, KW_AS, KW_CLASS, KW_STRUCT, KW_FOR, KW_STRING, 

  /* data types */
  KW_CHAR, KW_INT, KW_FLOAT, KW_DOUBLE, KW_ARG, KW_VOID,

  /* optional qualifiers to ints */
  KW_SHORT, KW_LONG, KW_UNSIGNED, 

  /* coral keywords */
  KW_RELATION, KW_TUPLE, KW_MAKE_TUPLE,

  /* for variables of type Relation or Tuple */
  COR_RELATION_VAR, COR_TUPLE_VAR, 

  /* other keywords */
  KW_EACH, KW_IN, KW_DO, KW_ENDDO,  
  KW_INIT_CORAL, 

  /* keywords to enclose declarative commands in 
     a C++ module */
  CORAL_BEGIN, CORAL_END, 

  /* Operators */
  LX_LPAREN, LX_RPAREN, LX_LBRACKET, LX_RBRACKET,
  LX_COLON, LX_DOT, LX_SEMICOLON, LX_COMMA, LX_COLON_EQ,
  LX_PLUS, LX_MINUS, LX_STAR, LX_SLASH, LX_BACKSLASH, 
  LX_EQ, LX_NEQ, LX_LT, LX_LE, LX_GT, LX_GE, LX_ARROW, 
  LX_EOF, LX_EOLN, LX_DOLLAR, LX_EXCLAMATION, LX_AMPERSAND,
  LX_HASH, LX_LEFTARROW, LX_RIGHTARROW, LX_LEFTBRACE, LX_RIGHTBRACE, 
  /* error tokens */
  LX_NOLINE, LX_NOTOFINTEREST, 

  NOT_KEYWORD
  }
lexeme_type;


typedef enum
{
TYPE_CHAR, TYPE_DOUBLE, TYPE_FLOAT, TYPE_INT, 
TYPE_LONG, TYPE_SHORT, TYPE_STRING, TYPE_UNSIGNED,
TYPE_FILENAME, 
TYPE_NONE

  }
type_name;


/* Lexeme abstract dataype: */

class token {
 public:
  /* Initialization functions of various flavors: */
  token (lexeme_type lx) {type = lx;}
  token (lexeme_type lx, int value) {type = lx; int_value = value;}
  token (lexeme_type lx, double value) {type = lx; double_value = value;}
  token (lexeme_type lx, char *value) {type = lx; str_value = value;}

  /* Deallocation function: */
  ~token () {if ((type == LX_IDENTIFIER || type == LX_STRING)
		 && str_value == NULL)
	      delete (str_value);}

  /* ADT operations: */
  lexeme_type token_type () {return (type);}
  int token_int () {return (int_value);}
  double token_double () {return (double_value);}
  char *token_str () {return (str_value);}

 private:
  lexeme_type type;		/* Type of a lexeme */
  union				/* Optional value for particular lexemes */
    {
      int int_value;		/* Integer for LX_INTEGER */
      double double_value;	/* double for LX_DOUBLE */
      char *str_value;		/* String for LX_STRING and LX_IDENTIFIER*/
    };
};

/*
 * structure that carries info about the CORAL commands generated 
 * corresponding to one 'blob' of embedded CORAL code 
 */
struct infoStruct {
  int no_of_params;
  type_name type_array[MAX_CORAL_VARIABLES];
  char *var_names[MAX_CORAL_VARIABLES];

  infoStruct() {no_of_params = 0;}
};
