/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "line_info.h"
#include "scan_input.h"

extern char * copy_string(char *);

scan_input::scan_input(char *filename)
{
  
  if (filename == NULL)	/* Empty string */
    {
      input_file = stdin;
      input_file_name = copy_string ("stdin");
    }
  else
    {
      input_file = fopen (filename, "r");
      if (input_file == NULL)
	{
	  fprintf(stderr,"Cannot open file: %s\n", filename);
	  input_file = stdin;
	  input_file_name = copy_string ("stdin");
	}
      else {
	input_file_name = copy_string (filename);
      }
    }
  
  limit = MAX_NUM_OF_LINES;
  lines = new LINE* [limit];
  for (int i = 0; i < limit; i++) {
    lines[i] = NULL;
  }
  top = -1;
  eof_reached = FALSE;
  eoln_reached = FALSE;
  
  output_file_name = NULL;
  next_token = NULL;
  
  current_line_number = 0;
}

scan_input::~scan_input()
{
  for (int i = 0; i < limit; i++) {
    delete lines[i];
  }
  
  delete lines;
  top = -1;
}

int scan_input::get_next_line(int i)
{
  if (eof_reached) {
    fprintf(stderr, "get_next_line:: eof not handled properly \n");
    return EOF_CHAR;
  }
  
  eoln_reached = FALSE;
  
  if (top >= limit) {
    fprintf(stderr, " get_next_line:: \
		something is strange \n");
    exit(1);
  }
  
  if (top < 0)
    top = -1;
  
  if ((top + 1) >= limit)
    resize();
  ++top;
  int c = get_line();
  if (i)
    next_token = NULL;
  return c;
}



int scan_input::get_new_line()
{
  if (eof_reached) {
    fprintf(stderr, "get_new_line:: eof not handled properly \n");
    return EOF_CHAR;
  }
  
  eoln_reached = FALSE;
  
  if (top >= limit) {
    fprintf(stderr, " get_new_line:: \
		something is strange \n");
    exit(1);
  }
  if (top < 0)
    top = 0; 
  else
    if (lines[top] != NULL)	 {
      delete lines[top];
    }
  int c = get_line();
  return c;
}

int scan_input::get_line()
{
  
  lines[top] = new LINE(input_file, input_file_name);
  int c = lines[top]->get_line();
  if (c == EOF_CHAR)
    eof_reached = TRUE;
  current_line_number++;
  return c;
}


void scan_input::resize() 
{
  
  if (limit > TOO_BIG) {
    fprintf(stderr, "resize : limit already too \
		big \n");
    return;
  }
  
  
  LINE **temp_lines = lines;
  int temp_limit = limit;
  
  limit *= 2;
  lines = new LINE* [limit];
  for (int i = 0; i < temp_limit; i++) {
    lines[i] = temp_lines[i];
  }
  for (i = temp_limit; i < limit; i++) {
    lines[i] = NULL;
  }
  
  delete temp_lines;
}

void scan_input::set_line_number(int x) 
{
  
  if (x > top) {
    fprintf(stderr, "set_line_number :: size too \
		big - %d\n", x);
    return;
  }
  
  for (int i = x+1; i <= top; i++) {
    delete lines[i];
    // lines[i].line = NULL;
  }
  
  top = x;
  
}

void scan_input::open_output_file(char *filename) 
{
  if (output_file_name)
    fprintf(stderr, "Warning : an output file may already be open \n");
  
  if (filename == NULL)	/* Empty string */
    {
      output_file = stdout;
      output_file_name = copy_string ("stdout");
    }
  else
    {
      output_file = fopen (filename, "w");
      if (output_file == NULL)
	{
	  fprintf(stderr,"Cannot open file: %s\n", filename);
	  output_file = stdout;
	  output_file_name = copy_string ("stdout");
	}
      
      else {
	output_file_name = copy_string (filename);
      }
    }
}


void scan_input::dump() 
{

  if (output_file_name == NULL) {
    fprintf(stderr, "no output file is open \n");
    fprintf(stderr, "call open_output_file(char *filename) first \n");
    return;
  }
  
  
  for (int i = 0; i <= top; i++)
    if (lines[i]) {
      lines[i]->dump_line(output_file);
      delete(lines[i]);
    }
    else {
      fprintf(stderr, "this line %d is empty ???\n", i); 
    }
  
  top = -1;
  
}

void scan_input::ignore_lines() {
  
  for (int i = 0; i <= top; i++)
    if (lines[i]) 
      delete(lines[i]);
  
  top = -1;
  
}
