/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#include <stdio.h>
#include <strings.h>
#include "scanner.h"
#include "line_info.h"
#include "scan_input.h"
#include "export.h"
#include "mystrings.h"
#include "hashdefines.h"

char *concat1(char *, int);
char *concat2(char *, char *);
void gen_type_decl(FILE *, kind *);
void gen_arg_assign(FILE *, kind *,int);
void gen_ret_assign(FILE *, kind *, char *, int, handle_export *);
void gen_header(FILE *, char *);
void gen_tail(FILE *);
void gen_class_decl(FILE *, char *, char *,int, mystring *, char *);
void arg_code(FILE *, kind *);
void ret_code(FILE *, kind *);
void gen_init_assign(FILE *, int);
void gen_arg_ret_assign(FILE *, kind *, int);
void gen_fail_code(FILE*);

void output_export_code(scan_input *input_buffer, handle_export * export_info,
			mystring *export_dummy_fn, char *dummy_temp_name,
			mystring *export_header_decl)
{ 
  FILE *output_file;
  output_file = input_buffer->get_output_file();
  export_header_decl->print(output_file);
  
  kind *k;
  char *fn_name = export_info->get_name();
  
  gen_header(output_file, fn_name);
  
  int argcount = export_info->get_num_of_args();
  for (int i = 0; i < argcount; i++) {
    k = export_info->get_arg(i);
    if (k->opt_neg_sign == 0) {
      gen_init_assign(output_file, i); // load the input args into into ouput arglist
    }
  }
  
  for (i = 0; i < argcount; i++) {
    k = export_info->get_arg(i);
    k->argname = concat1("arg",i);
    k->init_pointer = 1;
    arg_code(output_file, k);	// set up types.
    
    gen_type_decl(output_file, k); // gen the defs for the output defs
    gen_arg_assign(output_file, k, i); // gen assigns to the vars.
  }
  
  k = export_info->get_return_type();
  k->argname = "retvalue";
  k->init_pointer = 0;
  ret_code(output_file, k);
  
  
  gen_type_decl(output_file, k); // gen the type for the retvalue
  gen_ret_assign(output_file, k, fn_name, argcount, export_info); // call the fn
  
  for (i = 0; i < argcount; i++) {
    k = export_info->get_arg(i);
    if (k->opt_neg_sign) {
      gen_arg_ret_assign(output_file, k, i);
    }
  }
  
  gen_tail(output_file);
  
  char *exported_fn_name = export_info->get_exported_name();
  if (exported_fn_name) 
    gen_class_decl(output_file, exported_fn_name, fn_name,argcount, 
		   export_dummy_fn, dummy_temp_name);
  else
    gen_class_decl(output_file, fn_name, fn_name,argcount,
		   export_dummy_fn, dummy_temp_name);
  
}


void gen_type_decl(FILE * output_file, kind *k)
{

/*
 * NOTE : the only types that should have a pointer are char and Arg.
 *        Here too, only char * is valid. So the code here
 *        is special-cased for this
 */ 
/* 
  if ((k->pointer) > 1) { 
    fprintf(output_file, "\t%s ", k->type);
    for (t = 0; t < k->pointer; t++) {
      fprintf(output_file, "*"); 
    }
    fprintf(output_file, " %s;\n", k->argname);	
//    fprintf(output_file, "\t%s = new (%s *); \n", k->argname, k->type);
    fprintf(output_file, "\t%s = new (%s ", k->argname, k->type);
    for (t = 0; t < k->pointer -1; t++)
      fprintf(output_file, "*");
    fprintf(output_file, "); \n");
    return;
  }
*/
/*
  if (k->pointer)  {
    fprintf(output_file, "\t%s %s; \n", k->type, k->argname);
    if (k->init_pointer)
      fprintf(output_file, "\t%s = new (%s); \n", k->argname, k->type);
  }
  else
*/
    fprintf(output_file, "\t%s%c %s ; \n", k->type, (k->pointer && !index(k->type,'*') ? '*': ' '), 
	    k->argname);	// gen the type

}


void gen_arg_assign(FILE * output_file, kind *k, int i){
  if (!(k->opt_neg_sign)) {
    if (k->init_pointer == 0) {
      if (k->pointer > 1)
	fprintf(output_file, "*");
      fprintf(output_file, "\t%s = ", k->argname);
      if (k->pointer) {
	if (k->type)
	  fprintf(output_file, "(%s)", concat2(k->type, " *"));
	if (k->make)
	  fprintf(output_file, "%s", k->make);
      }
      else {
	if (k->type)
	  fprintf(output_file, "(%s)", k->type);
	if (k->make)
	  fprintf(output_file, "%s", k->make);
	else
	  fprintf(output_file, "*");
      }
      fprintf(output_file, "((query->args())[%d]); \n", i);
      return;
    }

/*
    if (k->pointer)
      fprintf(output_file, "\t%s = (%s)%s((query->args())[%d]); \n",
	      k->argname, k->type, k->make, i);
    else 
      fprintf(output_file, "\t%s = (%s)%s((query->args())[%d]); \n",
	      k->argname, k->type, k->make, i);
*/
    fprintf(output_file, "\t%s = (%s)%s((query->args())[%d]); \n",
	    k->argname, k->type, k->make, i);
  }
}


void gen_ret_assign(FILE * output_file, kind *k, char *fn_name,
		    int argcount, handle_export *export_info)
{
  char * temp = concat1("arg",argcount-1);
  fprintf(output_file, "\t");
  if (k->init_pointer)	
    if (k->pointer)
      fprintf(output_file, "*");
  fprintf(output_file, "%s = %s(", k->argname, fn_name);
  for (int i = 0; i < argcount - 1; i++)
    fprintf(output_file, "%s, ", (export_info->get_arg(i))->argname);
  fprintf(output_file, "%s);\n", temp);

  gen_fail_code(output_file);

  if (k->make)
    fprintf(output_file, "\t(*alist)[%d] = make_arg(%s%s);\n",
	    argcount,k->make, k->argname);
  else
    fprintf(output_file, "\t(*alist)[%d] = make_arg(%s);\n", argcount,k->argname);
}


void gen_arg_ret_assign(FILE * output_file, kind *k, int argcount)
{
  char * temp = concat1("arg",argcount);
  if (k->make)
    fprintf(output_file, "\t(*alist)[%d] = make_arg(%s%s);\n", argcount,k->make, k->argname);
  else
    fprintf(output_file, "\t(*alist)[%d] = make_arg(%s);\n", argcount,k->argname);
}

char *concat1(char *s, int i){
  
  char buf[10];
  sprintf(buf, "%d", i);
  int slen = strlen(s);
  int buflen = strlen(buf);
  int len = slen + buflen + 1;
  char *t = new char[len];
  strncpy(t, s, slen);
  strncpy(t+slen, buf, buflen);
  t[len-1] = '\0';
  return t;
}

char *concat2(char *s1, char *s2){
  int s1len = strlen(s1);
  int s2len = strlen(s2);
  int len = s1len + s2len + 1;
  char *t = new char[len];
  strncpy(t, s1, s1len);
  strncpy(t+s1len, s2, s2len);
  t[len-1] = '\0';
  return t;
}

// generates the first few lines of the solver
  
void gen_header(FILE *output_file, char *fn_name) 
{
    
  char *temp = concat2(fn_name, "solver");
  
  fprintf(output_file, "static Tuple * %s(Tuple *query)\n{\n", temp);
  fprintf(output_file, "\tif (query == NULL) {\n\t    fprintf(stderr,");
  fprintf(output_file, "\"Null argument passed to %s \\n\"); \n", temp);
  fprintf(output_file, "\t    return NULL; \n\t} \n");
  fprintf(output_file, "\tint arity = query->arity(); \n");
  fprintf(output_file, "\tArgList *alist = ArgList::New(arity);\n");
}

void gen_init_assign(FILE *output_file, int i){
  fprintf(output_file, "\t(*alist)[%d] = (query->args())[%d];\n", i,i);
}

void gen_tail(FILE *output_file){
  
  fprintf(output_file, "\tTuple *return_tuple = new Tuple(alist);\n");
  fprintf(output_file, "\treturn return_tuple;\n}\n");
}



void gen_class_decl(FILE *, char *exported_fn_name,
		    char *fn_name, int argcount,
		    mystring *export_dummy_fn, char *dummy_temp_name)
{
  char buf[256];
  sprintf(buf,"  %s = new BuiltinUserTupleRelation(%d,EnterSymbol(\"%s\"), %s);\n",
	  dummy_temp_name,argcount+1, exported_fn_name, 
	  concat2(fn_name, "solver"));
  export_dummy_fn->append(buf);
}

/**********************************************************************
   Inputs: the output file
  Outputs: void
 Added By: Bill Roth/Tue Mar  9 21:18:49 1993
 Comments: generates the code the allow user buitins to file.
**********************************************************************/

void gen_fail_code(FILE * output_file)
{
  fprintf(output_file,
	  "\tif(%s){\n\t\t%s=0;\n\t\tdelete alist;\n\t\treturn NULL;\n\t}\n",
	  CORAL_FAIL_VAR,CORAL_FAIL_VAR);
}

void arg_code(FILE *, kind *k) {
  
  if (k->opt_neg_sign == 0) {
    
    switch(k->value) {
      
    case CHAR :
      if (k->pointer) {
	k->type = "char *";
	k->make = "make_string";
      }
      else {
	k->type = "char";
	k->make = "make_int";
      }
      k->_typedef = k->type;
      break;
    case INT :
      k->type = "int";
      k->make = "make_int";
      k->_typedef = k->type;
      break;
    case FLOAT :
      k->type = "float";
      k->make = "make_float";
      k->_typedef = k->type;
      break;
    case DOUBLE :
      k->type = "double";
      k->make = "make_double";
      k->_typedef = k->type;
      break;
    case SHORT_INT :
      k->type = "short";
      k->make = "make_short";
      k->_typedef = k->type;
      break;
    case LONG_INT :
      k->type = "long";
      k->make = "make_long";
      k->_typedef = k->type;
      break;
    case UNSIGNED_INT :
      k->type = "unsigned";
      k->make = "make_int";
      k->_typedef = k->type;
      break;
    case UNSIGNED_SHORT_INT :
      k->type = "unsigned short";
      k->make = "make_short";
      k->_typedef = k->type;
      break;
    case UNSIGNED_LONG_INT :
      k->type = "unsigned long";
      k->make = "make_long";
      k->_typedef = k->type;
      break;
    case ARG :
      k->type = "Arg *";
      k->make = "";
      //k->init_pointer = 0;
      k->_typedef = k->type;
      break;
    case STRING :
      k->type = "char";
      k->pointer = 1;
      k->make = "make_string";
      k->init_pointer = 0;
      k->_typedef = k->type;
      break;
    case CLASS :
      k->type = k->name;
      k->make = "";
      k->_typedef = k->type;
      break;
    case STRUCT :
      k->type = k->name;
      k->make = "";
      k->_typedef = k->type;
      break;
    default:
      k->type = NULL;
      k->make = "";
      k->_typedef = k->type;
      break;
    }
  }
  else {
    switch(k->value) {
      
    case CHAR :
      k->type = "char";
      if (k->pointer)
	k->make = "(int)*";
      else
	k->make = "(int)";
      break;
    case INT :
      k->type = "int";
      if (k->pointer)
	k->make = "*";
      break;
    case FLOAT :
      k->type = "float";
      if (k->pointer)
	k->make = "(double)*";
      else
	k->make = "(double)";
      break;
    case DOUBLE :
      k->type = "double";
      if (k->pointer)
	k->make = "*";
      break;
    case SHORT_INT :
      k->type = "short";
      if (k->pointer)
	k->make = "(int)*";
      else
	k->make = "(int)";
      break;
    case LONG_INT :
      k->type = "long";
      if (k->pointer)
	k->make = "(int)*";
      else
	k->make = "(int)";
      break;
    case UNSIGNED_INT :
      k->type = "unsigned";
      if (k->pointer)
	k->make = "(int)*";
      else
	k->make = "(int)";
      break;
    case UNSIGNED_SHORT_INT :
      k->type = "unsigned short";
      if (k->pointer)
	k->make = "(int)*";
      else
	k->make = "(int)";
      break;
    case UNSIGNED_LONG_INT :
      k->type = "unsigned long";
      if (k->pointer)
	k->make = "(int)*";
      else
	k->make = "(int)";
      break;
    case ARG :
      if (!(k->pointer)) { 
	fprintf(stderr, "Warning :: -ve with Arg does not work correctly \n");
	k->make = "(Name)&";
      }
      else
	if (k->pointer > 1) {
	/*  printf("string is %s \n", k->argname); */
	  k->make = "(Name)*";
	}
	else 
	  k->make = "(Name)";
      
      k->type = "Arg";
      
      break;
    case STRING :
      k->type = "char";
      k->pointer = 1;
      k->make = NULL;
      break;
    case CLASS :
      k->type = k->name;
      k->make = NULL;
      break;
    case STRUCT :
      k->type = k->name;
      k->make = NULL;
      break;
    default:
      k->type = NULL;
      k->make = NULL;
      break;
    }
    if (!(k->pointer)) 
      fprintf(stderr, "Warning : -ve sign should be used with pointer args only, since C has only pass by value \n");
  }
}

void ret_code(FILE *, kind *k) {
  
  switch(k->value) {
    
  case CHAR :
    k->type = "char";
    if (k->pointer)
      k->make = "(int)*";
    else
      k->make = "(int)";
    break;
  case INT :
    k->type = "int";
    if (k->pointer)
      k->make = "*";
    break;
  case FLOAT :
    k->type = "float";
    if (k->pointer)
      k->make = "(double)*";
    else
      k->make = "(double)";
    break;
  case DOUBLE :
    k->type = "double";
    if (k->pointer)
      k->make = "*";
    break;
  case SHORT_INT :
    k->type = "short";
    if (k->pointer)
      k->make = "(int)*";
    else
      k->make = "(int)";
    break;
  case LONG_INT :
    k->type = "long";
    if (k->pointer)
      k->make = "(int)*";
    else
      k->make = "(int)";
    break;
  case UNSIGNED_INT :
    k->type = "unsigned";
    if (k->pointer)
      k->make = "(int)*";
    else
      k->make = "(int)";
    break;
  case UNSIGNED_SHORT_INT :
    k->type = "unsigned short";
    if (k->pointer)
      k->make = "(int)*";
    else
      k->make = "(int)";
    break;
  case UNSIGNED_LONG_INT :
    k->type = "unsigned long";
    if (k->pointer)
      k->make = "(int)*";
    else
      k->make = "(int)";
    break;
  case ARG :
    k->type = "Arg *";
    k->make = "";
    /*
    if (!(k->pointer))
      k->init_pointer = 1;
    */
    k->pointer = 1;
    break;
  case STRING :
    k->type = "char";
    k->pointer = 1;
    k->make = NULL;
    break;
  case CLASS :
    k->type = k->name;
    k->make = NULL;
    break;
  case STRUCT :
    k->type = k->name;
    k->make = NULL;
    break;
  default:
    k->type = NULL;
    k->make = NULL;
    break;
  }
}

void output_init_export(scan_input *input_buffer, char *,
			char *dummy_fn_name) 
{
  
  FILE *output_file = input_buffer->get_output_file();
  
  fprintf(output_file, "static void %s(); \n", dummy_fn_name);
}

void output_call_dummy(scan_input *input_buffer, char *dummy_fn_name){
  
  FILE *output_file = input_buffer->get_output_file();
  fprintf(output_file, "  %s();\n", dummy_fn_name);
}
