/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/* You must include stdio.h before including this file. */

extern char * copy_string(char *); 

const int EOF_CHAR = -1;	/* Character returned on end of file (EOF) */
const int EOLN_CHAR = -2;	/* Character returned on end of file (EOF) */


/* File_descriptor abstract datatype: */

class line_descriptor
{
 public:
  /* Initialization function */
  line_descriptor (FILE *, char *);

  /* Deallocation function */
  ~line_descriptor () {close_line_descriptor ();}

  /* ADT operations: */
  int valid ();
  void close_line_descriptor ();
  int get_char ();
  void unget_char (int);
  int get_line();
  int get_pos() { return pos; }
  char * return_line() { return copy_string(line); }
  void dump_line(FILE *);

 private:
  FILE *file;			/* File stream. */
  char *name;			/* Name of file */
  int returned_char;		/* Char handed back by UNGET_CHAR */
  char *line;			/* Characters on current line */
  int pos;			/* Position in line */
  int max_pos;			/* Max number of characters in line buffer */
};
