/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

#ifndef ORDSEARCH_H
#define ORDSEARCH_H

#include <stdio.h>
#include <string.h>
#include "externs.h"
#include "arg.h"
#include "term.h"
#include "generic-rel.h"

class Context;
class GoalNode;
class GoalNodeLink;

class ContextNode {
  public:
    GoalNode *goals;

    // unmarked goals as a singly linked list
    GoalNodeLink *first_unmarked_goal;	
    GoalNodeLink *last_unmarked_goal;

    // marked goals as a singly linked list
    GoalNodeLink *first_marked_goal;
    GoalNodeLink *last_marked_goal;

    int mark;		// if any goal is marked, so is the node
    int node_number;	// used for linear ordering of nodes

    int negated;	
	// CHECK IF NEEDED??
	// if any goal is negated, so is the node

    ContextNode *next;	// link to next node in context
    ContextNode *prev;	// link to previous node in context
    ContextNode *next_marked;	// link to next marked node
    ContextNode *prev_marked;	// link to previous marked node

    Context *context;	// the context to which this belongs to 

    ContextNode(GoalNode *new_goal, Context *c);
    
    inline int is_marked()
	{ return mark; }
    inline void mark_node()
	{ mark = 1; }

    int any_unmarked_goals();
    GoalNode *get_unmarked_goal();

    void move_goals_to_done();

    void move_to_marked_list(GoalNodeLink *g_ptr);
    void merge_nodes(ContextNode *tbm);

    void update_goalnode_info();
    void print_all(FILE *file);
    void free_all();
    // ~ContextNode();
};

class Context {
  public:
    ContextNode *first;
    ContextNode *last;
    ContextNode *first_marked;
    ContextNode *last_marked;

    Context();
    void add_new_goal(GoalNode *g_node, GoalNode *par);
    void insert_last(ContextNode *c_node);
    void insert_before(ContextNode *c_node, ContextNode *par_next_c_node);

    void delete_goal(GoalNode *g);
    void unlink_node(ContextNode *g_c_node);

    GoalNode *get_unmarked_goal(int &any_new_fact_in_done);
    void update_marked_info(ContextNode *c_node);

    void collapse_nodes(GoalNode *from, GoalNode *par, GoalNode *to);
    void print_all(FILE *file);
    void free_all();
};

extern int C_DeleteTupleCount, C_DeleteTupleSize;

class GoalNode : public Tuple {
  public:
    int mark;	
    GoalNode *parent_goal;
    ContextNode *c_node;
    Relation *owner_rel;
	// the above fields represent the semantics of goal nodes in the set

    int negated;	
	// used to check if program has cyclic negation/aggregation 

    GoalNode *parent_in_set;
    int rank_in_set;
	// the above two fields are for tarjan's union-find algorithm

    GoalNode(Relation *rel, int neg = 0);
    GoalNode(int arity, Relation *rel, int neg = 0);
    GoalNode(ArgList *arglist, BindEnv *env, Relation *rel, int neg = 0);
    GoalNode(ArgList&a, Relation *rel, int neg = 0);
    GoalNode(ArgList *arglist, Relation *rel, int neg = 0);
    ~GoalNode() { 
#ifdef DEBUG
    C_DeleteTupleCount++; C_DeleteTupleSize += sizeof(GoalNode);
#endif
		}

    void set_defaults(Relation *rel, int neg);
    inline void create_goalnode_info(GoalNode *par)
	{ parent_goal = par; } 

    GoalNode *find_canonical_elem ();
    ContextNode *find_context_node();
    GoalNode *link_goals(GoalNode *g);

    inline int is_marked() 
	{ return mark; }
    inline void mark_goal() 
	{ mark = 1; }

    int is_magic_goal();
    void print_all(FILE *file);
    Relation *find_done_relation();

};

class GoalNodeLink {
  public:
    GoalNode *g_node;
    GoalNodeLink *next;

    GoalNodeLink(GoalNode *goal, GoalNodeLink *ptr=NULL);
};
#endif /* ORDSEARCH_H */
