/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	generic-rel.h : Header file

	Abstract interface for handling "generic" Relations, independent
	of concrete implementation (linked list, database, builtin, etc).

	Contains the following class/type  declarations	 :
	  Relation
	  RelationList
	  RelationLink
	  TupleIterator
 ***********************************************************************/

#ifndef CORAL_GENERIC_REL_H
#define CORAL_GENERIC_REL_H

#include <arg.h>
#include <term.h>
#include <unify.h>

/*
 * To add further defines, just number them with successive powers of 2 
 */

/*
 * The following two can only be used within methods of GenericRel (or 
 * methods of subclasses of GenericRel) 
 */
#define REL_DISPLAY_NEW_INSERTIONS 1  /* Display non-subsumed insertions */
#define REL_DISPLAY_INSERTIONS 2     /* Display all attempted insertions */

/*
 * The following can only be used within methods of GenericIndex (or 
 * methods of subclasses of GenericIndex) 
 */
#define REL_DISPLAY_INDEXOPS   4     /* Display calls to index operations */

#define REL_PROFILE_STATS  8         /* Generate profile statistics */

/** Tarun **/
#define REL_EXPLAIN 16         /* Turn browser on(dump) */

#define DISPLAY_INSERTIONS  \
       ((exEnv.GlobalRelationOptions | this->local_options) & REL_DISPLAY_INSERTIONS)
#define DISPLAY_NEW_INSERTIONS  \
       ((exEnv.GlobalRelationOptions | this->local_options) & REL_DISPLAY_NEW_INSERTIONS)
				
#define DISPLAY_INDEXOPS  \
	((exEnv.GlobalRelationOptions | this->relation->local_options) & REL_DISPLAY_INDEXOPS)
				

class RMark; class TupleIterator; // forward declarations
class Relation;
class RelationList;
class RelationLink;
typedef int RelationOptions; // List of possible options follows.
extern class GenericIndex;
extern class ModuleInfo ;

// NullArgs is a conventional abbreviation for (VAR#1, VAR#2, ..., VAR#n)
extern ArgList NullArgs;
extern Arg* NoArgs[]; // standard zero-arg ArgList

extern Relation * Find_External_Relation(Name, int arity);
extern Relation * find_external_relation(Name, int arity);
extern Relation * make_relation(Name name, int arity, int index_deltas = -1);
extern Relation * make_relation(char * name, int arity, int index_deltas = -1);
//extern Relation * make_local_relation(Name, int arity, int index_deltas = -1);
extern Relation * make_local_relation(Name, int arity,
				      int index_deltas, int set_subsum = -1);
extern Relation * find_relation(Name, int arity);
extern Relation * find_local_relation(Name, int arity);
extern void       delete_tuple (Relation *rel, Tuple *tuple);
extern void       update_tuple (Relation *rel, Tuple *t_old, Tuple *t_new);
extern int        CheckRelationExists(Name);

typedef enum {
  /* the next three are the only possible rkind values possible for
     actual materialized relations. Only these rkinds need to be
     checked for at run time
   */
  COR_R_MAGIC, 
  COR_R_SUPPLEMENTARY,
  COR_R_ANSWER,  
  COR_R_DERIVED,
  COR_R_OTHER,
 } RelationKind;

extern class Context;
extern class GoalNode;
class AggSelInfo;
class PrioritizeInfo;
class PredAnnotations;

class Relation : public Arg {
  protected:
    int _arity;

  public:
    Name name;

    RelationOptions local_options; 
    unsigned int  check_subsum : 1;   // If set, check for subsumption when
				      // inserting tuples. 
    unsigned int delta_indexed : 1;
    unsigned int single_success : 1;

    int count;                  // number of facts in relation
    unsigned int ref_count : 8; // count of how many databases it is open in
    unsigned int scan_count : 8;// count of how many scans are open on it


    AggSelInfo *agg_sel_info;   // Info about aggregate selections on reln.
    PrioritizeInfo *priority_info;
                                // Info about prioritization on this relation

    HashVal _hash; 		// sufficient condition for inequality testing
    HashVal _eq_id;		// sufficient condition for equality testing


    Relation *for_supp_index;
	// auxiliary relation used only with magic relations, for generating
	// goal identifiers if required.

    /******** Ordered Search Fields ***********/
    RelationKind r_kind;
    short ordsearch;
    Relation *for_ordsearch;
	// used for subsumption checking in ordered search
    Relation *mp_done_reln;
	// non-NULL only if (r_kind == COR_R_MAGIC) && (ordsearch)

    /********* relation delta fields ***********/
    RelationList *delta_relations;
	// above two fields used for determining if the delta relations
	// will be a chain of tuples or a chain of indexed relations
    RelationLink *free_reln_list;
	// List of free relations that can be reused as delta relations.

    /*********** relation methods ***************/
    virtual arg_kind kindof() const;
    RelationKind find_r_kind();
    int arity() const { return _arity; }
    virtual void print(BindEnv*, FILE *file) const;
    virtual void print(BindEnv*, FILE *file, char *) const;
    virtual void sprint(char* str, int* pos, BindEnv *context = NULL) const;
    virtual void dump(int arg_number, FILE *file);
    virtual void print_name(FILE *file);
    virtual int isConstant();
    virtual int tuple_count() { return count; }


     /*********** index and semi-naive related methods ***********/
    virtual int add_index(char *s, int buckets = -1);
    virtual int add_index(BitVector *s, int buckets = -1);
    virtual int add_index(ArgList *args, int buckets = -1);
    virtual int add_index(ArgList *pat, int n_var, ArgList *v_nm, 
				int buckets = -1);
    virtual int add_all_indices(Relation *reln, 
				int buckets = -1);
    virtual int add_all_tuples (Relation *_reln, int marks_into_account = 0,
				int check_dupl = 0, int hide_em = 0);
    virtual int add_all_goals (Relation *reln, Context *context, 
						Relation *owner_rel);
    void add_agg_sel_anno(PredAnnotations *anno);
    virtual void add_agg_sel_info(AggSelInfo *newinfo);


     /*********** aggregate selection related methods **********/
    virtual int set_delta_indexing(int _delta);

     /*********** prioritize related methods **********/
     void add_prioritize_info(PredAnnotations *anno);
     virtual int add_hidden_relation(PrioritizeInfo *info);
                       // The above adds a new hidden relation
     virtual int insert_in_hidden_relation(Tuple *tuple);
     virtual int pop_from_hidden_relation();
                       // Pop a tuple from the hidden relation and add it
                       //    to visible part.
     virtual int pop_all_from_hidden_relation();
                       // Pop all tuples from the hidden relation, and
                       // add them to visible part.


     /*********** insert and related methods *************/
    virtual int insert_tuple(Tuple *tuple);

    virtual int insert_new(ArgList& args, BindEnv* env,
				BindEnv *dont_rename_env = NULL,
				Tuple *parent_goal = NULL,
				int dont_rename = 0); 
		// insert if not subsumed.
    inline int insert_new(Arg** args, BindEnv* env, 
				BindEnv *dont_rename_env = NULL,
				Tuple *parent_goal = NULL, 
				int dont_rename = 0)
	{ return insert_new(*(ArgList*)args, env, dont_rename_env,
			 parent_goal, dont_rename); }
    inline int insert_new(Tuple *tuple, BindEnv *dont_rename_env = NULL,
				Tuple *parent_goal = NULL,
				int dont_rename = 0)
	{ return insert_new(tuple->args(), tuple->bindenv, 
				dont_rename_env, parent_goal, dont_rename); }
    int insert(Tuple *tuple);
    int insert_in_context(GoalNode *g_node, GoalNode *parent_goal);
    virtual int insert_raw(Tuple *tuple);

    int insert_grouping(ArgList&args, BindEnv *env, 
		BindEnv *dont_rename_env = NULL, Tuple *parent_goal= NULL,
		int dont_rename=0); 
		// Arglist contains a grouping term.
    virtual RMark * getMark();
    virtual void freeMark(RMark *, int hide_em=0);
    virtual void free_allMarks() ;

    virtual BindEnv* get_next(TupleIterator&) = 0;

    /* get_next_tuple(): returns tuple if there is one 
    		(Builtin rels etc return NULL).
		Returns status via tupleit->bindenv->no_match() */
    virtual Tuple* get_next_tuple(TupleIterator&) = 0;
    virtual int is_subsumed(Tuple *tuple, RMark *startmark= NULL, 
			RMark *endmark = NULL);
    virtual int is_agg_subsumed(Tuple *tuple, RMark *startmark= NULL,
			RMark *endmark = NULL);
    virtual void release(TupleIterator&); /* Release state associated with
					tuple iterator */

    void printon(FILE *file) const;
    void printon(FILE *file, char *) const;
    virtual void print_facts(FILE *file, ArgList *arglist = NULL) const ;

    virtual int tuple_delete(Tuple *tuple) {delete_tuple(this, tuple); 
					    return 1;}
    virtual int tuple_insert(Tuple *tuple) { return this->insert_new(tuple);}
    virtual int tuple_update(Tuple *tuple_old, Tuple *tuple_new) {
      update_tuple(this, tuple_old, tuple_new); return 1;
    }
    virtual void free_all();
    virtual void free_indices();
    virtual int check_subsumption() { return check_subsum; }
    virtual void set_subsumption(int subsum_flag);
    virtual void empty_relation( int deleteTuples = 0);
			// Empty tuples out of the relation.  Delete the tuples
			// only if the deleteTuples arg is not 0

    virtual HashVal hash(BindEnv *env = NULL);
			// compute a hash value for a nested set
    virtual int equals(Arg *arg2);
    virtual int raw_equals(Relation *rel);
    virtual int contained_in(Relation *rel);
    virtual unsigned int cardinality(Tuple *tuple);

    virtual ~Relation();
    Relation( int arity, int delta_indexed = -1 );
    Relation();
};

class AggSelInfo{
    public:
    ArgList  *arglist;          /* Arglist that covers literal */
    ArgList  *groupbylist;      /* Arglist with groupby vars common with
				    `arglist', and other vars distinct.
				    Used for indexing */
    AggregateKind agg_kind;
    Arg * agg_value;            // Aggregated argument of arglist
    Arg * gb_agg_value;         // Aggregated argument of groupbylist
    int var_count;
    BindEnv *bindenv;           // So it can be reused.
    int indexnum;               // Used to avoid repeated checks
					// for what index to use
    AggSelInfo *next;
 };

 class PrioritizeInfo{
     public:
     int argnum;
     int order;        // > 0 --> maximum first,
                       // < 0 --> minimum first,
                       // = 0 --> no ordering.
     Relation *hidden_relation;  // Hidden part of relation
     PrioritizeInfo *next;

     PrioritizeInfo(int _order = 0, int _argnum = 0) {
       order = _order;
       argnum = _argnum;
       hidden_relation = NULL;
     }
};

class RelationLink {

public:
    RelationLink *next;
    Relation *reln;

    RelationLink(Relation *r, RelationLink *n = NULL)
	{ reln = r; next = n; }
};

class RelationList {

public:
    RelationLink *reln_chain;   // head of list of (Linked) Relations
    RelationLink *reln_lastptr; // points to last RelationLink (delta new)
    RelationList() { reln_chain = NULL; reln_lastptr = NULL; }
    void append_relation(Relation* _rel);
    void append(RelationLink * rell);
	
    inline void insert_tuple(Tuple *tuple)
	{
	    ASSERT((reln_lastptr != NULL) && (reln_lastptr->reln != NULL));
	    reln_lastptr->reln->insert_tuple(tuple);
	}
};

// RMarks are used to select a sub-range of a relation.
// The range (RM1, RM2) of relation R is the set of tuples
// in R that were added to R after RM1 was created but before RM2 was created.
// Either RM1 or RM2 can be NULL, which is equivalent to beginning/end 
// of relation.
// An RMark is created using 'relation->getMark()'.

class RMark {
  public:
    virtual ~RMark();
    RMark() { }
};


// A Tuple iterator is used to loop through (part of a) Relation
// Only return those tuples "between" start_mark and end_mark,
// and only those which match 
class DerivedMethod;
class QFModuleData;
class PipelinedExecInfo;
class Table; class RMarkArray;

typedef Relation * (*InterpDerivedSolver)(QFModuleData *md, 
					    Relation *magic,
					    int old_magic_relation,
					    TupleIterator* iterator=NULL);

struct ModuleExecInfo {
  Table *table;
  Relation *magic;
  RMarkArray *rm_Arr;
  QFModuleData *md;
  InterpDerivedSolver solver;
//  RMark *scan_mark;
  int  iter_number;       /* this is used by psn to determine the iteration
                             number of the stored computation. On the first
			     iteration of an scc, the non-recursive rules
			     will also be added to the recursive rules.
			     */
  
  ModuleExecInfo(QFModuleData *mod, Table *tab, Relation *mag,
		 InterpDerivedSolver solve) {
    md = mod; table = tab; magic = mag; solver = solve; rm_Arr = NULL ;
    iter_number = 1;
//    scan_mark = NULL;
  }
};


class TupleIterator {
  public:

    /**** Fields that are (usually) invariant within a rule application **/
    ArgList &arg_list;
    ArgList &temp_arglist; // Is this causing problems ??
    BindEnv *bindenv ;
    Relation *relation;

    RMark *start_mark;
    union {
        RMark *end_mark;
	QFModuleData *moduledata;   	/* For derived relations */
    };

    StackMark stack_mark;
    BindEnv *tuple_env;
    union {
	RMark *mpos;
        void *ppos;             /* position of the next tuple to
				   be considered */
	void *scanDesc;		/* for persistent relations */
	void *cursor;		/* for persistent relations */
	TupleIterator *next;	/* For free store handling */
	TupleIterator *answer_iterator;
    };
    union {
    	long ipos;
	PipelinedExecInfo *pipe; // for pipelined relations only. 
    };
    int pindex;                 /* index of current bucket, if
				   the relation is a hash relation */

    int _no_match;	// To return status on calls to get_next_tuple

    RelationLink *delta_rel_pos; // Used to handle semi-naive delta relations.

    /**** The following three fields are for dealing with indices. */
    long hash;
    GenericIndex* index;
    int		  *indexnump;

    /*********** The following field is used by return unify.  It is set by
	unify_literal, to signal that apply-rule should do the actual 
	unification, since extra information about the supplementary and 
	answer facts is required.
    ************/
    int unification_number;  

    union {
      PipelinedExecInfo *calling_pei;   /** used by pipelining for Cut **/
      Tuple *prev_tuple;
    };

    BindEnv *prev_bindenv;

    // the following field is used to store intermediate state of
    // bottom-up computation, when answers are being returned at
    // the end of each iteration
    union {
      ModuleExecInfo *state;
      ModuleInfo *prev_module_info;   // for pipelined relations only
    };
    

    /*********** Methods *************/

    void * operator new(size_t size);	/* To handle free store ourselves */
    void operator delete(void *, size_t size);	/* To handle free store */

    TupleIterator(Relation *rel, ArgList& args, BindEnv* env,
	 RMark *start = NULL, RMark *end = NULL, int *tryindexp = NULL);
    TupleIterator(Relation *rel, Arg** args, BindEnv* env,
	 RMark *start = NULL, RMark *end = NULL, int *tryindexp = NULL);
    TupleIterator(Relation *rel, Tuple *tuple,
	 RMark *start = NULL, RMark *end = NULL);
    ~TupleIterator();
    inline void reset() {
	/* Reset only those fields that change within a rule application */
	tuple_env = NULL;
	ppos = NULL;
	ipos = 0;
	_no_match = 0;
	delta_rel_pos = NULL;
	hash = VarHashValue;
	index = NULL;
	unification_number = -1;
	prev_tuple = NULL;
	prev_bindenv = NULL;
	state = NULL;
    }

    inline int in_delta() { return (delta_rel_pos != NULL); }
    inline void release() { if (relation) relation->release(*this); }

    inline int no_match() {return _no_match;}
    inline void set_no_match(){_no_match = 1;}
    inline void reset_no_match(){_no_match = 0;}
    BindEnv *get_next();

    /* get_next_tuple(): returns tuple if there is one 
		(Builtin rels etc return NULL). 
    */
    inline Tuple *get_next_tuple() {
      return relation->get_next_tuple(*this);
    }

};


#endif /*!CORAL_GENERIC_REL_H*/




