/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	garray.h : Header file

	Contains macro definitions that implement a garray - i.e.
	an array that can grow dynamically.

 ***********************************************************************/

#ifndef GARRAY_H
#define GARRAY_H
#ifndef GENERICH
#include <generic.h>
#endif
#include "config.h"

extern int C_NewGArraySize, C_DeleteGArraySize;
/*
 * The following must be used to declare any variable of the generic
 * type, G(rowing)Array
 */

#define GArray(type) CONCAT_ID2(type,_garray)
// inline int ceil_div(int size, int incr) { return (size+incr-1)/incr; }
#define ceil_div(size, incr) ((size+incr-1)/incr)


/*
 * The following function must be used to declare GArray(type)'s definition.
 * It must be included at most once in a program, so #ifdef as appropriate
 * may need to be used.
 */


#define GArrayDeclare(type)			\
    class GArray(type) {			\
	type **array;				\
	int size;				\
	int _limit;				\
	int incr; 				\
	public:					\
	    GArray(type) (int size =128*128, int incr = 128, int tlimit=-1);	\
	    /* type &operator[](int i); */			\
    	    inline type & operator[](int i)			\
    	    {							\
		ASSERT(array!=NULL && i<_limit && i >= 0);	\
		if (i >= size) resize(2*size);			\
		if (! array[i/incr]) { 				\
	    	    array[i/incr] = new type[incr];		\
		    C_NewGArraySize += incr*sizeof(type);	\
		}						\
		return ( array[i/incr][i%incr] );		\
    	    }							\
	    int limit() {return _limit;}				\
	    int resize(int newsize); 				\
	    GArray(type) *make_copy();				\
	    int get_next(int i);				\
	    ~GArray(type)();			\
    };	

/*
	    CONCAT_ID2(~,GArray(type)());			\
*/


/*
 * The following function must be used to define the implementation of 
 * GArray(type).  It must occur only once, else the implementation would be 
 * multiply defined.
 */

#define GArrayImplement(type)				\
    GArray(type)::GArray(type)(int tsize, int inc, int tlimit) 	\
    {							\
	size = tsize;					\
	if (tlimit < 0) _limit = size;			\
	else _limit = tlimit;				\
	incr = inc;					\
	if (size<incr) incr = size;			\
	if (tsize <= 0) array = NULL; 			\
	else  array = new type *[ceil_div(tsize,inc)];	\
	C_NewGArraySize += ceil_div(tsize,inc)*sizeof(type *);	\
	for(int i=0;i<ceil_div(tsize,inc);i++) array[i]=NULL;  	\
    }								\
								\
    int GArray(type)::resize(int newsize) 			\
    {								\
	int i;							\
	if(newsize <= size) { size = newsize; return 0;}	\
	if (_limit < newsize) _limit = newsize;			\
	type **newarray = new type *[ceil_div(newsize,incr)];	\
	for(i=0;i<ceil_div(size,incr);i++) 			\
		newarray[i]=array[i];				\
	for(i=ceil_div(size,incr);i<ceil_div(newsize,incr);i++) \
		newarray[i]=NULL;				\
	C_NewGArraySize += (newsize - size)*sizeof(type *);	\
	size = newsize;						\
	delete array;						\
	array = newarray;					\
	return 0;						\
    }							\
							\
    GArray(type) * GArray(type)::make_copy()		\
    {							\
	int i,j;					\
	GArray(type) *copy = new GArray(type);		\
							\
	copy->size = size;				\
	copy->_limit = _limit;				\
	copy->incr = incr;				\
	if(size<=0)	copy->array = NULL;		\
	else copy->array = new type *[ceil_div(size,incr)];	\
	C_NewGArraySize += size * sizeof(type *);	\
	for(i=0;i<ceil_div(size,incr);i++){		\
	    if(array[i]) {				\
	    	copy->array[i] = new type[incr];	\
	    	for (j=0;j<incr;j++)			\
		    copy->array[i][j] = array[i][j];	\
		C_NewGArraySize += incr*sizeof(type); 	\
		}					\
	    else copy->array[i] = NULL;			\
	    }						\
	return (copy) ;					\
    }							\
							\
    int GArray(type)::get_next(int i)			\
    {							\
	if ( !array ) return(-1);			\
	for(i++;i<size;){				\
	   if (! array[i/incr])				\
		i = ((i/incr)+1)*incr;			\
	   else break;					\
	   }						\
	return(i);					\
     }							\
							\
     GArray(type)::~GArray(type)()			\
     {							\
	if (!array) return;				\
	for(int i=0; i< ceil_div(size,incr);i++) {	\
	    if(array[i]) {				\
	       delete [incr] array[i];			\
	       C_DeleteGArraySize += incr*sizeof(type);\
	    }						\
	}						\
	delete [ceil_div(size,incr)] array ;		\
	C_DeleteGArraySize += ceil_div(size,incr)*sizeof(type *); \
     }
			
#endif /* !GARRAY_H */
