/************************************************************************
 ========================================================================
 CORAL 
 (c)  Copyright R. Ramakrishnan and The CORAL Group, 
 University of Wisconsin at Madison.
 (1992) All Rights Reserved.
 Version 0.1
 ========================================================================



 ------------------------------------------------------------------------
 CORAL Version 0.1
 RESEARCH SOFTWARE DISCLAIMER -------------------------------------------
 ------------------------------------------------------------------------

    As unestablished, research software, this program is provided free of 
    charge on an "as is" basis without warranty of any kind, either 
    express or implied.  Acceptance and use of this program constitutes 
    the user's understanding that (s)he will have no recourse for any 
    actual or consequential damages, including, but not limited to, 
    lost profits or savings, arising out of the use of or inability to 
    use this program.  

 ------------------------------------------------------------------------
 USER AGREEMENT ---------------------------------------------------------
 ------------------------------------------------------------------------

     BY ACCEPTANCE AND USE OF THIS EXPERIMENTAL PROGRAM
     THE USER AGREES TO THE FOLLOWING:

     a.  This program is provided free of charge for the user's personal, 
	 non-commercial, experimental use.

     b.  All title, ownership and rights to this program and any copies 
         remain with the copyright holder, irrespective of the ownership 
	 of the media on which the program resides.

     c.  The user is permitted to create derivative works to this program.  
         However, all copies of the program and its derivative works must
         contain the CORAL copyright notice, the UNESTABLISHED SOFTWARE 
         DISCLAIMER and this USER AGREEMENT.

     d.  The user understands and agrees that this program and any 
         derivative works are to be used solely for experimental purposes 
	 and are not to be sold or commercially exploited in any manner 
	 WITHOUT EXPRESS WRITTEN PERMISSION.

     e.  We request that the user supply us with a copy of any changes, 
         enhancements, or derivative works which the user may create,
	 with the user's permission to redistribute it.
	 Copies of such material should be sent to:  CORAL@CS.WISC.EDU

-------------------------------------------------------------------------
*************************************************************************/

/***********************************************************************
	CORAL Software :: U.W.Madison

	builtin-rel.h : Header file

	Contains the following class/type  declarations	 :
		 BuiltinRelation;
		 BuiltinUnaryRelation;
		 BuiltinBinaryRelation;
		 BuiltinCompareRelation;
		 BuiltinTraceRelation;
		 BuiltinDebugRelation;
		 BuiltinIndexRelation;
		 BuiltinFailRelation;

 ***********************************************************************/


#ifndef BUILTINREL_H
#define BUILTINREL_H

#include "term.h"
#include "generic-rel.h"

extern Relation *find_relation(Name name, int arity);

class BuiltinRelation;
class BuiltinUnaryRelation;
class BuiltinBinaryRelation;
class BuiltinCompareRelation;
class BuiltinTraceRelation;
class BuiltinDebugRelation;
class BuiltinIndexRelation;
class BuiltinFailRelation;

class BuiltinSetRelation;
extern BuiltinSetRelation MemberBuiltin;


extern BuiltinUnaryRelation SumBuiltin;
extern BuiltinUnaryRelation CountBuiltin;
extern BuiltinUnaryRelation MinBuiltin;
extern BuiltinUnaryRelation MaxBuiltin;
extern BuiltinUnaryRelation AvgBuiltin;

extern BuiltinBinaryRelation AddBuiltin;
extern BuiltinBinaryRelation SubBuiltin;
extern BuiltinBinaryRelation MulBuiltin;
extern BuiltinBinaryRelation DivBuiltin;

extern BuiltinCompareRelation EquBuiltin;
extern BuiltinCompareRelation NeqBuiltin;
extern BuiltinCompareRelation LssBuiltin;
extern BuiltinCompareRelation GrtBuiltin;
extern BuiltinCompareRelation LeqBuiltin;
extern BuiltinCompareRelation GeqBuiltin;

extern BuiltinTraceRelation TraceBuiltin, UntraceBuiltin;
extern BuiltinDebugRelation SetBuiltin, ClearBuiltin, AssignBuiltin;
extern BuiltinRelation DisplayBuiltin, HelpBuiltin, PrintfBuiltin ;
extern BuiltinRelation StartTimeRelation, DisplayTimeRelation ;
extern BuiltinRelation ConsultBuiltin;
extern BuiltinIndexRelation AddIndexBuiltin ;
extern BuiltinFailRelation  FailBuiltin;


typedef BindEnv* (*SolveProc)(BuiltinRelation&, TupleIterator&);
typedef const Arg * (*BinaryProc)(const Arg* arg0, const Arg* arg1);
typedef const Arg * (*AggProc)(Relation* rel);
typedef int (*CompareProc)(Term& arg0, Term& arg1);
typedef Tuple * (*UserTupleProc)(Tuple *query);
typedef Relation * (*UserRelProc)(Tuple  *query);

typedef BindEnv* (*SetProc)(TupleIterator&);


// generic Builtinrelation declaration
// Each builtin-relation is associated with a 'solver'
// function that is invoked when a get_next() occurs it.
class BuiltinRelation : public Relation {
  public:
    BuiltinRelation(int a, Name n, SolveProc solve_proc);
    BuiltinRelation(char * n, int a, UserRelProc solve_proc);
    BuiltinRelation(char * n, int a, UserTupleProc solve_proc);
    SolveProc solver;
    virtual BindEnv* get_next(TupleIterator&);
    virtual void release(TupleIterator&);
    virtual Tuple* get_next_tuple(TupleIterator& it) {
        get_next(it) ; return(NULL) ;
    	}

    virtual int insert_tuple(Tuple *tuple);

    virtual int insert_new(ArgList &args, BindEnv *env, 
			   BindEnv *dont_rename_env = NULL,
			   Tuple *parent_goal = NULL, int dont_rename =0);

    virtual void print_name(FILE *file);
    virtual int is_printable_builtin() {return 1;}
};

class BuiltinSetRelation : public BuiltinRelation {
public:
	BuiltinSetRelation(int a, Name n, SetProc set_proc);
	SetProc op;
	virtual BindEnv* get_next(TupleIterator&);
};

class BuiltinUnaryRelation : public BuiltinRelation {
  public:
  //  Arg* first ;   used for storing aggregate value 
  //  Arg* second ; used by average to store count 
    BuiltinUnaryRelation(int a, Name n, AggProc agg_op);
    AggProc op;
    virtual BindEnv* get_next(TupleIterator&);
  int is_printable_builtin() {return 0;}
};

class BuiltinBinaryRelation : public BuiltinRelation {
  public:
    BuiltinBinaryRelation(int a, Name n, BinaryProc bin_op);
    BinaryProc op;
    virtual BindEnv* get_next(TupleIterator&);
    int is_printable_builtin() {return 0;}
};

class BuiltinCompareRelation : public BuiltinRelation {
  public:
    virtual BindEnv* get_next(TupleIterator&);
    BuiltinCompareRelation(int a, Name n, CompareProc bin_op);
    CompareProc op;
    int is_printable_builtin() {return 0;}
};

class BuiltinFailRelation : public BuiltinRelation {
  public :
    virtual BindEnv* get_next(TupleIterator& iterator) {
      iterator.set_no_match();
      return iterator.bindenv;
    }
    BuiltinFailRelation(int a, Name n);
};


class BuiltinUserTupleRelation : public BuiltinRelation {
  public:
      BuiltinUserTupleRelation(int arity, Name n, UserTupleProc user_op);
      UserTupleProc op;
      virtual BindEnv* get_next(TupleIterator&);
      virtual Tuple* get_next_tuple(TupleIterator& it);
};

class BuiltinUserRelRelation : public BuiltinRelation {
  public:
      BuiltinUserRelRelation(int arity, Name n, UserRelProc user_op);
      UserRelProc op;
      virtual BindEnv* get_next(TupleIterator&);
      virtual Tuple* get_next_tuple(TupleIterator& it);
};

class BuiltinTraceRelation : public BuiltinRelation {
  public:
    BuiltinTraceRelation(int a, Name n);
};


class BuiltinDebugRelation : public BuiltinRelation {
 public:
    BuiltinDebugRelation(int a, Name n);
};

class BuiltinIndexRelation : public BuiltinRelation {
 public:
    BuiltinIndexRelation(int a, Name n);
    int is_printable_builtin() {return 0;}
};


#endif /* BUILTINREL_H */
