
\begin{tt}
\begin{verbatim}

module pipe_eg12.
@pipelining.

export multiset_to_list(bf).

% The first argument must be bound to a list; returns a multiset
% with the same elements.

multiset_to_list(S, L) :- 
	clear(check_subsumption),	% ensures no dup chks on base relations
	member(S, X), insert(temp(X)),  % notice the use of member in pipelined module
	convert(temp, [], L).		% should turn on subsumption checks again
					% here if desired.

convert(R, Lin, Lout) :- 
	univ(T, [R,X]), 		% The CORAL parser doesn't accept variables in
					% places where it expects a constant;
					% hence this kluge
	call(T),			% T= R(X); X is bound by this call
	delete(T),
	convert(R, [X|Lin], Lout).

convert(_, L, L).

end_module.

\end{verbatim}
\end{tt}

